import ecr = require('@aws-cdk/aws-ecr');
import cdk = require('@aws-cdk/core');
import { ContainerDefinition } from './container-definition';
import { CfnTaskDefinition } from './ecs.generated';
/**
 * Constructs for types of container images
 */
export declare abstract class ContainerImage {
    /**
     * Reference an image on DockerHub or another online registry
     */
    static fromRegistry(name: string, props?: RepositoryImageProps): RepositoryImage;
    /**
     * Reference an image in an ECR repository
     */
    static fromEcrRepository(repository: ecr.IRepository, tag?: string): EcrImage;
    /**
     * Reference an image that's constructed directly from sources on disk
     *
     * @param directory The directory containing the Dockerfile
     */
    static fromAsset(directory: string, props?: AssetImageProps): AssetImage;
    /**
     * Called when the image is used by a ContainerDefinition
     */
    abstract bind(scope: cdk.Construct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
/**
 * The configuration for creating a container image.
 */
export interface ContainerImageConfig {
    /**
     * Specifies the name of the container image.
     */
    readonly imageName: string;
    /**
     * Specifies the credentials used to access the image repository.
     */
    readonly repositoryCredentials?: CfnTaskDefinition.RepositoryCredentialsProperty;
}
import { AssetImage, AssetImageProps } from './images/asset-image';
import { EcrImage } from './images/ecr';
import { RepositoryImage, RepositoryImageProps } from './images/repository';
