"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Constructs for types of container images
 */
class ContainerImage {
    /**
     * Reference an image on DockerHub or another online registry
     */
    static fromRegistry(name, props = {}) {
        return new repository_1.RepositoryImage(name, props);
    }
    /**
     * Reference an image in an ECR repository
     */
    static fromEcrRepository(repository, tag = 'latest') {
        return new ecr_1.EcrImage(repository, tag);
    }
    /**
     * Reference an image that's constructed directly from sources on disk
     *
     * @param directory The directory containing the Dockerfile
     */
    static fromAsset(directory, props = {}) {
        return new asset_image_1.AssetImage(directory, props);
    }
}
exports.ContainerImage = ContainerImage;
const asset_image_1 = require("./images/asset-image");
const ecr_1 = require("./images/ecr");
const repository_1 = require("./images/repository");
//# sourceMappingURL=data:application/json;base64,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