import autoscaling = require('@aws-cdk/aws-autoscaling');
import cdk = require('@aws-cdk/core');
import { ICluster } from '../cluster';
/**
 * Properties for instance draining hook
 */
export interface InstanceDrainHookProps {
    /**
     * The AutoScalingGroup to install the instance draining hook for
     */
    autoScalingGroup: autoscaling.IAutoScalingGroup;
    /**
     * The cluster on which tasks have been scheduled
     */
    cluster: ICluster;
    /**
     * How many seconds to give tasks to drain before the instance is terminated anyway
     *
     * Must be between 0 and 15 minutes.
     *
     * @default Duration.minutes(15)
     */
    drainTime?: cdk.Duration;
}
/**
 * A hook to drain instances from ECS traffic before they're terminated
 */
export declare class InstanceDrainHook extends cdk.Construct {
    /**
     * Constructs a new instance of the InstanceDrainHook class.
     */
    constructor(scope: cdk.Construct, id: string, props: InstanceDrainHookProps);
}
