"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an EC2 cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class Ec2TaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromEc2TaskDefinitionArn(scope, id, ec2TaskDefinitionArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.taskDefinitionArn = ec2TaskDefinitionArn;
                this.compatibility = task_definition_1.Compatibility.EC2;
                this.isEc2Compatible = true;
                this.isFargateCompatible = false;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, Object.assign(Object.assign({}, props), { compatibility: task_definition_1.Compatibility.EC2, placementConstraints: props.placementConstraints }));
    }
}
exports.Ec2TaskDefinition = Ec2TaskDefinition;
//# sourceMappingURL=data:application/json;base64,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