import cdk = require('@aws-cdk/core');
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
/**
 * The properties for building an AssetImage.
 */
export interface AssetImageProps {
    /**
     * The arguments to pass to the `docker build` command
     *
     * @default none
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * Docker target to build to
     *
     * @default none
     */
    readonly target?: string;
}
/**
 * An image that will be built from a local directory with a Dockerfile
 */
export declare class AssetImage extends ContainerImage {
    private readonly directory;
    private readonly props;
    /**
     * Constructs a new instance of the AssetImage class.
     *
     * @param directory The directory containing the Dockerfile
     */
    constructor(directory: string, props?: AssetImageProps);
    bind(scope: cdk.Construct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
