"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ecr_assets_1 = require("@aws-cdk/aws-ecr-assets");
const container_image_1 = require("../container-image");
/**
 * An image that will be built from a local directory with a Dockerfile
 */
class AssetImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the AssetImage class.
     *
     * @param directory The directory containing the Dockerfile
     */
    constructor(directory, props = {}) {
        super();
        this.directory = directory;
        this.props = props;
    }
    bind(scope, containerDefinition) {
        const asset = new aws_ecr_assets_1.DockerImageAsset(scope, 'AssetImage', {
            directory: this.directory,
            buildArgs: this.props.buildArgs,
            target: this.props.target,
        });
        asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: asset.imageUri,
        };
    }
}
exports.AssetImage = AssetImage;
//# sourceMappingURL=data:application/json;base64,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