"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to CloudWatch Logs.
 */
class AwsLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the AwsLogDriver class.
     *
     * @param props the awslogs log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.logGroup && props.logRetention) {
            throw new Error('Cannot specify both `logGroup` and `logRetentionDays`.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(scope, containerDefinition) {
        this.logGroup = this.props.logGroup || new logs.LogGroup(scope, 'LogGroup', {
            retention: this.props.logRetention || Infinity,
        });
        this.logGroup.grantWrite(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            logDriver: 'awslogs',
            options: utils_1.removeEmpty({
                'awslogs-group': this.logGroup.logGroupName,
                'awslogs-stream-prefix': this.props.streamPrefix,
                'awslogs-region': core_1.Stack.of(containerDefinition).region,
                'awslogs-datetime-format': this.props.datetimeFormat,
                'awslogs-multiline-pattern': this.props.multilinePattern,
            }),
        };
    }
}
exports.AwsLogDriver = AwsLogDriver;
//# sourceMappingURL=data:application/json;base64,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