"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to journald Logs.
 */
class FluentdLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'fluentd',
            options: utils_1.stringifyOptions(Object.assign({ 'fluentd-address': this.props.address, 'fluentd-async-connect': this.props.asyncConnect, 'fluentd-buffer-limit': this.props.bufferLimit, 'fluentd-retry-wait': this.props.retryWait && this.props.retryWait.toSeconds(), 'fluentd-max-retries': this.props.maxRetries, 'fluentd-sub-second-precision': this.props.subSecondPrecision }, utils_1.renderCommonLogDriverOptions(this.props))),
        };
    }
}
exports.FluentdLogDriver = FluentdLogDriver;
//# sourceMappingURL=data:application/json;base64,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