"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * The type of compression the GELF driver uses to compress each log message.
 */
var GelfCompressionType;
(function (GelfCompressionType) {
    GelfCompressionType["GZIP"] = "gzip";
    GelfCompressionType["ZLIB"] = "zlib";
    GelfCompressionType["NONE"] = "none";
})(GelfCompressionType = exports.GelfCompressionType || (exports.GelfCompressionType = {}));
/**
 * A log driver that sends log information to journald Logs.
 */
class GelfLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the GelfLogDriver class.
     *
     * @param props the gelf log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        // Validation
        if (props.compressionLevel) {
            utils_1.ensureInRange(props.compressionLevel, -1, 9);
        }
        if (props.tcpMaxReconnect) {
            utils_1.ensurePositiveInteger(props.tcpMaxReconnect);
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'gelf',
            options: utils_1.stringifyOptions(Object.assign({ 'gelf-address': this.props.address, 'gelf-compression-type': this.props.compressionType, 'gelf-compression-level': this.props.compressionLevel, 'gelf-tcp-max-reconnect': this.props.tcpMaxReconnect, 'gelf-tcp-reconnect-delay': this.props.tcpReconnectDelay && this.props.tcpReconnectDelay.toSeconds() }, utils_1.renderCommonLogDriverOptions(this.props))),
        };
    }
}
exports.GelfLogDriver = GelfLogDriver;
//# sourceMappingURL=data:application/json;base64,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