"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to json-file Logs.
 */
class JsonFileLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        // Validation
        if (props.maxFile && props.maxFile < 0) {
            throw new Error('`maxFile` must be a positive integer.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'json-file',
            options: utils_1.stringifyOptions({
                'max-size': this.props.maxSize,
                'max-file': this.props.maxFile,
                'compress': this.props.compress,
                'labels': utils_1.joinWithCommas(this.props.labels),
                'env': utils_1.joinWithCommas(this.props.env),
                'env-regex': this.props.envRegex
            }),
        };
    }
}
exports.JsonFileLogDriver = JsonFileLogDriver;
//# sourceMappingURL=data:application/json;base64,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