"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_log_driver_1 = require("./aws-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * The base class for log drivers.
 */
class LogDrivers {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     */
    static fluentd(props) {
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     */
    static gelf(props) {
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     */
    static journald(props) {
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     */
    static jsonFile(props) {
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     */
    static splunk(props) {
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     */
    static syslog(props) {
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
}
exports.LogDrivers = LogDrivers;
//# sourceMappingURL=data:application/json;base64,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