"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * Log Message Format
 */
var SplunkLogFormat;
(function (SplunkLogFormat) {
    SplunkLogFormat["INLINE"] = "inline";
    SplunkLogFormat["JSON"] = "json";
    SplunkLogFormat["RAW"] = "raw";
})(SplunkLogFormat = exports.SplunkLogFormat || (exports.SplunkLogFormat = {}));
/**
 * A log driver that sends log information to splunk Logs.
 */
class SplunkLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.gzipLevel) {
            utils_1.ensureInRange(props.gzipLevel, -1, 9);
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'splunk',
            options: utils_1.stringifyOptions(Object.assign({ 'splunk-token': this.props.token, 'splunk-url': this.props.url, 'splunk-source': this.props.source, 'splunk-sourceType': this.props.sourceType, 'splunk-index': this.props.index, 'splunk-capath': this.props.caPath, 'splunk-caname': this.props.caName, 'splunk-insecureskipverify': this.props.insecureSkipVerify, 'splunk-format': this.props.format, 'splunk-verify-connection': this.props.verifyConnection, 'splunk-gzip': this.props.gzip, 'splunk-gzip-level': this.props.gzipLevel }, utils_1.renderCommonLogDriverOptions(this.props))),
        };
    }
}
exports.SplunkLogDriver = SplunkLogDriver;
//# sourceMappingURL=data:application/json;base64,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