"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
/**
 * Remove undefined values from a dictionary
 */
function removeEmpty(x) {
    for (const key of Object.keys(x)) {
        if (x[key] === undefined) {
            delete x[key];
        }
    }
    return x;
}
exports.removeEmpty = removeEmpty;
/**
 * Checks that a value is a positive integer
 */
function ensurePositiveInteger(val) {
    if (!core_1.Token.isUnresolved(val) && Number.isInteger(val) && val < 0) {
        throw new Error(`\`${val}\` must be a positive integer.`);
    }
}
exports.ensurePositiveInteger = ensurePositiveInteger;
/**
 * Checks that a value is contained in a range of two other values
 */
function ensureInRange(val, start, end) {
    if (!core_1.Token.isUnresolved(val) && !(val >= start && val <= end)) {
        throw new Error(`\`${val}\` must be within range ${start}:${end}`);
    }
}
exports.ensureInRange = ensureInRange;
function stringifyOptions(options) {
    const _options = {};
    const filteredOptions = removeEmpty(options);
    for (const key of Object.keys(filteredOptions)) {
        // Convert value to string
        _options[key] = `${filteredOptions[key]}`;
    }
    return _options;
}
exports.stringifyOptions = stringifyOptions;
function renderCommonLogDriverOptions(opts) {
    return {
        'tag': opts.tag,
        'labels': joinWithCommas(opts.labels),
        'env': joinWithCommas(opts.env),
        'env-regex': opts.envRegex
    };
}
exports.renderCommonLogDriverOptions = renderCommonLogDriverOptions;
function joinWithCommas(xs) {
    return xs && xs.join(',');
}
exports.joinWithCommas = joinWithCommas;
//# sourceMappingURL=data:application/json;base64,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