"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const ecs = require("../../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-ecs-integ');
// Create a cluster
const vpc = new ec2.Vpc(stack, 'Vpc', { maxAzs: 2 });
const cluster = new ecs.Cluster(stack, 'EcsCluster', { vpc });
cluster.addCapacity('DefaultAutoScalingGroup', {
    instanceType: new ec2.InstanceType('t2.micro'),
});
const prox = ecs.ProxyConfigurations.appMeshProxyConfiguration({
    containerName: 'envoy',
    properties: {
        ignoredUID: 1337,
        proxyIngressPort: 15000,
        proxyEgressPort: 15001,
        appPorts: [9080, 9081],
        egressIgnoredIPs: ["169.254.170.2", "169.254.169.254"]
    }
});
const taskDefinition = new ecs.Ec2TaskDefinition(stack, 'TaskDef', { networkMode: ecs.NetworkMode.AWS_VPC, proxyConfiguration: prox });
taskDefinition.addContainer('web', {
    image: ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample"),
    memoryLimitMiB: 256,
});
taskDefinition.addContainer('envoy', {
    image: ecs.ContainerImage.fromRegistry("envoyproxy/envoy"),
    memoryLimitMiB: 256,
});
new ecs.Ec2Service(stack, "Service", {
    cluster,
    taskDefinition
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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