"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const ecs = require("../../lib");
const lib_1 = require("../../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-ecs-integ-ecs');
const vpc = new ec2.Vpc(stack, 'Vpc', { maxAzs: 2 });
const cluster = new ecs.Cluster(stack, 'EcsCluster', { vpc });
cluster.addCapacity('DefaultAutoScalingGroup', {
    instanceType: new ec2.InstanceType('t2.micro')
});
// Add Private DNS Namespace
const domainName = "scorekeep.com";
cluster.addDefaultCloudMapNamespace({
    name: domainName,
});
// Create frontend service
const frontendTD = new ecs.Ec2TaskDefinition(stack, 'TaskDef', {
    networkMode: lib_1.NetworkMode.AWS_VPC
});
const frontend = frontendTD.addContainer('frontend', {
    image: ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample"),
    memoryLimitMiB: 256,
});
frontend.addPortMappings({
    containerPort: 80,
    hostPort: 80,
    protocol: ecs.Protocol.TCP
});
new ecs.Ec2Service(stack, "FrontendService", {
    cluster,
    taskDefinition: frontendTD,
    cloudMapOptions: {
        name: "frontend"
    }
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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