"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const ecs = require("../../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-ecs-integ-ecs');
const vpc = new ec2.Vpc(stack, 'Vpc', { maxAzs: 2 });
const cluster = new ecs.Cluster(stack, 'EcsCluster', { vpc });
cluster.addCapacity('DefaultAutoScalingGroup', {
    instanceType: new ec2.InstanceType('t2.micro')
});
// Add Private DNS Namespace
const domainName = "scorekeep.com";
cluster.addDefaultCloudMapNamespace({
    name: domainName,
});
// Create frontend service
// default network mode is bridge
const frontendTD = new ecs.Ec2TaskDefinition(stack, 'frontendTD');
const frontend = frontendTD.addContainer('frontend', {
    image: ecs.ContainerImage.fromRegistry("amazon/amazon-ecs-sample"),
    memoryLimitMiB: 256,
});
frontend.addPortMappings({
    containerPort: 80,
    hostPort: 80,
    protocol: ecs.Protocol.TCP
});
new ecs.Ec2Service(stack, "FrontendService", {
    cluster,
    taskDefinition: frontendTD,
    cloudMapOptions: {
        name: "frontend"
    }
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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