"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const ecs = require("../lib");
let stack;
let td;
const image = ecs.ContainerImage.fromRegistry('test-image');
module.exports = {
    'setUp'(cb) {
        stack = new cdk.Stack();
        td = new ecs.Ec2TaskDefinition(stack, 'TaskDefinition');
        cb();
    },
    'create a fluentd log driver with options'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: new ecs.FluentdLogDriver({
                tag: 'hello'
            }),
            memoryLimitMiB: 128
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd',
                        Options: {
                            tag: 'hello'
                        }
                    }
                }
            ]
        }));
        test.done();
    },
    'create a fluentd log driver without options'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: new ecs.FluentdLogDriver(),
            memoryLimitMiB: 128
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd'
                    }
                }
            ]
        }));
        test.done();
    },
    'create a fluentd log driver with all possible options'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: new ecs.FluentdLogDriver({
                address: 'localhost:24224',
                asyncConnect: true,
                bufferLimit: 128,
                retryWait: cdk.Duration.seconds(1),
                maxRetries: 4294967295,
                subSecondPrecision: false,
                tag: 'my-tag',
                labels: [
                    'one',
                    'two',
                    'three'
                ],
                env: [
                    'one',
                    'two',
                    'three'
                ],
                envRegex: '[0-9]{1}'
            }),
            memoryLimitMiB: 128
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd',
                        Options: {
                            'fluentd-address': 'localhost:24224',
                            'fluentd-async-connect': 'true',
                            'fluentd-buffer-limit': '128',
                            'fluentd-retry-wait': '1',
                            'fluentd-max-retries': '4294967295',
                            'fluentd-sub-second-precision': 'false',
                            'tag': 'my-tag',
                            'labels': 'one,two,three',
                            'env': 'one,two,three',
                            'env-regex': '[0-9]{1}'
                        }
                    }
                }
            ]
        }));
        test.done();
    },
    "create a fluentd log driver using fluentd"(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: ecs.LogDrivers.fluentd(),
            memoryLimitMiB: 128
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd'
                    }
                }
            ]
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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