"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const ecs = require("../lib");
let stack;
let td;
const image = ecs.ContainerImage.fromRegistry('test-image');
module.exports = {
    'setUp'(cb) {
        stack = new cdk.Stack();
        td = new ecs.Ec2TaskDefinition(stack, 'TaskDefinition');
        cb();
    },
    'create a splunk log driver with minimum options'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: new ecs.SplunkLogDriver({
                token: cdk.SecretValue.secretsManager('my-splunk-token'),
                url: 'my-splunk-url'
            }),
            memoryLimitMiB: 128
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'splunk',
                        Options: {
                            'splunk-token': '{{resolve:secretsmanager:my-splunk-token:SecretString:::}}',
                            'splunk-url': 'my-splunk-url'
                        }
                    }
                }
            ]
        }));
        test.done();
    },
    "create a splunk log driver using splunk with minimum options"(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: ecs.LogDrivers.splunk({
                token: cdk.SecretValue.secretsManager('my-splunk-token'),
                url: 'my-splunk-url'
            }),
            memoryLimitMiB: 128
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'splunk',
                        Options: {
                            'splunk-token': '{{resolve:secretsmanager:my-splunk-token:SecretString:::}}',
                            'splunk-url': 'my-splunk-url'
                        }
                    }
                }
            ]
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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