"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Load the `features.ts` source file, and replace the "V2NEXT" version markers with the actual current version
 */
const fs_1 = require("fs");
const path = require("path");
const flag_modeling_1 = require("../lib/private/flag-modeling");
async function main() {
    const featuresSourceFile = path.join(__dirname, '..', 'lib', 'features.ts');
    // eslint-disable-next-line @aws-cdk/no-invalid-path
    let currentv2 = JSON.parse(await fs_1.promises.readFile(path.join(__dirname, '..', '..', '..', '..', 'version.v2.json'), { encoding: 'utf-8' })).version;
    currentv2 = currentv2?.match(/^[0-9\.]+/)?.[0]; // Make sure to only retain the actual version number, not any '-rc.X' suffix
    if (!currentv2) {
        throw new Error('Could not determine current v2 version number');
    }
    let source = await fs_1.promises.readFile(featuresSourceFile, { encoding: 'utf-8' });
    source = source.replace(new RegExp(flag_modeling_1.MAGIC_V2NEXT, 'g'), currentv2);
    await fs_1.promises.writeFile(featuresSourceFile, source, { encoding: 'utf-8' });
}
main().catch(e => {
    // eslint-disable-next-line no-console
    console.error(e);
    process.exitCode = 1;
});
//# sourceMappingURL=data:application/json;base64,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