"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const nested_cloud_assembly_artifact_1 = require("./nested-cloud-assembly-artifact");
const cloud_assembly_1 = require("../cloud-assembly");
const cacheSym = Symbol();
/**
 * The nested Assembly
 *
 * Declared in a different file to break circular dep between CloudAssembly and NestedCloudAssemblyArtifact
 */
Object.defineProperty(nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact.prototype, 'nestedAssembly', {
    get() {
        if (!this[cacheSym]) {
            this[cacheSym] = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this[cacheSym];
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmVzdGVkLWNsb3VkLWFzc2VtYmx5LWFydGlmYWN0LWF1Zy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm5lc3RlZC1jbG91ZC1hc3NlbWJseS1hcnRpZmFjdC1hdWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxRkFBK0U7QUFDL0Usc0RBQWtEO0FBRWxELE1BQU0sUUFBUSxHQUFHLE1BQU0sRUFBRSxDQUFDO0FBRTFCOzs7O0dBSUc7QUFDSCxNQUFNLENBQUMsY0FBYyxDQUFDLDREQUEyQixDQUFDLFNBQVMsRUFBRSxnQkFBZ0IsRUFBRTtJQUM3RSxHQUFHO1FBQ0QsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDO1lBQ3BCLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxJQUFJLDhCQUFhLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFDRCxPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztLQUN2QjtDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IE5lc3RlZENsb3VkQXNzZW1ibHlBcnRpZmFjdCB9IGZyb20gJy4vbmVzdGVkLWNsb3VkLWFzc2VtYmx5LWFydGlmYWN0JztcbmltcG9ydCB7IENsb3VkQXNzZW1ibHkgfSBmcm9tICcuLi9jbG91ZC1hc3NlbWJseSc7XG5cbmNvbnN0IGNhY2hlU3ltID0gU3ltYm9sKCk7XG5cbi8qKlxuICogVGhlIG5lc3RlZCBBc3NlbWJseVxuICpcbiAqIERlY2xhcmVkIGluIGEgZGlmZmVyZW50IGZpbGUgdG8gYnJlYWsgY2lyY3VsYXIgZGVwIGJldHdlZW4gQ2xvdWRBc3NlbWJseSBhbmQgTmVzdGVkQ2xvdWRBc3NlbWJseUFydGlmYWN0XG4gKi9cbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShOZXN0ZWRDbG91ZEFzc2VtYmx5QXJ0aWZhY3QucHJvdG90eXBlLCAnbmVzdGVkQXNzZW1ibHknLCB7XG4gIGdldCgpIHtcbiAgICBpZiAoIXRoaXNbY2FjaGVTeW1dKSB7XG4gICAgICB0aGlzW2NhY2hlU3ltXSA9IG5ldyBDbG91ZEFzc2VtYmx5KHRoaXMuZnVsbFBhdGgpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpc1tjYWNoZVN5bV07XG4gIH0sXG59KTtcbiJdfQ==