"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedCloudAssemblyArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const NESTED_CLOUD_ASSEMBLY_SYM = Symbol.for('@aws-cdk/cx-api.NestedCloudAssemblyArtifact');
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * Checks if `art` is an instance of this class.
     *
     * Use this method instead of `instanceof` to properly detect `NestedCloudAssemblyArtifact`
     * instances, even when the construct library is symlinked.
     *
     * Explanation: in JavaScript, multiple copies of the `cx-api` library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class `NestedCloudAssemblyArtifact` in each copy of the `cx-api` library
     * is seen as a different class, and an instance of one class will not test as
     * `instanceof` the other class. `npm install` will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the `cx-api`
     * library can be accidentally installed, and `instanceof` will behave
     * unpredictably. It is safest to avoid using `instanceof`, and using
     * this type-testing method instead.
     */
    static isNestedCloudAssemblyArtifact(art) {
        return art && typeof art === 'object' && art[NESTED_CLOUD_ASSEMBLY_SYM];
    }
    constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NestedCloudAssemblyArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        this.directoryName = properties.directoryName;
        this.displayName = properties.displayName ?? name;
    }
    /**
     * Full path to the nested assembly directory
     */
    get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
    }
}
exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
_a = JSII_RTTI_SYMBOL_1;
NestedCloudAssemblyArtifact[_a] = { fqn: "@aws-cdk/cx-api.NestedCloudAssemblyArtifact", version: "2.138.0" };
/**
 * Mark all instances of 'NestedCloudAssemblyArtifact'
 *
 * Why not put this in the constructor? Because this is a class property,
 * not an instance property. It applies to all instances of the class.
 */
Object.defineProperty(NestedCloudAssemblyArtifact.prototype, NESTED_CLOUD_ASSEMBLY_SYM, {
    value: true,
    enumerable: false,
    writable: false,
});
//# sourceMappingURL=data:application/json;base64,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