"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeCloudArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_artifact_1 = require("../cloud-artifact");
const TREE_CLOUD_ARTIFACT_SYM = Symbol.for('@aws-cdk/cx-api.TreeCloudArtifact');
class TreeCloudArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * Checks if `art` is an instance of this class.
     *
     * Use this method instead of `instanceof` to properly detect `TreeCloudArtifact`
     * instances, even when the construct library is symlinked.
     *
     * Explanation: in JavaScript, multiple copies of the `cx-api` library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class `TreeCloudArtifact` in each copy of the `cx-api` library
     * is seen as a different class, and an instance of one class will not test as
     * `instanceof` the other class. `npm install` will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the `cx-api`
     * library can be accidentally installed, and `instanceof` will behave
     * unpredictably. It is safest to avoid using `instanceof`, and using
     * this type-testing method instead.
     */
    static isTreeCloudArtifact(art) {
        return art && typeof art === 'object' && art[TREE_CLOUD_ARTIFACT_SYM];
    }
    constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TreeCloudArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid TreeCloudArtifact. Missing "file" property');
        }
        this.file = properties.file;
    }
}
exports.TreeCloudArtifact = TreeCloudArtifact;
_a = JSII_RTTI_SYMBOL_1;
TreeCloudArtifact[_a] = { fqn: "@aws-cdk/cx-api.TreeCloudArtifact", version: "2.138.0" };
/**
 * Mark all instances of 'TreeCloudArtifact'
 *
 * Why not put this in the constructor? Because this is a class property,
 * not an instance property. It applies to all instances of the class.
 */
Object.defineProperty(TreeCloudArtifact.prototype, TREE_CLOUD_ARTIFACT_SYM, {
    value: true,
    enumerable: false,
    writable: false,
});
//# sourceMappingURL=data:application/json;base64,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