"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const asset_manifest_artifact_1 = require("./artifacts/asset-manifest-artifact");
const cloudformation_artifact_1 = require("./artifacts/cloudformation-artifact");
const nested_cloud_assembly_artifact_1 = require("./artifacts/nested-cloud-assembly-artifact");
const tree_cloud_artifact_1 = require("./artifacts/tree-cloud-artifact");
const cloud_artifact_1 = require("./cloud-artifact");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
/**
 * Add the 'fromManifest' factory function
 *
 * It is defined in a separate file to avoid circular dependencies between 'cloud-artifact.ts'
 * and all of its subclass files.
 */
cloud_artifact_1.CloudArtifact.fromManifest = function fromManifest(assembly, id, artifact) {
    switch (artifact.type) {
        case cxschema.ArtifactType.AWS_CLOUDFORMATION_STACK:
            return new cloudformation_artifact_1.CloudFormationStackArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.CDK_TREE:
            return new tree_cloud_artifact_1.TreeCloudArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.ASSET_MANIFEST:
            return new asset_manifest_artifact_1.AssetManifestArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.NESTED_CLOUD_ASSEMBLY:
            return new nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact(assembly, id, artifact);
        default:
            return undefined;
    }
};
//# sourceMappingURL=data:application/json;base64,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