"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcSubnetGroupType = void 0;
/**
 * The type of subnet group.
 * Same as SubnetType in the aws-cdk-lib/aws-ec2 package,
 * but we can't use that because of cyclical dependencies.
 */
var VpcSubnetGroupType;
(function (VpcSubnetGroupType) {
    /** Public subnet group type. */
    VpcSubnetGroupType["PUBLIC"] = "Public";
    /** Private subnet group type. */
    VpcSubnetGroupType["PRIVATE"] = "Private";
    /** Isolated subnet group type. */
    VpcSubnetGroupType["ISOLATED"] = "Isolated";
})(VpcSubnetGroupType || (exports.VpcSubnetGroupType = VpcSubnetGroupType = {}));
//# sourceMappingURL=data:application/json;base64,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