"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY = exports.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE = exports.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID = exports.EFS_DENY_ANONYMOUS_ACCESS = exports.KMS_ALIAS_NAME_REF = exports.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION = exports.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID = exports.EC2_RESTRICT_DEFAULT_SECURITY_GROUP = exports.ENABLE_EMR_SERVICE_POLICY_V2 = exports.REDSHIFT_COLUMN_ID = exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = exports.ROUTE53_PATTERNS_USE_CERTIFICATE = exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS = exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = exports.ENABLE_PARTITION_LITERALS = exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = exports.S3_CREATE_DEFAULT_LOGGING_POLICY = exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = exports.IAM_MINIMIZE_POLICIES = exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = exports.TARGET_PARTITIONS = exports.CHECK_SECRET_USAGE = exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = exports.LAMBDA_RECOGNIZE_LAYER_VERSION = exports.LAMBDA_RECOGNIZE_VERSION_PROPS = exports.EFS_DEFAULT_ENCRYPTION_AT_REST = exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = exports.RDS_LOWERCASE_DB_IDENTIFIER = exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = exports.S3_GRANT_WRITE_WITHOUT_ACL = exports.KMS_DEFAULT_KEY_POLICIES = exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports.DOCKER_IGNORE_SUPPORT = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
exports.NEW_PROJECT_DEFAULT_CONTEXT = exports.FUTURE_FLAGS = exports.FUTURE_FLAGS_EXPIRED = exports.futureFlagDefault = exports.CURRENT_VERSION_FLAG_DEFAULTS = exports.NEW_PROJECT_CONTEXT = exports.CURRENT_VERSION_EXPIRED_FLAGS = exports.FLAGS = exports.KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE = exports.CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2 = exports.CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE = exports.LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION = exports.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME = exports.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION = exports.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS = exports.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS = exports.LAMBDA_NODEJS_USE_LATEST_RUNTIME = void 0;
const flag_modeling_1 = require("./private/flag-modeling");
////////////////////////////////////////////////////////////////////////
//
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file.
//
////////////////////////////////////////////////////////////////////////
//
//  !!! IMPORTANT !!!
//
//  When you introduce a new flag, set its 'introducedIn.v2' value to the literal string
// 'V2·NEXT', without the dot.
//
//  DO NOT USE A VARIABLE. DO NOT DEFINE A CONSTANT. The actual value will be string-replaced at
//  version bump time.
//
////////////////////////////////////////////////////////////////////////
//
// There are three types of flags: ApiDefault, BugFix, and VisibleContext flags.
//
// - ApiDefault flags: change the behavior or defaults of the construct library. When
//   set, the infrastructure that is generated may be different but there is
//   a way to get the old infrastructure setup by using the API in a different way.
//
// - BugFix flags: the old infra we used to generate is no longer recommended,
//   and there is no way to achieve that result anymore except by making sure the
//   flag is unset, or set to `false`. Mostly used for infra-impacting bugfixes or
//   enhanced security defaults.
//
// - VisibleContext flags: not really a feature flag, but configurable context which is
//   advertised by putting the context in the `cdk.json` file of new projects.
//
// In future major versions, the "newProjectValues" will become the version
// default for both DefaultBehavior and BugFix flags, and DefaultBehavior flags
// will be removed (i.e., their new behavior will become the *only* behavior).
//
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
exports.STACK_RELATIVE_EXPORTS_CONTEXT = '@aws-cdk/core:stackRelativeExports';
exports.DOCKER_IGNORE_SUPPORT = '@aws-cdk/aws-ecr-assets:dockerIgnoreSupport';
exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = '@aws-cdk/aws-secretsmanager:parseOwnedSecretName';
exports.KMS_DEFAULT_KEY_POLICIES = '@aws-cdk/aws-kms:defaultKeyPolicies';
exports.S3_GRANT_WRITE_WITHOUT_ACL = '@aws-cdk/aws-s3:grantWriteWithoutAcl';
exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = '@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount';
exports.RDS_LOWERCASE_DB_IDENTIFIER = '@aws-cdk/aws-rds:lowercaseDbIdentifier';
exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = '@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId';
exports.EFS_DEFAULT_ENCRYPTION_AT_REST = '@aws-cdk/aws-efs:defaultEncryptionAtRest';
exports.LAMBDA_RECOGNIZE_VERSION_PROPS = '@aws-cdk/aws-lambda:recognizeVersionProps';
exports.LAMBDA_RECOGNIZE_LAYER_VERSION = '@aws-cdk/aws-lambda:recognizeLayerVersion';
exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = '@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021';
exports.CHECK_SECRET_USAGE = '@aws-cdk/core:checkSecretUsage';
exports.TARGET_PARTITIONS = '@aws-cdk/core:target-partitions';
exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = '@aws-cdk-containers/ecs-service-extensions:enableDefaultLogDriver';
exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = '@aws-cdk/aws-ec2:uniqueImdsv2TemplateName';
exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = '@aws-cdk/aws-ecs:arnFormatIncludesClusterName';
exports.IAM_MINIMIZE_POLICIES = '@aws-cdk/aws-iam:minimizePolicies';
exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = '@aws-cdk/aws-iam:importedRoleStackSafeDefaultPolicyName';
exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = '@aws-cdk/core:validateSnapshotRemovalPolicy';
exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = '@aws-cdk/aws-codepipeline:crossAccountKeyAliasStackSafeResourceName';
exports.S3_CREATE_DEFAULT_LOGGING_POLICY = '@aws-cdk/aws-s3:createDefaultLoggingPolicy';
exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = '@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption';
exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = '@aws-cdk/aws-apigateway:disableCloudWatchRole';
exports.ENABLE_PARTITION_LITERALS = '@aws-cdk/core:enablePartitionLiterals';
exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = '@aws-cdk/aws-events:eventsTargetQueueSameAccount';
exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS = '@aws-cdk/aws-iam:standardizedServicePrincipals';
exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = '@aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker';
exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = '@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy';
exports.ROUTE53_PATTERNS_USE_CERTIFICATE = '@aws-cdk/aws-route53-patters:useCertificate';
exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = '@aws-cdk/customresources:installLatestAwsSdkDefault';
exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = '@aws-cdk/aws-rds:databaseProxyUniqueResourceName';
exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = '@aws-cdk/aws-codedeploy:removeAlarmsFromDeploymentGroup';
exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = '@aws-cdk/aws-apigateway:authorizerChangeDeploymentLogicalId';
exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = '@aws-cdk/aws-ec2:launchTemplateDefaultUserData';
exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = '@aws-cdk/aws-secretsmanager:useAttachedSecretResourcePolicyForSecretTargetAttachments';
exports.REDSHIFT_COLUMN_ID = '@aws-cdk/aws-redshift:columnId';
exports.ENABLE_EMR_SERVICE_POLICY_V2 = '@aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2';
exports.EC2_RESTRICT_DEFAULT_SECURITY_GROUP = '@aws-cdk/aws-ec2:restrictDefaultSecurityGroup';
exports.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID = '@aws-cdk/aws-apigateway:requestValidatorUniqueId';
exports.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION = '@aws-cdk/core:includePrefixInUniqueNameGeneration';
exports.KMS_ALIAS_NAME_REF = '@aws-cdk/aws-kms:aliasNameRef';
exports.EFS_DENY_ANONYMOUS_ACCESS = '@aws-cdk/aws-efs:denyAnonymousAccess';
exports.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID = '@aws-cdk/aws-efs:mountTargetOrderInsensitiveLogicalId';
exports.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE = '@aws-cdk/aws-autoscaling:generateLaunchTemplateInsteadOfLaunchConfig';
exports.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY = '@aws-cdk/aws-opensearchservice:enableOpensearchMultiAzWithStandby';
exports.LAMBDA_NODEJS_USE_LATEST_RUNTIME = '@aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion';
exports.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS = '@aws-cdk/aws-rds:preventRenderingDeprecatedCredentials';
exports.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS = '@aws-cdk/aws-rds:auroraClusterChangeScopeOfInstanceParameterGroupWithEachParameters';
exports.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION = '@aws-cdk/aws-appsync:useArnForSourceApiAssociationIdentifier';
exports.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME = '@aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource';
exports.LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION = '@aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction';
exports.CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE = '@aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse';
exports.CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2 = '@aws-cdk/aws-codepipeline:defaultPipelineTypeToV2';
exports.KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE = '@aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope';
exports.FLAGS = {
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Allow multiple stacks with the same name',
        detailsMd: `
      If this is set, multiple stacks can use the same stack name (e.g. deployed to
      different environments). This means that the name of the synthesized template
      file will be based on the construct path and not on the defined \`stackName\`
      of the stack.`,
        recommendedValue: true,
        introducedIn: { v1: '1.16.0' },
        defaults: { v2: true },
        compatibilityWithOldBehaviorMd: 'Pass stack identifiers to the CLI instead of stack names.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Make `cdk diff` not fail when there are differences',
        detailsMd: `
      Determines what status code \`cdk diff\` should return when the specified stack
      differs from the deployed stack or the local CloudFormation template:

      * \`aws-cdk:enableDiffNoFail=true\` => status code == 0
      * \`aws-cdk:enableDiffNoFail=false\` => status code == 1

      You can override this behavior with the --fail flag:

      * \`--fail\` => status code == 1
      * \`--no-fail\` => status code == 0`,
        introducedIn: { v1: '1.19.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Specify `--fail` to the CLI.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Switch to new stack synthesis method which enables CI/CD',
        detailsMd: `
      If this flag is specified, all \`Stack\`s will use the \`DefaultStackSynthesizer\` by
      default. If it is not set, they will use the \`LegacyStackSynthesizer\`.`,
        introducedIn: { v1: '1.39.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Name exports based on the construct paths relative to the stack, rather than the global construct path',
        detailsMd: `
      Combined with the stack name this relative construct path is good enough to
      ensure uniqueness, and makes the export names robust against refactoring
      the location of the stack in the construct tree (specifically, moving the Stack
      into a Stage).`,
        introducedIn: { v1: '1.58.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.DOCKER_IGNORE_SUPPORT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'DockerImageAsset properly supports `.dockerignore` files by default',
        detailsMd: `
      If this flag is not set, the default behavior for \`DockerImageAsset\` is to use
      glob semantics for \`.dockerignore\` files. If this flag is set, the default behavior
      is standard Docker ignore semantics.

      This is a feature flag as the old behavior was technically incorrect but
      users may have come to depend on it.`,
        introducedIn: { v1: '1.73.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Update your `.dockerignore` file to match standard Docker ignore rules, if necessary.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Fix the referencing of SecretsManager names from ARNs',
        detailsMd: `
      Secret.secretName for an "owned" secret will attempt to parse the secretName from the ARN,
      rather than the default full resource name, which includes the SecretsManager suffix.

      If this flag is not set, Secret.secretName will include the SecretsManager suffix, which cannot be directly
      used by SecretsManager.DescribeSecret, and must be parsed by the user first (e.g., Fn:Join, Fn:Select, Fn:Split).`,
        introducedIn: { v1: '1.77.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Use `parseArn(secret.secretName).resourceName` to emulate the incorrect old parsing.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.KMS_DEFAULT_KEY_POLICIES]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Tighten default KMS key policies',
        detailsMd: `
      KMS Keys start with a default key policy that grants the account access to administer the key,
      mirroring the behavior of the KMS SDK/CLI/Console experience. Users may override the default key
      policy by specifying their own.

      If this flag is not set, the default key policy depends on the setting of the \`trustAccountIdentities\`
      flag. If false (the default, for backwards-compatibility reasons), the default key policy somewhat
      resembles the default admin key policy, but with the addition of 'GenerateDataKey' permissions. If
      true, the policy matches what happens when this feature flag is set.

      Additionally, if this flag is not set and the user supplies a custom key policy, this will be appended
      to the key's default policy (rather than replacing it).`,
        introducedIn: { v1: '1.78.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `trustAccountIdentities: false` to `Key` construct to restore the old behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_GRANT_WRITE_WITHOUT_ACL]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Remove `PutObjectAcl` from Bucket.grantWrite',
        detailsMd: `
      Change the old 's3:PutObject*' permission to 's3:PutObject' on Bucket,
      as the former includes 's3:PutObjectAcl',
      which could be used to grant read/write object access to IAM principals in other accounts.
      Use a feature flag to make sure existing customers who might be relying
      on the overly-broad permissions are not broken.`,
        introducedIn: { v1: '1.85.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Call `bucket.grantPutAcl()` in addition to `bucket.grantWrite()` to grant ACL permissions.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Do not specify a default DesiredCount for ECS services',
        detailsMd: `
      ApplicationLoadBalancedServiceBase, ApplicationMultipleTargetGroupServiceBase,
      NetworkLoadBalancedServiceBase, NetworkMultipleTargetGroupServiceBase, and
      QueueProcessingServiceBase currently determine a default value for the desired count of
      a CfnService if a desiredCount is not provided. The result of this is that on every
      deployment, the service count is reset to the fixed value, even if it was autoscaled.

      If this flag is not set, the default behaviour for CfnService.desiredCount is to set a
      desiredCount of 1, if one is not provided. If true, a default will not be defined for
      CfnService.desiredCount and as such desiredCount will be undefined, if one is not provided.`,
        introducedIn: { v1: '1.92.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'You can pass `desiredCount: 1` explicitly, but you should never need this.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.RDS_LOWERCASE_DB_IDENTIFIER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Force lowercasing of RDS Cluster names in CDK',
        detailsMd: `
      Cluster names must be lowercase, and the service will lowercase the name when the cluster
      is created. However, CDK did not use to know about this, and would use the user-provided name
      referencing the cluster, which would fail if it happened to be mixed-case.

      With this flag, lowercase the name in CDK so we can reference it properly.

      Must be behind a permanent flag because changing a name from mixed case to lowercase between deployments
      would lead CloudFormation to think the name was changed and would trigger a cluster replacement
      (losing data!).`,
        introducedIn: { v1: '1.97.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Allow adding/removing multiple UsagePlanKeys independently',
        detailsMd: `
      The UsagePlanKey resource connects an ApiKey with a UsagePlan. API Gateway does not allow more than one UsagePlanKey
      for any given UsagePlan and ApiKey combination. For this reason, CloudFormation cannot replace this resource without
      either the UsagePlan or ApiKey changing.

      The feature addition to support multiple UsagePlanKey resources - 142bd0e2 - recognized this and attempted to keep
      existing UsagePlanKey logical ids unchanged.
      However, this intentionally caused the logical id of the UsagePlanKey to be sensitive to order. That is, when
      the 'first' UsagePlanKey resource is removed, the logical id of the 'second' assumes what was originally the 'first',
      which again is disallowed.

      In effect, there is no way to get out of this mess in a backwards compatible way, while supporting existing stacks.
      This flag changes the logical id layout of UsagePlanKey to not be sensitive to order.`,
        introducedIn: { v1: '1.98.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enable this feature flag to have elastic file systems encrypted at rest by default.',
        detailsMd: `
      Encryption can also be configured explicitly using the \`encrypted\` property.
      `,
        introducedIn: { v1: '1.98.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass the `encrypted: false` property to the `FileSystem` construct to disable encryption.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the  `fn.currentVersion`.',
        detailsMd: `
      The previous calculation incorrectly considered properties of the \`AWS::Lambda::Function\` resource that did
      not constitute creating a new Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: '1.106.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_RECOGNIZE_LAYER_VERSION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the `fn.currentVersion`.',
        detailsMd: `
      This flag correct incorporates Lambda Layer properties into the Lambda Function Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: '1.159.0', v2: '2.27.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to have cloudfront distributions use the security policy TLSv1.2_2021 by default.',
        detailsMd: `
      The security policy can also be configured explicitly using the \`minimumProtocolVersion\` property.`,
        introducedIn: { v1: '1.117.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CHECK_SECRET_USAGE]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'Enable this flag to make it impossible to accidentally use SecretValues in unsafe locations',
        detailsMd: `
      With this flag enabled, \`SecretValue\` instances can only be passed to
      constructs that accept \`SecretValue\`s; otherwise, \`unsafeUnwrap()\` must be
      called to use it as a regular string.`,
        introducedIn: { v1: '1.153.0', v2: '2.21.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.TARGET_PARTITIONS]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'What regions to include in lookup tables of environment agnostic stacks',
        detailsMd: `
      Has no effect on stacks that have a defined region, but will limit the amount
      of unnecessary regions included in stacks without a known region.

      The type of this value should be a list of strings.`,
        introducedIn: { v1: '1.137.0', v2: '2.4.0' },
        recommendedValue: ['aws', 'aws-cn'],
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'ECS extensions will automatically add an `awslogs` driver if no logging is specified',
        detailsMd: `
      Enable this feature flag to configure default logging behavior for the ECS Service Extensions. This will enable the
      \`awslogs\` log driver for the application container of the service to send the container logs to CloudWatch Logs.

      This is a feature flag as the new behavior provides a better default experience for the users.`,
        introducedIn: { v1: '1.140.0', v2: '2.8.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Specify a log driver explicitly.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to have Launch Templates generated by the `InstanceRequireImdsv2Aspect` use unique names.',
        detailsMd: `
      Previously, the generated Launch Template names were only unique within a stack because they were based only on the
      \`Instance\` construct ID. If another stack that has an \`Instance\` with the same construct ID is deployed in the same
      account and region, the deployments would always fail as the generated Launch Template names were the same.

      The new implementation addresses this issue by generating the Launch Template name with the \`Names.uniqueId\` method.`,
        introducedIn: { v1: '1.140.0', v2: '2.8.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'ARN format used by ECS. In the new ARN format, the cluster name is part of the resource ID.',
        detailsMd: `
      If this flag is not set, the old ARN format (without cluster name) for ECS is used.
      If this flag is set, the new ARN format (with cluster name) for ECS is used.

      This is a feature flag as the old format is still valid for existing ECS clusters.

      See https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids
      `,
        introducedIn: { v2: '2.35.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_MINIMIZE_POLICIES]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'Minimize IAM policies by combining Statements',
        detailsMd: `
      Minimize IAM policies by combining Principals, Actions and Resources of two
      Statements in the policies, as long as it doesn't change the meaning of the
      policy.`,
        introducedIn: { v1: '1.150.0', v2: '2.18.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Error on snapshot removal policies on resources that do not support it.',
        detailsMd: `
      Makes sure we do not allow snapshot removal policy on resources that do not support it.
      If supplied on an unsupported resource, CloudFormation ignores the policy altogether.
      This flag will reduce confusion and unexpected loss of data when erroneously supplying
      the snapshot removal policy.`,
        introducedIn: { v2: '2.28.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'The old behavior was incorrect. Update your source to not specify SNAPSHOT policies on resources that do not support it.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Generate key aliases that include the stack name',
        detailsMd: `
      Enable this feature flag to have CodePipeline generate a unique cross account key alias name using the stack name.

      Previously, when creating multiple pipelines with similar naming conventions and when crossAccountKeys is true,
      the KMS key alias name created for these pipelines may be the same due to how the uniqueId is generated.

      This new implementation creates a stack safe resource name for the alias using the stack name instead of the stack ID.
      `,
        introducedIn: { v2: '2.29.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_CREATE_DEFAULT_LOGGING_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to create an S3 bucket policy by default in cases where an AWS service would automatically create the Policy if one does not exist.',
        detailsMd: `
      For example, in order to send VPC flow logs to an S3 bucket, there is a specific Bucket Policy
      that needs to be attached to the bucket. If you create the bucket without a policy and then add the
      bucket as the flow log destination, the service will automatically create the bucket policy with the
      necessary permissions. If you were to then try and add your own bucket policy CloudFormation will throw
      and error indicating that a bucket policy already exists.

      In cases where we know what the required policy is we can go ahead and create the policy so we can
      remain in control of it.

      @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3
      `,
        introducedIn: { v2: '2.31.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Restrict KMS key policy for encrypted Queues a bit more',
        detailsMd: `
      Enable this feature flag to restrict the decryption of a SQS queue, which is subscribed to a SNS topic, to
      only the topic which it is subscribed to and not the whole SNS service of an account.

      Previously the decryption was only restricted to the SNS service principal. To make the SQS subscription more
      secure, it is a good practice to restrict the decryption further and only allow the connected SNS topic to decryption
      the subscribed queue.`,
        introducedIn: { v2: '2.32.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Make default CloudWatch Role behavior safe for multiple API Gateways in one environment',
        detailsMd: `
      Enable this feature flag to change the default behavior for aws-apigateway.RestApi and aws-apigateway.SpecRestApi
      to _not_ create a CloudWatch role and Account. There is only a single ApiGateway account per AWS
      environment which means that each time you create a RestApi in your account the ApiGateway account
      is overwritten. If at some point the newest RestApi is deleted, the ApiGateway Account and CloudWatch
      role will also be deleted, breaking any existing ApiGateways that were depending on them.

      When this flag is enabled you should either create the ApiGateway account and CloudWatch role
      separately _or_ only enable the cloudWatchRole on a single RestApi.
      `,
        introducedIn: { v2: '2.38.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_PARTITION_LITERALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Make ARNs concrete if AWS partition is known',
        // eslint-disable-next-line @aws-cdk/no-literal-partition
        detailsMd: `
      Enable this feature flag to get partition names as string literals in Stacks with known regions defined in
      their environment, such as "aws" or "aws-cn".  Previously the CloudFormation intrinsic function
      "Ref: AWS::Partition" was used.  For example:

      \`\`\`yaml
      Principal:
        AWS:
          Fn::Join:
            - ""
            - - "arn:"
              - Ref: AWS::Partition
              - :iam::123456789876:root
      \`\`\`

      becomes:

      \`\`\`yaml
      Principal:
        AWS: "arn:aws:iam::123456789876:root"
      \`\`\`

      The intrinsic function will still be used in Stacks where no region is defined or the region's partition
      is unknown.
      `,
        introducedIn: { v2: '2.38.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Event Rules may only push to encrypted SQS queues in the same account',
        detailsMd: `
      This flag applies to SQS Queues that are used as the target of event Rules. When enabled, only principals
      from the same account as the Rule can send messages. If a queue is unencrypted, this restriction will
      always apply, regardless of the value of this flag.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use standardized (global) service principals everywhere',
        detailsMd: `
      We used to maintain a database of exceptions to Service Principal names in various regions. This database
      is no longer necessary: all service principals names have been standardized to their global form (\`SERVICE.amazonaws.com\`).

      This flag disables use of that exceptions database and always uses the global service principal.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Avoid setting the "ECS" deployment controller when adding a circuit breaker',
        detailsMd: `
      Enable this feature flag to avoid setting the "ECS" deployment controller when adding a circuit breaker to an
      ECS Service, as this will trigger a full replacement which fails to deploy when using set service names.
      This does not change any behaviour as the default deployment controller when it is not defined is ECS.

      This is a feature flag as the new behavior provides a better default experience for the users.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature to by default create default policy names for imported roles that depend on the stack the role is in.',
        detailsMd: `
      Without this, importing the same role in multiple places could lead to the permissions given for one version of the imported role
      to overwrite permissions given to the role at a different place where it was imported. This was due to all imported instances
      of a role using the same default policy name.

      This new implementation creates default policy names based on the constructs node path in their stack.
      `,
        introducedIn: { v2: '2.60.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use S3 Bucket Policy instead of ACLs for Server Access Logging',
        detailsMd: `
      Enable this feature flag to use S3 Bucket Policy for granting permission fo Server Access Logging
      rather than using the canned \`LogDeliveryWrite\` ACL. ACLs do not work when Object Ownership is
      enabled on the bucket.

      This flag uses a Bucket Policy statement to allow Server Access Log delivery, following best
      practices for S3.

      @see https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html
    `,
        introducedIn: { v2: '2.60.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ROUTE53_PATTERNS_USE_CERTIFICATE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Use the official `Certificate` resource instead of `DnsValidatedCertificate`',
        detailsMd: `
      Enable this feature flag to use the official CloudFormation supported \`Certificate\` resource instead
      of the deprecated \`DnsValidatedCertificate\` construct. If this flag is enabled and you are creating
      the stack in a region other than us-east-1 then you must also set \`crossRegionReferences=true\` on the
      stack.
      `,
        introducedIn: { v2: '2.61.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Define a `DnsValidatedCertificate` explicitly and pass in the `certificate` property',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Whether to install the latest SDK by default in AwsCustomResource',
        detailsMd: `
      This was originally introduced and enabled by default to not be limited by the SDK version
      that's installed on AWS Lambda. However, it creates issues for Lambdas bound to VPCs that
      do not have internet access, or in environments where 'npmjs.com' is not available.

      The recommended setting is to disable the default installation behavior, and pass the
      flag on a resource-by-resource basis to enable it if necessary.
    `,
        compatibilityWithOldBehaviorMd: 'Set installLatestAwsSdk: true on all resources that need it.',
        introducedIn: { v2: '2.60.0' },
        recommendedValue: false,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use unique resource name for Database Proxy',
        detailsMd: `
      If this flag is not set, the default behavior for \`DatabaseProxy\` is
      to use \`id\` of the constructor for \`dbProxyName\` when it's not specified in the argument.
      In this case, users can't deploy \`DatabaseProxy\`s that have the same \`id\` in the same region.

      If this flag is set, the default behavior is to use unique resource names for each \`DatabaseProxy\`.

      This is a feature flag as the old behavior was technically incorrect, but users may have come to depend on it.
    `,
        introducedIn: { v2: '2.65.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Remove CloudWatch alarms from deployment group',
        detailsMd: `
      Enable this flag to be able to remove all CloudWatch alarms from a deployment group by removing
      the alarms from the construct. If this flag is not set, removing all alarms from the construct
      will still leave the alarms configured for the deployment group.
    `,
        introducedIn: { v2: '2.65.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Include authorizer configuration in the calculation of the API deployment logical ID.',
        detailsMd: `
      The logical ID of the AWS::ApiGateway::Deployment resource is calculated by hashing
      the API configuration, including methods, and resources, etc. Enable this feature flag
      to also include the configuration of any authorizer attached to the API in the
      calculation, so any changes made to an authorizer will create a new deployment.
      `,
        introducedIn: { v2: '2.66.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Define user data for a launch template by default when a machine image is provided.',
        detailsMd: `
      The ec2.LaunchTemplate construct did not define user data when a machine image is
      provided despite the document. If this is set, a user data is automatically defined
      according to the OS of the machine image.
      `,
        recommendedValue: true,
        introducedIn: { v2: '2.67.0' },
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'SecretTargetAttachments uses the ResourcePolicy of the attached Secret.',
        detailsMd: `
      Enable this feature flag to make SecretTargetAttachments use the ResourcePolicy of the attached Secret.
      SecretTargetAttachments are created to connect a Secret to a target resource.
      In CDK code, they behave like regular Secret and can be used as a stand-in in most situations.
      Previously, adding to the ResourcePolicy of a SecretTargetAttachment did attempt to create a separate ResourcePolicy for the same Secret.
      However Secrets can only have a single ResourcePolicy, causing the CloudFormation deployment to fail.

      When enabling this feature flag for an existing Stack, ResourcePolicies created via a SecretTargetAttachment will need replacement.
      This won't be possible without intervention due to limitation outlined above.
      First remove all permissions granted to the Secret and deploy without the ResourcePolicies.
      Then you can re-add the permissions and deploy again.
      `,
        recommendedValue: true,
        introducedIn: { v2: '2.67.0' },
    },
    //////////////////////////////////////////////////////////////////////
    [exports.REDSHIFT_COLUMN_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Whether to use an ID to track Redshift column changes',
        detailsMd: `
      Redshift columns are identified by their \`name\`. If a column is renamed, the old column
      will be dropped and a new column will be created. This can cause data loss.

      This flag enables the use of an \`id\` attribute for Redshift columns. If this flag is enabled, the
      internal CDK architecture will track changes of Redshift columns through their \`id\`, rather
      than their \`name\`. This will prevent data loss when columns are renamed.

      **NOTE** - Enabling this flag comes at a **risk**. When enabled, update the \`id\`s of all columns,
      **however** do not change the \`names\`s of the columns. If the \`name\`s of the columns are changed during
      initial deployment, the columns will be dropped and recreated, causing data loss. After the initial deployment
      of the \`id\`s, the \`name\`s of the columns can be changed without data loss.
      `,
        introducedIn: { v2: '2.68.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_EMR_SERVICE_POLICY_V2]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable AmazonEMRServicePolicy_v2 managed policies',
        detailsMd: `
      If this flag is not set, the default behavior for \`EmrCreateCluster\` is
      to use \`AmazonElasticMapReduceRole\` managed policies.

      If this flag is set, the default behavior is to use the new \`AmazonEMRServicePolicy_v2\`
      managed policies.

      This is a feature flag as the old behavior will be deprecated, but some resources may require manual
      intervention since they might not have the appropriate tags propagated automatically.
      `,
        introducedIn: { v2: '2.72.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_RESTRICT_DEFAULT_SECURITY_GROUP]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Restrict access to the VPC default security group',
        detailsMd: `
      Enable this feature flag to remove the default ingress/egress rules from the
      VPC default security group.

      When a VPC is created, a default security group is created as well and this cannot
      be deleted. The default security group is created with ingress/egress rules that allow
      _all_ traffic. [AWS Security best practices recommend](https://docs.aws.amazon.com/securityhub/latest/userguide/ec2-controls.html#ec2-2)
      removing these ingress/egress rules in order to restrict access to the default security group.
    `,
        introducedIn: { v2: '2.78.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: `
      To allow all ingress/egress traffic to the VPC default security group you
      can set the \`restrictDefaultSecurityGroup: false\`.
    `,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Generate a unique id for each RequestValidator added to a method',
        detailsMd: `
      This flag allows multiple RequestValidators to be added to a RestApi when
      providing the \`RequestValidatorOptions\` in the \`addMethod()\` method.

      If the flag is not set then only a single RequestValidator can be added in this way.
      Any additional RequestValidators have to be created directly with \`new RequestValidator\`.
    `,
        introducedIn: { v2: '2.78.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.KMS_ALIAS_NAME_REF]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'KMS Alias name and keyArn will have implicit reference to KMS Key',
        detailsMd: `
      This flag allows an implicit dependency to be created between KMS Alias and KMS Key
      when referencing key.aliasName or key.keyArn.

      If the flag is not set then a raw string is passed as the Alias name and no
      implicit dependencies will be set.
    `,
        introducedIn: { v2: '2.83.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Generate a launch template when creating an AutoScalingGroup',
        detailsMd: `
      Enable this flag to allow AutoScalingGroups to generate a launch template when being created.
      Launch configurations have been deprecated and cannot be created in AWS Accounts created after
      December 31, 2023. Existing 'AutoScalingGroup' properties used for creating a launch configuration
      will now create an equivalent 'launchTemplate'. Alternatively, users can provide an explicit
      'launchTemplate' or 'mixedInstancesPolicy'. When this flag is enabled a 'launchTemplate' will
      attempt to set user data according to the OS of the machine image if explicit user data is not
      provided.
    `,
        introducedIn: { v2: '2.88.0' },
        compatibilityWithOldBehaviorMd: `
      If backwards compatibility needs to be maintained due to an existing autoscaling group
      using a launch config, set this flag to false.
    `,
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Include the stack prefix in the stack name generation process',
        detailsMd: `
      This flag prevents the prefix of a stack from making the stack's name longer than the 128 character limit.

      If the flag is set, the prefix is included in the stack name generation process.
      If the flag is not set, then the prefix of the stack is prepended to the generated stack name.

      **NOTE** - Enabling this flag comes at a **risk**. If you have already deployed stacks, changing the status of this
      feature flag can lead to a change in stacks' name. Changing a stack name mean recreating the whole stack, which
      is not viable in some productive setups.
    `,
        introducedIn: { v2: '2.84.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EFS_DENY_ANONYMOUS_ACCESS]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'EFS denies anonymous clients accesses',
        detailsMd: `
      This flag adds the file system policy that denies anonymous clients
      access to \`efs.FileSystem\`.

      If this flag is not set, \`efs.FileSystem\` will allow all anonymous clients
      that can access over the network.`,
        introducedIn: { v2: '2.93.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'You can pass `allowAnonymousAccess: true` so allow anonymous clients access.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enables support for Multi-AZ with Standby deployment for opensearch domains',
        detailsMd: `
      If this is set, an opensearch domain will automatically be created with
      multi-az with standby enabled.
    `,
        introducedIn: { v2: '2.88.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `capacity.multiAzWithStandbyEnabled: false` to `Domain` construct to restore the old behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_NODEJS_USE_LATEST_RUNTIME]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enables aws-lambda-nodejs.Function to use the latest available NodeJs runtime as the default',
        detailsMd: `
      If this is set, and a \`runtime\` prop is not passed to, Lambda NodeJs
      functions will us the latest version of the runtime provided by the Lambda
      service. Do not use this if you your lambda function is reliant on dependencies
      shipped as part of the runtime environment.
    `,
        introducedIn: { v2: '2.93.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `runtime: lambda.Runtime.NODEJS_16_X` to `Function` construct to restore the previous behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, mount targets will have a stable logicalId that is linked to the associated subnet.',
        detailsMd: `
      When this feature flag is enabled, each mount target will have a stable
      logicalId that is linked to the associated subnet. If the flag is set to
      false then the logicalIds of the mount targets can change if the number of
      subnets changes.

      Set this flag to false for existing mount targets.
    `,
        introducedIn: { v2: '2.93.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, a scope of InstanceParameterGroup for AuroraClusterInstance with each parameters will change.',
        detailsMd: `
      When this feature flag is enabled, a scope of \`InstanceParameterGroup\` for
      \`AuroraClusterInstance\` with each parameters will change to AuroraClusterInstance
      from AuroraCluster.

      If the flag is set to false then it can only make one \`AuroraClusterInstance\`
      with each \`InstanceParameterGroup\` in the AuroraCluster.
    `,
        introducedIn: { v2: '2.97.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, will always use the arn for identifiers for CfnSourceApiAssociation in the GraphqlApi construct rather than id.',
        detailsMd: `
      When this feature flag is enabled, we use the IGraphqlApi ARN rather than ID when creating or updating CfnSourceApiAssociation in 
      the GraphqlApi construct. Using the ARN allows the association to support an association with a source api or merged api in another account.
      Note that for existing source api associations created with this flag disabled, enabling the flag will lead to a resource replacement. 
    `,
        introducedIn: { v2: '2.97.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, creating an RDS database cluster from a snapshot will only render credentials for snapshot credentials.',
        detailsMd: `
      The \`credentials\` property on the \`DatabaseClusterFromSnapshotProps\`
      interface was deprecated with the new \`snapshotCredentials\` property being
      recommended. Before deprecating \`credentials\`, a secret would be generated
      while rendering credentials if the \`credentials\` property was undefined or
      if a secret wasn't provided via the \`credentials\` property. This behavior
      is replicated with the new \`snapshotCredentials\` property, but the original
      \`credentials\` secret can still be created resulting in an extra database
      secret.
      
      Set this flag to prevent rendering deprecated \`credentials\` and creating an
      extra database secret when only using \`snapshotCredentials\` to create an RDS
      database cluster from a snapshot.
    `,
        introducedIn: { v2: '2.98.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, the CodeCommit source action is using the default branch name \'main\'.',
        detailsMd: `
      When setting up a CodeCommit source action for the source stage of a pipeline, please note that the 
      default branch is \'master\'.
      However, with the activation of this feature flag, the default branch is updated to \'main\'.
    `,
        introducedIn: { v2: '2.103.1' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, the logical ID of a Lambda permission for a Lambda action includes an alarm ID.',
        detailsMd: `
      When this feature flag is enabled, a logical ID of \`LambdaPermission\` for a
      \`LambdaAction\` will include an alarm ID. Therefore multiple alarms for the same Lambda
      can be created with \`LambdaAction\`.
      
      If the flag is set to false then it can only make one alarm for the Lambda with
      \`LambdaAction\`.
    `,
        introducedIn: { v2: '2.124.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enables Pipeline to set the default value for crossAccountKeys to false.',
        detailsMd: `
      When this feature flag is enabled, and the \`crossAccountKeys\` property is not provided in a \`Pipeline\`
      construct, the construct automatically defaults the value of this property to false.
    `,
        introducedIn: { v2: '2.127.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `crossAccountKeys: true` to `Pipeline` construct to restore the previous behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enables Pipeline to set the default pipeline type to V2.',
        detailsMd: `
      When this feature flag is enabled, and the \`pipelineType\` property is not provided in a \`Pipeline\`
      construct, the construct automatically defaults the value of this property to \`PipelineType.V2\`.
    `,
        introducedIn: { v2: '2.133.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `pipelineType: PipelineType.V1` to `Pipeline` construct to restore the previous behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, IAM Policy created from KMS key grant will reduce the resource scope to this key only.',
        detailsMd: `
      When this feature flag is enabled and calling KMS key grant method, the created IAM policy will reduce the resource scope from
      '*' to this specific granting KMS key.
    `,
        introducedIn: { v2: '2.134.0' },
        recommendedValue: true,
    },
};
const CURRENT_MV = 'v2';
/**
 * The list of future flags that are now expired. This is going to be used to identify
 * and block usages of old feature flags in the new major version of CDK.
 */
exports.CURRENT_VERSION_EXPIRED_FLAGS = Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.introducedIn[CURRENT_MV] === undefined)
    .map(([name, _]) => name).sort();
/**
 * Flag values that should apply for new projects
 *
 * Add a flag in here (typically with the value `true`), to enable
 * backwards-breaking behavior changes only for new projects.  New projects
 * generated through `cdk init` will include these flags in their generated
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.NEW_PROJECT_CONTEXT = Object.fromEntries(Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.recommendedValue !== flag.defaults?.[CURRENT_MV] && flag.introducedIn[CURRENT_MV])
    .map(([name, flag]) => [name, flag.recommendedValue]));
/**
 * The default values of each of these flags in the current major version.
 *
 * This is the effective value of the flag, unless it's overriden via
 * context.
 *
 * Adding new flags here is only allowed during the pre-release period of a new
 * major version!
 */
exports.CURRENT_VERSION_FLAG_DEFAULTS = Object.fromEntries(Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.defaults?.[CURRENT_MV] !== undefined)
    .map(([name, flag]) => [name, flag.defaults?.[CURRENT_MV]]));
function futureFlagDefault(flag) {
    const value = exports.CURRENT_VERSION_FLAG_DEFAULTS[flag] ?? false;
    if (typeof value !== 'boolean') {
        throw new Error(`futureFlagDefault: default type of flag '${flag}' should be boolean, got '${typeof value}'`);
    }
    return value;
}
exports.futureFlagDefault = futureFlagDefault;
// Nobody should have been using any of this, but you never know
/** @deprecated use CURRENT_VERSION_EXPIRED_FLAGS instead */
exports.FUTURE_FLAGS_EXPIRED = exports.CURRENT_VERSION_EXPIRED_FLAGS;
/** @deprecated use NEW_PROJECT_CONTEXT instead */
exports.FUTURE_FLAGS = Object.fromEntries(Object.entries(exports.NEW_PROJECT_CONTEXT)
    .filter(([_, v]) => typeof v === 'boolean'));
/** @deprecated use NEW_PROJECT_CONTEXT instead */
exports.NEW_PROJECT_DEFAULT_CONTEXT = Object.fromEntries(Object.entries(exports.NEW_PROJECT_CONTEXT)
    .filter(([_, v]) => typeof v !== 'boolean'));
//# sourceMappingURL=data:application/json;base64,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