"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentPlaceholders = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Placeholders which can be used manifests
 *
 * These can occur both in the Asset Manifest as well as the general
 * Cloud Assembly manifest.
 */
class EnvironmentPlaceholders {
    /**
     * Replace the environment placeholders in all strings found in a complex object.
     *
     * Duplicated between cdk-assets and aws-cdk CLI because we don't have a good single place to put it
     * (they're nominally independent tools).
     */
    static replace(object, values) {
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_EnvironmentPlaceholderValues(values);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.replace);
            }
            throw error;
        }
        return this.recurse(object, value => {
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, values.region);
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, values.accountId);
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, values.partition);
            return value;
        });
    }
    /**
     * Like 'replace', but asynchronous
     */
    static async replaceAsync(object, provider) {
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_IEnvironmentPlaceholderProvider(provider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.replaceAsync);
            }
            throw error;
        }
        let needRegion = false;
        let needAccountId = false;
        let needPartition = false;
        this.recurse(object, value => {
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_REGION) > 1) {
                needRegion = true;
            }
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_ACCOUNT) > 1) {
                needAccountId = true;
            }
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_PARTITION) > 1) {
                needPartition = true;
            }
            return value;
        });
        const region = needRegion ? await provider.region() : undefined;
        const accountId = needAccountId ? await provider.accountId() : undefined;
        const partition = needPartition ? await provider.partition() : undefined;
        return this.recurse(object, value => {
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, region ?? 'WONTHAPPEN');
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, accountId ?? 'WONTHAPPEN');
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, partition ?? 'WONTHAPPEN');
            return value;
        });
    }
    static recurse(value, cb) {
        if (typeof value === 'string') {
            return cb(value);
        }
        if (typeof value !== 'object' || value === null) {
            return value;
        }
        if (Array.isArray(value)) {
            return value.map(x => this.recurse(x, cb));
        }
        const ret = {};
        for (const [key, inner] of Object.entries(value)) {
            ret[key] = this.recurse(inner, cb);
        }
        return ret;
    }
}
exports.EnvironmentPlaceholders = EnvironmentPlaceholders;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentPlaceholders[_a] = { fqn: "@aws-cdk/cx-api.EnvironmentPlaceholders", version: "2.138.0" };
/**
 * Insert this into the destination fields to be replaced with the current region
 */
EnvironmentPlaceholders.CURRENT_REGION = '${AWS::Region}';
/**
 * Insert this into the destination fields to be replaced with the current account
 */
EnvironmentPlaceholders.CURRENT_ACCOUNT = '${AWS::AccountId}';
/**
 * Insert this into the destination fields to be replaced with the current partition
 */
EnvironmentPlaceholders.CURRENT_PARTITION = '${AWS::Partition}';
/**
 * A "replace-all" function that doesn't require us escaping a literal string to a regex
 */
function replaceAll(s, search, replace) {
    return s.split(search).join(replace);
}
//# sourceMappingURL=data:application/json;base64,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