"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareVersions = exports.MAGIC_V2NEXT = exports.FlagType = void 0;
var FlagType;
(function (FlagType) {
    /**
     * Change the default behavior of the API
     *
     * The old behavior is not disrecommended, and possible to achieve with source
     * code changes. Also valid for changes that don't affect CloudFormation, but
     * the CXAPI contract.
     */
    FlagType[FlagType["ApiDefault"] = 0] = "ApiDefault";
    /**
     * Address a bug/introduce a recommended change
     *
     * The old behavior is no longer recommended. The only way to achieve it is by
     * keeping the flag at the legacy value.
     */
    FlagType[FlagType["BugFix"] = 1] = "BugFix";
    /**
     * Advertise the presence of this context option in `cdk.json`
     */
    FlagType[FlagType["VisibleContext"] = 2] = "VisibleContext";
})(FlagType || (exports.FlagType = FlagType = {}));
;
;
/**
 * The magic value that will be substituted at version bump time with the actual
 * new V2 version.
 *
 * Do not import this constant in the `features.ts` file, or the substitution
 * process won't work.
 */
exports.MAGIC_V2NEXT = 'V2NEXT';
/**
 * Compare two versions, returning -1, 0, or 1.
 */
function compareVersions(a, b) {
    if (a === b) {
        return 0;
    }
    if (a === undefined) {
        return -1;
    }
    if (b === undefined) {
        return 1;
    }
    const as = a.split('.').map(x => parseInt(x, 10));
    const bs = b.split('.').map(x => parseInt(x, 10));
    if (a === exports.MAGIC_V2NEXT) {
        return bs[0] <= 2 ? 1 : -1;
    }
    if (b === exports.MAGIC_V2NEXT) {
        return as[0] <= 2 ? -1 : 1;
    }
    for (let i = 0; i < Math.min(as.length, bs.length); i++) {
        if (as[i] < bs[i]) {
            return -1;
        }
        if (as[i] > bs[i]) {
            return 1;
        }
    }
    return as.length - bs.length;
}
exports.compareVersions = compareVersions;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmxhZy1tb2RlbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZsYWctbW9kZWxpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsSUFBWSxRQXNCWDtBQXRCRCxXQUFZLFFBQVE7SUFDbEI7Ozs7OztPQU1HO0lBQ0gsbURBQVUsQ0FBQTtJQUVWOzs7OztPQUtHO0lBQ0gsMkNBQU0sQ0FBQTtJQUVOOztPQUVHO0lBQ0gsMkRBQWMsQ0FBQTtBQUNoQixDQUFDLEVBdEJXLFFBQVEsd0JBQVIsUUFBUSxRQXNCbkI7QUFBQSxDQUFDO0FBYUQsQ0FBQztBQWNGOzs7Ozs7R0FNRztBQUNVLFFBQUEsWUFBWSxHQUFHLFFBQVEsQ0FBQztBQUVyQzs7R0FFRztBQUNILFNBQWdCLGVBQWUsQ0FBQyxDQUFxQixFQUFFLENBQXFCO0lBQzFFLElBQUksQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1FBQUMsT0FBTyxDQUFDLENBQUM7SUFBQyxDQUFDO0lBQzFCLElBQUksQ0FBQyxLQUFLLFNBQVMsRUFBRSxDQUFDO1FBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUFDLENBQUM7SUFDbkMsSUFBSSxDQUFDLEtBQUssU0FBUyxFQUFFLENBQUM7UUFBQyxPQUFPLENBQUMsQ0FBQztJQUFDLENBQUM7SUFFbEMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDbEQsTUFBTSxFQUFFLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFFbEQsSUFBSSxDQUFDLEtBQUssb0JBQVksRUFBRSxDQUFDO1FBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQUMsQ0FBQztJQUN2RCxJQUFJLENBQUMsS0FBSyxvQkFBWSxFQUFFLENBQUM7UUFBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFBQyxDQUFDO0lBRXZELEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7UUFDeEQsSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7WUFBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQUMsQ0FBQztRQUNqQyxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztZQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQUMsQ0FBQztJQUNsQyxDQUFDO0lBQ0QsT0FBTyxFQUFFLENBQUMsTUFBTSxHQUFHLEVBQUUsQ0FBQyxNQUFNLENBQUM7QUFDL0IsQ0FBQztBQWhCRCwwQ0FnQkMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZW51bSBGbGFnVHlwZSB7XG4gIC8qKlxuICAgKiBDaGFuZ2UgdGhlIGRlZmF1bHQgYmVoYXZpb3Igb2YgdGhlIEFQSVxuICAgKlxuICAgKiBUaGUgb2xkIGJlaGF2aW9yIGlzIG5vdCBkaXNyZWNvbW1lbmRlZCwgYW5kIHBvc3NpYmxlIHRvIGFjaGlldmUgd2l0aCBzb3VyY2VcbiAgICogY29kZSBjaGFuZ2VzLiBBbHNvIHZhbGlkIGZvciBjaGFuZ2VzIHRoYXQgZG9uJ3QgYWZmZWN0IENsb3VkRm9ybWF0aW9uLCBidXRcbiAgICogdGhlIENYQVBJIGNvbnRyYWN0LlxuICAgKi9cbiAgQXBpRGVmYXVsdCxcblxuICAvKipcbiAgICogQWRkcmVzcyBhIGJ1Zy9pbnRyb2R1Y2UgYSByZWNvbW1lbmRlZCBjaGFuZ2VcbiAgICpcbiAgICogVGhlIG9sZCBiZWhhdmlvciBpcyBubyBsb25nZXIgcmVjb21tZW5kZWQuIFRoZSBvbmx5IHdheSB0byBhY2hpZXZlIGl0IGlzIGJ5XG4gICAqIGtlZXBpbmcgdGhlIGZsYWcgYXQgdGhlIGxlZ2FjeSB2YWx1ZS5cbiAgICovXG4gIEJ1Z0ZpeCxcblxuICAvKipcbiAgICogQWR2ZXJ0aXNlIHRoZSBwcmVzZW5jZSBvZiB0aGlzIGNvbnRleHQgb3B0aW9uIGluIGBjZGsuanNvbmBcbiAgICovXG4gIFZpc2libGVDb250ZXh0LFxufTtcblxuZXhwb3J0IGludGVyZmFjZSBGbGFnSW5mb0Jhc2Uge1xuICAvKiogU2luZ2xlLWxpbmUgZGVzY3JpcHRpb24gZm9yIHRoZSBmbGFnICovXG4gIHJlYWRvbmx5IHN1bW1hcnk6IHN0cmluZztcbiAgLyoqIERldGFpbGVkIGRlc2NyaXB0aW9uIGZvciB0aGUgZmxhZyAoTWFya2Rvd24pICovXG4gIHJlYWRvbmx5IGRldGFpbHNNZDogc3RyaW5nO1xuICAvKiogVmVyc2lvbiBudW1iZXIgdGhlIGZsYWcgd2FzIGludHJvZHVjZWQgaW4gZWFjaCB2ZXJzaW9uIGxpbmUuIGB1bmRlZmluZWRgIG1lYW5zIGZsYWcgZG9lcyBub3QgZXhpc3QgaW4gdGhhdCBsaW5lLiAqL1xuICByZWFkb25seSBpbnRyb2R1Y2VkSW46IHsgdjE/OiBzdHJpbmc7IHYyPzogc3RyaW5nIH07XG4gIC8qKiBEZWZhdWx0IHZhbHVlLCBpZiBmbGFnIGlzIHVuc2V0IGJ5IHVzZXIuIEFkZGluZyBhIGZsYWcgd2l0aCBhIGRlZmF1bHQgbWF5IG5vdCBjaGFuZ2UgYmVoYXZpb3IgYWZ0ZXIgR0EhICovXG4gIHJlYWRvbmx5IGRlZmF1bHRzPzogeyB2Mj86IGFueSB9O1xuICAvKiogRGVmYXVsdCBpbiBuZXcgcHJvamVjdHMgKi9cbiAgcmVhZG9ubHkgcmVjb21tZW5kZWRWYWx1ZTogYW55O1xufTtcblxuLyoqIEZsYWcgaW5mb3JtYXRpb24sIGFkZGluZyByZXF1aXJlZCBmaWVsZHMgaWYgcHJlc2VudCAqL1xuZXhwb3J0IHR5cGUgRmxhZ0luZm8gPSBGbGFnSW5mb0Jhc2UgJiAoXG4gIHwgeyByZWFkb25seSB0eXBlOiBGbGFnVHlwZS5BcGlEZWZhdWx0O1xuXG4gICAgLyoqIERlc2NyaWJlIHJlc3RvcmluZyBvbGQgYmVoYXZpb3Igb3IgZGVhbGluZyB3aXRoIHRoZSBjaGFuZ2UgKE1hcmtkb3duKSAqL1xuICAgIHJlYWRvbmx5IGNvbXBhdGliaWxpdHlXaXRoT2xkQmVoYXZpb3JNZDogc3RyaW5nOyB9XG4gIHwgeyByZWFkb25seSB0eXBlOiBGbGFnVHlwZS5CdWdGaXg7XG4gICAgLyoqIERlc2NyaWJlIHJlc3RvcmluZyBvbGQgYmVoYXZpb3Igb3IgZGVhbGluZyB3aXRoIHRoZSBjaGFuZ2UgKE1hcmtkb3duKSAqL1xuICAgIHJlYWRvbmx5IGNvbXBhdGliaWxpdHlXaXRoT2xkQmVoYXZpb3JNZD86IHN0cmluZzsgfVxuICB8IHsgcmVhZG9ubHkgdHlwZTogRmxhZ1R5cGUuVmlzaWJsZUNvbnRleHQgfVxuKTtcblxuLyoqXG4gKiBUaGUgbWFnaWMgdmFsdWUgdGhhdCB3aWxsIGJlIHN1YnN0aXR1dGVkIGF0IHZlcnNpb24gYnVtcCB0aW1lIHdpdGggdGhlIGFjdHVhbFxuICogbmV3IFYyIHZlcnNpb24uXG4gKlxuICogRG8gbm90IGltcG9ydCB0aGlzIGNvbnN0YW50IGluIHRoZSBgZmVhdHVyZXMudHNgIGZpbGUsIG9yIHRoZSBzdWJzdGl0dXRpb25cbiAqIHByb2Nlc3Mgd29uJ3Qgd29yay5cbiAqL1xuZXhwb3J0IGNvbnN0IE1BR0lDX1YyTkVYVCA9ICdWMk5FWFQnO1xuXG4vKipcbiAqIENvbXBhcmUgdHdvIHZlcnNpb25zLCByZXR1cm5pbmcgLTEsIDAsIG9yIDEuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBjb21wYXJlVmVyc2lvbnMoYTogc3RyaW5nIHwgdW5kZWZpbmVkLCBiOiBzdHJpbmcgfCB1bmRlZmluZWQpOiBudW1iZXIge1xuICBpZiAoYSA9PT0gYikgeyByZXR1cm4gMDsgfVxuICBpZiAoYSA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiAtMTsgfVxuICBpZiAoYiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiAxOyB9XG5cbiAgY29uc3QgYXMgPSBhLnNwbGl0KCcuJykubWFwKHggPT4gcGFyc2VJbnQoeCwgMTApKTtcbiAgY29uc3QgYnMgPSBiLnNwbGl0KCcuJykubWFwKHggPT4gcGFyc2VJbnQoeCwgMTApKTtcblxuICBpZiAoYSA9PT0gTUFHSUNfVjJORVhUKSB7IHJldHVybiBic1swXSA8PSAyID8gMSA6IC0xOyB9XG4gIGlmIChiID09PSBNQUdJQ19WMk5FWFQpIHsgcmV0dXJuIGFzWzBdIDw9IDIgPyAtMSA6IDE7IH1cblxuICBmb3IgKGxldCBpID0gMDsgaSA8IE1hdGgubWluKGFzLmxlbmd0aCwgYnMubGVuZ3RoKTsgaSsrKSB7XG4gICAgaWYgKGFzW2ldIDwgYnNbaV0pIHsgcmV0dXJuIC0xOyB9XG4gICAgaWYgKGFzW2ldID4gYnNbaV0pIHsgcmV0dXJuIDE7IH1cbiAgfVxuICByZXR1cm4gYXMubGVuZ3RoIC0gYnMubGVuZ3RoO1xufVxuIl19