# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserPasswordArgs', 'UserPassword']

@pulumi.input_type
class UserPasswordArgs:
    def __init__(__self__, *,
                 pgp_key: pulumi.Input[_builtins.str],
                 user: pulumi.Input[_builtins.str],
                 host: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserPassword resource.
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`.
        :param pulumi.Input[_builtins.str] user: The IAM user to associate with this access key.
        :param pulumi.Input[_builtins.str] host: The source host of the user. Defaults to `localhost`.
        """
        pulumi.set(__self__, "pgp_key", pgp_key)
        pulumi.set(__self__, "user", user)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> pulumi.Input[_builtins.str]:
        """
        Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`.
        """
        return pulumi.get(self, "pgp_key")

    @pgp_key.setter
    def pgp_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pgp_key", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        The IAM user to associate with this access key.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source host of the user. Defaults to `localhost`.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class _UserPasswordState:
    def __init__(__self__, *,
                 encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserPassword resources.
        :param pulumi.Input[_builtins.str] encrypted_password: The encrypted password, base64 encoded.
        :param pulumi.Input[_builtins.str] host: The source host of the user. Defaults to `localhost`.
        :param pulumi.Input[_builtins.str] key_fingerprint: The fingerprint of the PGP key used to encrypt the password
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`.
        :param pulumi.Input[_builtins.str] user: The IAM user to associate with this access key.
        """
        if encrypted_password is not None:
            pulumi.set(__self__, "encrypted_password", encrypted_password)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if key_fingerprint is not None:
            pulumi.set(__self__, "key_fingerprint", key_fingerprint)
        if pgp_key is not None:
            pulumi.set(__self__, "pgp_key", pgp_key)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="encryptedPassword")
    def encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encrypted password, base64 encoded.
        """
        return pulumi.get(self, "encrypted_password")

    @encrypted_password.setter
    def encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypted_password", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source host of the user. Defaults to `localhost`.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fingerprint of the PGP key used to encrypt the password
        """
        return pulumi.get(self, "key_fingerprint")

    @key_fingerprint.setter
    def key_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`.
        """
        return pulumi.get(self, "pgp_key")

    @pgp_key.setter
    def pgp_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pgp_key", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM user to associate with this access key.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("mysql:index/userPassword:UserPassword")
class UserPassword(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `UserPassword` resource sets and manages a password for a given
        user on a MySQL server.

        > **NOTE on MySQL Passwords:** This resource conflicts with the `password`
           argument for `User`. This resource uses PGP encryption to avoid
           storing unencrypted passwords in the provider state.

        > **NOTE on How Passwords are Created:** This resource **automatically**
           generates a **random** password. The password will be a random UUID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mysql as mysql

        jdoe = mysql.User("jdoe", user="jdoe")
        jdoe_user_password = mysql.UserPassword("jdoe",
           user=jdoe.user,
           pgp_key="keybase:joestump")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] host: The source host of the user. Defaults to `localhost`.
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`.
        :param pulumi.Input[_builtins.str] user: The IAM user to associate with this access key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserPasswordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `UserPassword` resource sets and manages a password for a given
        user on a MySQL server.

        > **NOTE on MySQL Passwords:** This resource conflicts with the `password`
           argument for `User`. This resource uses PGP encryption to avoid
           storing unencrypted passwords in the provider state.

        > **NOTE on How Passwords are Created:** This resource **automatically**
           generates a **random** password. The password will be a random UUID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_mysql as mysql

        jdoe = mysql.User("jdoe", user="jdoe")
        jdoe_user_password = mysql.UserPassword("jdoe",
           user=jdoe.user,
           pgp_key="keybase:joestump")
        ```

        :param str resource_name: The name of the resource.
        :param UserPasswordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserPasswordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserPasswordArgs.__new__(UserPasswordArgs)

            __props__.__dict__["host"] = host
            if pgp_key is None and not opts.urn:
                raise TypeError("Missing required property 'pgp_key'")
            __props__.__dict__["pgp_key"] = pgp_key
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["encrypted_password"] = None
            __props__.__dict__["key_fingerprint"] = None
        super(UserPassword, __self__).__init__(
            'mysql:index/userPassword:UserPassword',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            pgp_key: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserPassword':
        """
        Get an existing UserPassword resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] encrypted_password: The encrypted password, base64 encoded.
        :param pulumi.Input[_builtins.str] host: The source host of the user. Defaults to `localhost`.
        :param pulumi.Input[_builtins.str] key_fingerprint: The fingerprint of the PGP key used to encrypt the password
        :param pulumi.Input[_builtins.str] pgp_key: Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`.
        :param pulumi.Input[_builtins.str] user: The IAM user to associate with this access key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserPasswordState.__new__(_UserPasswordState)

        __props__.__dict__["encrypted_password"] = encrypted_password
        __props__.__dict__["host"] = host
        __props__.__dict__["key_fingerprint"] = key_fingerprint
        __props__.__dict__["pgp_key"] = pgp_key
        __props__.__dict__["user"] = user
        return UserPassword(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="encryptedPassword")
    def encrypted_password(self) -> pulumi.Output[_builtins.str]:
        """
        The encrypted password, base64 encoded.
        """
        return pulumi.get(self, "encrypted_password")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source host of the user. Defaults to `localhost`.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The fingerprint of the PGP key used to encrypt the password
        """
        return pulumi.get(self, "key_fingerprint")

    @_builtins.property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> pulumi.Output[_builtins.str]:
        """
        Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`.
        """
        return pulumi.get(self, "pgp_key")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The IAM user to associate with this access key.
        """
        return pulumi.get(self, "user")

