#
# # Copyright © 2025 Peak AI Limited. or its affiliates. All Rights Reserved.
# #
# # Licensed under the Apache License, Version 2.0 (the "License"). You
# # may not use this file except in compliance with the License. A copy of
# # the License is located at:
# #
# # https://github.com/PeakBI/peak-sdk/blob/main/LICENSE
# #
# # or in the "license" file accompanying this file. This file is
# # distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
# # ANY KIND, either express or implied. See the License for the specific
# # language governing permissions and limitations under the License.
# #
# # This file is part of the peak-sdk.
# # see (https://github.com/PeakBI/peak-sdk)
# #
# # You should have received a copy of the APACHE LICENSE, VERSION 2.0
# # along with this program. If not, see <https://apache.org/licenses/LICENSE-2.0>
#
"""CLI entrypoint."""
import sys

import peak.config
import typer
from peak.cli import args, helpers
from peak.cli.metrics import metrics
from peak.cli.press import apps, blocks, deployments, specs
from peak.cli.resources import alerts, artifacts, cache, images, services, tenants, users, webapps, workflows
from peak.constants import Sources
from peak.output import Writer

# Workaround to not gray out texts after first paragraph
typer.rich_utils.STYLE_HELPTEXT = ""

typer_app = typer.Typer(rich_markup_mode="markdown", help="Create and Manage Peak Resources")
typer_app.add_typer(images.app, name="images")
typer_app.add_typer(metrics.app, name="metrics")
typer_app.add_typer(alerts.app, name="alerts")
typer_app.add_typer(artifacts.app, name="artifacts")
typer_app.add_typer(cache.app, name="cache")
typer_app.add_typer(workflows.app, name="workflows")
typer_app.add_typer(webapps.app, name="webapps")
typer_app.add_typer(services.app, name="services")
typer_app.add_typer(tenants.app, name="tenants")
typer_app.add_typer(apps.app, name="apps")
typer_app.add_typer(blocks.app, name="blocks")
typer_app.add_typer(specs.app, name="specs")
typer_app.add_typer(deployments.app, name="deployments")
typer_app.add_typer(users.app, name="users")


@typer_app.callback()
def main(ctx: typer.Context, version: bool = args.VERSION_OPTION) -> None:  # noqa: ARG001
    """Add global version option and add client to context only if any command is invoked."""
    peak.config.SOURCE = Sources.CLI

    if "--help" not in sys.argv and ctx.invoked_subcommand:
        ctx.obj = {
            "client": helpers.get_client(ctx.invoked_subcommand),
            "writer": Writer(),
        }


if __name__ == "__main__":
    typer_app()
