# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.preview.hosted_numbers.hosted_number_order import HostedNumberOrderList


class HostedNumbers(Version):

    def __init__(self, domain):
        """
        Initialize the HostedNumbers version of Preview

        :returns: HostedNumbers version of Preview
        :rtype: twilio.rest.preview.hosted_numbers.HostedNumbers.HostedNumbers
        """
        super(HostedNumbers, self).__init__(domain)
        self.version = 'HostedNumbers'
        self._hosted_number_orders = None

    @property
    def hosted_number_orders(self):
        """
        :rtype: twilio.rest.preview.hosted_numbers.hosted_number_order.HostedNumberOrderList
        """
        if self._hosted_number_orders is None:
            self._hosted_number_orders = HostedNumberOrderList(self)
        return self._hosted_number_orders

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.HostedNumbers>'
