import pytest
import stk

from ...case_data import CaseData


@pytest.fixture(
    scope="session",
    params=(
        lambda name: CaseData(
            molecule=stk.ConstructedMolecule(
                topology_graph=stk.cof.Hexagonal(
                    building_blocks={
                        stk.BuildingBlock(
                            smiles="BrC1=C(Br)[C+]=N1",
                            functional_groups=[stk.BromoFactory()],
                        ): (
                            4,
                            5,
                            6,
                            7,
                            8,
                            9,
                            20,
                            21,
                            23,
                            24,
                            30,
                            36,
                            38,
                            40,
                            41,
                            42,
                            43,
                            46,
                            47,
                            52,
                            53,
                            60,
                            61,
                        ),
                        stk.BuildingBlock(
                            smiles="BrN1N(Br)[C+]=N1",
                            functional_groups=[stk.BromoFactory()],
                        ): (
                            10,
                            11,
                            12,
                            13,
                            14,
                            15,
                            22,
                            25,
                            26,
                            27,
                            28,
                            29,
                            37,
                            39,
                            44,
                            45,
                            54,
                            55,
                            56,
                            57,
                            58,
                            59,
                            31,
                            62,
                            63,
                        ),
                        stk.BuildingBlock(
                            smiles=(
                                "Br[C+]1[C+]2[N+][C+2]C2(Br)[C+](I)[C+"
                                "](I)[C+](Br)[C+]1Br"
                            ),
                            functional_groups=[
                                stk.BromoFactory(),
                                stk.IodoFactory(),
                                stk.FluoroFactory(),
                            ],
                        ): (0, 1, 18, 50, 51),
                        stk.BuildingBlock(
                            smiles=(
                                "Br[C+]1[C+]2[S][C+2]C2(Br)[C+](I)[C+]"
                                "(I)[C+](Br)[C+]1Br"
                            ),
                            functional_groups=[
                                stk.BromoFactory(),
                                stk.IodoFactory(),
                                stk.FluoroFactory(),
                            ],
                        ): (2, 16, 34, 49),
                        stk.BuildingBlock(
                            smiles=(
                                "Br[C+]1[C+]2[S][O]C2(Br)[C+](I)[C+](I"
                                ")[C+](Br)[C+]1Br"
                            ),
                            functional_groups=[
                                stk.BromoFactory(),
                                stk.IodoFactory(),
                                stk.FluoroFactory(),
                            ],
                        ): (3, 17, 19, 32, 33, 35, 48),
                    },
                    lattice_size=(2, 2, 1),
                    vertex_alignments={0: 5},
                ),
            ),
            smiles=(
                "BrC1=C([C+]2[C+](Br)[C+](I)[C+]3C4=C([C+]=N4)[C+]4[C+"
                "](Br)[C+](Br)[C+]5[C+]6N7N=[C+]N7C78OS[C+]7[C+]7C9=C("
                "[C+]=N9)[C+]9[C+]([C+](Br)[C+](I)[C+]%10N%11N=[C+]N%1"
                "1[C+]%11[C+](Br)[C+](Br)[C+](I)[C+](N%12N=[C+]N%12Br)"
                "C%12([C+2][NH2+][C+]%11%12)N%11[C+]=NN%11[C+]%11[C+]("
                "I)[C+](C%12=C(Br)[C+]=N%12)C%12%13[C+2][NH2+][C+]%12["
                "C+](C%12=C(N=[C+]%12)[C+]7[C+]7[C+]%12[C+]8N8N=[C+]N8"
                "[C+]8[C+](C%14=C([C+]=N%14)C6%14OS[C+]4%14)[C+]4[C+]6"
                "C%14=C(N=[C+]%14)[C+]%14[C+](C%15=C([C+]=N%15)[C+]2[C"
                "+]2SOC23N2N=[C+]N42)[C+]2S[C+2]C2(Br)[C+](N2N=[C+]N2B"
                "r)[C+]2[C+]%14N3N=[C+]N3[C+]3[C+]4C%14=C(N=[C+]%14)[C"
                "+]%14[C+]([C+](Br)[C+](N%15N=[C+]N%15Br)[C+]%15C%16=C"
                "(N=[C+]%16)[C+]%16[C+](Br)[C+]%17[NH2+][C+2]C%17(C%17"
                "=C(Br)[C+]=N%17)[C+](N%17N=[C+]N%17Br)[C+](N%17N=[C+]"
                "N%17Br)[C+]%16C%16=C([C+]=N%16)[C+]%16[C+](C%17=C(N=["
                "C+]%17)C%14%17[C+2][NH2+][C+]%15%17)[C+]%14C%15=C([C+"
                "]=N%15)C%15(OS[C+]4%15)[C+]4[C+]%15C%17=C(N=[C+]%17)["
                "C+]%17[C+]%18C%19=C(N=[C+]%19)[C+]%19[C+]([C+](C%20=C"
                "(Br)[C+]=N%20)[C+](C%20=C(Br)[C+]=N%20)[C+](C%20=C([C"
                "+]=N%20)[C+]%14[C+](N%14N=[C+]N%14Br)C%14(N%20N=[C+]N"
                "%20Br)[C+2]S[C+]%16%14)C%14(OS[C+]%19%14)N%14[C+]=NN4"
                "%14)N4N=[C+]N4[C+]4[C+]%14C%16=C(N=[C+]%16)C%16(OS[C+"
                "]%18%16)[C+]([C+]([C+]%17N%16[C+]=NN%16[C+]8C8([C+2]["
                "NH2+][C+]68)N6N=[C+]N6[C+]%153)N3[C+]=NN%123)N3N=[C+]"
                "N3[C+]3[C+]([C+](C6=C%13N=[C+]6)[C+](I)[C+](C6=C(Br)["
                "C+]=N6)C6(OS[C+]36)C3=C(N=[C+]3)[C+]%14[C+](I)[C+](N3"
                "N=[C+]N3Br)C3(N6N=[C+]N6Br)[C+2]S[C+]43)N3[C+]=NN73)N"
                "3[C+]=NN23)[C+]%11N2[C+]=NN2C%102[C+2]S[C+]92)N2N=[C+"
                "]N52)N=[C+]1"
            ),
            name=name,
        ),
        # Non-planar linear BB.
        lambda name: CaseData(
            molecule=stk.ConstructedMolecule(
                topology_graph=stk.cof.Hexagonal(
                    building_blocks=(
                        stk.BuildingBlock(
                            smiles="C1(C(C(C(C(C1Br)Br)Br)Br)Br)Br",
                            functional_groups=[stk.BromoFactory()],
                        ),
                        stk.BuildingBlock(
                            smiles="C1=C(Br)C=C2C=CC(Br)=CC2=C1CCCC",
                            functional_groups=[stk.BromoFactory()],
                        ),
                    ),
                    lattice_size=(2, 2, 1),
                ),
            ),
            smiles=(
                "[H]C1=C([H])C2=C([H])C(C3([H])C([H])(Br)C([H])(Br)C(["
                "H])(Br)C4([H])C5=C([H])C6=C(C([H])([H])C([H])([H])C(["
                "H])([H])C([H])([H])[H])C([H])=C(C([H])=C6C([H])=C5[H]"
                ")C5([H])C([H])(Br)C([H])(Br)C6([H])C7=C([H])C(C([H])("
                "[H])C([H])([H])C([H])([H])C([H])([H])[H])=C8C([H])=C("
                "C([H])=C([H])C8=C7[H])C7([H])C([H])(Br)C([H])(Br)C8(["
                "H])C9=C([H])C%10=C(C([H])([H])C([H])([H])C([H])([H])C"
                "([H])([H])[H])C([H])=C(C([H])=C%10C([H])=C9[H])C9([H]"
                ")C([H])(Br)C([H])(Br)C([H])(C%10=C([H])C(C([H])([H])C"
                "([H])([H])C([H])([H])C([H])([H])[H])=C%11C([H])=C(Br)"
                "C([H])=C([H])C%11=C%10[H])C%10([H])C%11=C([H])C%12=C("
                "C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])C([H]"
                ")=C(C([H])=C%12C([H])=C%11[H])C%11([H])C([H])(Br)C([H"
                "])(C%12=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H"
                "])([H])[H])=C%13C([H])=C(Br)C([H])=C([H])C%13=C%12[H]"
                ")C%12([H])C%13=C([H])C(C([H])([H])C([H])([H])C([H])(["
                "H])C([H])([H])[H])=C%14C([H])=C(C([H])=C([H])C%14=C%1"
                "3[H])C%13([H])C([H])(Br)C([H])(C%14=C([H])C(C([H])([H"
                "])C([H])([H])C([H])([H])C([H])([H])[H])=C%15C([H])=C("
                "Br)C([H])=C([H])C%15=C%14[H])C%14([H])C%15=C([H])C%16"
                "=C(C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])C("
                "[H])=C(C([H])=C%16C([H])=C%15[H])C%15([H])C([H])(Br)C"
                "([H])(C%16=C([H])C(C([H])([H])C([H])([H])C([H])([H])C"
                "([H])([H])[H])=C%17C([H])=C(Br)C([H])=C([H])C%17=C%16"
                "[H])C([H])(C%16=C([H])C(C([H])([H])C([H])([H])C([H])("
                "[H])C([H])([H])[H])=C%17C([H])=C(Br)C([H])=C([H])C%17"
                "=C%16[H])C([H])(C%16=C([H])C(C([H])([H])C([H])([H])C("
                "[H])([H])C([H])([H])[H])=C%17C([H])=C(Br)C([H])=C([H]"
                ")C%17=C%16[H])C%15([H])C%15=C([H])C(C([H])([H])C([H])"
                "([H])C([H])([H])C([H])([H])[H])=C%16C([H])=C(C([H])=C"
                "([H])C%16=C%15[H])C%15([H])C%16([H])C%17=C([H])C%18=C"
                "(C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])C([H"
                "])=C(C([H])=C%18C([H])=C%17[H])C%14([H])C%13([H])C%13"
                "=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H])([H])"
                "[H])=C%14C([H])=C(C([H])=C([H])C%14=C%13[H])C%13([H])"
                "C%14([H])C%17=C([H])C%18=C(C([H])([H])C([H])([H])C([H"
                "])([H])C([H])([H])[H])C([H])=C(C([H])=C%18C([H])=C%17"
                "[H])C%12([H])C%11([H])C%11=C([H])C(C([H])([H])C([H])("
                "[H])C([H])([H])C([H])([H])[H])=C%12C([H])=C(C([H])=C("
                "[H])C%12=C%11[H])C%11([H])C([H])(C%12=C([H])C%17=C(C("
                "[H])([H])C([H])([H])C([H])([H])C([H])([H])[H])C([H])="
                "C(C([H])=C%17C([H])=C%12[H])C9%10[H])C9([H])C%10=C([H"
                "])C(C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])="
                "C%12C([H])=C(C([H])=C([H])C%12=C%10[H])C8([H])C7([H])"
                "C7=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H])([H"
                "])[H])=C8C([H])=C(C([H])=C([H])C8=C7[H])C7([H])C8([H]"
                ")C%10=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H])"
                "([H])[H])=C%12C([H])=C(C([H])=C([H])C%12=C%10[H])C6(["
                "H])C5([H])C5=C([H])C(C([H])([H])C([H])([H])C([H])([H]"
                ")C([H])([H])[H])=C6C([H])=C(C([H])=C([H])C6=C5[H])C5("
                "[H])C([H])(C6=C([H])C(C([H])([H])C([H])([H])C([H])([H"
                "])C([H])([H])[H])=C%10C([H])=C(C([H])=C([H])C%10=C6[H"
                "])C43[H])C([H])(Br)C([H])(C3=C([H])C(C([H])([H])C([H]"
                ")([H])C([H])([H])C([H])([H])[H])=C4C([H])=C(Br)C([H])"
                "=C([H])C4=C3[H])C3([H])C4=C([H])C(C([H])([H])C([H])(["
                "H])C([H])([H])C([H])([H])[H])=C6C([H])=C(C([H])=C([H]"
                ")C6=C4[H])C4([H])C([H])(Br)C([H])(C6=C([H])C(C([H])(["
                "H])C([H])([H])C([H])([H])C([H])([H])[H])=C%10C([H])=C"
                "(Br)C([H])=C([H])C%10=C6[H])C6([H])C%10=C([H])C%12=C("
                "C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])C([H]"
                ")=C(C([H])=C%12C([H])=C%10[H])C%10([H])C([H])(Br)C([H"
                "])(C%12=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H"
                "])([H])[H])=C%17C([H])=C(Br)C([H])=C([H])C%17=C%12[H]"
                ")C([H])(C%12=C([H])C(C([H])([H])C([H])([H])C([H])([H]"
                ")C([H])([H])[H])=C%17C([H])=C(Br)C([H])=C([H])C%17=C%"
                "12[H])C%12([H])C%17=C([H])C%18=C(C([H])([H])C([H])([H"
                "])C([H])([H])C([H])([H])[H])C([H])=C(C([H])=C%18C([H]"
                ")=C%17[H])C%17([H])C%18([H])C%19=C([H])C(C([H])([H])C"
                "([H])([H])C([H])([H])C([H])([H])[H])=C%20C([H])=C(C(["
                "H])=C([H])C%20=C%19[H])C%19([H])C%20([H])C%21=C([H])C"
                "(C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])=C%2"
                "2C([H])=C(C([H])=C([H])C%22=C%21[H])C([H])(C%14([H])C"
                "%14=C([H])C%21=C(C([H])([H])C([H])([H])C([H])([H])C(["
                "H])([H])[H])C([H])=C(C([H])=C%21C([H])=C%14[H])C%11(["
                "H])C%11([H])C%14=C([H])C(C([H])([H])C([H])([H])C([H])"
                "([H])C([H])([H])[H])=C%21C([H])=C(C([H])=C([H])C%21=C"
                "%14[H])C%20([H])C%14([H])C%20=C([H])C%21=C(C([H])([H]"
                ")C([H])([H])C([H])([H])C([H])([H])[H])C([H])=C(C([H])"
                "=C%21C([H])=C%20[H])C([H])(C7([H])C7=C([H])C(C([H])(["
                "H])C([H])([H])C([H])([H])C([H])([H])[H])=C%20C([H])=C"
                "(C([H])=C([H])C%20=C7[H])C9%11[H])C([H])(C7=C([H])C(C"
                "([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])=C9C(["
                "H])=C(C([H])=C([H])C9=C7[H])C4([H])C6([H])C4=C([H])C6"
                "=C(C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])C("
                "[H])=C(C([H])=C6C([H])=C4[H])C%14([H])C%19([H])C4=C(["
                "H])C(C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])"
                "=C6C([H])=C(C([H])=C([H])C6=C4[H])C%10%12[H])C8([H])C"
                "4=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H])([H]"
                ")[H])=C6C([H])=C(C([H])=C([H])C6=C4[H])C53[H])C3([H])"
                "C4=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H])([H"
                "])[H])=C5C([H])=C(C([H])=C([H])C5=C4[H])C%18([H])C([H"
                "])(C4=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H])"
                "([H])[H])=C5C([H])=C(C([H])=C([H])C5=C4[H])C([H])(C%1"
                "6([H])C4=C([H])C(C([H])([H])C([H])([H])C([H])([H])C(["
                "H])([H])[H])=C5C([H])=C(C([H])=C([H])C5=C4[H])C%133[H"
                "])C([H])(C3=C([H])C(C([H])([H])C([H])([H])C([H])([H])"
                "C([H])([H])[H])=C4C([H])=C(Br)C([H])=C([H])C4=C3[H])C"
                "%15([H])C3=C([H])C(C([H])([H])C([H])([H])C([H])([H])C"
                "([H])([H])[H])=C4C([H])=C(Br)C([H])=C([H])C4=C3[H])C("
                "[H])(C3=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H"
                "])([H])[H])=C4C([H])=C(Br)C([H])=C([H])C4=C3[H])C%17("
                "[H])C3=C([H])C(C([H])([H])C([H])([H])C([H])([H])C([H]"
                ")([H])[H])=C4C([H])=C(Br)C([H])=C([H])C4=C3[H])=C([H]"
                ")C(C([H])([H])C([H])([H])C([H])([H])C([H])([H])[H])=C"
                "2C([H])=C1Br"
            ),
            name=name,
        ),
        # One placer atom linear BB.
        lambda name: CaseData(
            molecule=stk.ConstructedMolecule(
                topology_graph=stk.cof.Hexagonal(
                    building_blocks=(
                        stk.BuildingBlock(
                            smiles="C1(C(C(C(C(C1Br)Br)Br)Br)Br)Br",
                            functional_groups=[stk.BromoFactory()],
                        ),
                        stk.BuildingBlock(
                            smiles="C(Br)Br",
                            functional_groups=[stk.BromoFactory()],
                        ),
                    ),
                    lattice_size=(2, 2, 1),
                ),
            ),
            smiles=(
                "[H]C([H])(Br)C1([H])C([H])(Br)C2([H])C([H])([H])C3([H"
                "])C([H])(C([H])([H])Br)C([H])(Br)C4([H])C([H])([H])C5"
                "([H])C([H])(C([H])([H])Br)C([H])(Br)C6([H])C([H])([H]"
                ")C7([H])C([H])(C([H])([H])Br)C([H])(Br)C([H])(Br)C8(["
                "H])C([H])([H])C9([H])C([H])(Br)C([H])(Br)C%10([H])C(["
                "H])([H])C%11([H])C([H])(Br)C([H])(Br)C%12([H])C([H])("
                "[H])C%13([H])C([H])(Br)C([H])(Br)C([H])(Br)C([H])(C(["
                "H])([H])Br)C%13([H])C([H])([H])C%13([H])C([H])(Br)C(["
                "H])(C([H])([H])Br)C%14([H])C([H])([H])C%15([H])C([H])"
                "(Br)C([H])(C([H])([H])Br)C%16([H])C([H])([H])C%17([H]"
                ")C([H])(Br)C([H])(C([H])([H])Br)C([H])(C([H])([H])Br)"
                "C%18([H])C([H])([H])C%19([H])C([H])(C([H])([H])Br)C(["
                "H])(C([H])([H])Br)C%20([H])C([H])([H])C%21([H])C([H])"
                "(C([H])([H])Br)C([H])(C([H])([H])Br)C([H])(C([H])([H]"
                ")C2([H])C([H])(C([H])([H])Br)C1([H])C([H])([H])Br)C1("
                "[H])C([H])([H])C3([H])C4([H])C([H])([H])C2([H])C3([H]"
                ")C([H])([H])C5([H])C6([H])C([H])([H])C4([H])C([H])(C("
                "[H])([H])C87[H])C5([H])C([H])([H])C9([H])C%10([H])C(["
                "H])([H])C6([H])C7([H])C([H])([H])C%11([H])C%12([H])C("
                "[H])([H])C%13([H])C%14([H])C([H])([H])C7([H])C7([H])C"
                "([H])([H])C%15([H])C%16([H])C([H])([H])C8([H])C([H])("
                "C([H])([H])C%17%18[H])C9([H])C([H])([H])C%19([H])C%20"
                "([H])C([H])([H])C([H])(C2([H])C([H])([H])C%211[H])C1("
                "[H])C([H])([H])C9([H])C2([H])C([H])([H])C([H])(C5([H]"
                ")C([H])([H])C6([H])C7([H])C([H])([H])C82[H])C4([H])C("
                "[H])([H])C31[H]"
            ),
            name=name,
        ),
        lambda name: CaseData(
            molecule=stk.ConstructedMolecule(
                topology_graph=stk.cof.Hexagonal(
                    building_blocks=(
                        stk.BuildingBlock(
                            smiles="C1(C(C(C(C(C1Br)Br)Br)Br)Br)Br",
                            functional_groups=[stk.BromoFactory()],
                        ),
                        stk.BuildingBlock(
                            smiles="C(Br)Br",
                            functional_groups=[stk.BromoFactory()],
                        ),
                    ),
                    lattice_size=(2, 2, 1),
                    scale_multiplier=0.8,
                ),
            ),
            smiles=(
                "[H]C([H])(Br)C1([H])C([H])(Br)C2([H])C([H])([H])C3([H"
                "])C([H])(C([H])([H])Br)C([H])(Br)C4([H])C([H])([H])C5"
                "([H])C([H])(C([H])([H])Br)C([H])(Br)C6([H])C([H])([H]"
                ")C7([H])C([H])(C([H])([H])Br)C([H])(Br)C([H])(Br)C8(["
                "H])C([H])([H])C9([H])C([H])(Br)C([H])(Br)C%10([H])C(["
                "H])([H])C%11([H])C([H])(Br)C([H])(Br)C%12([H])C([H])("
                "[H])C%13([H])C([H])(Br)C([H])(Br)C([H])(Br)C([H])(C(["
                "H])([H])Br)C%13([H])C([H])([H])C%13([H])C([H])(Br)C(["
                "H])(C([H])([H])Br)C%14([H])C([H])([H])C%15([H])C([H])"
                "(Br)C([H])(C([H])([H])Br)C%16([H])C([H])([H])C%17([H]"
                ")C([H])(Br)C([H])(C([H])([H])Br)C([H])(C([H])([H])Br)"
                "C%18([H])C([H])([H])C%19([H])C([H])(C([H])([H])Br)C(["
                "H])(C([H])([H])Br)C%20([H])C([H])([H])C%21([H])C([H])"
                "(C([H])([H])Br)C([H])(C([H])([H])Br)C([H])(C([H])([H]"
                ")C2([H])C([H])(C([H])([H])Br)C1([H])C([H])([H])Br)C1("
                "[H])C([H])([H])C3([H])C4([H])C([H])([H])C2([H])C3([H]"
                ")C([H])([H])C5([H])C6([H])C([H])([H])C4([H])C([H])(C("
                "[H])([H])C87[H])C5([H])C([H])([H])C9([H])C%10([H])C(["
                "H])([H])C6([H])C7([H])C([H])([H])C%11([H])C%12([H])C("
                "[H])([H])C%13([H])C%14([H])C([H])([H])C7([H])C7([H])C"
                "([H])([H])C%15([H])C%16([H])C([H])([H])C8([H])C([H])("
                "C([H])([H])C%17%18[H])C9([H])C([H])([H])C%19([H])C%20"
                "([H])C([H])([H])C([H])(C2([H])C([H])([H])C%211[H])C1("
                "[H])C([H])([H])C9([H])C2([H])C([H])([H])C([H])(C5([H]"
                ")C([H])([H])C6([H])C7([H])C([H])([H])C82[H])C4([H])C("
                "[H])([H])C31[H]"
            ),
            name=name,
        ),
        # Two placer atom linear BB.
        lambda name: CaseData(
            molecule=stk.ConstructedMolecule(
                topology_graph=stk.cof.Hexagonal(
                    building_blocks=(
                        stk.BuildingBlock(
                            smiles="C1(C(C(C(C(C1Br)Br)Br)Br)Br)Br",
                            functional_groups=[stk.BromoFactory()],
                        ),
                        stk.BuildingBlock(
                            smiles="BrCCBr",
                            functional_groups=[stk.BromoFactory()],
                        ),
                    ),
                    lattice_size=(2, 2, 1),
                ),
            ),
            smiles=(
                "[H]C([H])(Br)C([H])([H])C1([H])C([H])(Br)C([H])(Br)C("
                "[H])(Br)C2([H])C([H])([H])C([H])([H])C3([H])C([H])(Br"
                ")C([H])(Br)C4([H])C([H])([H])C([H])([H])C5([H])C([H])"
                "(Br)C([H])(Br)C6([H])C([H])([H])C([H])([H])C7([H])C(["
                "H])(Br)C([H])(Br)C([H])(C([H])([H])C([H])([H])Br)C8(["
                "H])C([H])([H])C([H])([H])C9([H])C([H])(Br)C([H])(C([H"
                "])([H])C([H])([H])Br)C%10([H])C([H])([H])C([H])([H])C"
                "%11([H])C([H])(Br)C([H])(C([H])([H])C([H])([H])Br)C%1"
                "2([H])C([H])([H])C([H])([H])C%13([H])C([H])(Br)C([H])"
                "(C([H])([H])C([H])([H])Br)C([H])(C([H])([H])C([H])([H"
                "])Br)C([H])(C([H])([H])C([H])([H])Br)C%13([H])C([H])("
                "[H])C([H])([H])C%13([H])C([H])(C([H])([H])C([H])([H])"
                "Br)C([H])(C([H])([H])C([H])([H])Br)C%14([H])C([H])([H"
                "])C([H])([H])C%15([H])C([H])(C([H])([H])C([H])([H])Br"
                ")C([H])(C([H])([H])C([H])([H])Br)C%16([H])C([H])([H])"
                "C([H])([H])C%17([H])C([H])(C([H])([H])C([H])([H])Br)C"
                "([H])(C([H])([H])C([H])([H])Br)C([H])(Br)C%18([H])C(["
                "H])([H])C([H])([H])C%19([H])C([H])(C([H])([H])C([H])("
                "[H])Br)C([H])(Br)C%20([H])C([H])([H])C([H])([H])C%21("
                "[H])C([H])(C([H])([H])C([H])([H])Br)C([H])(Br)C([H])("
                "C([H])([H])C([H])([H])C12[H])C1([H])C([H])([H])C([H])"
                "([H])C3([H])C4([H])C([H])([H])C([H])([H])C2([H])C3([H"
                "])C([H])([H])C([H])([H])C5([H])C6([H])C([H])([H])C([H"
                "])([H])C4([H])C([H])(C([H])([H])C([H])([H])C78[H])C5("
                "[H])C([H])([H])C([H])([H])C9([H])C%10([H])C([H])([H])"
                "C([H])([H])C6([H])C7([H])C([H])([H])C([H])([H])C%11(["
                "H])C%12([H])C([H])([H])C([H])([H])C%13([H])C%14([H])C"
                "([H])([H])C([H])([H])C7([H])C7([H])C([H])([H])C([H])("
                "[H])C%15([H])C%16([H])C([H])([H])C([H])([H])C8([H])C("
                "[H])(C([H])([H])C([H])([H])C%18%17[H])C9([H])C([H])(["
                "H])C([H])([H])C%19([H])C%20([H])C([H])([H])C([H])([H]"
                ")C([H])(C2([H])C([H])([H])C([H])([H])C%211[H])C1([H])"
                "C([H])([H])C([H])([H])C9([H])C2([H])C([H])([H])C([H])"
                "([H])C([H])(C4([H])C([H])([H])C([H])([H])C31[H])C5([H"
                "])C([H])([H])C([H])([H])C6([H])C7([H])C([H])([H])C([H"
                "])([H])C82[H]"
            ),
            name=name,
        ),
    ),
)
def cof_hexagonal(request) -> CaseData:
    return request.param(
        f"{request.fixturename}{request.param_index}",
    )
