window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"mgplot": {"fullname": "mgplot", "modulename": "mgplot", "kind": "module", "doc": "<p>Provide a frontend to matplotlib for working with timeseries data, indexed with a PeriodIndex.</p>\n\n<p>This package simplifiers the creation of common plots used in economic and financial analysis,\nsuch as bar plots, line plots, growth plots, and seasonal trend plots. It also includes utilities\nfor color management and finalising plots with consistent styling.</p>\n"}, "mgplot.BarKwargs": {"fullname": "mgplot.BarKwargs", "modulename": "mgplot", "qualname": "BarKwargs", "kind": "class", "doc": "<p>Keyword arguments for the bar_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.BarKwargs.ax": {"fullname": "mgplot.BarKwargs.ax", "modulename": "mgplot", "qualname": "BarKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.BarKwargs.stacked": {"fullname": "mgplot.BarKwargs.stacked", "modulename": "mgplot", "qualname": "BarKwargs.stacked", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.BarKwargs.max_ticks": {"fullname": "mgplot.BarKwargs.max_ticks", "modulename": "mgplot", "qualname": "BarKwargs.max_ticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.BarKwargs.plot_from": {"fullname": "mgplot.BarKwargs.plot_from", "modulename": "mgplot", "qualname": "BarKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period]"}, "mgplot.BarKwargs.color": {"fullname": "mgplot.BarKwargs.color", "modulename": "mgplot", "qualname": "BarKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.BarKwargs.label_series": {"fullname": "mgplot.BarKwargs.label_series", "modulename": "mgplot", "qualname": "BarKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool]]"}, "mgplot.BarKwargs.width": {"fullname": "mgplot.BarKwargs.width", "modulename": "mgplot", "qualname": "BarKwargs.width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | int | Sequence[float | int]]"}, "mgplot.BarKwargs.annotate": {"fullname": "mgplot.BarKwargs.annotate", "modulename": "mgplot", "qualname": "BarKwargs.annotate", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.BarKwargs.fontsize": {"fullname": "mgplot.BarKwargs.fontsize", "modulename": "mgplot", "qualname": "BarKwargs.fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float | str]"}, "mgplot.BarKwargs.fontname": {"fullname": "mgplot.BarKwargs.fontname", "modulename": "mgplot", "qualname": "BarKwargs.fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.BarKwargs.rounding": {"fullname": "mgplot.BarKwargs.rounding", "modulename": "mgplot", "qualname": "BarKwargs.rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.BarKwargs.rotation": {"fullname": "mgplot.BarKwargs.rotation", "modulename": "mgplot", "qualname": "BarKwargs.rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float]"}, "mgplot.BarKwargs.annotate_color": {"fullname": "mgplot.BarKwargs.annotate_color", "modulename": "mgplot", "qualname": "BarKwargs.annotate_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.BarKwargs.above": {"fullname": "mgplot.BarKwargs.above", "modulename": "mgplot", "qualname": "BarKwargs.above", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs": {"fullname": "mgplot.FinaliseKwargs", "modulename": "mgplot", "qualname": "FinaliseKwargs", "kind": "class", "doc": "<p>Keyword arguments for the finalise_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.FinaliseKwargs.title": {"fullname": "mgplot.FinaliseKwargs.title", "modulename": "mgplot", "qualname": "FinaliseKwargs.title", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.FinaliseKwargs.xlabel": {"fullname": "mgplot.FinaliseKwargs.xlabel", "modulename": "mgplot", "qualname": "FinaliseKwargs.xlabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.FinaliseKwargs.ylabel": {"fullname": "mgplot.FinaliseKwargs.ylabel", "modulename": "mgplot", "qualname": "FinaliseKwargs.ylabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.FinaliseKwargs.xlim": {"fullname": "mgplot.FinaliseKwargs.xlim", "modulename": "mgplot", "qualname": "FinaliseKwargs.xlim", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[tuple[float, float] | None]"}, "mgplot.FinaliseKwargs.ylim": {"fullname": "mgplot.FinaliseKwargs.ylim", "modulename": "mgplot", "qualname": "FinaliseKwargs.ylim", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[tuple[float, float] | None]"}, "mgplot.FinaliseKwargs.xticks": {"fullname": "mgplot.FinaliseKwargs.xticks", "modulename": "mgplot", "qualname": "FinaliseKwargs.xticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[list[float] | None]"}, "mgplot.FinaliseKwargs.yticks": {"fullname": "mgplot.FinaliseKwargs.yticks", "modulename": "mgplot", "qualname": "FinaliseKwargs.yticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[list[float] | None]"}, "mgplot.FinaliseKwargs.xscale": {"fullname": "mgplot.FinaliseKwargs.xscale", "modulename": "mgplot", "qualname": "FinaliseKwargs.xscale", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.FinaliseKwargs.yscale": {"fullname": "mgplot.FinaliseKwargs.yscale", "modulename": "mgplot", "qualname": "FinaliseKwargs.yscale", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.FinaliseKwargs.legend": {"fullname": "mgplot.FinaliseKwargs.legend", "modulename": "mgplot", "qualname": "FinaliseKwargs.legend", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | dict[str, Any] | None]"}, "mgplot.FinaliseKwargs.axhspan": {"fullname": "mgplot.FinaliseKwargs.axhspan", "modulename": "mgplot", "qualname": "FinaliseKwargs.axhspan", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.FinaliseKwargs.axvspan": {"fullname": "mgplot.FinaliseKwargs.axvspan", "modulename": "mgplot", "qualname": "FinaliseKwargs.axvspan", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.FinaliseKwargs.axhline": {"fullname": "mgplot.FinaliseKwargs.axhline", "modulename": "mgplot", "qualname": "FinaliseKwargs.axhline", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.FinaliseKwargs.axvline": {"fullname": "mgplot.FinaliseKwargs.axvline", "modulename": "mgplot", "qualname": "FinaliseKwargs.axvline", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.FinaliseKwargs.lfooter": {"fullname": "mgplot.FinaliseKwargs.lfooter", "modulename": "mgplot", "qualname": "FinaliseKwargs.lfooter", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.rfooter": {"fullname": "mgplot.FinaliseKwargs.rfooter", "modulename": "mgplot", "qualname": "FinaliseKwargs.rfooter", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.lheader": {"fullname": "mgplot.FinaliseKwargs.lheader", "modulename": "mgplot", "qualname": "FinaliseKwargs.lheader", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.rheader": {"fullname": "mgplot.FinaliseKwargs.rheader", "modulename": "mgplot", "qualname": "FinaliseKwargs.rheader", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.pre_tag": {"fullname": "mgplot.FinaliseKwargs.pre_tag", "modulename": "mgplot", "qualname": "FinaliseKwargs.pre_tag", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.tag": {"fullname": "mgplot.FinaliseKwargs.tag", "modulename": "mgplot", "qualname": "FinaliseKwargs.tag", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.chart_dir": {"fullname": "mgplot.FinaliseKwargs.chart_dir", "modulename": "mgplot", "qualname": "FinaliseKwargs.chart_dir", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.file_type": {"fullname": "mgplot.FinaliseKwargs.file_type", "modulename": "mgplot", "qualname": "FinaliseKwargs.file_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.FinaliseKwargs.dpi": {"fullname": "mgplot.FinaliseKwargs.dpi", "modulename": "mgplot", "qualname": "FinaliseKwargs.dpi", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.FinaliseKwargs.figsize": {"fullname": "mgplot.FinaliseKwargs.figsize", "modulename": "mgplot", "qualname": "FinaliseKwargs.figsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[tuple[float, float]]"}, "mgplot.FinaliseKwargs.show": {"fullname": "mgplot.FinaliseKwargs.show", "modulename": "mgplot", "qualname": "FinaliseKwargs.show", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs.preserve_lims": {"fullname": "mgplot.FinaliseKwargs.preserve_lims", "modulename": "mgplot", "qualname": "FinaliseKwargs.preserve_lims", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs.remove_legend": {"fullname": "mgplot.FinaliseKwargs.remove_legend", "modulename": "mgplot", "qualname": "FinaliseKwargs.remove_legend", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs.zero_y": {"fullname": "mgplot.FinaliseKwargs.zero_y", "modulename": "mgplot", "qualname": "FinaliseKwargs.zero_y", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs.y0": {"fullname": "mgplot.FinaliseKwargs.y0", "modulename": "mgplot", "qualname": "FinaliseKwargs.y0", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs.x0": {"fullname": "mgplot.FinaliseKwargs.x0", "modulename": "mgplot", "qualname": "FinaliseKwargs.x0", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs.dont_save": {"fullname": "mgplot.FinaliseKwargs.dont_save", "modulename": "mgplot", "qualname": "FinaliseKwargs.dont_save", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.FinaliseKwargs.dont_close": {"fullname": "mgplot.FinaliseKwargs.dont_close", "modulename": "mgplot", "qualname": "FinaliseKwargs.dont_close", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.GrowthKwargs": {"fullname": "mgplot.GrowthKwargs", "modulename": "mgplot", "qualname": "GrowthKwargs", "kind": "class", "doc": "<p>Keyword arguments for the growth_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.GrowthKwargs.ax": {"fullname": "mgplot.GrowthKwargs.ax", "modulename": "mgplot", "qualname": "GrowthKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.GrowthKwargs.plot_from": {"fullname": "mgplot.GrowthKwargs.plot_from", "modulename": "mgplot", "qualname": "GrowthKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period]"}, "mgplot.GrowthKwargs.label_series": {"fullname": "mgplot.GrowthKwargs.label_series", "modulename": "mgplot", "qualname": "GrowthKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.GrowthKwargs.max_ticks": {"fullname": "mgplot.GrowthKwargs.max_ticks", "modulename": "mgplot", "qualname": "GrowthKwargs.max_ticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.GrowthKwargs.line_width": {"fullname": "mgplot.GrowthKwargs.line_width", "modulename": "mgplot", "qualname": "GrowthKwargs.line_width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float]"}, "mgplot.GrowthKwargs.line_color": {"fullname": "mgplot.GrowthKwargs.line_color", "modulename": "mgplot", "qualname": "GrowthKwargs.line_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.GrowthKwargs.line_style": {"fullname": "mgplot.GrowthKwargs.line_style", "modulename": "mgplot", "qualname": "GrowthKwargs.line_style", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.GrowthKwargs.annotate_line": {"fullname": "mgplot.GrowthKwargs.annotate_line", "modulename": "mgplot", "qualname": "GrowthKwargs.annotate_line", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.GrowthKwargs.line_rounding": {"fullname": "mgplot.GrowthKwargs.line_rounding", "modulename": "mgplot", "qualname": "GrowthKwargs.line_rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | int]"}, "mgplot.GrowthKwargs.line_fontsize": {"fullname": "mgplot.GrowthKwargs.line_fontsize", "modulename": "mgplot", "qualname": "GrowthKwargs.line_fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float | str]"}, "mgplot.GrowthKwargs.line_fontname": {"fullname": "mgplot.GrowthKwargs.line_fontname", "modulename": "mgplot", "qualname": "GrowthKwargs.line_fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.GrowthKwargs.line_anno_color": {"fullname": "mgplot.GrowthKwargs.line_anno_color", "modulename": "mgplot", "qualname": "GrowthKwargs.line_anno_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.GrowthKwargs.annotate_bars": {"fullname": "mgplot.GrowthKwargs.annotate_bars", "modulename": "mgplot", "qualname": "GrowthKwargs.annotate_bars", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.GrowthKwargs.bar_fontsize": {"fullname": "mgplot.GrowthKwargs.bar_fontsize", "modulename": "mgplot", "qualname": "GrowthKwargs.bar_fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float | str]"}, "mgplot.GrowthKwargs.bar_fontname": {"fullname": "mgplot.GrowthKwargs.bar_fontname", "modulename": "mgplot", "qualname": "GrowthKwargs.bar_fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.GrowthKwargs.bar_rounding": {"fullname": "mgplot.GrowthKwargs.bar_rounding", "modulename": "mgplot", "qualname": "GrowthKwargs.bar_rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.GrowthKwargs.bar_width": {"fullname": "mgplot.GrowthKwargs.bar_width", "modulename": "mgplot", "qualname": "GrowthKwargs.bar_width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float]"}, "mgplot.GrowthKwargs.bar_color": {"fullname": "mgplot.GrowthKwargs.bar_color", "modulename": "mgplot", "qualname": "GrowthKwargs.bar_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.GrowthKwargs.bar_anno_color": {"fullname": "mgplot.GrowthKwargs.bar_anno_color", "modulename": "mgplot", "qualname": "GrowthKwargs.bar_anno_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.GrowthKwargs.bar_rotation": {"fullname": "mgplot.GrowthKwargs.bar_rotation", "modulename": "mgplot", "qualname": "GrowthKwargs.bar_rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float]"}, "mgplot.LineKwargs": {"fullname": "mgplot.LineKwargs", "modulename": "mgplot", "qualname": "LineKwargs", "kind": "class", "doc": "<p>Keyword arguments for the line_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.LineKwargs.ax": {"fullname": "mgplot.LineKwargs.ax", "modulename": "mgplot", "qualname": "LineKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.LineKwargs.style": {"fullname": "mgplot.LineKwargs.style", "modulename": "mgplot", "qualname": "LineKwargs.style", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.LineKwargs.width": {"fullname": "mgplot.LineKwargs.width", "modulename": "mgplot", "qualname": "LineKwargs.width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | int | Sequence[float | int]]"}, "mgplot.LineKwargs.color": {"fullname": "mgplot.LineKwargs.color", "modulename": "mgplot", "qualname": "LineKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.LineKwargs.alpha": {"fullname": "mgplot.LineKwargs.alpha", "modulename": "mgplot", "qualname": "LineKwargs.alpha", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | Sequence[float]]"}, "mgplot.LineKwargs.drawstyle": {"fullname": "mgplot.LineKwargs.drawstyle", "modulename": "mgplot", "qualname": "LineKwargs.drawstyle", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str] | None]"}, "mgplot.LineKwargs.marker": {"fullname": "mgplot.LineKwargs.marker", "modulename": "mgplot", "qualname": "LineKwargs.marker", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str] | None]"}, "mgplot.LineKwargs.markersize": {"fullname": "mgplot.LineKwargs.markersize", "modulename": "mgplot", "qualname": "LineKwargs.markersize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | Sequence[float] | int | None]"}, "mgplot.LineKwargs.dropna": {"fullname": "mgplot.LineKwargs.dropna", "modulename": "mgplot", "qualname": "LineKwargs.dropna", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool]]"}, "mgplot.LineKwargs.annotate": {"fullname": "mgplot.LineKwargs.annotate", "modulename": "mgplot", "qualname": "LineKwargs.annotate", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool]]"}, "mgplot.LineKwargs.rounding": {"fullname": "mgplot.LineKwargs.rounding", "modulename": "mgplot", "qualname": "LineKwargs.rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[Sequence[int | bool] | int | bool | None]"}, "mgplot.LineKwargs.fontsize": {"fullname": "mgplot.LineKwargs.fontsize", "modulename": "mgplot", "qualname": "LineKwargs.fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[Sequence[str | int | float] | str | int | float]"}, "mgplot.LineKwargs.fontname": {"fullname": "mgplot.LineKwargs.fontname", "modulename": "mgplot", "qualname": "LineKwargs.fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.LineKwargs.rotation": {"fullname": "mgplot.LineKwargs.rotation", "modulename": "mgplot", "qualname": "LineKwargs.rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | int | Sequence[float | int]]"}, "mgplot.LineKwargs.annotate_color": {"fullname": "mgplot.LineKwargs.annotate_color", "modulename": "mgplot", "qualname": "LineKwargs.annotate_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str] | bool | Sequence[bool] | None]"}, "mgplot.LineKwargs.plot_from": {"fullname": "mgplot.LineKwargs.plot_from", "modulename": "mgplot", "qualname": "LineKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period | None]"}, "mgplot.LineKwargs.label_series": {"fullname": "mgplot.LineKwargs.label_series", "modulename": "mgplot", "qualname": "LineKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool] | None]"}, "mgplot.LineKwargs.max_ticks": {"fullname": "mgplot.LineKwargs.max_ticks", "modulename": "mgplot", "qualname": "LineKwargs.max_ticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.PostcovidKwargs": {"fullname": "mgplot.PostcovidKwargs", "modulename": "mgplot", "qualname": "PostcovidKwargs", "kind": "class", "doc": "<p>Keyword arguments for the post-COVID plot.</p>\n", "bases": "mgplot.line_plot.LineKwargs"}, "mgplot.PostcovidKwargs.start_r": {"fullname": "mgplot.PostcovidKwargs.start_r", "modulename": "mgplot", "qualname": "PostcovidKwargs.start_r", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[pandas._libs.tslibs.period.Period]"}, "mgplot.PostcovidKwargs.end_r": {"fullname": "mgplot.PostcovidKwargs.end_r", "modulename": "mgplot", "qualname": "PostcovidKwargs.end_r", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[pandas._libs.tslibs.period.Period]"}, "mgplot.RunKwargs": {"fullname": "mgplot.RunKwargs", "modulename": "mgplot", "qualname": "RunKwargs", "kind": "class", "doc": "<p>Keyword arguments for the run_plot function.</p>\n", "bases": "mgplot.line_plot.LineKwargs"}, "mgplot.RunKwargs.threshold": {"fullname": "mgplot.RunKwargs.threshold", "modulename": "mgplot", "qualname": "RunKwargs.threshold", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float]"}, "mgplot.RunKwargs.direction": {"fullname": "mgplot.RunKwargs.direction", "modulename": "mgplot", "qualname": "RunKwargs.direction", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.RunKwargs.highlight_color": {"fullname": "mgplot.RunKwargs.highlight_color", "modulename": "mgplot", "qualname": "RunKwargs.highlight_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.RunKwargs.highlight_label": {"fullname": "mgplot.RunKwargs.highlight_label", "modulename": "mgplot", "qualname": "RunKwargs.highlight_label", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.SeriesGrowthKwargs": {"fullname": "mgplot.SeriesGrowthKwargs", "modulename": "mgplot", "qualname": "SeriesGrowthKwargs", "kind": "class", "doc": "<p>Keyword arguments for the series_growth_plot function.</p>\n", "bases": "mgplot.growth_plot.GrowthKwargs"}, "mgplot.SeriesGrowthKwargs.ylabel": {"fullname": "mgplot.SeriesGrowthKwargs.ylabel", "modulename": "mgplot", "qualname": "SeriesGrowthKwargs.ylabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.SummaryKwargs": {"fullname": "mgplot.SummaryKwargs", "modulename": "mgplot", "qualname": "SummaryKwargs", "kind": "class", "doc": "<p>Keyword arguments for the summary_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.SummaryKwargs.ax": {"fullname": "mgplot.SummaryKwargs.ax", "modulename": "mgplot", "qualname": "SummaryKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.SummaryKwargs.verbose": {"fullname": "mgplot.SummaryKwargs.verbose", "modulename": "mgplot", "qualname": "SummaryKwargs.verbose", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.SummaryKwargs.middle": {"fullname": "mgplot.SummaryKwargs.middle", "modulename": "mgplot", "qualname": "SummaryKwargs.middle", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float]"}, "mgplot.SummaryKwargs.plot_type": {"fullname": "mgplot.SummaryKwargs.plot_type", "modulename": "mgplot", "qualname": "SummaryKwargs.plot_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.SummaryKwargs.plot_from": {"fullname": "mgplot.SummaryKwargs.plot_from", "modulename": "mgplot", "qualname": "SummaryKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period]"}, "mgplot.SummaryKwargs.legend": {"fullname": "mgplot.SummaryKwargs.legend", "modulename": "mgplot", "qualname": "SummaryKwargs.legend", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.SummaryKwargs.xlabel": {"fullname": "mgplot.SummaryKwargs.xlabel", "modulename": "mgplot", "qualname": "SummaryKwargs.xlabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.abbreviate_state": {"fullname": "mgplot.abbreviate_state", "modulename": "mgplot", "qualname": "abbreviate_state", "kind": "function", "doc": "<p>Abbreviate long-form state names.</p>\n\n<p>Args:\n    state: str - the long-form state name.</p>\n\n<p>Return the abbreviation for a state name.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">state</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "mgplot.bar_plot": {"fullname": "mgplot.bar_plot", "modulename": "mgplot.bar_plot", "kind": "module", "doc": "<p>Create bar plots using Matplotlib.</p>\n\n<p>Note: bar plots in Matplotlib are not the same as bar charts in other\nlibraries. Bar plots are used to represent categorical data with\nrectangular bars. As a result, bar plots and line plots typically\ncannot be plotted on the same axes.</p>\n"}, "mgplot.bar_plot_finalise": {"fullname": "mgplot.bar_plot_finalise", "modulename": "mgplot", "qualname": "bar_plot_finalise", "kind": "function", "doc": "<p>Call bar_plot() and finalise_plot().</p>\n\n<p>Args:\n    data: The data to be plotted.\n    kwargs: Combined bar plot and finalise plot keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">BPFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.calc_growth": {"fullname": "mgplot.calc_growth", "modulename": "mgplot", "qualname": "calc_growth", "kind": "function", "doc": "<p>Calculate annual and periodic growth for a pandas Series.</p>\n\n<p>Args:\n    series: Series - a pandas series with a date-like PeriodIndex.</p>\n\n<p>Returns:\n    DataFrame: A two column DataFrame with annual and periodic growth rates.</p>\n\n<p>Raises:\n    TypeError if the series is not a pandas Series.\n    TypeError if the series index is not a PeriodIndex.\n    ValueError if the series is empty.\n    ValueError if the series index does not have a frequency of Q, M, or D.\n    ValueError if the series index has duplicates.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">series</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "mgplot.clear_chart_dir": {"fullname": "mgplot.clear_chart_dir", "modulename": "mgplot", "qualname": "clear_chart_dir", "kind": "function", "doc": "<p>Remove all graph-image files from the global chart_dir.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.colorise_list": {"fullname": "mgplot.colorise_list", "modulename": "mgplot", "qualname": "colorise_list", "kind": "function", "doc": "<p>Return a list of party/state colors for a party_list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">party_list</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "mgplot.contrast": {"fullname": "mgplot.contrast", "modulename": "mgplot", "qualname": "contrast", "kind": "function", "doc": "<p>Provide a contrasting color to any party color.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">orig_color</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot": {"fullname": "mgplot.finalise_plot", "modulename": "mgplot.finalise_plot", "kind": "module", "doc": "<p>Functions to finalise and save plots to the file system.</p>\n"}, "mgplot.get_color": {"fullname": "mgplot.get_color", "modulename": "mgplot", "qualname": "get_color", "kind": "function", "doc": "<p>Return a matplotlib color for a party label or an Australian state/territory.</p>\n\n<p>Args:\n    s: str - the party label or Australian state/territory name.</p>\n\n<p>Returns a color string that can be used in matplotlib plots.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">s</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "mgplot.get_party_palette": {"fullname": "mgplot.get_party_palette", "modulename": "mgplot", "qualname": "get_party_palette", "kind": "function", "doc": "<p>Return a matplotlib color-map name based on party_text.</p>\n\n<p>Works for Australian major political parties.</p>\n\n<p>Args:\n    party_text: str - the party label or name.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">party_text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "mgplot.get_setting": {"fullname": "mgplot.get_setting", "modulename": "mgplot", "qualname": "get_setting", "kind": "function", "doc": "<p>Get a setting from the global settings.</p>\n\n<p>Args:\n    setting: str - name of the setting to get.</p>\n\n<p>Raises:\n    KeyError: if the setting is not found</p>\n\n<p>Returns:\n    value: Any - the value of the setting</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">setting</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "mgplot.growth_plot": {"fullname": "mgplot.growth_plot", "modulename": "mgplot.growth_plot", "kind": "module", "doc": "<p>Plot period and annual/through-the-year growth rates on the same axes.</p>\n\n<p>Key functions:</p>\n\n<ul>\n<li>calc_growth()</li>\n<li>growth_plot()</li>\n<li>series_growth_plot()</li>\n</ul>\n"}, "mgplot.growth_plot_finalise": {"fullname": "mgplot.growth_plot_finalise", "modulename": "mgplot", "qualname": "growth_plot_finalise", "kind": "function", "doc": "<p>Call growth_plot() and finalise_plot().</p>\n\n<p>Args:\n    data: The growth data to be plotted.\n    kwargs: Combined growth plot and finalise plot keyword arguments.</p>\n\n<p>Note:\n    Use this when you are providing the raw growth data. Don't forget to\n    set the ylabel in kwargs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">GrowthPFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.line_plot": {"fullname": "mgplot.line_plot", "modulename": "mgplot.line_plot", "kind": "module", "doc": "<p>Plot a series or a dataframe with lines.</p>\n"}, "mgplot.line_plot_finalise": {"fullname": "mgplot.line_plot_finalise", "modulename": "mgplot", "qualname": "line_plot_finalise", "kind": "function", "doc": "<p>Call line_plot() then finalise_plot().</p>\n\n<p>Args:\n    data: The data to be plotted.\n    kwargs: Combined line plot and finalise plot keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">LPFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.multi_column": {"fullname": "mgplot.multi_column", "modulename": "mgplot", "qualname": "multi_column", "kind": "function", "doc": "<p>Create multiple plots, one for each column in a DataFrame.</p>\n\n<p>Args:\n    data: DataFrame - The data to be plotted.\n    function: Callable | list[Callable] - The plotting function(s) to be used.\n    kwargs: Any - Additional keyword arguments passed to plotting functions.</p>\n\n<p>Returns:\n    None</p>\n\n<p>Raises:\n    TypeError: If data is not a DataFrame.\n    ValueError: If DataFrame is empty or has no columns.</p>\n\n<p>Note:\n    The plot title will be kwargs[\"title\"] plus the column name.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">function</span><span class=\"p\">:</span> <span class=\"n\">Callable</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.multi_start": {"fullname": "mgplot.multi_start", "modulename": "mgplot", "qualname": "multi_start", "kind": "function", "doc": "<p>Create multiple plots with different starting points.</p>\n\n<p>Args:\n    data: Series | DataFrame - The data to be plotted.\n    function: Callable | list[Callable] - desired plotting function(s).\n    starts: Iterable[Period | int | None] - The starting points for each plot.\n    kwargs: Any - Additional keyword arguments passed to plotting functions.</p>\n\n<p>Returns:\n    None</p>\n\n<p>Raises:\n    TypeError: If starts is not an iterable of None, Period or int.\n    ValueError: If starts contains invalid values or is empty.</p>\n\n<p>Note:\n    kwargs['tag'] is used to create a unique tag for each plot.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"n\">function</span><span class=\"p\">:</span> <span class=\"n\">Callable</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">starts</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"kc\">None</span> <span class=\"o\">|</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">_libs</span><span class=\"o\">.</span><span class=\"n\">tslibs</span><span class=\"o\">.</span><span class=\"n\">period</span><span class=\"o\">.</span><span class=\"n\">Period</span> <span class=\"o\">|</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.plot_then_finalise": {"fullname": "mgplot.plot_then_finalise", "modulename": "mgplot", "qualname": "plot_then_finalise", "kind": "function", "doc": "<p>Chain a plotting function with the finalise_plot() function.</p>\n\n<p>Args:\n    data: Series | DataFrame - The data to be plotted.\n    function: Callable | list[Callable] - the desired plotting function(s).\n    kwargs: Any - Additional keyword arguments.</p>\n\n<p>Returns None.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"n\">function</span><span class=\"p\">:</span> <span class=\"n\">Callable</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.postcovid_plot": {"fullname": "mgplot.postcovid_plot", "modulename": "mgplot.postcovid_plot", "kind": "module", "doc": "<p>Plot the pre-COVID trajectory against the current trend.</p>\n"}, "mgplot.postcovid_plot_finalise": {"fullname": "mgplot.postcovid_plot_finalise", "modulename": "mgplot", "qualname": "postcovid_plot_finalise", "kind": "function", "doc": "<p>Call postcovid_plot() and finalise_plot().</p>\n\n<p>Args:\n    data: The data to be plotted.\n    kwargs: Combined postcovid plot and finalise plot keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">PCFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.revision_plot": {"fullname": "mgplot.revision_plot", "modulename": "mgplot.revision_plot", "kind": "module", "doc": "<p>Plot ABS revisions to estimates over time.</p>\n"}, "mgplot.revision_plot_finalise": {"fullname": "mgplot.revision_plot_finalise", "modulename": "mgplot", "qualname": "revision_plot_finalise", "kind": "function", "doc": "<p>Call revision_plot() and finalise_plot().</p>\n\n<p>Args:\n    data: The revision data to be plotted.\n    kwargs: Combined revision plot and finalise plot keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">RevPFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.run_plot": {"fullname": "mgplot.run_plot", "modulename": "mgplot.run_plot", "kind": "module", "doc": "<p>Plot and highlight the 'runs' in a series.</p>\n"}, "mgplot.run_plot_finalise": {"fullname": "mgplot.run_plot_finalise", "modulename": "mgplot", "qualname": "run_plot_finalise", "kind": "function", "doc": "<p>Call run_plot() and finalise_plot().</p>\n\n<p>Args:\n    data: The data to be plotted.\n    kwargs: Combined run plot and finalise plot keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">RunPFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.seastrend_plot": {"fullname": "mgplot.seastrend_plot", "modulename": "mgplot.seastrend_plot", "kind": "module", "doc": "<p>Create seasonal+trend plots.</p>\n"}, "mgplot.seastrend_plot_finalise": {"fullname": "mgplot.seastrend_plot_finalise", "modulename": "mgplot", "qualname": "seastrend_plot_finalise", "kind": "function", "doc": "<p>Call seastrend_plot() and finalise_plot().</p>\n\n<p>Args:\n    data: The seasonal and trend data to be plotted.\n    kwargs: Combined seastrend plot and finalise plot keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">SFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.series_growth_plot": {"fullname": "mgplot.series_growth_plot", "modulename": "mgplot", "qualname": "series_growth_plot", "kind": "function", "doc": "<p>Plot annual and periodic growth in percentage terms from a pandas Series.</p>\n\n<p>Args:\n    data: A pandas Series with an appropriate PeriodIndex.\n    kwargs: SeriesGrowthKwargs</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">growth_plot</span><span class=\"o\">.</span><span class=\"n\">SeriesGrowthKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.series_growth_plot_finalise": {"fullname": "mgplot.series_growth_plot_finalise", "modulename": "mgplot", "qualname": "series_growth_plot_finalise", "kind": "function", "doc": "<p>Call series_growth_plot() and finalise_plot().</p>\n\n<p>Args:\n    data: The series data to calculate and plot growth for.\n    kwargs: Combined series growth plot and finalise plot keyword arguments.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">SGFPKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.set_chart_dir": {"fullname": "mgplot.set_chart_dir", "modulename": "mgplot", "qualname": "set_chart_dir", "kind": "function", "doc": "<p>Set a global chart directory for finalise_plot().</p>\n\n<p>Args:\n    chart_dir: str - the directory to set as the chart directory</p>\n\n<p>Note: Path.mkdir() may raise an exception if a directory cannot be created.</p>\n\n<p>Note: This is a wrapper for set_setting() to set the chart_dir setting, and\ncreate the directory if it does not exist.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">chart_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.set_setting": {"fullname": "mgplot.set_setting", "modulename": "mgplot", "qualname": "set_setting", "kind": "function", "doc": "<p>Set a setting in the global settings.</p>\n\n<p>Args:\n    setting: str - name of the setting to set (see get_setting())\n    value: Any - the value to set the setting to</p>\n\n<p>Raises:\n    KeyError: if the setting is not found\n    ValueError: if the value is invalid for the setting</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">setting</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.state_abbrs": {"fullname": "mgplot.state_abbrs", "modulename": "mgplot", "qualname": "state_abbrs", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;NSW&#x27;, &#x27;Vic&#x27;, &#x27;Qld&#x27;, &#x27;SA&#x27;, &#x27;WA&#x27;, &#x27;Tas&#x27;, &#x27;NT&#x27;, &#x27;ACT&#x27;)"}, "mgplot.state_names": {"fullname": "mgplot.state_names", "modulename": "mgplot", "qualname": "state_names", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;New South Wales&#x27;, &#x27;Victoria&#x27;, &#x27;Queensland&#x27;, &#x27;South Australia&#x27;, &#x27;Western Australia&#x27;, &#x27;Tasmania&#x27;, &#x27;Northern Territory&#x27;, &#x27;Australian Capital Territory&#x27;)"}, "mgplot.summary_plot": {"fullname": "mgplot.summary_plot", "modulename": "mgplot.summary_plot", "kind": "module", "doc": "<p>Produce a summary plot for the data in a given DataFrame.</p>\n"}, "mgplot.summary_plot_finalise": {"fullname": "mgplot.summary_plot_finalise", "modulename": "mgplot", "qualname": "summary_plot_finalise", "kind": "function", "doc": "<p>Call summary_plot() and finalise_plot().</p>\n\n<p>This is more complex than most of the above convenience methods as it\ncreates multiple plots (one for each plot type).</p>\n\n<p>Args:\n    data: DataFrame containing the summary data. The index must be a PeriodIndex.\n    kwargs: Combined summary plot and finalise plot keyword arguments.</p>\n\n<p>Raises:\n    TypeError: If data is not a DataFrame with a PeriodIndex.\n    IndexError: If DataFrame is empty.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalisers</span><span class=\"o\">.</span><span class=\"n\">SumPFKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.bar_plot.ME": {"fullname": "mgplot.bar_plot.ME", "modulename": "mgplot.bar_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;bar_plot&#x27;"}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"fullname": "mgplot.bar_plot.MAX_ANNOTATIONS", "modulename": "mgplot.bar_plot", "qualname": "MAX_ANNOTATIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[int]", "default_value": "30"}, "mgplot.bar_plot.ADJUSTMENT_FACTOR": {"fullname": "mgplot.bar_plot.ADJUSTMENT_FACTOR", "modulename": "mgplot.bar_plot", "qualname": "ADJUSTMENT_FACTOR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "0.02"}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"fullname": "mgplot.bar_plot.MIN_BAR_WIDTH", "modulename": "mgplot.bar_plot", "qualname": "MIN_BAR_WIDTH", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "0.0"}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"fullname": "mgplot.bar_plot.MAX_BAR_WIDTH", "modulename": "mgplot.bar_plot", "qualname": "MAX_BAR_WIDTH", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "1.0"}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"fullname": "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH", "modulename": "mgplot.bar_plot", "qualname": "DEFAULT_GROUPED_WIDTH", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "0.8"}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"fullname": "mgplot.bar_plot.DEFAULT_BAR_OFFSET", "modulename": "mgplot.bar_plot", "qualname": "DEFAULT_BAR_OFFSET", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "0.5"}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"fullname": "mgplot.bar_plot.DEFAULT_MAX_TICKS", "modulename": "mgplot.bar_plot", "qualname": "DEFAULT_MAX_TICKS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[int]", "default_value": "10"}, "mgplot.bar_plot.BarKwargs": {"fullname": "mgplot.bar_plot.BarKwargs", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs", "kind": "class", "doc": "<p>Keyword arguments for the bar_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.bar_plot.BarKwargs.ax": {"fullname": "mgplot.bar_plot.BarKwargs.ax", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.bar_plot.BarKwargs.stacked": {"fullname": "mgplot.bar_plot.BarKwargs.stacked", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.stacked", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.bar_plot.BarKwargs.max_ticks": {"fullname": "mgplot.bar_plot.BarKwargs.max_ticks", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.max_ticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.bar_plot.BarKwargs.plot_from": {"fullname": "mgplot.bar_plot.BarKwargs.plot_from", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period]"}, "mgplot.bar_plot.BarKwargs.color": {"fullname": "mgplot.bar_plot.BarKwargs.color", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.bar_plot.BarKwargs.label_series": {"fullname": "mgplot.bar_plot.BarKwargs.label_series", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool]]"}, "mgplot.bar_plot.BarKwargs.width": {"fullname": "mgplot.bar_plot.BarKwargs.width", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | int | Sequence[float | int]]"}, "mgplot.bar_plot.BarKwargs.annotate": {"fullname": "mgplot.bar_plot.BarKwargs.annotate", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.annotate", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.bar_plot.BarKwargs.fontsize": {"fullname": "mgplot.bar_plot.BarKwargs.fontsize", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float | str]"}, "mgplot.bar_plot.BarKwargs.fontname": {"fullname": "mgplot.bar_plot.BarKwargs.fontname", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.bar_plot.BarKwargs.rounding": {"fullname": "mgplot.bar_plot.BarKwargs.rounding", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.bar_plot.BarKwargs.rotation": {"fullname": "mgplot.bar_plot.BarKwargs.rotation", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float]"}, "mgplot.bar_plot.BarKwargs.annotate_color": {"fullname": "mgplot.bar_plot.BarKwargs.annotate_color", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.annotate_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.bar_plot.BarKwargs.above": {"fullname": "mgplot.bar_plot.BarKwargs.above", "modulename": "mgplot.bar_plot", "qualname": "BarKwargs.above", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.bar_plot.AnnoKwargs": {"fullname": "mgplot.bar_plot.AnnoKwargs", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs", "kind": "class", "doc": "<p>TypedDict for the kwargs used in annotate_bars.</p>\n", "bases": "typing.TypedDict"}, "mgplot.bar_plot.AnnoKwargs.annotate": {"fullname": "mgplot.bar_plot.AnnoKwargs.annotate", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.annotate", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"fullname": "mgplot.bar_plot.AnnoKwargs.fontsize", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int | float | str"}, "mgplot.bar_plot.AnnoKwargs.fontname": {"fullname": "mgplot.bar_plot.AnnoKwargs.fontname", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "mgplot.bar_plot.AnnoKwargs.color": {"fullname": "mgplot.bar_plot.AnnoKwargs.color", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "mgplot.bar_plot.AnnoKwargs.rotation": {"fullname": "mgplot.bar_plot.AnnoKwargs.rotation", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int | float"}, "mgplot.bar_plot.AnnoKwargs.foreground": {"fullname": "mgplot.bar_plot.AnnoKwargs.foreground", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.foreground", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "mgplot.bar_plot.AnnoKwargs.above": {"fullname": "mgplot.bar_plot.AnnoKwargs.above", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.above", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool"}, "mgplot.bar_plot.AnnoKwargs.rounding": {"fullname": "mgplot.bar_plot.AnnoKwargs.rounding", "modulename": "mgplot.bar_plot", "qualname": "AnnoKwargs.rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | int"}, "mgplot.bar_plot.annotate_bars": {"fullname": "mgplot.bar_plot.annotate_bars", "modulename": "mgplot.bar_plot", "qualname": "annotate_bars", "kind": "function", "doc": "<p>Bar plot annotations.</p>\n\n<p>Note: \"annotate\", \"fontsize\", \"fontname\", \"color\", and \"rotation\" are expected in anno_kwargs.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">series</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span>,</span><span class=\"param\">\t<span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">base</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">anno_kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">bar_plot</span><span class=\"o\">.</span><span class=\"n\">AnnoKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.bar_plot.GroupedKwargs": {"fullname": "mgplot.bar_plot.GroupedKwargs", "modulename": "mgplot.bar_plot", "qualname": "GroupedKwargs", "kind": "class", "doc": "<p>TypedDict for the kwargs used in grouped.</p>\n", "bases": "typing.TypedDict"}, "mgplot.bar_plot.GroupedKwargs.color": {"fullname": "mgplot.bar_plot.GroupedKwargs.color", "modulename": "mgplot.bar_plot", "qualname": "GroupedKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Sequence[str]"}, "mgplot.bar_plot.GroupedKwargs.width": {"fullname": "mgplot.bar_plot.GroupedKwargs.width", "modulename": "mgplot.bar_plot", "qualname": "GroupedKwargs.width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Sequence[float | int]"}, "mgplot.bar_plot.GroupedKwargs.label_series": {"fullname": "mgplot.bar_plot.GroupedKwargs.label_series", "modulename": "mgplot.bar_plot", "qualname": "GroupedKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Sequence[bool]"}, "mgplot.bar_plot.grouped": {"fullname": "mgplot.bar_plot.grouped", "modulename": "mgplot.bar_plot", "qualname": "grouped", "kind": "function", "doc": "<p>Plot a grouped bar plot.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">anno_args</span><span class=\"p\">:</span> <span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">bar_plot</span><span class=\"o\">.</span><span class=\"n\">AnnoKwargs</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">bar_plot</span><span class=\"o\">.</span><span class=\"n\">GroupedKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.bar_plot.StackedKwargs": {"fullname": "mgplot.bar_plot.StackedKwargs", "modulename": "mgplot.bar_plot", "qualname": "StackedKwargs", "kind": "class", "doc": "<p>TypedDict for the kwargs used in stacked.</p>\n", "bases": "typing.TypedDict"}, "mgplot.bar_plot.StackedKwargs.color": {"fullname": "mgplot.bar_plot.StackedKwargs.color", "modulename": "mgplot.bar_plot", "qualname": "StackedKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Sequence[str]"}, "mgplot.bar_plot.StackedKwargs.width": {"fullname": "mgplot.bar_plot.StackedKwargs.width", "modulename": "mgplot.bar_plot", "qualname": "StackedKwargs.width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Sequence[float | int]"}, "mgplot.bar_plot.StackedKwargs.label_series": {"fullname": "mgplot.bar_plot.StackedKwargs.label_series", "modulename": "mgplot.bar_plot", "qualname": "StackedKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Sequence[bool]"}, "mgplot.bar_plot.stacked": {"fullname": "mgplot.bar_plot.stacked", "modulename": "mgplot.bar_plot", "qualname": "stacked", "kind": "function", "doc": "<p>Plot a stacked bar plot.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">anno_args</span><span class=\"p\">:</span> <span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">bar_plot</span><span class=\"o\">.</span><span class=\"n\">AnnoKwargs</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">bar_plot</span><span class=\"o\">.</span><span class=\"n\">StackedKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.bar_plot.bar_plot": {"fullname": "mgplot.bar_plot.bar_plot", "modulename": "mgplot.bar_plot", "qualname": "bar_plot", "kind": "function", "doc": "<p>Create a bar plot from the given data.</p>\n\n<p>Each column in the DataFrame will be stacked on top of each other,\nwith positive values above zero and negative values below zero.</p>\n\n<p>Args:\n    data: Series | DataFrame - The data to plot. Can be a DataFrame or a Series.\n    **kwargs: BarKwargs - Additional keyword arguments for customization.\n    (see BarKwargs for details)</p>\n\n<p>Note: This function does not assume all data is timeseries with a PeriodIndex.</p>\n\n<p>Returns:\n    axes: Axes - The axes for the plot.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">bar_plot</span><span class=\"o\">.</span><span class=\"n\">BarKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.ME": {"fullname": "mgplot.finalise_plot.ME", "modulename": "mgplot.finalise_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;finalise_plot&#x27;"}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"fullname": "mgplot.finalise_plot.MAX_FILENAME_LENGTH", "modulename": "mgplot.finalise_plot", "qualname": "MAX_FILENAME_LENGTH", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[int]", "default_value": "150"}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"fullname": "mgplot.finalise_plot.DEFAULT_MARGIN", "modulename": "mgplot.finalise_plot", "qualname": "DEFAULT_MARGIN", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "0.02"}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"fullname": "mgplot.finalise_plot.TIGHT_LAYOUT_PAD", "modulename": "mgplot.finalise_plot", "qualname": "TIGHT_LAYOUT_PAD", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "1.1"}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"fullname": "mgplot.finalise_plot.FOOTNOTE_FONTSIZE", "modulename": "mgplot.finalise_plot", "qualname": "FOOTNOTE_FONTSIZE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[int]", "default_value": "8"}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"fullname": "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE", "modulename": "mgplot.finalise_plot", "qualname": "FOOTNOTE_FONTSTYLE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;italic&#x27;"}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"fullname": "mgplot.finalise_plot.FOOTNOTE_COLOR", "modulename": "mgplot.finalise_plot", "qualname": "FOOTNOTE_COLOR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;#999999&#x27;"}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"fullname": "mgplot.finalise_plot.ZERO_LINE_WIDTH", "modulename": "mgplot.finalise_plot", "qualname": "ZERO_LINE_WIDTH", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "0.66"}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"fullname": "mgplot.finalise_plot.ZERO_LINE_COLOR", "modulename": "mgplot.finalise_plot", "qualname": "ZERO_LINE_COLOR", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;#555555&#x27;"}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"fullname": "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT", "modulename": "mgplot.finalise_plot", "qualname": "ZERO_AXIS_ADJUSTMENT", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[float]", "default_value": "0.02"}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"fullname": "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME", "modulename": "mgplot.finalise_plot", "qualname": "DEFAULT_FILE_TITLE_NAME", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;plot&#x27;"}, "mgplot.finalise_plot.FinaliseKwargs": {"fullname": "mgplot.finalise_plot.FinaliseKwargs", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs", "kind": "class", "doc": "<p>Keyword arguments for the finalise_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.finalise_plot.FinaliseKwargs.title": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.title", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.title", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.xlabel", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.xlabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.ylabel", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.ylabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.xlim", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.xlim", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[tuple[float, float] | None]"}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.ylim", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.ylim", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[tuple[float, float] | None]"}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.xticks", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.xticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[list[float] | None]"}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.yticks", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.yticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[list[float] | None]"}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.xscale", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.xscale", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.yscale", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.yscale", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.legend", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.legend", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | dict[str, Any] | None]"}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.axhspan", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.axhspan", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.axvspan", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.axvspan", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.axhline", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.axhline", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.axvline", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.axvline", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.lfooter", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.lfooter", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.rfooter", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.rfooter", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.lheader", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.lheader", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.rheader", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.rheader", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.pre_tag", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.pre_tag", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.tag", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.tag", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.chart_dir", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.chart_dir", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.file_type", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.file_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.dpi", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.dpi", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.figsize", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.figsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[tuple[float, float]]"}, "mgplot.finalise_plot.FinaliseKwargs.show": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.show", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.show", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.preserve_lims", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.preserve_lims", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.remove_legend", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.remove_legend", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.zero_y", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.zero_y", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.y0", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.y0", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.x0", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.x0", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.dont_save", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.dont_save", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"fullname": "mgplot.finalise_plot.FinaliseKwargs.dont_close", "modulename": "mgplot.finalise_plot", "qualname": "FinaliseKwargs.dont_close", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.finalise_plot.VALUE_KWARGS": {"fullname": "mgplot.finalise_plot.VALUE_KWARGS", "modulename": "mgplot.finalise_plot", "qualname": "VALUE_KWARGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;title&#x27;, &#x27;xlabel&#x27;, &#x27;ylabel&#x27;, &#x27;xlim&#x27;, &#x27;ylim&#x27;, &#x27;xticks&#x27;, &#x27;yticks&#x27;, &#x27;xscale&#x27;, &#x27;yscale&#x27;)"}, "mgplot.finalise_plot.SPLAT_KWARGS": {"fullname": "mgplot.finalise_plot.SPLAT_KWARGS", "modulename": "mgplot.finalise_plot", "qualname": "SPLAT_KWARGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;axhspan&#x27;, &#x27;axvspan&#x27;, &#x27;axhline&#x27;, &#x27;axvline&#x27;, &#x27;legend&#x27;)"}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"fullname": "mgplot.finalise_plot.HEADER_FOOTER_KWARGS", "modulename": "mgplot.finalise_plot", "qualname": "HEADER_FOOTER_KWARGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;lfooter&#x27;, &#x27;rfooter&#x27;, &#x27;lheader&#x27;, &#x27;rheader&#x27;)"}, "mgplot.finalise_plot.sanitize_filename": {"fullname": "mgplot.finalise_plot.sanitize_filename", "modulename": "mgplot.finalise_plot", "qualname": "sanitize_filename", "kind": "function", "doc": "<p>Convert a string to a safe filename.</p>\n\n<p>Args:\n    filename: The string to convert to a filename\n    max_length: Maximum length for the filename</p>\n\n<p>Returns:\n    A safe filename string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">max_length</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">150</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.make_legend": {"fullname": "mgplot.finalise_plot.make_legend", "modulename": "mgplot.finalise_plot", "qualname": "make_legend", "kind": "function", "doc": "<p>Create a legend for the plot.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">legend</span><span class=\"p\">:</span> <span class=\"kc\">None</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.apply_value_kwargs": {"fullname": "mgplot.finalise_plot.apply_value_kwargs", "modulename": "mgplot.finalise_plot", "qualname": "apply_value_kwargs", "kind": "function", "doc": "<p>Set matplotlib elements by name using Axes.set().</p>\n\n<p>Tricky: some plotting functions may set the xlabel or ylabel.\nSo ... we will set these if a setting is explicitly provided. If no\nsetting is provided, we will set to None if they are not already set.\nIf they have already been set, we will not change them.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">value_kwargs_</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalise_plot</span><span class=\"o\">.</span><span class=\"n\">FinaliseKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.apply_splat_kwargs": {"fullname": "mgplot.finalise_plot.apply_splat_kwargs", "modulename": "mgplot.finalise_plot", "qualname": "apply_splat_kwargs", "kind": "function", "doc": "<p>Set matplotlib elements dynamically using setting_name and splat.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">settings</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalise_plot</span><span class=\"o\">.</span><span class=\"n\">FinaliseKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.apply_annotations": {"fullname": "mgplot.finalise_plot.apply_annotations", "modulename": "mgplot.finalise_plot", "qualname": "apply_annotations", "kind": "function", "doc": "<p>Set figure size and apply chart annotations.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalise_plot</span><span class=\"o\">.</span><span class=\"n\">FinaliseKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.apply_late_kwargs": {"fullname": "mgplot.finalise_plot.apply_late_kwargs", "modulename": "mgplot.finalise_plot", "qualname": "apply_late_kwargs", "kind": "function", "doc": "<p>Apply settings found in kwargs, after plotting the data.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalise_plot</span><span class=\"o\">.</span><span class=\"n\">FinaliseKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.apply_kwargs": {"fullname": "mgplot.finalise_plot.apply_kwargs", "modulename": "mgplot.finalise_plot", "qualname": "apply_kwargs", "kind": "function", "doc": "<p>Apply settings found in kwargs.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalise_plot</span><span class=\"o\">.</span><span class=\"n\">FinaliseKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.save_to_file": {"fullname": "mgplot.finalise_plot.save_to_file", "modulename": "mgplot.finalise_plot", "qualname": "save_to_file", "kind": "function", "doc": "<p>Save the figure to file.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">fig</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">figure</span><span class=\"o\">.</span><span class=\"n\">Figure</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalise_plot</span><span class=\"o\">.</span><span class=\"n\">FinaliseKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.finalise_plot.finalise_plot": {"fullname": "mgplot.finalise_plot.finalise_plot", "modulename": "mgplot.finalise_plot", "qualname": "finalise_plot", "kind": "function", "doc": "<p>Finalise and save plots to the file system.</p>\n\n<p>The filename for the saved plot is constructed from the global\nchart_dir, the plot's title, any specified tag text, and the\nfile_type for the plot.</p>\n\n<p>Args:\n    axes: Axes - matplotlib axes object - required\n    kwargs: FinaliseKwargs</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">finalise_plot</span><span class=\"o\">.</span><span class=\"n\">FinaliseKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"fullname": "mgplot.growth_plot.FREQUENCY_TO_PERIODS", "modulename": "mgplot.growth_plot", "qualname": "FREQUENCY_TO_PERIODS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;Q&#x27;: 4, &#x27;M&#x27;: 12, &#x27;D&#x27;: 365}"}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"fullname": "mgplot.growth_plot.FREQUENCY_TO_NAME", "modulename": "mgplot.growth_plot", "qualname": "FREQUENCY_TO_NAME", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;Q&#x27;: &#x27;Quarterly&#x27;, &#x27;M&#x27;: &#x27;Monthly&#x27;, &#x27;D&#x27;: &#x27;Daily&#x27;}"}, "mgplot.growth_plot.TWO_COLUMNS": {"fullname": "mgplot.growth_plot.TWO_COLUMNS", "modulename": "mgplot.growth_plot", "qualname": "TWO_COLUMNS", "kind": "variable", "doc": "<p></p>\n", "default_value": "2"}, "mgplot.growth_plot.GrowthKwargs": {"fullname": "mgplot.growth_plot.GrowthKwargs", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs", "kind": "class", "doc": "<p>Keyword arguments for the growth_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.growth_plot.GrowthKwargs.ax": {"fullname": "mgplot.growth_plot.GrowthKwargs.ax", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"fullname": "mgplot.growth_plot.GrowthKwargs.plot_from", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period]"}, "mgplot.growth_plot.GrowthKwargs.label_series": {"fullname": "mgplot.growth_plot.GrowthKwargs.label_series", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"fullname": "mgplot.growth_plot.GrowthKwargs.max_ticks", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.max_ticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.growth_plot.GrowthKwargs.line_width": {"fullname": "mgplot.growth_plot.GrowthKwargs.line_width", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.line_width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float]"}, "mgplot.growth_plot.GrowthKwargs.line_color": {"fullname": "mgplot.growth_plot.GrowthKwargs.line_color", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.line_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.growth_plot.GrowthKwargs.line_style": {"fullname": "mgplot.growth_plot.GrowthKwargs.line_style", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.line_style", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"fullname": "mgplot.growth_plot.GrowthKwargs.annotate_line", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.annotate_line", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"fullname": "mgplot.growth_plot.GrowthKwargs.line_rounding", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.line_rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | int]"}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"fullname": "mgplot.growth_plot.GrowthKwargs.line_fontsize", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.line_fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float | str]"}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"fullname": "mgplot.growth_plot.GrowthKwargs.line_fontname", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.line_fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"fullname": "mgplot.growth_plot.GrowthKwargs.line_anno_color", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.line_anno_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"fullname": "mgplot.growth_plot.GrowthKwargs.annotate_bars", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.annotate_bars", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"fullname": "mgplot.growth_plot.GrowthKwargs.bar_fontsize", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.bar_fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float | str]"}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"fullname": "mgplot.growth_plot.GrowthKwargs.bar_fontname", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.bar_fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"fullname": "mgplot.growth_plot.GrowthKwargs.bar_rounding", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.bar_rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"fullname": "mgplot.growth_plot.GrowthKwargs.bar_width", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.bar_width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float]"}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"fullname": "mgplot.growth_plot.GrowthKwargs.bar_color", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.bar_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"fullname": "mgplot.growth_plot.GrowthKwargs.bar_anno_color", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.bar_anno_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"fullname": "mgplot.growth_plot.GrowthKwargs.bar_rotation", "modulename": "mgplot.growth_plot", "qualname": "GrowthKwargs.bar_rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | float]"}, "mgplot.growth_plot.SeriesGrowthKwargs": {"fullname": "mgplot.growth_plot.SeriesGrowthKwargs", "modulename": "mgplot.growth_plot", "qualname": "SeriesGrowthKwargs", "kind": "class", "doc": "<p>Keyword arguments for the series_growth_plot function.</p>\n", "bases": "GrowthKwargs"}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"fullname": "mgplot.growth_plot.SeriesGrowthKwargs.ylabel", "modulename": "mgplot.growth_plot", "qualname": "SeriesGrowthKwargs.ylabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.growth_plot.common_transitions": {"fullname": "mgplot.growth_plot.common_transitions", "modulename": "mgplot.growth_plot", "qualname": "common_transitions", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, tuple[str, typing.Any]]", "default_value": "{&#x27;label_series&#x27;: (&#x27;label_series&#x27;, True), &#x27;ax&#x27;: (&#x27;ax&#x27;, None), &#x27;max_ticks&#x27;: (&#x27;max_ticks&#x27;, None), &#x27;plot_from&#x27;: (&#x27;plot_from&#x27;, None), &#x27;report_kwargs&#x27;: (&#x27;report_kwargs&#x27;, None)}"}, "mgplot.growth_plot.to_line_plot": {"fullname": "mgplot.growth_plot.to_line_plot", "modulename": "mgplot.growth_plot", "qualname": "to_line_plot", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, tuple[str, typing.Any]]", "default_value": "{&#x27;label_series&#x27;: (&#x27;label_series&#x27;, True), &#x27;ax&#x27;: (&#x27;ax&#x27;, None), &#x27;max_ticks&#x27;: (&#x27;max_ticks&#x27;, None), &#x27;plot_from&#x27;: (&#x27;plot_from&#x27;, None), &#x27;report_kwargs&#x27;: (&#x27;report_kwargs&#x27;, None), &#x27;line_width&#x27;: (&#x27;width&#x27;, None), &#x27;line_color&#x27;: (&#x27;color&#x27;, &#x27;darkblue&#x27;), &#x27;line_style&#x27;: (&#x27;style&#x27;, None), &#x27;annotate_line&#x27;: (&#x27;annotate&#x27;, True), &#x27;line_rounding&#x27;: (&#x27;rounding&#x27;, None), &#x27;line_fontsize&#x27;: (&#x27;fontsize&#x27;, None), &#x27;line_fontname&#x27;: (&#x27;fontname&#x27;, None), &#x27;line_anno_color&#x27;: (&#x27;annotate_color&#x27;, None)}"}, "mgplot.growth_plot.to_bar_plot": {"fullname": "mgplot.growth_plot.to_bar_plot", "modulename": "mgplot.growth_plot", "qualname": "to_bar_plot", "kind": "variable", "doc": "<p></p>\n", "annotation": ": dict[str, tuple[str, typing.Any]]", "default_value": "{&#x27;label_series&#x27;: (&#x27;label_series&#x27;, True), &#x27;ax&#x27;: (&#x27;ax&#x27;, None), &#x27;max_ticks&#x27;: (&#x27;max_ticks&#x27;, None), &#x27;plot_from&#x27;: (&#x27;plot_from&#x27;, None), &#x27;report_kwargs&#x27;: (&#x27;report_kwargs&#x27;, None), &#x27;bar_width&#x27;: (&#x27;width&#x27;, 0.8), &#x27;bar_color&#x27;: (&#x27;color&#x27;, &#x27;#dd0000&#x27;), &#x27;annotate_bars&#x27;: (&#x27;annotate&#x27;, True), &#x27;bar_rounding&#x27;: (&#x27;rounding&#x27;, None), &#x27;above&#x27;: (&#x27;above&#x27;, False), &#x27;bar_rotation&#x27;: (&#x27;rotation&#x27;, None), &#x27;bar_fontsize&#x27;: (&#x27;fontsize&#x27;, None), &#x27;bar_fontname&#x27;: (&#x27;fontname&#x27;, None), &#x27;bar_anno_color&#x27;: (&#x27;annotate_color&#x27;, None)}"}, "mgplot.growth_plot.calc_growth": {"fullname": "mgplot.growth_plot.calc_growth", "modulename": "mgplot.growth_plot", "qualname": "calc_growth", "kind": "function", "doc": "<p>Calculate annual and periodic growth for a pandas Series.</p>\n\n<p>Args:\n    series: Series - a pandas series with a date-like PeriodIndex.</p>\n\n<p>Returns:\n    DataFrame: A two column DataFrame with annual and periodic growth rates.</p>\n\n<p>Raises:\n    TypeError if the series is not a pandas Series.\n    TypeError if the series index is not a PeriodIndex.\n    ValueError if the series is empty.\n    ValueError if the series index does not have a frequency of Q, M, or D.\n    ValueError if the series index has duplicates.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">series</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "mgplot.growth_plot.growth_plot": {"fullname": "mgplot.growth_plot.growth_plot", "modulename": "mgplot.growth_plot", "qualname": "growth_plot", "kind": "function", "doc": "<p>Plot annual growth and periodic growth on the same axes.</p>\n\n<p>Args:\n    data: A pandas DataFrame with two columns:\n    kwargs: GrowthKwargs</p>\n\n<p>Returns:\n    axes: The matplotlib Axes object.</p>\n\n<p>Raises:\n    TypeError if the data is not a 2-column DataFrame.\n    TypeError if the annual index is not a PeriodIndex.\n    ValueError if the annual and periodic series do not have the same index.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">growth_plot</span><span class=\"o\">.</span><span class=\"n\">GrowthKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.growth_plot.series_growth_plot": {"fullname": "mgplot.growth_plot.series_growth_plot", "modulename": "mgplot.growth_plot", "qualname": "series_growth_plot", "kind": "function", "doc": "<p>Plot annual and periodic growth in percentage terms from a pandas Series.</p>\n\n<p>Args:\n    data: A pandas Series with an appropriate PeriodIndex.\n    kwargs: SeriesGrowthKwargs</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">growth_plot</span><span class=\"o\">.</span><span class=\"n\">SeriesGrowthKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.line_plot.ME": {"fullname": "mgplot.line_plot.ME", "modulename": "mgplot.line_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;line_plot&#x27;"}, "mgplot.line_plot.LineKwargs": {"fullname": "mgplot.line_plot.LineKwargs", "modulename": "mgplot.line_plot", "qualname": "LineKwargs", "kind": "class", "doc": "<p>Keyword arguments for the line_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.line_plot.LineKwargs.ax": {"fullname": "mgplot.line_plot.LineKwargs.ax", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.line_plot.LineKwargs.style": {"fullname": "mgplot.line_plot.LineKwargs.style", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.style", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.line_plot.LineKwargs.width": {"fullname": "mgplot.line_plot.LineKwargs.width", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.width", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | int | Sequence[float | int]]"}, "mgplot.line_plot.LineKwargs.color": {"fullname": "mgplot.line_plot.LineKwargs.color", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.line_plot.LineKwargs.alpha": {"fullname": "mgplot.line_plot.LineKwargs.alpha", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.alpha", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | Sequence[float]]"}, "mgplot.line_plot.LineKwargs.drawstyle": {"fullname": "mgplot.line_plot.LineKwargs.drawstyle", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.drawstyle", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str] | None]"}, "mgplot.line_plot.LineKwargs.marker": {"fullname": "mgplot.line_plot.LineKwargs.marker", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.marker", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str] | None]"}, "mgplot.line_plot.LineKwargs.markersize": {"fullname": "mgplot.line_plot.LineKwargs.markersize", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.markersize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | Sequence[float] | int | None]"}, "mgplot.line_plot.LineKwargs.dropna": {"fullname": "mgplot.line_plot.LineKwargs.dropna", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.dropna", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool]]"}, "mgplot.line_plot.LineKwargs.annotate": {"fullname": "mgplot.line_plot.LineKwargs.annotate", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.annotate", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool]]"}, "mgplot.line_plot.LineKwargs.rounding": {"fullname": "mgplot.line_plot.LineKwargs.rounding", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[Sequence[int | bool] | int | bool | None]"}, "mgplot.line_plot.LineKwargs.fontsize": {"fullname": "mgplot.line_plot.LineKwargs.fontsize", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[Sequence[str | int | float] | str | int | float]"}, "mgplot.line_plot.LineKwargs.fontname": {"fullname": "mgplot.line_plot.LineKwargs.fontname", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.line_plot.LineKwargs.rotation": {"fullname": "mgplot.line_plot.LineKwargs.rotation", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float | int | Sequence[float | int]]"}, "mgplot.line_plot.LineKwargs.annotate_color": {"fullname": "mgplot.line_plot.LineKwargs.annotate_color", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.annotate_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str] | bool | Sequence[bool] | None]"}, "mgplot.line_plot.LineKwargs.plot_from": {"fullname": "mgplot.line_plot.LineKwargs.plot_from", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period | None]"}, "mgplot.line_plot.LineKwargs.label_series": {"fullname": "mgplot.line_plot.LineKwargs.label_series", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.label_series", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool | Sequence[bool] | None]"}, "mgplot.line_plot.LineKwargs.max_ticks": {"fullname": "mgplot.line_plot.LineKwargs.max_ticks", "modulename": "mgplot.line_plot", "qualname": "LineKwargs.max_ticks", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int]"}, "mgplot.line_plot.AnnotateKwargs": {"fullname": "mgplot.line_plot.AnnotateKwargs", "modulename": "mgplot.line_plot", "qualname": "AnnotateKwargs", "kind": "class", "doc": "<p>Keyword arguments for the annotate_series function.</p>\n", "bases": "typing.TypedDict"}, "mgplot.line_plot.AnnotateKwargs.color": {"fullname": "mgplot.line_plot.AnnotateKwargs.color", "modulename": "mgplot.line_plot", "qualname": "AnnotateKwargs.color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "mgplot.line_plot.AnnotateKwargs.rounding": {"fullname": "mgplot.line_plot.AnnotateKwargs.rounding", "modulename": "mgplot.line_plot", "qualname": "AnnotateKwargs.rounding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int | bool"}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"fullname": "mgplot.line_plot.AnnotateKwargs.fontsize", "modulename": "mgplot.line_plot", "qualname": "AnnotateKwargs.fontsize", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str | int | float"}, "mgplot.line_plot.AnnotateKwargs.fontname": {"fullname": "mgplot.line_plot.AnnotateKwargs.fontname", "modulename": "mgplot.line_plot", "qualname": "AnnotateKwargs.fontname", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "mgplot.line_plot.AnnotateKwargs.rotation": {"fullname": "mgplot.line_plot.AnnotateKwargs.rotation", "modulename": "mgplot.line_plot", "qualname": "AnnotateKwargs.rotation", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int | float"}, "mgplot.line_plot.annotate_series": {"fullname": "mgplot.line_plot.annotate_series", "modulename": "mgplot.line_plot", "qualname": "annotate_series", "kind": "function", "doc": "<p>Annotate the right-hand end-point of a line-plotted series.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">series</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span>,</span><span class=\"param\">\t<span class=\"n\">axes</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">line_plot</span><span class=\"o\">.</span><span class=\"n\">AnnotateKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.line_plot.get_style_width_color_etc": {"fullname": "mgplot.line_plot.get_style_width_color_etc", "modulename": "mgplot.line_plot", "qualname": "get_style_width_color_etc", "kind": "function", "doc": "<p>Get the plot-line attributes arguemnts.</p>\n\n<p>Args:\n    item_count: Number of data series to plot (columns in DataFrame)\n    num_data_points: Number of data points in the series (rows in DataFrame)\n    kwargs: LineKwargs - other arguments</p>\n\n<p>Returns a tuple comprising:\n    - swce: dict[str, list | tuple] - style, width, color, etc. for each line\n    - kwargs_d: dict[str, Any] - the kwargs with defaults applied for the line plot</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">item_count</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">num_data_points</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">line_plot</span><span class=\"o\">.</span><span class=\"n\">LineKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">],</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "mgplot.line_plot.line_plot": {"fullname": "mgplot.line_plot.line_plot", "modulename": "mgplot.line_plot", "qualname": "line_plot", "kind": "function", "doc": "<p>Build a single or multi-line plot.</p>\n\n<p>Args:\n    data: DataFrame | Series - data to plot\n    kwargs: LineKwargs - keyword arguments for the line plot</p>\n\n<p>Returns:</p>\n\n<ul>\n<li>axes: Axes - the axes object for the plot</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">line_plot</span><span class=\"o\">.</span><span class=\"n\">LineKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.postcovid_plot.ME": {"fullname": "mgplot.postcovid_plot.ME", "modulename": "mgplot.postcovid_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;postcovid_plot&#x27;"}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"fullname": "mgplot.postcovid_plot.DEFAULT_PERIODS", "modulename": "mgplot.postcovid_plot", "qualname": "DEFAULT_PERIODS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;Q&#x27;: {&#x27;start&#x27;: &#x27;2014Q4&#x27;, &#x27;end&#x27;: &#x27;2019Q4&#x27;}, &#x27;M&#x27;: {&#x27;start&#x27;: &#x27;2015-01&#x27;, &#x27;end&#x27;: &#x27;2020-01&#x27;}, &#x27;D&#x27;: {&#x27;start&#x27;: &#x27;2015-01-01&#x27;, &#x27;end&#x27;: &#x27;2020-01-01&#x27;}}"}, "mgplot.postcovid_plot.PostcovidKwargs": {"fullname": "mgplot.postcovid_plot.PostcovidKwargs", "modulename": "mgplot.postcovid_plot", "qualname": "PostcovidKwargs", "kind": "class", "doc": "<p>Keyword arguments for the post-COVID plot.</p>\n", "bases": "mgplot.line_plot.LineKwargs"}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"fullname": "mgplot.postcovid_plot.PostcovidKwargs.start_r", "modulename": "mgplot.postcovid_plot", "qualname": "PostcovidKwargs.start_r", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[pandas._libs.tslibs.period.Period]"}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"fullname": "mgplot.postcovid_plot.PostcovidKwargs.end_r", "modulename": "mgplot.postcovid_plot", "qualname": "PostcovidKwargs.end_r", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[pandas._libs.tslibs.period.Period]"}, "mgplot.postcovid_plot.get_projection": {"fullname": "mgplot.postcovid_plot.get_projection", "modulename": "mgplot.postcovid_plot", "qualname": "get_projection", "kind": "function", "doc": "<p>Create a linear projection based on pre-COVID data.</p>\n\n<p>Assumes the start of the data has been trimmed to the period before COVID.</p>\n\n<p>Args:\n    original: Series - the original series with a PeriodIndex.\n    to_period: Period - the period to which the projection should extend.</p>\n\n<p>Returns:\n    Series: A pandas Series with linear projection values using the same index as original.</p>\n\n<p>Raises:\n    ValueError: If to_period is not within the original series index range.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">original</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span>,</span><span class=\"param\">\t<span class=\"n\">to_period</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">_libs</span><span class=\"o\">.</span><span class=\"n\">tslibs</span><span class=\"o\">.</span><span class=\"n\">period</span><span class=\"o\">.</span><span class=\"n\">Period</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span>:</span></span>", "funcdef": "def"}, "mgplot.postcovid_plot.postcovid_plot": {"fullname": "mgplot.postcovid_plot.postcovid_plot", "modulename": "mgplot.postcovid_plot", "qualname": "postcovid_plot", "kind": "function", "doc": "<p>Plot a series with a PeriodIndex, including a post-COVID projection.</p>\n\n<p>Args:\n    data: Series - the series to be plotted.\n    kwargs: PostcovidKwargs - plotting arguments.</p>\n\n<p>Raises:\n    TypeError if series is not a pandas Series\n    TypeError if series does not have a PeriodIndex\n    ValueError if series does not have a D, M or Q frequency\n    ValueError if regression start is after regression end</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">postcovid_plot</span><span class=\"o\">.</span><span class=\"n\">PostcovidKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.revision_plot.ME": {"fullname": "mgplot.revision_plot.ME", "modulename": "mgplot.revision_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;revision_plot&#x27;"}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"fullname": "mgplot.revision_plot.DEFAULT_PLOT_FROM", "modulename": "mgplot.revision_plot", "qualname": "DEFAULT_PLOT_FROM", "kind": "variable", "doc": "<p></p>\n", "default_value": "-15"}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"fullname": "mgplot.revision_plot.MIN_REVISION_COLUMNS", "modulename": "mgplot.revision_plot", "qualname": "MIN_REVISION_COLUMNS", "kind": "variable", "doc": "<p></p>\n", "default_value": "2"}, "mgplot.revision_plot.revision_plot": {"fullname": "mgplot.revision_plot.revision_plot", "modulename": "mgplot.revision_plot", "qualname": "revision_plot", "kind": "function", "doc": "<p>Plot the revisions to ABS data.</p>\n\n<p>Args:\n    data: DataFrame - the data to plot, with a column for each data revision.\n           Must have at least 2 columns to show meaningful revision comparisons.\n    kwargs: LineKwargs - additional keyword arguments for the line_plot function.</p>\n\n<p>Returns:\n    Axes: A matplotlib Axes object containing the revision plot.</p>\n\n<p>Raises:\n    TypeError: If data is not a DataFrame.\n    ValueError: If DataFrame has fewer than 2 columns for revision comparison.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">line_plot</span><span class=\"o\">.</span><span class=\"n\">LineKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.run_plot.ME": {"fullname": "mgplot.run_plot.ME", "modulename": "mgplot.run_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;run_plot&#x27;"}, "mgplot.run_plot.STROKE_LINEWIDTH": {"fullname": "mgplot.run_plot.STROKE_LINEWIDTH", "modulename": "mgplot.run_plot", "qualname": "STROKE_LINEWIDTH", "kind": "variable", "doc": "<p></p>\n", "default_value": "5"}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"fullname": "mgplot.run_plot.DEFAULT_THRESHOLD", "modulename": "mgplot.run_plot", "qualname": "DEFAULT_THRESHOLD", "kind": "variable", "doc": "<p></p>\n", "default_value": "0.1"}, "mgplot.run_plot.DEFAULT_ROUNDING": {"fullname": "mgplot.run_plot.DEFAULT_ROUNDING", "modulename": "mgplot.run_plot", "qualname": "DEFAULT_ROUNDING", "kind": "variable", "doc": "<p></p>\n", "default_value": "2"}, "mgplot.run_plot.UP_COLOR": {"fullname": "mgplot.run_plot.UP_COLOR", "modulename": "mgplot.run_plot", "qualname": "UP_COLOR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;gold&#x27;"}, "mgplot.run_plot.DOWN_COLOR": {"fullname": "mgplot.run_plot.DOWN_COLOR", "modulename": "mgplot.run_plot", "qualname": "DOWN_COLOR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;skyblue&#x27;"}, "mgplot.run_plot.UNKNOWN_COLOR": {"fullname": "mgplot.run_plot.UNKNOWN_COLOR", "modulename": "mgplot.run_plot", "qualname": "UNKNOWN_COLOR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;gray&#x27;"}, "mgplot.run_plot.LINE_COLOR": {"fullname": "mgplot.run_plot.LINE_COLOR", "modulename": "mgplot.run_plot", "qualname": "LINE_COLOR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;darkblue&#x27;"}, "mgplot.run_plot.RunKwargs": {"fullname": "mgplot.run_plot.RunKwargs", "modulename": "mgplot.run_plot", "qualname": "RunKwargs", "kind": "class", "doc": "<p>Keyword arguments for the run_plot function.</p>\n", "bases": "mgplot.line_plot.LineKwargs"}, "mgplot.run_plot.RunKwargs.threshold": {"fullname": "mgplot.run_plot.RunKwargs.threshold", "modulename": "mgplot.run_plot", "qualname": "RunKwargs.threshold", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float]"}, "mgplot.run_plot.RunKwargs.direction": {"fullname": "mgplot.run_plot.RunKwargs.direction", "modulename": "mgplot.run_plot", "qualname": "RunKwargs.direction", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.run_plot.RunKwargs.highlight_color": {"fullname": "mgplot.run_plot.RunKwargs.highlight_color", "modulename": "mgplot.run_plot", "qualname": "RunKwargs.highlight_color", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.run_plot.RunKwargs.highlight_label": {"fullname": "mgplot.run_plot.RunKwargs.highlight_label", "modulename": "mgplot.run_plot", "qualname": "RunKwargs.highlight_label", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | Sequence[str]]"}, "mgplot.run_plot.run_plot": {"fullname": "mgplot.run_plot.run_plot", "modulename": "mgplot.run_plot", "qualname": "run_plot", "kind": "function", "doc": "<p>Plot a series of percentage rates, highlighting the increasing runs.</p>\n\n<p>Arguments:\n    data: Series - ordered pandas Series of percentages, with PeriodIndex.\n    kwargs: RunKwargs - keyword arguments for the run_plot function.</p>\n\n<p>Return:</p>\n\n<ul>\n<li>matplotlib Axes object</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">run_plot</span><span class=\"o\">.</span><span class=\"n\">RunKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.seastrend_plot.ME": {"fullname": "mgplot.seastrend_plot.ME", "modulename": "mgplot.seastrend_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[str]", "default_value": "&#x27;seastrend_plot&#x27;"}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"fullname": "mgplot.seastrend_plot.REQUIRED_COLUMNS", "modulename": "mgplot.seastrend_plot", "qualname": "REQUIRED_COLUMNS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Final[int]", "default_value": "2"}, "mgplot.seastrend_plot.seastrend_plot": {"fullname": "mgplot.seastrend_plot.seastrend_plot", "modulename": "mgplot.seastrend_plot", "qualname": "seastrend_plot", "kind": "function", "doc": "<p>Produce a seasonal+trend plot.</p>\n\n<p>Arguments:\n    data: DataFrame - the data to plot. Must have exactly 2 columns:\n                      Seasonal data in column 0, Trend data in column 1\n    kwargs: LineKwargs - additional keyword arguments to pass to line_plot()</p>\n\n<p>Returns:\n    Axes: A matplotlib Axes object containing the seasonal+trend plot</p>\n\n<p>Raises:\n    ValueError: If the DataFrame does not have exactly 2 columns</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">line_plot</span><span class=\"o\">.</span><span class=\"n\">LineKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.ME": {"fullname": "mgplot.summary_plot.ME", "modulename": "mgplot.summary_plot", "qualname": "ME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;summary_plot&#x27;"}, "mgplot.summary_plot.ZSCORES": {"fullname": "mgplot.summary_plot.ZSCORES", "modulename": "mgplot.summary_plot", "qualname": "ZSCORES", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;zscores&#x27;"}, "mgplot.summary_plot.ZSCALED": {"fullname": "mgplot.summary_plot.ZSCALED", "modulename": "mgplot.summary_plot", "qualname": "ZSCALED", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;zscaled&#x27;"}, "mgplot.summary_plot.SPAN_LIMIT": {"fullname": "mgplot.summary_plot.SPAN_LIMIT", "modulename": "mgplot.summary_plot", "qualname": "SPAN_LIMIT", "kind": "variable", "doc": "<p></p>\n", "default_value": "1.15"}, "mgplot.summary_plot.SPACE_MARGIN": {"fullname": "mgplot.summary_plot.SPACE_MARGIN", "modulename": "mgplot.summary_plot", "qualname": "SPACE_MARGIN", "kind": "variable", "doc": "<p></p>\n", "default_value": "0.2"}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"fullname": "mgplot.summary_plot.DEFAULT_FONT_SIZE", "modulename": "mgplot.summary_plot", "qualname": "DEFAULT_FONT_SIZE", "kind": "variable", "doc": "<p></p>\n", "default_value": "10"}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"fullname": "mgplot.summary_plot.SMALL_FONT_SIZE", "modulename": "mgplot.summary_plot", "qualname": "SMALL_FONT_SIZE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;x-small&#x27;"}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"fullname": "mgplot.summary_plot.SMALL_MARKER_SIZE", "modulename": "mgplot.summary_plot", "qualname": "SMALL_MARKER_SIZE", "kind": "variable", "doc": "<p></p>\n", "default_value": "5"}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"fullname": "mgplot.summary_plot.REFERENCE_LINE_WIDTH", "modulename": "mgplot.summary_plot", "qualname": "REFERENCE_LINE_WIDTH", "kind": "variable", "doc": "<p></p>\n", "default_value": "0.5"}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"fullname": "mgplot.summary_plot.DEFAULT_MIDDLE", "modulename": "mgplot.summary_plot", "qualname": "DEFAULT_MIDDLE", "kind": "variable", "doc": "<p></p>\n", "default_value": "0.8"}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"fullname": "mgplot.summary_plot.DEFAULT_PLOT_FROM", "modulename": "mgplot.summary_plot", "qualname": "DEFAULT_PLOT_FROM", "kind": "variable", "doc": "<p></p>\n", "default_value": "0"}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"fullname": "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD", "modulename": "mgplot.summary_plot", "qualname": "HIGH_PRECISION_THRESHOLD", "kind": "variable", "doc": "<p></p>\n", "default_value": "1"}, "mgplot.summary_plot.SummaryKwargs": {"fullname": "mgplot.summary_plot.SummaryKwargs", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs", "kind": "class", "doc": "<p>Keyword arguments for the summary_plot function.</p>\n", "bases": "mgplot.keyword_checking.BaseKwargs"}, "mgplot.summary_plot.SummaryKwargs.ax": {"fullname": "mgplot.summary_plot.SummaryKwargs.ax", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs.ax", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[matplotlib.axes._axes.Axes | None]"}, "mgplot.summary_plot.SummaryKwargs.verbose": {"fullname": "mgplot.summary_plot.SummaryKwargs.verbose", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs.verbose", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[bool]"}, "mgplot.summary_plot.SummaryKwargs.middle": {"fullname": "mgplot.summary_plot.SummaryKwargs.middle", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs.middle", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[float]"}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"fullname": "mgplot.summary_plot.SummaryKwargs.plot_type", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs.plot_type", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str]"}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"fullname": "mgplot.summary_plot.SummaryKwargs.plot_from", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs.plot_from", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[int | pandas._libs.tslibs.period.Period]"}, "mgplot.summary_plot.SummaryKwargs.legend": {"fullname": "mgplot.summary_plot.SummaryKwargs.legend", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs.legend", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[dict[str, Any]]"}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"fullname": "mgplot.summary_plot.SummaryKwargs.xlabel", "modulename": "mgplot.summary_plot", "qualname": "SummaryKwargs.xlabel", "kind": "variable", "doc": "<p></p>\n", "annotation": ": NotRequired[str | None]"}, "mgplot.summary_plot.calc_quantiles": {"fullname": "mgplot.summary_plot.calc_quantiles", "modulename": "mgplot.summary_plot", "qualname": "calc_quantiles", "kind": "function", "doc": "<p>Calculate the quantiles for the middle of the data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">middle</span><span class=\"p\">:</span> <span class=\"nb\">float</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.calculate_z": {"fullname": "mgplot.summary_plot.calculate_z", "modulename": "mgplot.summary_plot", "qualname": "calculate_z", "kind": "function", "doc": "<p>Calculate z-scores, scaled z-scores and middle quantiles.</p>\n\n<p>Args:\n    original: DataFrame containing the original data.\n    middle: float, the proportion of data to highlight in the middle (eg. 0.8 for 80%).\n    verbose: bool, whether to print the summary data.</p>\n\n<p>Returns:\n    tuple[DataFrame, DataFrame]: z_scores and z_scaled DataFrames.</p>\n\n<p>Raises:\n    ValueError: If original DataFrame is empty or has zero variance.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">original</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">middle</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.plot_middle_bars": {"fullname": "mgplot.summary_plot.plot_middle_bars", "modulename": "mgplot.summary_plot", "qualname": "plot_middle_bars", "kind": "function", "doc": "<p>Plot the middle (typically 80%) of the data as a bar.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">adjusted</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">middle</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.plot_latest_datapoint": {"fullname": "mgplot.summary_plot.plot_latest_datapoint", "modulename": "mgplot.summary_plot", "qualname": "plot_latest_datapoint", "kind": "function", "doc": "<p>Add the latest datapoints to the summary plot.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ax</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">original</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">adjusted</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">font_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.label_extremes": {"fullname": "mgplot.summary_plot.label_extremes", "modulename": "mgplot.summary_plot", "qualname": "label_extremes", "kind": "function", "doc": "<p>Label the extremes in the scaled plots.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ax</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">,</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">plot_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">font_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.horizontal_bar_plot": {"fullname": "mgplot.summary_plot.horizontal_bar_plot", "modulename": "mgplot.summary_plot", "qualname": "horizontal_bar_plot", "kind": "function", "doc": "<p>Plot horizontal bars for the middle of the data.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">original</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">adjusted</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">middle</span><span class=\"p\">:</span> <span class=\"nb\">float</span>,</span><span class=\"param\">\t<span class=\"n\">plot_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.label_x_axis": {"fullname": "mgplot.summary_plot.label_x_axis", "modulename": "mgplot.summary_plot", "qualname": "label_x_axis", "kind": "function", "doc": "<p>Label the x-axis for the plot.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">plot_from</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">_libs</span><span class=\"o\">.</span><span class=\"n\">tslibs</span><span class=\"o\">.</span><span class=\"n\">period</span><span class=\"o\">.</span><span class=\"n\">Period</span>,</span><span class=\"param\">\t<span class=\"n\">label</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">plot_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">ax</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>,</span><span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.mark_reference_lines": {"fullname": "mgplot.summary_plot.mark_reference_lines", "modulename": "mgplot.summary_plot", "qualname": "mark_reference_lines", "kind": "function", "doc": "<p>Mark the reference lines for the plot.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">plot_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">ax</span><span class=\"p\">:</span> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.plot_the_data": {"fullname": "mgplot.summary_plot.plot_the_data", "modulename": "mgplot.summary_plot", "qualname": "plot_the_data", "kind": "function", "doc": "<p>Plot the data as a summary plot.</p>\n\n<p>Args:\n    df: DataFrame - the data to plot.\n    kwargs: SummaryKwargs, additional keyword arguments for the plot.</p>\n\n<p>Returns:\n    tuple[Axes, str]: A tuple comprising the Axes object and plot type ('zscores' or 'zscaled').</p>\n\n<p>Raises:\n    ValueError: If middle value is not between 0 and 1, or if plot_type is invalid.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">summary_plot</span><span class=\"o\">.</span><span class=\"n\">SummaryKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "mgplot.summary_plot.summary_plot": {"fullname": "mgplot.summary_plot.summary_plot", "modulename": "mgplot.summary_plot", "qualname": "summary_plot", "kind": "function", "doc": "<p>Plot a summary of historical data for a given DataFrame.</p>\n\n<p>Args:\n    data: DataFrame containing the summary data. The column names are\n          used as labels for the plot.\n    kwargs: Additional arguments for the plot, including middle (float),\n           plot_type (str), verbose (bool), and standard plotting options.</p>\n\n<p>Returns:\n    Axes: A matplotlib Axes object containing the summary plot.</p>\n\n<p>Raises:\n    TypeError: If data is not a DataFrame.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">DataT</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Unpack</span><span class=\"p\">[</span><span class=\"n\">mgplot</span><span class=\"o\">.</span><span class=\"n\">summary_plot</span><span class=\"o\">.</span><span class=\"n\">SummaryKwargs</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">matplotlib</span><span class=\"o\">.</span><span class=\"n\">axes</span><span class=\"o\">.</span><span class=\"n\">_axes</span><span class=\"o\">.</span><span class=\"n\">Axes</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"mgplot": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 59}, "mgplot.BarKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.BarKwargs.ax": {"qualname": 2, "fullname": 3, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.stacked": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.max_ticks": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.plot_from": {"qualname": 3, "fullname": 4, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.color": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.label_series": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.width": {"qualname": 2, "fullname": 3, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.annotate": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.fontsize": {"qualname": 2, "fullname": 3, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.fontname": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.rounding": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.rotation": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.annotate_color": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.BarKwargs.above": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.FinaliseKwargs.title": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.xlabel": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.ylabel": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.xlim": {"qualname": 2, "fullname": 3, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.ylim": {"qualname": 2, "fullname": 3, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.xticks": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.yticks": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.xscale": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.yscale": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.legend": {"qualname": 2, "fullname": 3, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.axhspan": {"qualname": 2, "fullname": 3, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.axvspan": {"qualname": 2, "fullname": 3, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.axhline": {"qualname": 2, "fullname": 3, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.axvline": {"qualname": 2, "fullname": 3, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.lfooter": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.rfooter": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.lheader": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.rheader": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.pre_tag": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.tag": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.chart_dir": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.file_type": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.dpi": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.figsize": {"qualname": 2, "fullname": 3, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.show": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.preserve_lims": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.remove_legend": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.zero_y": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.y0": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.x0": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.dont_save": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.FinaliseKwargs.dont_close": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.GrowthKwargs.ax": {"qualname": 2, "fullname": 3, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.plot_from": {"qualname": 3, "fullname": 4, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.label_series": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.max_ticks": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.line_width": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.line_color": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.line_style": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.annotate_line": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.line_rounding": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.line_fontsize": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.line_fontname": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.line_anno_color": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.annotate_bars": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.bar_fontsize": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.bar_fontname": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.bar_rounding": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.bar_width": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.bar_color": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.bar_anno_color": {"qualname": 4, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.GrowthKwargs.bar_rotation": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.LineKwargs.ax": {"qualname": 2, "fullname": 3, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.style": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.width": {"qualname": 2, "fullname": 3, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.color": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.alpha": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.drawstyle": {"qualname": 2, "fullname": 3, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.marker": {"qualname": 2, "fullname": 3, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.markersize": {"qualname": 2, "fullname": 3, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.dropna": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.annotate": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.rounding": {"qualname": 2, "fullname": 3, "annotation": 10, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.fontsize": {"qualname": 2, "fullname": 3, "annotation": 12, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.fontname": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.rotation": {"qualname": 2, "fullname": 3, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.annotate_color": {"qualname": 3, "fullname": 4, "annotation": 10, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.plot_from": {"qualname": 3, "fullname": 4, "annotation": 10, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.label_series": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.LineKwargs.max_ticks": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.PostcovidKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.PostcovidKwargs.start_r": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.PostcovidKwargs.end_r": {"qualname": 3, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.RunKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.RunKwargs.threshold": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.RunKwargs.direction": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.RunKwargs.highlight_color": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.RunKwargs.highlight_label": {"qualname": 3, "fullname": 4, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SeriesGrowthKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 11}, "mgplot.SeriesGrowthKwargs.ylabel": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SummaryKwargs": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.SummaryKwargs.ax": {"qualname": 2, "fullname": 3, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SummaryKwargs.verbose": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SummaryKwargs.middle": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SummaryKwargs.plot_type": {"qualname": 3, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SummaryKwargs.plot_from": {"qualname": 3, "fullname": 4, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SummaryKwargs.legend": {"qualname": 2, "fullname": 3, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.SummaryKwargs.xlabel": {"qualname": 2, "fullname": 3, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.abbreviate_state": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 29}, "mgplot.bar_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 53}, "mgplot.bar_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 28}, "mgplot.calc_growth": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 91}, "mgplot.clear_chart_dir": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 10, "bases": 0, "doc": 13}, "mgplot.colorise_list": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 13}, "mgplot.contrast": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 11}, "mgplot.finalise_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 13}, "mgplot.get_color": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 42}, "mgplot.get_party_palette": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 34}, "mgplot.get_setting": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 42}, "mgplot.growth_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 39}, "mgplot.growth_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 52}, "mgplot.line_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "mgplot.line_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 28}, "mgplot.multi_column": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 84}, "mgplot.multi_start": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 98}, "mgplot.plot_then_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 44}, "mgplot.postcovid_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "mgplot.postcovid_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 28}, "mgplot.revision_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "mgplot.revision_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 29}, "mgplot.run_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "mgplot.run_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 28}, "mgplot.seastrend_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "mgplot.seastrend_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 31}, "mgplot.series_growth_plot": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 28}, "mgplot.series_growth_plot_finalise": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 34}, "mgplot.set_chart_dir": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 67}, "mgplot.set_setting": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 52}, "mgplot.state_abbrs": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 26, "signature": 0, "bases": 0, "doc": 3}, "mgplot.state_names": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 33, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "mgplot.summary_plot_finalise": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 77}, "mgplot.bar_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 2, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.ADJUSTMENT_FACTOR": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.bar_plot.BarKwargs.ax": {"qualname": 2, "fullname": 5, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.stacked": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.max_ticks": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.plot_from": {"qualname": 3, "fullname": 6, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.color": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.label_series": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.width": {"qualname": 2, "fullname": 5, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.annotate": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.fontsize": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.fontname": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.rounding": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.rotation": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.annotate_color": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.BarKwargs.above": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "mgplot.bar_plot.AnnoKwargs.annotate": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs.fontname": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs.color": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs.rotation": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs.foreground": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs.above": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.AnnoKwargs.rounding": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.annotate_bars": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 120, "bases": 0, "doc": 21}, "mgplot.bar_plot.GroupedKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 10}, "mgplot.bar_plot.GroupedKwargs.color": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.GroupedKwargs.width": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.GroupedKwargs.label_series": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.grouped": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 115, "bases": 0, "doc": 8}, "mgplot.bar_plot.StackedKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 10}, "mgplot.bar_plot.StackedKwargs.color": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.StackedKwargs.width": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.StackedKwargs.label_series": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.bar_plot.stacked": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 115, "bases": 0, "doc": 8}, "mgplot.bar_plot.bar_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 94}, "mgplot.finalise_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 2, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"qualname": 4, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.finalise_plot.FinaliseKwargs.title": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"qualname": 2, "fullname": 5, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"qualname": 2, "fullname": 5, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"qualname": 2, "fullname": 5, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.show": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.VALUE_KWARGS": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 29, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.SPLAT_KWARGS": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 17, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 14, "signature": 0, "bases": 0, "doc": 3}, "mgplot.finalise_plot.sanitize_filename": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 35}, "mgplot.finalise_plot.make_legend": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 82, "bases": 0, "doc": 9}, "mgplot.finalise_plot.apply_value_kwargs": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 62}, "mgplot.finalise_plot.apply_splat_kwargs": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 12}, "mgplot.finalise_plot.apply_annotations": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 10}, "mgplot.finalise_plot.apply_late_kwargs": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 12}, "mgplot.finalise_plot.apply_kwargs": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 8}, "mgplot.finalise_plot.save_to_file": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 60, "bases": 0, "doc": 8}, "mgplot.finalise_plot.finalise_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 53}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 16, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.TWO_COLUMNS": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.growth_plot.GrowthKwargs.ax": {"qualname": 2, "fullname": 5, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"qualname": 3, "fullname": 6, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.label_series": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.line_width": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.line_color": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.line_style": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"qualname": 3, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"qualname": 4, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"qualname": 3, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"qualname": 4, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.SeriesGrowthKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 11}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.common_transitions": {"qualname": 2, "fullname": 5, "annotation": 5, "default_value": 50, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.to_line_plot": {"qualname": 3, "fullname": 6, "annotation": 5, "default_value": 126, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.to_bar_plot": {"qualname": 3, "fullname": 6, "annotation": 5, "default_value": 135, "signature": 0, "bases": 0, "doc": 3}, "mgplot.growth_plot.calc_growth": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 91}, "mgplot.growth_plot.growth_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 70}, "mgplot.growth_plot.series_growth_plot": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 28}, "mgplot.line_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 2, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.line_plot.LineKwargs.ax": {"qualname": 2, "fullname": 5, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.style": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.width": {"qualname": 2, "fullname": 5, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.color": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.alpha": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.drawstyle": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.marker": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.markersize": {"qualname": 2, "fullname": 5, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.dropna": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.annotate": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.rounding": {"qualname": 2, "fullname": 5, "annotation": 10, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.fontsize": {"qualname": 2, "fullname": 5, "annotation": 12, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.fontname": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.rotation": {"qualname": 2, "fullname": 5, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.annotate_color": {"qualname": 3, "fullname": 6, "annotation": 10, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.plot_from": {"qualname": 3, "fullname": 6, "annotation": 10, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.label_series": {"qualname": 3, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.LineKwargs.max_ticks": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.AnnotateKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 10}, "mgplot.line_plot.AnnotateKwargs.color": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.AnnotateKwargs.rounding": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.AnnotateKwargs.fontname": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.AnnotateKwargs.rotation": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.line_plot.annotate_series": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 92, "bases": 0, "doc": 14}, "mgplot.line_plot.get_style_width_color_etc": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 107, "bases": 0, "doc": 71}, "mgplot.line_plot.line_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 45}, "mgplot.postcovid_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 67, "signature": 0, "bases": 0, "doc": 3}, "mgplot.postcovid_plot.PostcovidKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"qualname": 3, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"qualname": 3, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.postcovid_plot.get_projection": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 83, "bases": 0, "doc": 86}, "mgplot.postcovid_plot.postcovid_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 68}, "mgplot.revision_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.revision_plot.revision_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 82}, "mgplot.run_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.STROKE_LINEWIDTH": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.DEFAULT_ROUNDING": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.UP_COLOR": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.DOWN_COLOR": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.UNKNOWN_COLOR": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.LINE_COLOR": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.RunKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.run_plot.RunKwargs.threshold": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.RunKwargs.direction": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.RunKwargs.highlight_color": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.RunKwargs.highlight_label": {"qualname": 3, "fullname": 6, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.run_plot.run_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 47}, "mgplot.seastrend_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 2, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.seastrend_plot.seastrend_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 67}, "mgplot.summary_plot.ME": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.ZSCORES": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.ZSCALED": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SPAN_LIMIT": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SPACE_MARGIN": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SummaryKwargs": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 10}, "mgplot.summary_plot.SummaryKwargs.ax": {"qualname": 2, "fullname": 5, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SummaryKwargs.verbose": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SummaryKwargs.middle": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"qualname": 3, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"qualname": 3, "fullname": 6, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SummaryKwargs.legend": {"qualname": 2, "fullname": 5, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"qualname": 2, "fullname": 5, "annotation": 4, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mgplot.summary_plot.calc_quantiles": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 12}, "mgplot.summary_plot.calculate_z": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 112, "bases": 0, "doc": 72}, "mgplot.summary_plot.plot_middle_bars": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 14}, "mgplot.summary_plot.plot_latest_datapoint": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 106, "bases": 0, "doc": 11}, "mgplot.summary_plot.label_extremes": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 147, "bases": 0, "doc": 10}, "mgplot.summary_plot.horizontal_bar_plot": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 128, "bases": 0, "doc": 12}, "mgplot.summary_plot.label_x_axis": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 130, "bases": 0, "doc": 10}, "mgplot.summary_plot.mark_reference_lines": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 10}, "mgplot.summary_plot.plot_the_data": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 93, "bases": 0, "doc": 66}, "mgplot.summary_plot.summary_plot": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 75}}, "length": 360, "save": true}, "index": {"qualname": {"root": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 22, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.BarKwargs.ax": {"tf": 1}, "mgplot.BarKwargs.stacked": {"tf": 1}, "mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.BarKwargs.color": {"tf": 1}, "mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.BarKwargs.width": {"tf": 1}, "mgplot.BarKwargs.annotate": {"tf": 1}, "mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.BarKwargs.fontname": {"tf": 1}, "mgplot.BarKwargs.rounding": {"tf": 1}, "mgplot.BarKwargs.rotation": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}}, "df": 30}}}}}}, "s": {"docs": {"mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.BarKwargs.ax": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.ax": {"tf": 1}, "mgplot.SummaryKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}}, "df": 8, "h": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.annotate": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.LineKwargs.annotate": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 15, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}}, "df": 6}}}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}}, "df": 2}}}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}}, "df": 9}}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}}, "df": 3}}}, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}}, "df": 2}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}}, "df": 5}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}}, "df": 3, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}}, "df": 4}}}}}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 1}, "mgplot.state_abbrs": {"tf": 1}, "mgplot.state_names": {"tf": 1}}, "df": 3}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.LineKwargs.style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 5}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 12, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}, "t": {"docs": {"mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.get_setting": {"tf": 1}, "mgplot.set_setting": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 3}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"mgplot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 3, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.SummaryKwargs": {"tf": 1}, "mgplot.SummaryKwargs.ax": {"tf": 1}, "mgplot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.SummaryKwargs.middle": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}}, "df": 16}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}}, "df": 3}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}}, "df": 10}, "r": {"docs": {}, "df": 0, "k": {"docs": {"mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}}, "df": 2}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}}, "df": 2}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.make_legend": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}}, "df": 4}}}}, "n": {"docs": {"mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {"mgplot.bar_plot.ME": {"tf": 1}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.postcovid_plot.ME": {"tf": 1}, "mgplot.revision_plot.ME": {"tf": 1}, "mgplot.run_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.ME": {"tf": 1}, "mgplot.summary_plot.ME": {"tf": 1}}, "df": 8}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}}, "df": 7}}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}}, "df": 3}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}}, "df": 4}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}}, "df": 4}}}, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}}, "df": 4}}}}}}}, "e": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1, "n": {"docs": {"mgplot.plot_then_finalise": {"tf": 1}}, "df": 1}}}, "o": {"docs": {"mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 5}, "w": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1}}, "df": 1}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 48}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 3, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {"mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}}, "df": 10}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}}, "df": 11}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.LineKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}}, "df": 10}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 12, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.FinaliseKwargs.title": {"tf": 1}, "mgplot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.FinaliseKwargs.show": {"tf": 1}, "mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}}, "df": 66}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}}, "df": 4, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.BarKwargs.color": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.LineKwargs.color": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.run_plot.UP_COLOR": {"tf": 1}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}}, "df": 30, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.colorise_list": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.multi_column": {"tf": 1}}, "df": 1, "s": {"docs": {"mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.contrast": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 12}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}}, "df": 7}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}}, "df": 2}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}}, "df": 24, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.LineKwargs": {"tf": 1}, "mgplot.LineKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.style": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1}, "mgplot.LineKwargs.color": {"tf": 1}, "mgplot.LineKwargs.alpha": {"tf": 1}, "mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.LineKwargs.dropna": {"tf": 1}, "mgplot.LineKwargs.annotate": {"tf": 1}, "mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1}, "mgplot.LineKwargs.fontname": {"tf": 1}, "mgplot.LineKwargs.rotation": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}}, "df": 38}}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.colorise_list": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.BarKwargs.width": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}}, "df": 16}}}}}, "r": {"docs": {"mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}}, "df": 4, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.BarKwargs.rounding": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}}, "df": 11}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.BarKwargs.rotation": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.LineKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}}, "df": 8}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}}, "df": 2}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 4}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 3, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.RunKwargs": {"tf": 1}, "mgplot.RunKwargs.threshold": {"tf": 1}, "mgplot.RunKwargs.direction": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}}, "df": 10}}}}}}}}}, "x": {"0": {"docs": {"mgplot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}}, "df": 2}, "docs": {"mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}}, "df": 2}}}}}}, "y": {"0": {"docs": {"mgplot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}}, "df": 2}, "docs": {"mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {"mgplot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}}, "df": 4}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot.DOWN_COLOR": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}}, "df": 12}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}}, "df": 1}}}}}}}}}, "z": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}}, "df": 5}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.ZSCORES": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot.ZSCALED": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 8, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.GrowthKwargs": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}}, "df": 42}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}}, "df": 2, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "c": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}}, "df": 4}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}}, "df": 2, "s": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}}, "df": 7}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {"mgplot.run_plot.UP_COLOR": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}}, "df": 1}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.calc_quantiles": {"tf": 1}}, "df": 1}}}}}}}}}}}, "fullname": {"root": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot": {"tf": 1}, "mgplot.BarKwargs": {"tf": 1}, "mgplot.BarKwargs.ax": {"tf": 1}, "mgplot.BarKwargs.stacked": {"tf": 1}, "mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.BarKwargs.color": {"tf": 1}, "mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.BarKwargs.width": {"tf": 1}, "mgplot.BarKwargs.annotate": {"tf": 1}, "mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.BarKwargs.fontname": {"tf": 1}, "mgplot.BarKwargs.rounding": {"tf": 1}, "mgplot.BarKwargs.rotation": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.BarKwargs.above": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.FinaliseKwargs.title": {"tf": 1}, "mgplot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.FinaliseKwargs.show": {"tf": 1}, "mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.LineKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.style": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1}, "mgplot.LineKwargs.color": {"tf": 1}, "mgplot.LineKwargs.alpha": {"tf": 1}, "mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.LineKwargs.dropna": {"tf": 1}, "mgplot.LineKwargs.annotate": {"tf": 1}, "mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1}, "mgplot.LineKwargs.fontname": {"tf": 1}, "mgplot.LineKwargs.rotation": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.RunKwargs.threshold": {"tf": 1}, "mgplot.RunKwargs.direction": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.SummaryKwargs.ax": {"tf": 1}, "mgplot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.SummaryKwargs.middle": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.abbreviate_state": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.calc_growth": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.colorise_list": {"tf": 1}, "mgplot.contrast": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.state_abbrs": {"tf": 1}, "mgplot.state_names": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.ME": {"tf": 1}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.ME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.ME": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.ME": {"tf": 1}, "mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}, "mgplot.run_plot.UP_COLOR": {"tf": 1}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.ME": {"tf": 1}, "mgplot.summary_plot.ZSCORES": {"tf": 1}, "mgplot.summary_plot.ZSCALED": {"tf": 1}, "mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 360}}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}}, "df": 10}, "r": {"docs": {}, "df": 0, "k": {"docs": {"mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}}, "df": 2}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}}, "df": 2}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.make_legend": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}}, "df": 4}}}}, "n": {"docs": {"mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {"mgplot.bar_plot.ME": {"tf": 1}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.postcovid_plot.ME": {"tf": 1}, "mgplot.revision_plot.ME": {"tf": 1}, "mgplot.run_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.ME": {"tf": 1}, "mgplot.summary_plot.ME": {"tf": 1}}, "df": 8}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.bar_plot.ME": {"tf": 1}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1.4142135623730951}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1.4142135623730951}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1.4142135623730951}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 62, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.BarKwargs.ax": {"tf": 1}, "mgplot.BarKwargs.stacked": {"tf": 1}, "mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.BarKwargs.color": {"tf": 1}, "mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.BarKwargs.width": {"tf": 1}, "mgplot.BarKwargs.annotate": {"tf": 1}, "mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.BarKwargs.fontname": {"tf": 1}, "mgplot.BarKwargs.rounding": {"tf": 1}, "mgplot.BarKwargs.rotation": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}}, "df": 30}}}}}}, "s": {"docs": {"mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.BarKwargs.ax": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.ax": {"tf": 1}, "mgplot.SummaryKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}}, "df": 8, "h": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.annotate": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.LineKwargs.annotate": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 15, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}}, "df": 6}}}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}}, "df": 2}}}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}}, "df": 9}}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}}, "df": 3}}}, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}}, "df": 2}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}}, "df": 5}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}}, "df": 3, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}}, "df": 4}}}}}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 1}, "mgplot.state_abbrs": {"tf": 1}, "mgplot.state_names": {"tf": 1}}, "df": 3}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.LineKwargs.style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 5}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 12, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}, "t": {"docs": {"mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.get_setting": {"tf": 1}, "mgplot.set_setting": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}}, "df": 5}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"mgplot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.summary_plot.ME": {"tf": 1}, "mgplot.summary_plot.ZSCORES": {"tf": 1}, "mgplot.summary_plot.ZSCALED": {"tf": 1}, "mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1.4142135623730951}}, "df": 32, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.SummaryKwargs": {"tf": 1}, "mgplot.SummaryKwargs.ax": {"tf": 1}, "mgplot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.SummaryKwargs.middle": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}}, "df": 16}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}}, "df": 3}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}}, "df": 7}}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}}, "df": 3}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}}, "df": 4}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}}, "df": 4}}}, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}}, "df": 4}}}}}}}, "e": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1, "n": {"docs": {"mgplot.plot_then_finalise": {"tf": 1}}, "df": 1}}}, "o": {"docs": {"mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 5}, "w": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1}}, "df": 1}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.ME": {"tf": 1}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.series_growth_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.ME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot.ME": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1.4142135623730951}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.run_plot.ME": {"tf": 1}, "mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}, "mgplot.run_plot.UP_COLOR": {"tf": 1}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.ME": {"tf": 1}, "mgplot.summary_plot.ZSCORES": {"tf": 1}, "mgplot.summary_plot.ZSCALED": {"tf": 1}, "mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1.4142135623730951}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 1.4142135623730951}}, "df": 244}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot.ME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}}, "df": 9, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {"mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}}, "df": 10}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}}, "df": 11}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.LineKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}}, "df": 10}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1.4142135623730951}}, "df": 67, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.FinaliseKwargs.title": {"tf": 1}, "mgplot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.FinaliseKwargs.show": {"tf": 1}, "mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}}, "df": 66}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}}, "df": 4, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.BarKwargs.color": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.LineKwargs.color": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.run_plot.UP_COLOR": {"tf": 1}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}}, "df": 30, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.colorise_list": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.multi_column": {"tf": 1}}, "df": 1, "s": {"docs": {"mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.contrast": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 12}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}}, "df": 7}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}}, "df": 2}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1.4142135623730951}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}}, "df": 52, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.LineKwargs": {"tf": 1}, "mgplot.LineKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.style": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1}, "mgplot.LineKwargs.color": {"tf": 1}, "mgplot.LineKwargs.alpha": {"tf": 1}, "mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.LineKwargs.dropna": {"tf": 1}, "mgplot.LineKwargs.annotate": {"tf": 1}, "mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1}, "mgplot.LineKwargs.fontname": {"tf": 1}, "mgplot.LineKwargs.rotation": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}}, "df": 38}}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.colorise_list": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.BarKwargs.width": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}}, "df": 16}}}}}, "r": {"docs": {"mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}}, "df": 4, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.BarKwargs.rounding": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}}, "df": 11}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.BarKwargs.rotation": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.LineKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}}, "df": 8}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}}, "df": 2}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.revision_plot.ME": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1.4142135623730951}, "mgplot.revision_plot.revision_plot": {"tf": 1.4142135623730951}}, "df": 6}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.run_plot.ME": {"tf": 1}, "mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}, "mgplot.run_plot.UP_COLOR": {"tf": 1}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1.4142135623730951}}, "df": 16, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.RunKwargs": {"tf": 1}, "mgplot.RunKwargs.threshold": {"tf": 1}, "mgplot.RunKwargs.direction": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}}, "df": 10}}}}}}}}}, "x": {"0": {"docs": {"mgplot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}}, "df": 2}, "docs": {"mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}}, "df": 2}}}}}}, "y": {"0": {"docs": {"mgplot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}}, "df": 2}, "docs": {"mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {"mgplot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}}, "df": 4}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot.DOWN_COLOR": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}}, "df": 12}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}}, "df": 1}}}}}}}}}, "z": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}}, "df": 5}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.ZSCORES": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot.ZSCALED": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.series_growth_plot": {"tf": 1.4142135623730951}}, "df": 37, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.GrowthKwargs": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}}, "df": 42}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}}, "df": 2, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "c": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}}, "df": 4}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}}, "df": 2, "s": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}}, "df": 7}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {"mgplot.run_plot.UP_COLOR": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}}, "df": 1}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.calc_quantiles": {"tf": 1}}, "df": 1}}}}}}}}}}}, "annotation": {"root": {"docs": {"mgplot.BarKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.BarKwargs.stacked": {"tf": 1}, "mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.BarKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.BarKwargs.color": {"tf": 1.4142135623730951}, "mgplot.BarKwargs.label_series": {"tf": 1.4142135623730951}, "mgplot.BarKwargs.width": {"tf": 2}, "mgplot.BarKwargs.annotate": {"tf": 1}, "mgplot.BarKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.fontname": {"tf": 1}, "mgplot.BarKwargs.rounding": {"tf": 1}, "mgplot.BarKwargs.rotation": {"tf": 1.4142135623730951}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.BarKwargs.above": {"tf": 1}, "mgplot.FinaliseKwargs.title": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.xlabel": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.ylabel": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.xlim": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.ylim": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.xticks": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.yticks": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.xscale": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.yscale": {"tf": 1.4142135623730951}, "mgplot.FinaliseKwargs.legend": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.FinaliseKwargs.show": {"tf": 1}, "mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.GrowthKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1.4142135623730951}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1.4142135623730951}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.style": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.width": {"tf": 2}, "mgplot.LineKwargs.color": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.alpha": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.drawstyle": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.marker": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.markersize": {"tf": 2}, "mgplot.LineKwargs.dropna": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.annotate": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.rounding": {"tf": 2.23606797749979}, "mgplot.LineKwargs.fontsize": {"tf": 2.449489742783178}, "mgplot.LineKwargs.fontname": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.rotation": {"tf": 2}, "mgplot.LineKwargs.annotate_color": {"tf": 2.23606797749979}, "mgplot.LineKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.RunKwargs.threshold": {"tf": 1}, "mgplot.RunKwargs.direction": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1.4142135623730951}, "mgplot.RunKwargs.highlight_label": {"tf": 1.4142135623730951}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1.4142135623730951}, "mgplot.SummaryKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.SummaryKwargs.middle": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1.4142135623730951}, "mgplot.bar_plot.ME": {"tf": 1}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.width": {"tf": 2}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1.4142135623730951}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1.4142135623730951}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1.4142135623730951}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1.4142135623730951}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1.4142135623730951}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1.4142135623730951}, "mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.style": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.width": {"tf": 2}, "mgplot.line_plot.LineKwargs.color": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 2}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 2.23606797749979}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 2.449489742783178}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 2}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 2.23606797749979}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1.4142135623730951}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1.4142135623730951}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1.4142135623730951}}, "df": 240, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"mgplot.BarKwargs.ax": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.ax": {"tf": 1}, "mgplot.SummaryKwargs.ax": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}}, "df": 8}}}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.BarKwargs.stacked": {"tf": 1}, "mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.BarKwargs.annotate": {"tf": 1}, "mgplot.BarKwargs.above": {"tf": 1}, "mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.FinaliseKwargs.show": {"tf": 1}, "mgplot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.LineKwargs.dropna": {"tf": 1}, "mgplot.LineKwargs.annotate": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.SummaryKwargs.verbose": {"tf": 1}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1}}, "df": 42}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.BarKwargs.rounding": {"tf": 1}, "mgplot.BarKwargs.rotation": {"tf": 1}, "mgplot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}}, "df": 32}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.BarKwargs.color": {"tf": 1}, "mgplot.BarKwargs.fontname": {"tf": 1}, "mgplot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.FinaliseKwargs.title": {"tf": 1}, "mgplot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.LineKwargs.style": {"tf": 1}, "mgplot.LineKwargs.color": {"tf": 1}, "mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.LineKwargs.fontname": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.RunKwargs.direction": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}}, "df": 70}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs.width": {"tf": 1}, "mgplot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1}, "mgplot.LineKwargs.alpha": {"tf": 1}, "mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.LineKwargs.rotation": {"tf": 1}, "mgplot.RunKwargs.threshold": {"tf": 1}, "mgplot.SummaryKwargs.middle": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1}}, "df": 16}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}}, "df": 6}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}}, "df": 4}}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}}, "df": 10}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.BarKwargs.ax": {"tf": 1}, "mgplot.FinaliseKwargs.title": {"tf": 1}, "mgplot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.GrowthKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.ax": {"tf": 1}, "mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.SummaryKwargs.ax": {"tf": 1}, "mgplot.SummaryKwargs.xlabel": {"tf": 1}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1}}, "df": 46}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1.7320508075688772}}, "df": 8}}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.SummaryKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1}, "mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1}}, "df": 15}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}}, "df": 8}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.GrowthKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.PostcovidKwargs.start_r": {"tf": 1.4142135623730951}, "mgplot.PostcovidKwargs.end_r": {"tf": 1.4142135623730951}, "mgplot.SummaryKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1.4142135623730951}}, "df": 12}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}}, "df": 12}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs.plot_from": {"tf": 1}, "mgplot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.LineKwargs.plot_from": {"tf": 1}, "mgplot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.SummaryKwargs.plot_from": {"tf": 1}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1}}, "df": 12}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 3}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.BarKwargs.color": {"tf": 1}, "mgplot.LineKwargs.style": {"tf": 1}, "mgplot.LineKwargs.color": {"tf": 1}, "mgplot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.LineKwargs.marker": {"tf": 1}, "mgplot.LineKwargs.fontname": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.RunKwargs.highlight_label": {"tf": 1}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.style": {"tf": 1}, "mgplot.line_plot.LineKwargs.color": {"tf": 1}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1}}, "df": 20}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.BarKwargs.label_series": {"tf": 1}, "mgplot.LineKwargs.dropna": {"tf": 1}, "mgplot.LineKwargs.annotate": {"tf": 1}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.LineKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1}}, "df": 12}}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs.width": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1}, "mgplot.LineKwargs.alpha": {"tf": 1}, "mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.LineKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1}}, "df": 12}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1}}, "df": 15}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs.width": {"tf": 1.4142135623730951}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.LineKwargs.width": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.markersize": {"tf": 1}, "mgplot.LineKwargs.rounding": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.rotation": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1.4142135623730951}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.width": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1.4142135623730951}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}}, "df": 22}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs.fontsize": {"tf": 1}, "mgplot.BarKwargs.rotation": {"tf": 1}, "mgplot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.LineKwargs.fontsize": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1.4142135623730951}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1}}, "df": 24}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.bar_plot.ME": {"tf": 1}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.ME": {"tf": 1}}, "df": 8}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}}, "df": 5}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}}, "df": 9}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1}, "mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 5}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.LineKwargs.rounding": {"tf": 1.4142135623730951}, "mgplot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1.4142135623730951}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1}}, "df": 8}}}}}}, "default_value": {"root": {"0": {"1": {"docs": {"mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 2.449489742783178}}, "df": 1}, "2": {"docs": {"mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}}, "df": 3}, "docs": {"mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1.4142135623730951}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1}}, "df": 14}, "1": {"0": {"docs": {"mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1}}, "df": 2}, "2": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}}, "df": 1}, "5": {"0": {"docs": {"mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1}}, "df": 1}, "docs": {"mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}}, "df": 2}, "docs": {"mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1.4142135623730951}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1}, "mgplot.summary_plot.SPAN_LIMIT": {"tf": 1}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1}}, "df": 5}, "2": {"0": {"1": {"4": {"docs": {}, "df": 0, "q": {"4": {"docs": {"mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "5": {"docs": {"mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1.4142135623730951}}, "df": 1}, "9": {"docs": {}, "df": 0, "q": {"4": {"docs": {"mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "2": {"0": {"docs": {"mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"mgplot.growth_plot.TWO_COLUMNS": {"tf": 1}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1}}, "df": 5}, "3": {"0": {"docs": {"mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1}}, "df": 1}, "6": {"5": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "4": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}}, "df": 1}, "5": {"5": {"5": {"5": {"5": {"5": {"docs": {"mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1}, "mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1}}, "df": 4}, "6": {"6": {"docs": {"mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "8": {"docs": {"mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1}}, "df": 4}, "9": {"9": {"9": {"9": {"9": {"9": {"docs": {"mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"mgplot.state_abbrs": {"tf": 1.4142135623730951}, "mgplot.state_names": {"tf": 1.4142135623730951}, "mgplot.bar_plot.ME": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.ME": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1.4142135623730951}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 2}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 2.23606797749979}, "mgplot.growth_plot.common_transitions": {"tf": 2.6457513110645907}, "mgplot.growth_plot.to_line_plot": {"tf": 3.872983346207417}, "mgplot.growth_plot.to_bar_plot": {"tf": 4}, "mgplot.line_plot.ME": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.ME": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 4}, "mgplot.revision_plot.ME": {"tf": 1.4142135623730951}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1}, "mgplot.run_plot.ME": {"tf": 1.4142135623730951}, "mgplot.run_plot.UP_COLOR": {"tf": 1.4142135623730951}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1.4142135623730951}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1.4142135623730951}, "mgplot.run_plot.LINE_COLOR": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.ME": {"tf": 1.4142135623730951}, "mgplot.summary_plot.ME": {"tf": 1.4142135623730951}, "mgplot.summary_plot.ZSCORES": {"tf": 1.4142135623730951}, "mgplot.summary_plot.ZSCALED": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1.4142135623730951}}, "df": 31, "x": {"2": {"7": {"docs": {"mgplot.state_abbrs": {"tf": 4}, "mgplot.state_names": {"tf": 4}, "mgplot.bar_plot.ME": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.ME": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.VALUE_KWARGS": {"tf": 4.242640687119285}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 3.1622776601683795}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 2.8284271247461903}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 2.449489742783178}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 3.4641016151377544}, "mgplot.growth_plot.common_transitions": {"tf": 4.47213595499958}, "mgplot.growth_plot.to_line_plot": {"tf": 7.3484692283495345}, "mgplot.growth_plot.to_bar_plot": {"tf": 7.615773105863909}, "mgplot.line_plot.ME": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.ME": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 5.477225575051661}, "mgplot.revision_plot.ME": {"tf": 1.4142135623730951}, "mgplot.run_plot.ME": {"tf": 1.4142135623730951}, "mgplot.run_plot.UP_COLOR": {"tf": 1.4142135623730951}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1.4142135623730951}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1.4142135623730951}, "mgplot.run_plot.LINE_COLOR": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.ME": {"tf": 1.4142135623730951}, "mgplot.summary_plot.ME": {"tf": 1.4142135623730951}, "mgplot.summary_plot.ZSCORES": {"tf": 1.4142135623730951}, "mgplot.summary_plot.ZSCALED": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1.4142135623730951}}, "df": 30}, "docs": {}, "df": 0}, "docs": {"mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "w": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1}}, "t": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "w": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 2}, "mgplot.growth_plot.to_line_plot": {"tf": 3.1622776601683795}, "mgplot.growth_plot.to_bar_plot": {"tf": 3}}, "df": 3}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}}}}, "q": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.state_names": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.seastrend_plot.ME": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1.7320508075688772}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.run_plot.DOWN_COLOR": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.summary_plot.ME": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.state_names": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.state_abbrs": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.state_names": {"tf": 1.4142135623730951}}, "df": 1, "n": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}}}}}, "x": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3, "h": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.7320508075688772}}, "df": 2}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.state_names": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 2}, "mgplot.growth_plot.to_bar_plot": {"tf": 2}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.bar_plot.ME": {"tf": 1}, "mgplot.growth_plot.to_bar_plot": {"tf": 2.6457513110645907}}, "df": 2, "s": {"docs": {"mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.ME": {"tf": 1}, "mgplot.finalise_plot.ME": {"tf": 1}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1}, "mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot.ME": {"tf": 1}, "mgplot.postcovid_plot.ME": {"tf": 1}, "mgplot.revision_plot.ME": {"tf": 1}, "mgplot.run_plot.ME": {"tf": 1}, "mgplot.seastrend_plot.ME": {"tf": 1}, "mgplot.summary_plot.ME": {"tf": 1}}, "df": 12}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot.ME": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.ME": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 2.8284271247461903}, "mgplot.line_plot.ME": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.revision_plot.ME": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot.ME": {"tf": 1}}, "df": 1}}}, "m": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}, "d": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot.to_line_plot": {"tf": 1}, "mgplot.run_plot.LINE_COLOR": {"tf": 1}}, "df": 2}}}}}}}, "d": {"0": {"0": {"0": {"0": {"docs": {"mgplot.growth_plot.to_bar_plot": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot.common_transitions": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_line_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.4142135623730951}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1.7320508075688772}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.run_plot.UP_COLOR": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1}}, "df": 1}}}}, "z": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.ZSCORES": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot.ZSCALED": {"tf": 1}}, "df": 1}}}}}}}}}, "signature": {"root": {"1": {"5": {"0": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"mgplot.abbreviate_state": {"tf": 4}, "mgplot.bar_plot": {"tf": 7.483314773547883}, "mgplot.bar_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.calc_growth": {"tf": 6.324555320336759}, "mgplot.clear_chart_dir": {"tf": 3}, "mgplot.colorise_list": {"tf": 5.0990195135927845}, "mgplot.contrast": {"tf": 4}, "mgplot.finalise_plot": {"tf": 7.3484692283495345}, "mgplot.get_color": {"tf": 4}, "mgplot.get_party_palette": {"tf": 4}, "mgplot.get_setting": {"tf": 4}, "mgplot.growth_plot": {"tf": 7.483314773547883}, "mgplot.growth_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.line_plot": {"tf": 7.483314773547883}, "mgplot.line_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.multi_column": {"tf": 7.681145747868608}, "mgplot.multi_start": {"tf": 9.486832980505138}, "mgplot.plot_then_finalise": {"tf": 6.782329983125268}, "mgplot.postcovid_plot": {"tf": 7.483314773547883}, "mgplot.postcovid_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.revision_plot": {"tf": 7.483314773547883}, "mgplot.revision_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.run_plot": {"tf": 7.483314773547883}, "mgplot.run_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.seastrend_plot": {"tf": 7.483314773547883}, "mgplot.seastrend_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.series_growth_plot": {"tf": 7.483314773547883}, "mgplot.series_growth_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.set_chart_dir": {"tf": 4}, "mgplot.set_setting": {"tf": 4.898979485566356}, "mgplot.summary_plot": {"tf": 7.483314773547883}, "mgplot.summary_plot_finalise": {"tf": 6.4031242374328485}, "mgplot.bar_plot.annotate_bars": {"tf": 9.848857801796104}, "mgplot.bar_plot.grouped": {"tf": 9.591663046625438}, "mgplot.bar_plot.stacked": {"tf": 9.591663046625438}, "mgplot.bar_plot.bar_plot": {"tf": 7.483314773547883}, "mgplot.finalise_plot.sanitize_filename": {"tf": 5.477225575051661}, "mgplot.finalise_plot.make_legend": {"tf": 8.306623862918075}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 8.306623862918075}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 7.937253933193772}, "mgplot.finalise_plot.apply_annotations": {"tf": 7.3484692283495345}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 7.3484692283495345}, "mgplot.finalise_plot.apply_kwargs": {"tf": 7.3484692283495345}, "mgplot.finalise_plot.save_to_file": {"tf": 7}, "mgplot.finalise_plot.finalise_plot": {"tf": 7.3484692283495345}, "mgplot.growth_plot.calc_growth": {"tf": 6.324555320336759}, "mgplot.growth_plot.growth_plot": {"tf": 7.483314773547883}, "mgplot.growth_plot.series_growth_plot": {"tf": 7.483314773547883}, "mgplot.line_plot.annotate_series": {"tf": 8.660254037844387}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 9.219544457292887}, "mgplot.line_plot.line_plot": {"tf": 7.483314773547883}, "mgplot.postcovid_plot.get_projection": {"tf": 8.18535277187245}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 7.483314773547883}, "mgplot.revision_plot.revision_plot": {"tf": 7.483314773547883}, "mgplot.run_plot.run_plot": {"tf": 7.483314773547883}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 7.483314773547883}, "mgplot.summary_plot.calc_quantiles": {"tf": 4.47213595499958}, "mgplot.summary_plot.calculate_z": {"tf": 9.643650760992955}, "mgplot.summary_plot.plot_middle_bars": {"tf": 8.602325267042627}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 9.273618495495704}, "mgplot.summary_plot.label_extremes": {"tf": 10.908712114635714}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 10.198039027185569}, "mgplot.summary_plot.label_x_axis": {"tf": 10.246950765959598}, "mgplot.summary_plot.mark_reference_lines": {"tf": 6.082762530298219}, "mgplot.summary_plot.plot_the_data": {"tf": 8.717797887081348}, "mgplot.summary_plot.summary_plot": {"tf": 7.483314773547883}}, "df": 66, "s": {"docs": {"mgplot.get_color": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.multi_start": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.stacked": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {"mgplot.abbreviate_state": {"tf": 1.4142135623730951}, "mgplot.colorise_list": {"tf": 1.4142135623730951}, "mgplot.contrast": {"tf": 1.4142135623730951}, "mgplot.get_color": {"tf": 1.4142135623730951}, "mgplot.get_party_palette": {"tf": 1.4142135623730951}, "mgplot.get_setting": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1.7320508075688772}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_x_axis": {"tf": 1.4142135623730951}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 19}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.bar_plot.annotate_bars": {"tf": 1.7320508075688772}, "mgplot.growth_plot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.line_plot.annotate_series": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.get_projection": {"tf": 2}}, "df": 5, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.get_setting": {"tf": 1}, "mgplot.set_setting": {"tf": 1}}, "df": 2, "s": {"docs": {"mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.seastrend_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.series_growth_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 3, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 3}}}}}}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 32, "t": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 29}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_extremes": {"tf": 1.4142135623730951}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 12}}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 5}}}, "f": {"docs": {"mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 4}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 47}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 41}}}}}}, "m": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1.4142135623730951}, "mgplot.bar_plot.stacked": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 41}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 38}}}}}}}}, "x": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 4}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1.4142135623730951}, "mgplot.bar_plot.stacked": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 5, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1.4142135623730951}, "mgplot.bar_plot.stacked": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1.4142135623730951}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 36}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1.7320508075688772}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_extremes": {"tf": 1.4142135623730951}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_x_axis": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 16}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.colorise_list": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1.7320508075688772}, "mgplot.summary_plot.label_x_axis": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 2, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.postcovid_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.finalise_plot": {"tf": 2}, "mgplot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.line_plot": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot": {"tf": 1.7320508075688772}, "mgplot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.run_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot": {"tf": 1.7320508075688772}, "mgplot.series_growth_plot": {"tf": 1.7320508075688772}, "mgplot.summary_plot": {"tf": 1.7320508075688772}, "mgplot.bar_plot.annotate_bars": {"tf": 2}, "mgplot.bar_plot.grouped": {"tf": 2}, "mgplot.bar_plot.stacked": {"tf": 2}, "mgplot.bar_plot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.make_legend": {"tf": 2}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 2}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 2}, "mgplot.finalise_plot.apply_annotations": {"tf": 2}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 2}, "mgplot.finalise_plot.apply_kwargs": {"tf": 2}, "mgplot.finalise_plot.finalise_plot": {"tf": 2}, "mgplot.growth_plot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.series_growth_plot": {"tf": 1.7320508075688772}, "mgplot.line_plot.annotate_series": {"tf": 2}, "mgplot.line_plot.line_plot": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.7320508075688772}, "mgplot.revision_plot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.run_plot.run_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.7320508075688772}, "mgplot.summary_plot.label_extremes": {"tf": 1.7320508075688772}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.7320508075688772}, "mgplot.summary_plot.label_x_axis": {"tf": 1.7320508075688772}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_the_data": {"tf": 1.7320508075688772}, "mgplot.summary_plot.summary_plot": {"tf": 1.7320508075688772}}, "df": 37}}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.get_setting": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 10}, "n": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}}, "df": 3, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}}, "df": 2}}}, "d": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 3}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 8, "r": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}}, "df": 9}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 8}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {"mgplot.finalise_plot.save_to_file": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.save_to_file": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_extremes": {"tf": 1.4142135623730951}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 12}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}}, "df": 3}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1.4142135623730951}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 32}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1.4142135623730951}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_extremes": {"tf": 1.4142135623730951}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 15}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.contrast": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.colorise_list": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 5}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.line_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 8, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 7}}}}}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.finalise_plot.make_legend": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.colorise_list": {"tf": 1}, "mgplot.multi_start": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.multi_start": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 6}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.contrast": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 4}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 3}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 5}}}, "e": {"docs": {"mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 5}}}}, "o": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.growth_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 4, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.grouped": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.revision_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.run_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}}, "df": 15}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}}, "df": 10}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}}, "df": 10}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}}, "df": 10}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}}, "df": 4, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}}, "df": 4}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}}, "df": 5}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.SeriesGrowthKwargs": {"tf": 1}}, "df": 1, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}}, "df": 4}}}}}}}}}}}, "doc": {"root": {"0": {"docs": {"mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 4}, "1": {"docs": {"mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 3}, "2": {"docs": {"mgplot.growth_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}}, "df": 6}, "8": {"0": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}}, "df": 2}, "docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}, "docs": {"mgplot": {"tf": 2.449489742783178}, "mgplot.BarKwargs": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.stacked": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.max_ticks": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.color": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.width": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.annotate": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.fontname": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.rounding": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.rotation": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.annotate_color": {"tf": 1.7320508075688772}, "mgplot.BarKwargs.above": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.title": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.xlabel": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.ylabel": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.xlim": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.ylim": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.xticks": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.yticks": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.xscale": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.yscale": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.legend": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.axhspan": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.axvspan": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.axhline": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.axvline": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.lfooter": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.rfooter": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.lheader": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.rheader": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.pre_tag": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.tag": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.chart_dir": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.file_type": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.dpi": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.figsize": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.show": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.preserve_lims": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.remove_legend": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.zero_y": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.y0": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.x0": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.dont_save": {"tf": 1.7320508075688772}, "mgplot.FinaliseKwargs.dont_close": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.max_ticks": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_width": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_color": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_style": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.annotate_line": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_rounding": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_fontsize": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_fontname": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.line_anno_color": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.annotate_bars": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_fontsize": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_fontname": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_rounding": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_width": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_color": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_anno_color": {"tf": 1.7320508075688772}, "mgplot.GrowthKwargs.bar_rotation": {"tf": 1.7320508075688772}, "mgplot.LineKwargs": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.style": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.width": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.color": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.alpha": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.drawstyle": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.marker": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.markersize": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.dropna": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.annotate": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.rounding": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.fontname": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.rotation": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.annotate_color": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.LineKwargs.max_ticks": {"tf": 1.7320508075688772}, "mgplot.PostcovidKwargs": {"tf": 1.7320508075688772}, "mgplot.PostcovidKwargs.start_r": {"tf": 1.7320508075688772}, "mgplot.PostcovidKwargs.end_r": {"tf": 1.7320508075688772}, "mgplot.RunKwargs": {"tf": 1.7320508075688772}, "mgplot.RunKwargs.threshold": {"tf": 1.7320508075688772}, "mgplot.RunKwargs.direction": {"tf": 1.7320508075688772}, "mgplot.RunKwargs.highlight_color": {"tf": 1.7320508075688772}, "mgplot.RunKwargs.highlight_label": {"tf": 1.7320508075688772}, "mgplot.SeriesGrowthKwargs": {"tf": 1.7320508075688772}, "mgplot.SeriesGrowthKwargs.ylabel": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.verbose": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.middle": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.plot_type": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.legend": {"tf": 1.7320508075688772}, "mgplot.SummaryKwargs.xlabel": {"tf": 1.7320508075688772}, "mgplot.abbreviate_state": {"tf": 3}, "mgplot.bar_plot": {"tf": 2.449489742783178}, "mgplot.bar_plot_finalise": {"tf": 2.449489742783178}, "mgplot.calc_growth": {"tf": 3.4641016151377544}, "mgplot.clear_chart_dir": {"tf": 1.7320508075688772}, "mgplot.colorise_list": {"tf": 1.7320508075688772}, "mgplot.contrast": {"tf": 1.7320508075688772}, "mgplot.finalise_plot": {"tf": 1.7320508075688772}, "mgplot.get_color": {"tf": 3}, "mgplot.get_party_palette": {"tf": 3}, "mgplot.get_setting": {"tf": 3.1622776601683795}, "mgplot.growth_plot": {"tf": 4.242640687119285}, "mgplot.growth_plot_finalise": {"tf": 3}, "mgplot.line_plot": {"tf": 1.7320508075688772}, "mgplot.line_plot_finalise": {"tf": 2.449489742783178}, "mgplot.multi_column": {"tf": 4}, "mgplot.multi_start": {"tf": 4.358898943540674}, "mgplot.plot_then_finalise": {"tf": 3.3166247903554}, "mgplot.postcovid_plot": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot_finalise": {"tf": 2.449489742783178}, "mgplot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.revision_plot_finalise": {"tf": 2.449489742783178}, "mgplot.run_plot": {"tf": 1.7320508075688772}, "mgplot.run_plot_finalise": {"tf": 2.449489742783178}, "mgplot.seastrend_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot_finalise": {"tf": 2.449489742783178}, "mgplot.series_growth_plot": {"tf": 2.23606797749979}, "mgplot.series_growth_plot_finalise": {"tf": 2.449489742783178}, "mgplot.set_chart_dir": {"tf": 3.3166247903554}, "mgplot.set_setting": {"tf": 2.6457513110645907}, "mgplot.state_abbrs": {"tf": 1.7320508075688772}, "mgplot.state_names": {"tf": 1.7320508075688772}, "mgplot.summary_plot": {"tf": 1.7320508075688772}, "mgplot.summary_plot_finalise": {"tf": 3.4641016151377544}, "mgplot.bar_plot.ME": {"tf": 1.7320508075688772}, "mgplot.bar_plot.MAX_ANNOTATIONS": {"tf": 1.7320508075688772}, "mgplot.bar_plot.ADJUSTMENT_FACTOR": {"tf": 1.7320508075688772}, "mgplot.bar_plot.MIN_BAR_WIDTH": {"tf": 1.7320508075688772}, "mgplot.bar_plot.MAX_BAR_WIDTH": {"tf": 1.7320508075688772}, "mgplot.bar_plot.DEFAULT_GROUPED_WIDTH": {"tf": 1.7320508075688772}, "mgplot.bar_plot.DEFAULT_BAR_OFFSET": {"tf": 1.7320508075688772}, "mgplot.bar_plot.DEFAULT_MAX_TICKS": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.stacked": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.max_ticks": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.color": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.width": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.annotate": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.fontname": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.rounding": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.rotation": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.annotate_color": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs.above": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.annotate": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.fontname": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.color": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.rotation": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.foreground": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.above": {"tf": 1.7320508075688772}, "mgplot.bar_plot.AnnoKwargs.rounding": {"tf": 1.7320508075688772}, "mgplot.bar_plot.annotate_bars": {"tf": 2.449489742783178}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1.7320508075688772}, "mgplot.bar_plot.GroupedKwargs.color": {"tf": 1.7320508075688772}, "mgplot.bar_plot.GroupedKwargs.width": {"tf": 1.7320508075688772}, "mgplot.bar_plot.GroupedKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.bar_plot.grouped": {"tf": 1.7320508075688772}, "mgplot.bar_plot.StackedKwargs": {"tf": 1.7320508075688772}, "mgplot.bar_plot.StackedKwargs.color": {"tf": 1.7320508075688772}, "mgplot.bar_plot.StackedKwargs.width": {"tf": 1.7320508075688772}, "mgplot.bar_plot.StackedKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.bar_plot.stacked": {"tf": 1.7320508075688772}, "mgplot.bar_plot.bar_plot": {"tf": 4}, "mgplot.finalise_plot.ME": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.MAX_FILENAME_LENGTH": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.DEFAULT_MARGIN": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.TIGHT_LAYOUT_PAD": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FOOTNOTE_FONTSIZE": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FOOTNOTE_FONTSTYLE": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FOOTNOTE_COLOR": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.ZERO_LINE_WIDTH": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.ZERO_LINE_COLOR": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.ZERO_AXIS_ADJUSTMENT": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.DEFAULT_FILE_TITLE_NAME": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.title": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.xlabel": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.ylabel": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.xlim": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.ylim": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.xticks": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.yticks": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.xscale": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.yscale": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.legend": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.axhspan": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.axvspan": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.axhline": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.axvline": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.lfooter": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.rfooter": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.lheader": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.rheader": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.pre_tag": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.tag": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.chart_dir": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.file_type": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.dpi": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.figsize": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.show": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.preserve_lims": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.remove_legend": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.zero_y": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.y0": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.x0": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.dont_save": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs.dont_close": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.VALUE_KWARGS": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.SPLAT_KWARGS": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.HEADER_FOOTER_KWARGS": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.sanitize_filename": {"tf": 2.6457513110645907}, "mgplot.finalise_plot.make_legend": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 2.449489742783178}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.apply_annotations": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.save_to_file": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.finalise_plot": {"tf": 2.8284271247461903}, "mgplot.growth_plot.FREQUENCY_TO_PERIODS": {"tf": 1.7320508075688772}, "mgplot.growth_plot.FREQUENCY_TO_NAME": {"tf": 1.7320508075688772}, "mgplot.growth_plot.TWO_COLUMNS": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.max_ticks": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_width": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_color": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_style": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.annotate_line": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_rounding": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_fontsize": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_fontname": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.line_anno_color": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.annotate_bars": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_fontsize": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_fontname": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_rounding": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_width": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_color": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_anno_color": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs.bar_rotation": {"tf": 1.7320508075688772}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1.7320508075688772}, "mgplot.growth_plot.SeriesGrowthKwargs.ylabel": {"tf": 1.7320508075688772}, "mgplot.growth_plot.common_transitions": {"tf": 1.7320508075688772}, "mgplot.growth_plot.to_line_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.to_bar_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.calc_growth": {"tf": 3.4641016151377544}, "mgplot.growth_plot.growth_plot": {"tf": 3.3166247903554}, "mgplot.growth_plot.series_growth_plot": {"tf": 2.23606797749979}, "mgplot.line_plot.ME": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.style": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.width": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.color": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.alpha": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.drawstyle": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.marker": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.markersize": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.dropna": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.annotate": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.rounding": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.fontname": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.rotation": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.annotate_color": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.label_series": {"tf": 1.7320508075688772}, "mgplot.line_plot.LineKwargs.max_ticks": {"tf": 1.7320508075688772}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1.7320508075688772}, "mgplot.line_plot.AnnotateKwargs.color": {"tf": 1.7320508075688772}, "mgplot.line_plot.AnnotateKwargs.rounding": {"tf": 1.7320508075688772}, "mgplot.line_plot.AnnotateKwargs.fontsize": {"tf": 1.7320508075688772}, "mgplot.line_plot.AnnotateKwargs.fontname": {"tf": 1.7320508075688772}, "mgplot.line_plot.AnnotateKwargs.rotation": {"tf": 1.7320508075688772}, "mgplot.line_plot.annotate_series": {"tf": 1.7320508075688772}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 2.8284271247461903}, "mgplot.line_plot.line_plot": {"tf": 3.7416573867739413}, "mgplot.postcovid_plot.ME": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.DEFAULT_PERIODS": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.PostcovidKwargs.start_r": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.PostcovidKwargs.end_r": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.get_projection": {"tf": 3.872983346207417}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 2.8284271247461903}, "mgplot.revision_plot.ME": {"tf": 1.7320508075688772}, "mgplot.revision_plot.DEFAULT_PLOT_FROM": {"tf": 1.7320508075688772}, "mgplot.revision_plot.MIN_REVISION_COLUMNS": {"tf": 1.7320508075688772}, "mgplot.revision_plot.revision_plot": {"tf": 3.4641016151377544}, "mgplot.run_plot.ME": {"tf": 1.7320508075688772}, "mgplot.run_plot.STROKE_LINEWIDTH": {"tf": 1.7320508075688772}, "mgplot.run_plot.DEFAULT_THRESHOLD": {"tf": 1.7320508075688772}, "mgplot.run_plot.DEFAULT_ROUNDING": {"tf": 1.7320508075688772}, "mgplot.run_plot.UP_COLOR": {"tf": 1.7320508075688772}, "mgplot.run_plot.DOWN_COLOR": {"tf": 1.7320508075688772}, "mgplot.run_plot.UNKNOWN_COLOR": {"tf": 1.7320508075688772}, "mgplot.run_plot.LINE_COLOR": {"tf": 1.7320508075688772}, "mgplot.run_plot.RunKwargs": {"tf": 1.7320508075688772}, "mgplot.run_plot.RunKwargs.threshold": {"tf": 1.7320508075688772}, "mgplot.run_plot.RunKwargs.direction": {"tf": 1.7320508075688772}, "mgplot.run_plot.RunKwargs.highlight_color": {"tf": 1.7320508075688772}, "mgplot.run_plot.RunKwargs.highlight_label": {"tf": 1.7320508075688772}, "mgplot.run_plot.run_plot": {"tf": 3.7416573867739413}, "mgplot.seastrend_plot.ME": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot.REQUIRED_COLUMNS": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 3.1622776601683795}, "mgplot.summary_plot.ME": {"tf": 1.7320508075688772}, "mgplot.summary_plot.ZSCORES": {"tf": 1.7320508075688772}, "mgplot.summary_plot.ZSCALED": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SPAN_LIMIT": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SPACE_MARGIN": {"tf": 1.7320508075688772}, "mgplot.summary_plot.DEFAULT_FONT_SIZE": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SMALL_FONT_SIZE": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SMALL_MARKER_SIZE": {"tf": 1.7320508075688772}, "mgplot.summary_plot.REFERENCE_LINE_WIDTH": {"tf": 1.7320508075688772}, "mgplot.summary_plot.DEFAULT_MIDDLE": {"tf": 1.7320508075688772}, "mgplot.summary_plot.DEFAULT_PLOT_FROM": {"tf": 1.7320508075688772}, "mgplot.summary_plot.HIGH_PRECISION_THRESHOLD": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.ax": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.verbose": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.middle": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.plot_type": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.plot_from": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.legend": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs.xlabel": {"tf": 1.7320508075688772}, "mgplot.summary_plot.calc_quantiles": {"tf": 1.7320508075688772}, "mgplot.summary_plot.calculate_z": {"tf": 3.4641016151377544}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.7320508075688772}, "mgplot.summary_plot.label_extremes": {"tf": 1.7320508075688772}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.7320508075688772}, "mgplot.summary_plot.label_x_axis": {"tf": 1.7320508075688772}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_the_data": {"tf": 3.4641016151377544}, "mgplot.summary_plot.summary_plot": {"tf": 3.4641016151377544}}, "df": 360, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"mgplot": {"tf": 1}, "mgplot.contrast": {"tf": 1}}, "df": 2, "d": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1}}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 3}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}}, "df": 3}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.multi_start": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 2.23606797749979}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"mgplot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.run_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 15}}}}, "c": {"docs": {"mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 6}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 4, "s": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2}}}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 11}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.colorise_list": {"tf": 1}, "mgplot.contrast": {"tf": 1}, "mgplot.get_color": {"tf": 1.4142135623730951}, "mgplot.get_party_palette": {"tf": 1.7320508075688772}}, "df": 4, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.colorise_list": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.bar_plot_finalise": {"tf": 2}, "mgplot.finalise_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot_finalise": {"tf": 2}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 2}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 2}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 2}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 2}, "mgplot.seastrend_plot": {"tf": 2}, "mgplot.seastrend_plot_finalise": {"tf": 2}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 2.23606797749979}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 2.23606797749979}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1.4142135623730951}, "mgplot.bar_plot.stacked": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.7320508075688772}, "mgplot.line_plot.line_plot": {"tf": 2}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 2}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 2}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 2.449489742783178}, "mgplot.summary_plot.summary_plot": {"tf": 2.23606797749979}}, "df": 60, "s": {"docs": {"mgplot": {"tf": 2.449489742783178}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot": {"tf": 2.23606797749979}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 10}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 14}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 9}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.multi_column": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot_finalise": {"tf": 1.4142135623730951}}, "df": 1, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 1, "s": {"docs": {"mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "a": {"docs": {"mgplot": {"tf": 1.4142135623730951}, "mgplot.abbreviate_state": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 2.6457513110645907}, "mgplot.colorise_list": {"tf": 1.4142135623730951}, "mgplot.contrast": {"tf": 1}, "mgplot.get_color": {"tf": 1.7320508075688772}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.line_plot": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 2.449489742783178}, "mgplot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.run_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.series_growth_plot": {"tf": 1.4142135623730951}, "mgplot.set_chart_dir": {"tf": 1.7320508075688772}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 2}, "mgplot.finalise_plot.sanitize_filename": {"tf": 2}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 2.6457513110645907}, "mgplot.growth_plot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.series_growth_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 2.449489742783178}, "mgplot.revision_plot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 2}}, "df": 43, "n": {"docs": {"mgplot.get_color": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 5, "d": {"docs": {"mgplot": {"tf": 1.7320508075688772}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.revision_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.run_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 29}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 6, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.growth_plot": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}}, "df": 2}}}}}}}}}, "y": {"docs": {"mgplot.contrast": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 9}}, "s": {"docs": {"mgplot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 9, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2, "s": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}, "l": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 3}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1.4142135623730951}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 45}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"mgplot.abbreviate_state": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.calc_growth": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 41}}, "e": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 6}}, "b": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.abbreviate_state": {"tf": 1}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 3}}}, "s": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 12}}}}}}}}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot": {"tf": 1}, "mgplot.line_plot": {"tf": 1.7320508075688772}, "mgplot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.run_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.line_plot.line_plot": {"tf": 1.7320508075688772}, "mgplot.revision_plot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1.4142135623730951}}, "df": 18}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.get_color": {"tf": 1.4142135623730951}, "mgplot.get_party_palette": {"tf": 1}}, "df": 2}}}}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 2}}}}}}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.postcovid_plot": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 8}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 4}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot": {"tf": 1.4142135623730951}, "mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.abbreviate_state": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.calc_growth": {"tf": 1}, "mgplot.colorise_list": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1.4142135623730951}, "mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.line_plot": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.run_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1.4142135623730951}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.line_plot.line_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1.7320508075688772}}, "df": 54, "m": {"docs": {"mgplot.abbreviate_state": {"tf": 1.4142135623730951}}, "df": 1}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.get_setting": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}}, "df": 4}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.line_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.revision_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.run_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.series_growth_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 15, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 2.23606797749979}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 3}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 2}, "mgplot.revision_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}}, "df": 24, "s": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}}, "df": 5}}}}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1, "o": {"docs": {"mgplot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.contrast": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1.4142135623730951}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1.7320508075688772}, "mgplot.multi_start": {"tf": 1.7320508075688772}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1.4142135623730951}, "mgplot.set_setting": {"tf": 1.7320508075688772}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 2}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.7320508075688772}, "mgplot.summary_plot.calculate_z": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 36, "p": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.revision_plot": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 3}}}}}}}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 3}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"mgplot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 6}}, "e": {"docs": {"mgplot": {"tf": 1}, "mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.abbreviate_state": {"tf": 1.4142135623730951}, "mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.calc_growth": {"tf": 2.23606797749979}, "mgplot.clear_chart_dir": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.get_setting": {"tf": 2.23606797749979}, "mgplot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.line_plot": {"tf": 1.7320508075688772}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 2}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 2}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 2}, "mgplot.set_setting": {"tf": 2.6457513110645907}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 2.23606797749979}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 2.6457513110645907}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 2.23606797749979}, "mgplot.growth_plot.growth_plot": {"tf": 2.449489742783178}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 2}, "mgplot.line_plot.line_plot": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 2.8284271247461903}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 2}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1.7320508075688772}, "mgplot.summary_plot.calculate_z": {"tf": 2}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_extremes": {"tf": 1.4142135623730951}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_x_axis": {"tf": 1.4142135623730951}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_the_data": {"tf": 2}, "mgplot.summary_plot.summary_plot": {"tf": 2.23606797749979}}, "df": 77, "n": {"docs": {"mgplot.line_plot_finalise": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}, "y": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.4142135623730951}}, "df": 1}, "m": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.get_color": {"tf": 1}}, "df": 1}, "n": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.postcovid_plot": {"tf": 1}}, "df": 1}}}}}}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}}, "df": 4}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 13}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 3}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 4, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"mgplot": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_color": {"tf": 1.4142135623730951}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 18}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"mgplot.set_chart_dir": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 2}, "x": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "k": {"docs": {"mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"mgplot.line_plot": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 7}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"mgplot.get_party_palette": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot": {"tf": 1.7320508075688772}, "mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 21, "i": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.7320508075688772}}, "df": 4}}, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.7320508075688772}}, "df": 1}}, "d": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mgplot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.line_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1.7320508075688772}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 2.23606797749979}, "mgplot.revision_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot": {"tf": 2}, "mgplot.seastrend_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.bar_plot.bar_plot": {"tf": 2}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.7320508075688772}, "mgplot.line_plot.line_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 2.23606797749979}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 2}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 2}}, "df": 39, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 2}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.bar_plot.bar_plot": {"tf": 1.7320508075688772}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1.7320508075688772}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1.7320508075688772}}, "df": 21, "s": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {"mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 9}}, "n": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}}, "df": 2}}}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.set_chart_dir": {"tf": 2.23606797749979}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.multi_start": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 1}}}}}}}}}}, "f": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"mgplot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.get_color": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.7320508075688772}, "mgplot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 22, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1.4142135623730951}}, "df": 6, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 4}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2}}}}}}}}, "t": {"docs": {"mgplot.multi_start": {"tf": 1.4142135623730951}}, "df": 1}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.multi_start": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {"mgplot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.multi_start": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.multi_start": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "m": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1.4142135623730951}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 24}, "f": {"docs": {"mgplot.calc_growth": {"tf": 2.23606797749979}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot": {"tf": 2}, "mgplot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1.4142135623730951}, "mgplot.set_setting": {"tf": 1.4142135623730951}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 2}, "mgplot.growth_plot.calc_growth": {"tf": 2.23606797749979}, "mgplot.growth_plot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 2}, "mgplot.revision_plot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 22}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 6, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.line_plot": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}}, "df": 2}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_annotations": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1.7320508075688772}}, "df": 8, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 4, "+": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.seastrend_plot_finalise": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.calc_growth": {"tf": 3.1622776601683795}, "mgplot.growth_plot": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 2.6457513110645907}, "mgplot.run_plot": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1.4142135623730951}, "mgplot.series_growth_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 3.1622776601683795}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 2.23606797749979}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 2.6457513110645907}, "mgplot.run_plot.run_plot": {"tf": 1.7320508075688772}}, "df": 23, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.series_growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 3}, "t": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 2}, "mgplot.set_setting": {"tf": 1.7320508075688772}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 2.6457513110645907}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}}, "df": 6, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.get_setting": {"tf": 2.23606797749979}, "mgplot.set_chart_dir": {"tf": 1.4142135623730951}, "mgplot.set_setting": {"tf": 2.6457513110645907}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 5, "s": {"docs": {"mgplot.get_setting": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}}, "df": 4}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 2}}, "df": 1, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.get_color": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.multi_start": {"tf": 1.4142135623730951}}, "df": 1}}}, "s": {"docs": {"mgplot.multi_start": {"tf": 1.7320508075688772}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {"mgplot.abbreviate_state": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 9, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.get_color": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.save_to_file": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 3, "d": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 4}}, "f": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1.4142135623730951}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1.4142135623730951}, "mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.make_legend": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}}, "df": 8, "d": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}, "s": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}}, "df": 9}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2, "s": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 2}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot": {"tf": 1}, "mgplot.contrast": {"tf": 1.4142135623730951}, "mgplot.get_color": {"tf": 1.4142135623730951}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 6, "s": {"docs": {"mgplot.colorise_list": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 13, "s": {"docs": {"mgplot.growth_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}}, "df": 8}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 2}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.contrast": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.multi_start": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1.4142135623730951}}, "df": 8}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot_finalise": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 5}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.set_chart_dir": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}}, "df": 9, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}}, "df": 3}}}}}, "c": {"docs": {"mgplot.growth_plot": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 5}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.bar_plot": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.postcovid_plot": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 2}, "mgplot.finalise_plot.apply_annotations": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 5, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.plot_then_finalise": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"mgplot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1}, "mgplot.colorise_list": {"tf": 1}, "mgplot.get_setting": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1}, "mgplot.run_plot": {"tf": 1.4142135623730951}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 21}, "n": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 6, "e": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 3}}}}, "r": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1}, "mgplot.get_color": {"tf": 1.4142135623730951}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1.4142135623730951}}, "df": 15, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 2}, "mgplot.summary_plot.calculate_z": {"tf": 1.7320508075688772}}, "df": 2}}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 15}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 2}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.revision_plot": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1, "d": {"docs": {"mgplot": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 10}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 4}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.multi_start": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mgplot": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 8}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 6}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 3}}, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.label_extremes": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.revision_plot": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot": {"tf": 1}, "mgplot.BarKwargs": {"tf": 1}, "mgplot.bar_plot": {"tf": 2.23606797749979}, "mgplot.bar_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}, "mgplot.bar_plot.stacked": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.summary_plot.plot_middle_bars": {"tf": 1}}, "df": 10, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.get_party_palette": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1.7320508075688772}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 17, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 2}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.line_plot": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 3}}}, "y": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.line_plot": {"tf": 1.4142135623730951}, "mgplot.line_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.annotate_series": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.7320508075688772}, "mgplot.line_plot.line_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 13, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}}, "df": 7}}}}}}, "s": {"docs": {"mgplot.line_plot": {"tf": 1}, "mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 2}, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1.4142135623730951}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}}, "df": 2}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.colorise_list": {"tf": 1.4142135623730951}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}}, "df": 3}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.abbreviate_state": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.get_color": {"tf": 1.4142135623730951}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.summary_plot.label_extremes": {"tf": 1}, "mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 4, "s": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.summary_plot.plot_latest_datapoint": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.finalise_plot.sanitize_filename": {"tf": 1.4142135623730951}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.finalise_plot.make_legend": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mgplot": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot": {"tf": 2}, "mgplot.growth_plot_finalise": {"tf": 2}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.4142135623730951}, "mgplot.growth_plot.growth_plot": {"tf": 1.4142135623730951}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}}, "df": 13, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}}, "df": 2}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.grouped": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 6}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.get_setting": {"tf": 1.4142135623730951}, "mgplot.set_setting": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 3}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"mgplot.growth_plot": {"tf": 1}}, "df": 1, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.BarKwargs": {"tf": 1}, "mgplot.FinaliseKwargs": {"tf": 1}, "mgplot.GrowthKwargs": {"tf": 1}, "mgplot.LineKwargs": {"tf": 1}, "mgplot.PostcovidKwargs": {"tf": 1}, "mgplot.RunKwargs": {"tf": 1}, "mgplot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.SummaryKwargs": {"tf": 1}, "mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.BarKwargs": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.FinaliseKwargs": {"tf": 1}, "mgplot.growth_plot.GrowthKwargs": {"tf": 1}, "mgplot.growth_plot.SeriesGrowthKwargs": {"tf": 1}, "mgplot.line_plot.LineKwargs": {"tf": 1}, "mgplot.line_plot.AnnotateKwargs": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.PostcovidKwargs": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.SummaryKwargs": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 40}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.get_setting": {"tf": 1}, "mgplot.set_setting": {"tf": 1}}, "df": 2}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot_finalise": {"tf": 1}, "mgplot.finalise_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.line_plot": {"tf": 1}, "mgplot.line_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1.4142135623730951}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.postcovid_plot_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot_finalise": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.seastrend_plot_finalise": {"tf": 1}, "mgplot.series_growth_plot": {"tf": 1}, "mgplot.series_growth_plot_finalise": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.AnnoKwargs": {"tf": 1}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.GroupedKwargs": {"tf": 1}, "mgplot.bar_plot.StackedKwargs": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_late_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_kwargs": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.growth_plot.series_growth_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1.7320508075688772}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 40}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.RunKwargs": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot_finalise": {"tf": 1.4142135623730951}, "mgplot.run_plot.RunKwargs": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 5, "s": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.abbreviate_state": {"tf": 1}, "mgplot.colorise_list": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 6, "s": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1}, "mgplot.get_color": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.line_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.sanitize_filename": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.line_plot.get_style_width_color_etc": {"tf": 1}, "mgplot.line_plot.line_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 24}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.clear_chart_dir": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.finalise_plot": {"tf": 1}, "mgplot.finalise_plot.finalise_plot": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.revision_plot": {"tf": 2}, "mgplot.revision_plot_finalise": {"tf": 1.7320508075688772}, "mgplot.revision_plot.revision_plot": {"tf": 2}}, "df": 3, "s": {"docs": {"mgplot.revision_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.bar_plot": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.bar_plot": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.mark_reference_lines": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.run_plot": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.set_chart_dir": {"tf": 1}}, "df": 1, "s": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 20}}}}, "w": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mgplot.bar_plot.annotate_bars": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.abbreviate_state": {"tf": 1.4142135623730951}, "mgplot.get_color": {"tf": 1}, "mgplot.get_party_palette": {"tf": 1.4142135623730951}, "mgplot.get_setting": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.finalise_plot.apply_splat_kwargs": {"tf": 1}}, "df": 8, "s": {"docs": {"mgplot.abbreviate_state": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 2, "t": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.get_setting": {"tf": 1}, "mgplot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1.7320508075688772}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot_finalise": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1.4142135623730951}, "mgplot.growth_plot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot.growth_plot": {"tf": 1.7320508075688772}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.7320508075688772}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 23, "e": {"docs": {"mgplot.bar_plot": {"tf": 1}, "mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.set_chart_dir": {"tf": 1.4142135623730951}, "mgplot.bar_plot.annotate_bars": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1}}, "df": 7}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1.7320508075688772}, "mgplot.plot_then_finalise": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1}}, "df": 1, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.line_plot.get_style_width_color_etc": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.get_setting": {"tf": 1.4142135623730951}, "mgplot.set_setting": {"tf": 1.7320508075688772}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 3, "s": {"docs": {"mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.multi_start": {"tf": 1}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.postcovid_plot.get_projection": {"tf": 1}}, "df": 4}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.multi_start": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1}, "mgplot.set_setting": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1.7320508075688772}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 16}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 3}}}}}}}, "z": {"docs": {"mgplot.summary_plot.calculate_z": {"tf": 2}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"mgplot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.bar_plot.bar_plot": {"tf": 1.4142135623730951}, "mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 3}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.summary_plot.plot_the_data": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot": {"tf": 1.4142135623730951}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.growth_plot.growth_plot": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1.4142135623730951}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.seastrend_plot.seastrend_plot": {"tf": 1.4142135623730951}}, "df": 11}}, "s": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.multi_column": {"tf": 1}, "mgplot.revision_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot.get_projection": {"tf": 1}, "mgplot.revision_plot.revision_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 7}, "n": {"docs": {}, "df": 0, "d": {"docs": {"mgplot.line_plot.annotate_series": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mgplot.run_plot": {"tf": 1}, "mgplot.run_plot.run_plot": {"tf": 1}}, "df": 2}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot": {"tf": 1}, "mgplot.summary_plot.summary_plot": {"tf": 1}}, "df": 2}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.summary_plot.horizontal_bar_plot": {"tf": 1}}, "df": 1}}}}}}}}}}, "q": {"docs": {"mgplot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot": {"tf": 1}, "mgplot.growth_plot.calc_growth": {"tf": 1}, "mgplot.postcovid_plot.postcovid_plot": {"tf": 1}}, "df": 4, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mgplot.summary_plot.calc_quantiles": {"tf": 1}, "mgplot.summary_plot.calculate_z": {"tf": 1}}, "df": 2}}}}}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.growth_plot_finalise": {"tf": 1}, "mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mgplot.growth_plot": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {"mgplot.summary_plot.label_x_axis": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mgplot.finalise_plot.apply_value_kwargs": {"tf": 1}}, "df": 1}}}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();