from setuptools import setup, find_packages

setup(
    name="cleanframes",
    version="0.3.6",
    author="Abdullah Almutairi",
    author_email="abdullah@example.com",
    description="A professional tool for cleaning duplicate or near-duplicate image frames using perceptual hashing and embeddings.",
    long_description=open("README.md", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/abdullahalmutairi/cleanframes",
    packages=find_packages(),
    install_requires=[
        "torch>=2.0.1",
        "torchvision>=0.15.2",
        "torchaudio>=2.0.2",
        "numpy>=1.24",
        "pandas>=2.0",
        "tqdm",
        "pillow",
        "timm>=0.9.12",
        "transformers>=4.41.0",
        "open_clip_torch>=2.23.0",
        "scikit-learn",
        "matplotlib",
        "tabulate",
        "imagehash",
        "onnxruntime-gpu>=1.17.0",
        "hdbscan",
        "rich"
    ],
    python_requires=">=3.8",
    license="MIT",
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
) 