# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudCredentialArgs', 'CloudCredential']

@pulumi.input_type
class CloudCredentialArgs:
    def __init__(__self__, *,
                 amazonec2_credential_config: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 azure_credential_config: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']] = None,
                 google_credential_config: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']] = None,
                 harvester_credential_config: Optional[pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linode_credential_config: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_credential_config: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']] = None,
                 s3_credential_config: Optional[pulumi.Input['CloudCredentialS3CredentialConfigArgs']] = None,
                 vsphere_credential_config: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']] = None):
        """
        The set of arguments for constructing a CloudCredential resource.
        :param pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs'] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialAzureCredentialConfigArgs'] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] description: Description for the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs'] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialGoogleCredentialConfigArgs'] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs'] harvester_credential_config: Harvester config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialLinodeCredentialConfigArgs'] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] name: The name of the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs'] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialS3CredentialConfigArgs'] s3_credential_config: S3 config for the Cloud Credential. For Rancher 2.6.0 and above (list maxitems:1)
        :param pulumi.Input['CloudCredentialVsphereCredentialConfigArgs'] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        if amazonec2_credential_config is not None:
            pulumi.set(__self__, "amazonec2_credential_config", amazonec2_credential_config)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_credential_config is not None:
            pulumi.set(__self__, "azure_credential_config", azure_credential_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if digitalocean_credential_config is not None:
            pulumi.set(__self__, "digitalocean_credential_config", digitalocean_credential_config)
        if google_credential_config is not None:
            pulumi.set(__self__, "google_credential_config", google_credential_config)
        if harvester_credential_config is not None:
            pulumi.set(__self__, "harvester_credential_config", harvester_credential_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linode_credential_config is not None:
            pulumi.set(__self__, "linode_credential_config", linode_credential_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openstack_credential_config is not None:
            pulumi.set(__self__, "openstack_credential_config", openstack_credential_config)
        if s3_credential_config is not None:
            pulumi.set(__self__, "s3_credential_config", s3_credential_config)
        if vsphere_credential_config is not None:
            pulumi.set(__self__, "vsphere_credential_config", vsphere_credential_config)

    @_builtins.property
    @pulumi.getter(name="amazonec2CredentialConfig")
    def amazonec2_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]:
        """
        AWS config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "amazonec2_credential_config")

    @amazonec2_credential_config.setter
    def amazonec2_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]):
        pulumi.set(self, "amazonec2_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for Cloud Credential object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="azureCredentialConfig")
    def azure_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]:
        """
        Azure config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "azure_credential_config")

    @azure_credential_config.setter
    def azure_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]):
        pulumi.set(self, "azure_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the Cloud Credential (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="digitaloceanCredentialConfig")
    def digitalocean_credential_config(self) -> Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]:
        """
        DigitalOcean config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "digitalocean_credential_config")

    @digitalocean_credential_config.setter
    def digitalocean_credential_config(self, value: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]):
        pulumi.set(self, "digitalocean_credential_config", value)

    @_builtins.property
    @pulumi.getter(name="googleCredentialConfig")
    def google_credential_config(self) -> Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]:
        """
        Google config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "google_credential_config")

    @google_credential_config.setter
    def google_credential_config(self, value: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]):
        pulumi.set(self, "google_credential_config", value)

    @_builtins.property
    @pulumi.getter(name="harvesterCredentialConfig")
    def harvester_credential_config(self) -> Optional[pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs']]:
        """
        Harvester config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "harvester_credential_config")

    @harvester_credential_config.setter
    def harvester_credential_config(self, value: Optional[pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs']]):
        pulumi.set(self, "harvester_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for Cloud Credential object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="linodeCredentialConfig")
    def linode_credential_config(self) -> Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]:
        """
        Linode config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "linode_credential_config")

    @linode_credential_config.setter
    def linode_credential_config(self, value: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]):
        pulumi.set(self, "linode_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cloud Credential (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openstackCredentialConfig")
    def openstack_credential_config(self) -> Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]:
        """
        OpenStack config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "openstack_credential_config")

    @openstack_credential_config.setter
    def openstack_credential_config(self, value: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]):
        pulumi.set(self, "openstack_credential_config", value)

    @_builtins.property
    @pulumi.getter(name="s3CredentialConfig")
    def s3_credential_config(self) -> Optional[pulumi.Input['CloudCredentialS3CredentialConfigArgs']]:
        """
        S3 config for the Cloud Credential. For Rancher 2.6.0 and above (list maxitems:1)
        """
        return pulumi.get(self, "s3_credential_config")

    @s3_credential_config.setter
    def s3_credential_config(self, value: Optional[pulumi.Input['CloudCredentialS3CredentialConfigArgs']]):
        pulumi.set(self, "s3_credential_config", value)

    @_builtins.property
    @pulumi.getter(name="vsphereCredentialConfig")
    def vsphere_credential_config(self) -> Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]:
        """
        vSphere config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "vsphere_credential_config")

    @vsphere_credential_config.setter
    def vsphere_credential_config(self, value: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]):
        pulumi.set(self, "vsphere_credential_config", value)


@pulumi.input_type
class _CloudCredentialState:
    def __init__(__self__, *,
                 amazonec2_credential_config: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 azure_credential_config: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 google_credential_config: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']] = None,
                 harvester_credential_config: Optional[pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linode_credential_config: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_credential_config: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']] = None,
                 s3_credential_config: Optional[pulumi.Input['CloudCredentialS3CredentialConfigArgs']] = None,
                 vsphere_credential_config: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']] = None):
        """
        Input properties used for looking up and filtering CloudCredential resources.
        :param pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs'] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialAzureCredentialConfigArgs'] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] description: Description for the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs'] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] driver: (Computed) The driver of the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialGoogleCredentialConfigArgs'] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs'] harvester_credential_config: Harvester config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialLinodeCredentialConfigArgs'] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] name: The name of the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs'] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialS3CredentialConfigArgs'] s3_credential_config: S3 config for the Cloud Credential. For Rancher 2.6.0 and above (list maxitems:1)
        :param pulumi.Input['CloudCredentialVsphereCredentialConfigArgs'] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        if amazonec2_credential_config is not None:
            pulumi.set(__self__, "amazonec2_credential_config", amazonec2_credential_config)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_credential_config is not None:
            pulumi.set(__self__, "azure_credential_config", azure_credential_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if digitalocean_credential_config is not None:
            pulumi.set(__self__, "digitalocean_credential_config", digitalocean_credential_config)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if google_credential_config is not None:
            pulumi.set(__self__, "google_credential_config", google_credential_config)
        if harvester_credential_config is not None:
            pulumi.set(__self__, "harvester_credential_config", harvester_credential_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linode_credential_config is not None:
            pulumi.set(__self__, "linode_credential_config", linode_credential_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openstack_credential_config is not None:
            pulumi.set(__self__, "openstack_credential_config", openstack_credential_config)
        if s3_credential_config is not None:
            pulumi.set(__self__, "s3_credential_config", s3_credential_config)
        if vsphere_credential_config is not None:
            pulumi.set(__self__, "vsphere_credential_config", vsphere_credential_config)

    @_builtins.property
    @pulumi.getter(name="amazonec2CredentialConfig")
    def amazonec2_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]:
        """
        AWS config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "amazonec2_credential_config")

    @amazonec2_credential_config.setter
    def amazonec2_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]):
        pulumi.set(self, "amazonec2_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for Cloud Credential object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="azureCredentialConfig")
    def azure_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]:
        """
        Azure config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "azure_credential_config")

    @azure_credential_config.setter
    def azure_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]):
        pulumi.set(self, "azure_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the Cloud Credential (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="digitaloceanCredentialConfig")
    def digitalocean_credential_config(self) -> Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]:
        """
        DigitalOcean config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "digitalocean_credential_config")

    @digitalocean_credential_config.setter
    def digitalocean_credential_config(self, value: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]):
        pulumi.set(self, "digitalocean_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The driver of the Cloud Credential (string)
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver", value)

    @_builtins.property
    @pulumi.getter(name="googleCredentialConfig")
    def google_credential_config(self) -> Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]:
        """
        Google config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "google_credential_config")

    @google_credential_config.setter
    def google_credential_config(self, value: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]):
        pulumi.set(self, "google_credential_config", value)

    @_builtins.property
    @pulumi.getter(name="harvesterCredentialConfig")
    def harvester_credential_config(self) -> Optional[pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs']]:
        """
        Harvester config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "harvester_credential_config")

    @harvester_credential_config.setter
    def harvester_credential_config(self, value: Optional[pulumi.Input['CloudCredentialHarvesterCredentialConfigArgs']]):
        pulumi.set(self, "harvester_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for Cloud Credential object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="linodeCredentialConfig")
    def linode_credential_config(self) -> Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]:
        """
        Linode config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "linode_credential_config")

    @linode_credential_config.setter
    def linode_credential_config(self, value: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]):
        pulumi.set(self, "linode_credential_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cloud Credential (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openstackCredentialConfig")
    def openstack_credential_config(self) -> Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]:
        """
        OpenStack config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "openstack_credential_config")

    @openstack_credential_config.setter
    def openstack_credential_config(self, value: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]):
        pulumi.set(self, "openstack_credential_config", value)

    @_builtins.property
    @pulumi.getter(name="s3CredentialConfig")
    def s3_credential_config(self) -> Optional[pulumi.Input['CloudCredentialS3CredentialConfigArgs']]:
        """
        S3 config for the Cloud Credential. For Rancher 2.6.0 and above (list maxitems:1)
        """
        return pulumi.get(self, "s3_credential_config")

    @s3_credential_config.setter
    def s3_credential_config(self, value: Optional[pulumi.Input['CloudCredentialS3CredentialConfigArgs']]):
        pulumi.set(self, "s3_credential_config", value)

    @_builtins.property
    @pulumi.getter(name="vsphereCredentialConfig")
    def vsphere_credential_config(self) -> Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]:
        """
        vSphere config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "vsphere_credential_config")

    @vsphere_credential_config.setter
    def vsphere_credential_config(self, value: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]):
        pulumi.set(self, "vsphere_credential_config", value)


@pulumi.type_token("rancher2:index/cloudCredential:CloudCredential")
class CloudCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazonec2_credential_config: Optional[pulumi.Input[Union['CloudCredentialAmazonec2CredentialConfigArgs', 'CloudCredentialAmazonec2CredentialConfigArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 azure_credential_config: Optional[pulumi.Input[Union['CloudCredentialAzureCredentialConfigArgs', 'CloudCredentialAzureCredentialConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input[Union['CloudCredentialDigitaloceanCredentialConfigArgs', 'CloudCredentialDigitaloceanCredentialConfigArgsDict']]] = None,
                 google_credential_config: Optional[pulumi.Input[Union['CloudCredentialGoogleCredentialConfigArgs', 'CloudCredentialGoogleCredentialConfigArgsDict']]] = None,
                 harvester_credential_config: Optional[pulumi.Input[Union['CloudCredentialHarvesterCredentialConfigArgs', 'CloudCredentialHarvesterCredentialConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linode_credential_config: Optional[pulumi.Input[Union['CloudCredentialLinodeCredentialConfigArgs', 'CloudCredentialLinodeCredentialConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_credential_config: Optional[pulumi.Input[Union['CloudCredentialOpenstackCredentialConfigArgs', 'CloudCredentialOpenstackCredentialConfigArgsDict']]] = None,
                 s3_credential_config: Optional[pulumi.Input[Union['CloudCredentialS3CredentialConfigArgs', 'CloudCredentialS3CredentialConfigArgsDict']]] = None,
                 vsphere_credential_config: Optional[pulumi.Input[Union['CloudCredentialVsphereCredentialConfigArgs', 'CloudCredentialVsphereCredentialConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Cloud Credential resource. This can be used to create Cloud Credential for Rancher v2.2.x and retrieve their information.

        amazonec2, azure, digitalocean, harvester, linode, openstack and vsphere credentials config are supported for Cloud Credential.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cloud Credential
        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<AWS_ACCESS_KEY>",
                "secret_key": "<AWS_SECRET_KEY>",
            })
        ```

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Get imported harvester cluster info
        foo_harvester = rancher2.get_cluster_v2(name="foo-harvester")
        # Create a new Cloud Credential for an imported Harvester cluster
        foo_harvester_cloud_credential = rancher2.CloudCredential("foo-harvester",
            name="foo-harvester",
            harvester_credential_config={
                "cluster_id": foo_harvester.cluster_v1_id,
                "cluster_type": "imported",
                "kubeconfig_content": foo_harvester.kube_config,
            })
        ```

        ## Import

        Cloud Credential can be imported using the Cloud Credential ID and the Driver name.

        bash

        ```sh
        $ pulumi import rancher2:index/cloudCredential:CloudCredential foo &lt;CLOUD_CREDENTIAL_ID&gt;.&lt;DRIVER&gt;
        ```

        The following drivers are supported:

        * amazonec2

        * azure

        * digitalocean

        * googlekubernetesengine

        * linode

        * openstack

        * s3

        * vmwarevsphere

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CloudCredentialAmazonec2CredentialConfigArgs', 'CloudCredentialAmazonec2CredentialConfigArgsDict']] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input[Union['CloudCredentialAzureCredentialConfigArgs', 'CloudCredentialAzureCredentialConfigArgsDict']] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] description: Description for the Cloud Credential (string)
        :param pulumi.Input[Union['CloudCredentialDigitaloceanCredentialConfigArgs', 'CloudCredentialDigitaloceanCredentialConfigArgsDict']] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Union['CloudCredentialGoogleCredentialConfigArgs', 'CloudCredentialGoogleCredentialConfigArgsDict']] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Union['CloudCredentialHarvesterCredentialConfigArgs', 'CloudCredentialHarvesterCredentialConfigArgsDict']] harvester_credential_config: Harvester config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input[Union['CloudCredentialLinodeCredentialConfigArgs', 'CloudCredentialLinodeCredentialConfigArgsDict']] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] name: The name of the Cloud Credential (string)
        :param pulumi.Input[Union['CloudCredentialOpenstackCredentialConfigArgs', 'CloudCredentialOpenstackCredentialConfigArgsDict']] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Union['CloudCredentialS3CredentialConfigArgs', 'CloudCredentialS3CredentialConfigArgsDict']] s3_credential_config: S3 config for the Cloud Credential. For Rancher 2.6.0 and above (list maxitems:1)
        :param pulumi.Input[Union['CloudCredentialVsphereCredentialConfigArgs', 'CloudCredentialVsphereCredentialConfigArgsDict']] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CloudCredentialArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Cloud Credential resource. This can be used to create Cloud Credential for Rancher v2.2.x and retrieve their information.

        amazonec2, azure, digitalocean, harvester, linode, openstack and vsphere credentials config are supported for Cloud Credential.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cloud Credential
        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<AWS_ACCESS_KEY>",
                "secret_key": "<AWS_SECRET_KEY>",
            })
        ```

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Get imported harvester cluster info
        foo_harvester = rancher2.get_cluster_v2(name="foo-harvester")
        # Create a new Cloud Credential for an imported Harvester cluster
        foo_harvester_cloud_credential = rancher2.CloudCredential("foo-harvester",
            name="foo-harvester",
            harvester_credential_config={
                "cluster_id": foo_harvester.cluster_v1_id,
                "cluster_type": "imported",
                "kubeconfig_content": foo_harvester.kube_config,
            })
        ```

        ## Import

        Cloud Credential can be imported using the Cloud Credential ID and the Driver name.

        bash

        ```sh
        $ pulumi import rancher2:index/cloudCredential:CloudCredential foo &lt;CLOUD_CREDENTIAL_ID&gt;.&lt;DRIVER&gt;
        ```

        The following drivers are supported:

        * amazonec2

        * azure

        * digitalocean

        * googlekubernetesengine

        * linode

        * openstack

        * s3

        * vmwarevsphere

        :param str resource_name: The name of the resource.
        :param CloudCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazonec2_credential_config: Optional[pulumi.Input[Union['CloudCredentialAmazonec2CredentialConfigArgs', 'CloudCredentialAmazonec2CredentialConfigArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 azure_credential_config: Optional[pulumi.Input[Union['CloudCredentialAzureCredentialConfigArgs', 'CloudCredentialAzureCredentialConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input[Union['CloudCredentialDigitaloceanCredentialConfigArgs', 'CloudCredentialDigitaloceanCredentialConfigArgsDict']]] = None,
                 google_credential_config: Optional[pulumi.Input[Union['CloudCredentialGoogleCredentialConfigArgs', 'CloudCredentialGoogleCredentialConfigArgsDict']]] = None,
                 harvester_credential_config: Optional[pulumi.Input[Union['CloudCredentialHarvesterCredentialConfigArgs', 'CloudCredentialHarvesterCredentialConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linode_credential_config: Optional[pulumi.Input[Union['CloudCredentialLinodeCredentialConfigArgs', 'CloudCredentialLinodeCredentialConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_credential_config: Optional[pulumi.Input[Union['CloudCredentialOpenstackCredentialConfigArgs', 'CloudCredentialOpenstackCredentialConfigArgsDict']]] = None,
                 s3_credential_config: Optional[pulumi.Input[Union['CloudCredentialS3CredentialConfigArgs', 'CloudCredentialS3CredentialConfigArgsDict']]] = None,
                 vsphere_credential_config: Optional[pulumi.Input[Union['CloudCredentialVsphereCredentialConfigArgs', 'CloudCredentialVsphereCredentialConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudCredentialArgs.__new__(CloudCredentialArgs)

            __props__.__dict__["amazonec2_credential_config"] = amazonec2_credential_config
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["azure_credential_config"] = azure_credential_config
            __props__.__dict__["description"] = description
            __props__.__dict__["digitalocean_credential_config"] = digitalocean_credential_config
            __props__.__dict__["google_credential_config"] = google_credential_config
            __props__.__dict__["harvester_credential_config"] = harvester_credential_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linode_credential_config"] = linode_credential_config
            __props__.__dict__["name"] = name
            __props__.__dict__["openstack_credential_config"] = openstack_credential_config
            __props__.__dict__["s3_credential_config"] = s3_credential_config
            __props__.__dict__["vsphere_credential_config"] = vsphere_credential_config
            __props__.__dict__["driver"] = None
        super(CloudCredential, __self__).__init__(
            'rancher2:index/cloudCredential:CloudCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amazonec2_credential_config: Optional[pulumi.Input[Union['CloudCredentialAmazonec2CredentialConfigArgs', 'CloudCredentialAmazonec2CredentialConfigArgsDict']]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            azure_credential_config: Optional[pulumi.Input[Union['CloudCredentialAzureCredentialConfigArgs', 'CloudCredentialAzureCredentialConfigArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            digitalocean_credential_config: Optional[pulumi.Input[Union['CloudCredentialDigitaloceanCredentialConfigArgs', 'CloudCredentialDigitaloceanCredentialConfigArgsDict']]] = None,
            driver: Optional[pulumi.Input[_builtins.str]] = None,
            google_credential_config: Optional[pulumi.Input[Union['CloudCredentialGoogleCredentialConfigArgs', 'CloudCredentialGoogleCredentialConfigArgsDict']]] = None,
            harvester_credential_config: Optional[pulumi.Input[Union['CloudCredentialHarvesterCredentialConfigArgs', 'CloudCredentialHarvesterCredentialConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            linode_credential_config: Optional[pulumi.Input[Union['CloudCredentialLinodeCredentialConfigArgs', 'CloudCredentialLinodeCredentialConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            openstack_credential_config: Optional[pulumi.Input[Union['CloudCredentialOpenstackCredentialConfigArgs', 'CloudCredentialOpenstackCredentialConfigArgsDict']]] = None,
            s3_credential_config: Optional[pulumi.Input[Union['CloudCredentialS3CredentialConfigArgs', 'CloudCredentialS3CredentialConfigArgsDict']]] = None,
            vsphere_credential_config: Optional[pulumi.Input[Union['CloudCredentialVsphereCredentialConfigArgs', 'CloudCredentialVsphereCredentialConfigArgsDict']]] = None) -> 'CloudCredential':
        """
        Get an existing CloudCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CloudCredentialAmazonec2CredentialConfigArgs', 'CloudCredentialAmazonec2CredentialConfigArgsDict']] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input[Union['CloudCredentialAzureCredentialConfigArgs', 'CloudCredentialAzureCredentialConfigArgsDict']] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] description: Description for the Cloud Credential (string)
        :param pulumi.Input[Union['CloudCredentialDigitaloceanCredentialConfigArgs', 'CloudCredentialDigitaloceanCredentialConfigArgsDict']] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] driver: (Computed) The driver of the Cloud Credential (string)
        :param pulumi.Input[Union['CloudCredentialGoogleCredentialConfigArgs', 'CloudCredentialGoogleCredentialConfigArgsDict']] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Union['CloudCredentialHarvesterCredentialConfigArgs', 'CloudCredentialHarvesterCredentialConfigArgsDict']] harvester_credential_config: Harvester config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input[Union['CloudCredentialLinodeCredentialConfigArgs', 'CloudCredentialLinodeCredentialConfigArgsDict']] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[_builtins.str] name: The name of the Cloud Credential (string)
        :param pulumi.Input[Union['CloudCredentialOpenstackCredentialConfigArgs', 'CloudCredentialOpenstackCredentialConfigArgsDict']] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Union['CloudCredentialS3CredentialConfigArgs', 'CloudCredentialS3CredentialConfigArgsDict']] s3_credential_config: S3 config for the Cloud Credential. For Rancher 2.6.0 and above (list maxitems:1)
        :param pulumi.Input[Union['CloudCredentialVsphereCredentialConfigArgs', 'CloudCredentialVsphereCredentialConfigArgsDict']] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudCredentialState.__new__(_CloudCredentialState)

        __props__.__dict__["amazonec2_credential_config"] = amazonec2_credential_config
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["azure_credential_config"] = azure_credential_config
        __props__.__dict__["description"] = description
        __props__.__dict__["digitalocean_credential_config"] = digitalocean_credential_config
        __props__.__dict__["driver"] = driver
        __props__.__dict__["google_credential_config"] = google_credential_config
        __props__.__dict__["harvester_credential_config"] = harvester_credential_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["linode_credential_config"] = linode_credential_config
        __props__.__dict__["name"] = name
        __props__.__dict__["openstack_credential_config"] = openstack_credential_config
        __props__.__dict__["s3_credential_config"] = s3_credential_config
        __props__.__dict__["vsphere_credential_config"] = vsphere_credential_config
        return CloudCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="amazonec2CredentialConfig")
    def amazonec2_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialAmazonec2CredentialConfig']]:
        """
        AWS config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "amazonec2_credential_config")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations for Cloud Credential object (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="azureCredentialConfig")
    def azure_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialAzureCredentialConfig']]:
        """
        Azure config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "azure_credential_config")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for the Cloud Credential (string)
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="digitaloceanCredentialConfig")
    def digitalocean_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialDigitaloceanCredentialConfig']]:
        """
        DigitalOcean config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "digitalocean_credential_config")

    @_builtins.property
    @pulumi.getter
    def driver(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The driver of the Cloud Credential (string)
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="googleCredentialConfig")
    def google_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialGoogleCredentialConfig']]:
        """
        Google config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "google_credential_config")

    @_builtins.property
    @pulumi.getter(name="harvesterCredentialConfig")
    def harvester_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialHarvesterCredentialConfig']]:
        """
        Harvester config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "harvester_credential_config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels for Cloud Credential object (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="linodeCredentialConfig")
    def linode_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialLinodeCredentialConfig']]:
        """
        Linode config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "linode_credential_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cloud Credential (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openstackCredentialConfig")
    def openstack_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialOpenstackCredentialConfig']]:
        """
        OpenStack config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "openstack_credential_config")

    @_builtins.property
    @pulumi.getter(name="s3CredentialConfig")
    def s3_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialS3CredentialConfig']]:
        """
        S3 config for the Cloud Credential. For Rancher 2.6.0 and above (list maxitems:1)
        """
        return pulumi.get(self, "s3_credential_config")

    @_builtins.property
    @pulumi.getter(name="vsphereCredentialConfig")
    def vsphere_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialVsphereCredentialConfig']]:
        """
        vSphere config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "vsphere_credential_config")

