# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetClusterDriverResult',
    'AwaitableGetClusterDriverResult',
    'get_cluster_driver',
    'get_cluster_driver_output',
]

@pulumi.output_type
class GetClusterDriverResult:
    """
    A collection of values returned by getClusterDriver.
    """
    def __init__(__self__, active=None, actual_url=None, annotations=None, builtin=None, checksum=None, id=None, labels=None, name=None, ui_url=None, url=None, whitelist_domains=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if actual_url and not isinstance(actual_url, str):
            raise TypeError("Expected argument 'actual_url' to be a str")
        pulumi.set(__self__, "actual_url", actual_url)
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if builtin and not isinstance(builtin, bool):
            raise TypeError("Expected argument 'builtin' to be a bool")
        pulumi.set(__self__, "builtin", builtin)
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if ui_url and not isinstance(ui_url, str):
            raise TypeError("Expected argument 'ui_url' to be a str")
        pulumi.set(__self__, "ui_url", ui_url)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if whitelist_domains and not isinstance(whitelist_domains, list):
            raise TypeError("Expected argument 'whitelist_domains' to be a list")
        pulumi.set(__self__, "whitelist_domains", whitelist_domains)

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        """
        (Computed) Specify if the cluster driver state (bool)
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="actualUrl")
    def actual_url(self) -> _builtins.str:
        """
        (Computed) Actual url of the cluster driver (string)
        """
        return pulumi.get(self, "actual_url")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        (Computed) Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def builtin(self) -> _builtins.bool:
        """
        (Computed) Specify whether the cluster driver is an internal cluster driver or not (bool)
        """
        return pulumi.get(self, "builtin")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> _builtins.str:
        """
        (Computed) Verify that the downloaded driver matches the expected checksum (string)
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        (Computed) Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="uiUrl")
    def ui_url(self) -> _builtins.str:
        """
        (Computed) The URL to load for customized Add Clusters screen for this driver (string)
        """
        return pulumi.get(self, "ui_url")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="whitelistDomains")
    def whitelist_domains(self) -> Sequence[_builtins.str]:
        """
        (Computed) Domains to whitelist for the ui (list)
        """
        return pulumi.get(self, "whitelist_domains")


class AwaitableGetClusterDriverResult(GetClusterDriverResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterDriverResult(
            active=self.active,
            actual_url=self.actual_url,
            annotations=self.annotations,
            builtin=self.builtin,
            checksum=self.checksum,
            id=self.id,
            labels=self.labels,
            name=self.name,
            ui_url=self.ui_url,
            url=self.url,
            whitelist_domains=self.whitelist_domains)


def get_cluster_driver(name: Optional[_builtins.str] = None,
                       url: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterDriverResult:
    """
    Use this data source to retrieve information about a Rancher v2 Cluster Driver resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_cluster_driver(name="foo")
    ```


    :param _builtins.str name: Name of the cluster driver (string)
    :param _builtins.str url: The URL to download the machine driver binary for 64-bit Linux (string)
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['url'] = url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('rancher2:index/getClusterDriver:getClusterDriver', __args__, opts=opts, typ=GetClusterDriverResult).value

    return AwaitableGetClusterDriverResult(
        active=pulumi.get(__ret__, 'active'),
        actual_url=pulumi.get(__ret__, 'actual_url'),
        annotations=pulumi.get(__ret__, 'annotations'),
        builtin=pulumi.get(__ret__, 'builtin'),
        checksum=pulumi.get(__ret__, 'checksum'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        ui_url=pulumi.get(__ret__, 'ui_url'),
        url=pulumi.get(__ret__, 'url'),
        whitelist_domains=pulumi.get(__ret__, 'whitelist_domains'))
def get_cluster_driver_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                              url: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterDriverResult]:
    """
    Use this data source to retrieve information about a Rancher v2 Cluster Driver resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_cluster_driver(name="foo")
    ```


    :param _builtins.str name: Name of the cluster driver (string)
    :param _builtins.str url: The URL to download the machine driver binary for 64-bit Linux (string)
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['url'] = url
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('rancher2:index/getClusterDriver:getClusterDriver', __args__, opts=opts, typ=GetClusterDriverResult)
    return __ret__.apply(lambda __response__: GetClusterDriverResult(
        active=pulumi.get(__response__, 'active'),
        actual_url=pulumi.get(__response__, 'actual_url'),
        annotations=pulumi.get(__response__, 'annotations'),
        builtin=pulumi.get(__response__, 'builtin'),
        checksum=pulumi.get(__response__, 'checksum'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        ui_url=pulumi.get(__response__, 'ui_url'),
        url=pulumi.get(__response__, 'url'),
        whitelist_domains=pulumi.get(__response__, 'whitelist_domains')))
