# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 container_resource_limit: Optional[pulumi.Input['ProjectContainerResourceLimitArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_quota: Optional[pulumi.Input['ProjectResourceQuotaArgs']] = None,
                 wait_for_cluster: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id where create project (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Node Pool object (map)
        :param pulumi.Input['ProjectContainerResourceLimitArgs'] container_resource_limit: Default containers resource limits on project (List maxitem:1)
        :param pulumi.Input[_builtins.str] description: A project description (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Node Pool object (map)
        :param pulumi.Input[_builtins.str] name: The name of the project (string)
        :param pulumi.Input['ProjectResourceQuotaArgs'] resource_quota: Resource quota for project. Rancher v2.1.x or higher (list maxitems:1)
        :param pulumi.Input[_builtins.bool] wait_for_cluster: Wait for cluster becomes active. Default `false` (bool)
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if container_resource_limit is not None:
            pulumi.set(__self__, "container_resource_limit", container_resource_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_quota is not None:
            pulumi.set(__self__, "resource_quota", resource_quota)
        if wait_for_cluster is not None:
            pulumi.set(__self__, "wait_for_cluster", wait_for_cluster)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster id where create project (string)
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for Node Pool object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="containerResourceLimit")
    def container_resource_limit(self) -> Optional[pulumi.Input['ProjectContainerResourceLimitArgs']]:
        """
        Default containers resource limits on project (List maxitem:1)
        """
        return pulumi.get(self, "container_resource_limit")

    @container_resource_limit.setter
    def container_resource_limit(self, value: Optional[pulumi.Input['ProjectContainerResourceLimitArgs']]):
        pulumi.set(self, "container_resource_limit", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A project description (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for Node Pool object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceQuota")
    def resource_quota(self) -> Optional[pulumi.Input['ProjectResourceQuotaArgs']]:
        """
        Resource quota for project. Rancher v2.1.x or higher (list maxitems:1)
        """
        return pulumi.get(self, "resource_quota")

    @resource_quota.setter
    def resource_quota(self, value: Optional[pulumi.Input['ProjectResourceQuotaArgs']]):
        pulumi.set(self, "resource_quota", value)

    @_builtins.property
    @pulumi.getter(name="waitForCluster")
    def wait_for_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wait for cluster becomes active. Default `false` (bool)
        """
        return pulumi.get(self, "wait_for_cluster")

    @wait_for_cluster.setter
    def wait_for_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_cluster", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_resource_limit: Optional[pulumi.Input['ProjectContainerResourceLimitArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_quota: Optional[pulumi.Input['ProjectResourceQuotaArgs']] = None,
                 wait_for_cluster: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Node Pool object (map)
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id where create project (string)
        :param pulumi.Input['ProjectContainerResourceLimitArgs'] container_resource_limit: Default containers resource limits on project (List maxitem:1)
        :param pulumi.Input[_builtins.str] description: A project description (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Node Pool object (map)
        :param pulumi.Input[_builtins.str] name: The name of the project (string)
        :param pulumi.Input['ProjectResourceQuotaArgs'] resource_quota: Resource quota for project. Rancher v2.1.x or higher (list maxitems:1)
        :param pulumi.Input[_builtins.bool] wait_for_cluster: Wait for cluster becomes active. Default `false` (bool)
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if container_resource_limit is not None:
            pulumi.set(__self__, "container_resource_limit", container_resource_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_quota is not None:
            pulumi.set(__self__, "resource_quota", resource_quota)
        if wait_for_cluster is not None:
            pulumi.set(__self__, "wait_for_cluster", wait_for_cluster)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for Node Pool object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster id where create project (string)
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="containerResourceLimit")
    def container_resource_limit(self) -> Optional[pulumi.Input['ProjectContainerResourceLimitArgs']]:
        """
        Default containers resource limits on project (List maxitem:1)
        """
        return pulumi.get(self, "container_resource_limit")

    @container_resource_limit.setter
    def container_resource_limit(self, value: Optional[pulumi.Input['ProjectContainerResourceLimitArgs']]):
        pulumi.set(self, "container_resource_limit", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A project description (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for Node Pool object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceQuota")
    def resource_quota(self) -> Optional[pulumi.Input['ProjectResourceQuotaArgs']]:
        """
        Resource quota for project. Rancher v2.1.x or higher (list maxitems:1)
        """
        return pulumi.get(self, "resource_quota")

    @resource_quota.setter
    def resource_quota(self, value: Optional[pulumi.Input['ProjectResourceQuotaArgs']]):
        pulumi.set(self, "resource_quota", value)

    @_builtins.property
    @pulumi.getter(name="waitForCluster")
    def wait_for_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wait for cluster becomes active. Default `false` (bool)
        """
        return pulumi.get(self, "wait_for_cluster")

    @wait_for_cluster.setter
    def wait_for_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_cluster", value)


@pulumi.type_token("rancher2:index/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_resource_limit: Optional[pulumi.Input[Union['ProjectContainerResourceLimitArgs', 'ProjectContainerResourceLimitArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_quota: Optional[pulumi.Input[Union['ProjectResourceQuotaArgs', 'ProjectResourceQuotaArgsDict']]] = None,
                 wait_for_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Project resource. This can be used to create projects for Rancher v2 environments and retrieve their information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Project
        foo = rancher2.Project("foo",
            name="foo",
            cluster_id="<CLUSTER_ID>",
            resource_quota={
                "project_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "2000Mi",
                    "requests_storage": "2Gi",
                },
                "namespace_default_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "500Mi",
                    "requests_storage": "1Gi",
                },
            },
            container_resource_limit={
                "limits_cpu": "20m",
                "limits_memory": "20Mi",
                "requests_cpu": "1m",
                "requests_memory": "1Mi",
            })
        ```

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Project
        foo = rancher2.Project("foo",
            name="foo",
            cluster_id="<CLUSTER_ID>",
            resource_quota={
                "project_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "2000Mi",
                    "requests_storage": "2Gi",
                },
                "namespace_default_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "500Mi",
                    "requests_storage": "1Gi",
                },
            },
            container_resource_limit={
                "limits_cpu": "20m",
                "limits_memory": "20Mi",
                "requests_cpu": "1m",
                "requests_memory": "1Mi",
            })
        ```

        ## Import

        Projects can be imported using the Rancher Project ID

        ```sh
        $ pulumi import rancher2:index/project:Project foo &lt;project_id&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Node Pool object (map)
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id where create project (string)
        :param pulumi.Input[Union['ProjectContainerResourceLimitArgs', 'ProjectContainerResourceLimitArgsDict']] container_resource_limit: Default containers resource limits on project (List maxitem:1)
        :param pulumi.Input[_builtins.str] description: A project description (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Node Pool object (map)
        :param pulumi.Input[_builtins.str] name: The name of the project (string)
        :param pulumi.Input[Union['ProjectResourceQuotaArgs', 'ProjectResourceQuotaArgsDict']] resource_quota: Resource quota for project. Rancher v2.1.x or higher (list maxitems:1)
        :param pulumi.Input[_builtins.bool] wait_for_cluster: Wait for cluster becomes active. Default `false` (bool)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Project resource. This can be used to create projects for Rancher v2 environments and retrieve their information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Project
        foo = rancher2.Project("foo",
            name="foo",
            cluster_id="<CLUSTER_ID>",
            resource_quota={
                "project_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "2000Mi",
                    "requests_storage": "2Gi",
                },
                "namespace_default_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "500Mi",
                    "requests_storage": "1Gi",
                },
            },
            container_resource_limit={
                "limits_cpu": "20m",
                "limits_memory": "20Mi",
                "requests_cpu": "1m",
                "requests_memory": "1Mi",
            })
        ```

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Project
        foo = rancher2.Project("foo",
            name="foo",
            cluster_id="<CLUSTER_ID>",
            resource_quota={
                "project_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "2000Mi",
                    "requests_storage": "2Gi",
                },
                "namespace_default_limit": {
                    "limits_cpu": "2000m",
                    "limits_memory": "500Mi",
                    "requests_storage": "1Gi",
                },
            },
            container_resource_limit={
                "limits_cpu": "20m",
                "limits_memory": "20Mi",
                "requests_cpu": "1m",
                "requests_memory": "1Mi",
            })
        ```

        ## Import

        Projects can be imported using the Rancher Project ID

        ```sh
        $ pulumi import rancher2:index/project:Project foo &lt;project_id&gt;
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_resource_limit: Optional[pulumi.Input[Union['ProjectContainerResourceLimitArgs', 'ProjectContainerResourceLimitArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_quota: Optional[pulumi.Input[Union['ProjectResourceQuotaArgs', 'ProjectResourceQuotaArgsDict']]] = None,
                 wait_for_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["annotations"] = annotations
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["container_resource_limit"] = container_resource_limit
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_quota"] = resource_quota
            __props__.__dict__["wait_for_cluster"] = wait_for_cluster
        super(Project, __self__).__init__(
            'rancher2:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            container_resource_limit: Optional[pulumi.Input[Union['ProjectContainerResourceLimitArgs', 'ProjectContainerResourceLimitArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_quota: Optional[pulumi.Input[Union['ProjectResourceQuotaArgs', 'ProjectResourceQuotaArgsDict']]] = None,
            wait_for_cluster: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for Node Pool object (map)
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id where create project (string)
        :param pulumi.Input[Union['ProjectContainerResourceLimitArgs', 'ProjectContainerResourceLimitArgsDict']] container_resource_limit: Default containers resource limits on project (List maxitem:1)
        :param pulumi.Input[_builtins.str] description: A project description (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for Node Pool object (map)
        :param pulumi.Input[_builtins.str] name: The name of the project (string)
        :param pulumi.Input[Union['ProjectResourceQuotaArgs', 'ProjectResourceQuotaArgsDict']] resource_quota: Resource quota for project. Rancher v2.1.x or higher (list maxitems:1)
        :param pulumi.Input[_builtins.bool] wait_for_cluster: Wait for cluster becomes active. Default `false` (bool)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["container_resource_limit"] = container_resource_limit
        __props__.__dict__["description"] = description
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_quota"] = resource_quota
        __props__.__dict__["wait_for_cluster"] = wait_for_cluster
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations for Node Pool object (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster id where create project (string)
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="containerResourceLimit")
    def container_resource_limit(self) -> pulumi.Output[Optional['outputs.ProjectContainerResourceLimit']]:
        """
        Default containers resource limits on project (List maxitem:1)
        """
        return pulumi.get(self, "container_resource_limit")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A project description (string)
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels for Node Pool object (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceQuota")
    def resource_quota(self) -> pulumi.Output[Optional['outputs.ProjectResourceQuota']]:
        """
        Resource quota for project. Rancher v2.1.x or higher (list maxitems:1)
        """
        return pulumi.get(self, "resource_quota")

    @_builtins.property
    @pulumi.getter(name="waitForCluster")
    def wait_for_cluster(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Wait for cluster becomes active. Default `false` (bool)
        """
        return pulumi.get(self, "wait_for_cluster")

