# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SecretV2Args', 'SecretV2']

@pulumi.input_type
class SecretV2Args:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 data: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretV2 resource.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id of the secret V2 (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: The data of the secret v2 (map)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the secret v2 (map)
        :param pulumi.Input[_builtins.bool] immutable: If set to true, any secret update will remove and recreate the secret. This is a beta field enabled by k8s `ImmutableEphemeralVolumes` feature gate. Default: `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the secret v2 (map)
        :param pulumi.Input[_builtins.str] name: The name of the secret v2 (string)
        :param pulumi.Input[_builtins.str] namespace: The namespaces of the secret v2. Default: `default` (string)
        :param pulumi.Input[_builtins.str] type: The type of the k8s secret, used to facilitate programmatic handling of secret data, [More info](https://github.com/kubernetes/api/blob/release-1.20/core/v1/types.go#L5772) about k8s secret types and expected format.  Default: `Opaque` (string)
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "data", data)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if immutable is not None:
            pulumi.set(__self__, "immutable", immutable)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster id of the secret V2 (string)
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        The data of the secret v2 (map)
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the secret v2 (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, any secret update will remove and recreate the secret. This is a beta field enabled by k8s `ImmutableEphemeralVolumes` feature gate. Default: `false` (bool)
        """
        return pulumi.get(self, "immutable")

    @immutable.setter
    def immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immutable", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the secret v2 (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the secret v2 (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespaces of the secret v2. Default: `default` (string)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the k8s secret, used to facilitate programmatic handling of secret data, [More info](https://github.com/kubernetes/api/blob/release-1.20/core/v1/types.go#L5772) about k8s secret types and expected format.  Default: `Opaque` (string)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SecretV2State:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_version: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretV2 resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the secret v2 (map)
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id of the secret V2 (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: The data of the secret v2 (map)
        :param pulumi.Input[_builtins.bool] immutable: If set to true, any secret update will remove and recreate the secret. This is a beta field enabled by k8s `ImmutableEphemeralVolumes` feature gate. Default: `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the secret v2 (map)
        :param pulumi.Input[_builtins.str] name: The name of the secret v2 (string)
        :param pulumi.Input[_builtins.str] namespace: The namespaces of the secret v2. Default: `default` (string)
        :param pulumi.Input[_builtins.str] resource_version: (Computed) The k8s resource version (string)
        :param pulumi.Input[_builtins.str] type: The type of the k8s secret, used to facilitate programmatic handling of secret data, [More info](https://github.com/kubernetes/api/blob/release-1.20/core/v1/types.go#L5772) about k8s secret types and expected format.  Default: `Opaque` (string)
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if immutable is not None:
            pulumi.set(__self__, "immutable", immutable)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the secret v2 (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster id of the secret V2 (string)
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The data of the secret v2 (map)
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, any secret update will remove and recreate the secret. This is a beta field enabled by k8s `ImmutableEphemeralVolumes` feature gate. Default: `false` (bool)
        """
        return pulumi.get(self, "immutable")

    @immutable.setter
    def immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immutable", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the secret v2 (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the secret v2 (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespaces of the secret v2. Default: `default` (string)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The k8s resource version (string)
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_version", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the k8s secret, used to facilitate programmatic handling of secret data, [More info](https://github.com/kubernetes/api/blob/release-1.20/core/v1/types.go#L5772) about k8s secret types and expected format.  Default: `Opaque` (string)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("rancher2:index/secretV2:SecretV2")
class SecretV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Rancher Secret v2 resource. This can be used to create k8s secrets for Rancher v2 environments and retrieve their information. Secret v2 resource is available at Rancher v2.5.x and above.

        ## Import

        V2 secrets can be imported using the Rancher cluster ID, Secret V2 namespace and name.

        ```sh
        $ pulumi import rancher2:index/secretV2:SecretV2 foo &lt;CLUSTER_ID&gt;.&lt;SECRET_V2_NAMESPACE&gt;/&lt;SECRET_V2_NAME&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the secret v2 (map)
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id of the secret V2 (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: The data of the secret v2 (map)
        :param pulumi.Input[_builtins.bool] immutable: If set to true, any secret update will remove and recreate the secret. This is a beta field enabled by k8s `ImmutableEphemeralVolumes` feature gate. Default: `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the secret v2 (map)
        :param pulumi.Input[_builtins.str] name: The name of the secret v2 (string)
        :param pulumi.Input[_builtins.str] namespace: The namespaces of the secret v2. Default: `default` (string)
        :param pulumi.Input[_builtins.str] type: The type of the k8s secret, used to facilitate programmatic handling of secret data, [More info](https://github.com/kubernetes/api/blob/release-1.20/core/v1/types.go#L5772) about k8s secret types and expected format.  Default: `Opaque` (string)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher Secret v2 resource. This can be used to create k8s secrets for Rancher v2 environments and retrieve their information. Secret v2 resource is available at Rancher v2.5.x and above.

        ## Import

        V2 secrets can be imported using the Rancher cluster ID, Secret V2 namespace and name.

        ```sh
        $ pulumi import rancher2:index/secretV2:SecretV2 foo &lt;CLUSTER_ID&gt;.&lt;SECRET_V2_NAMESPACE&gt;/&lt;SECRET_V2_NAME&gt;
        ```

        :param str resource_name: The name of the resource.
        :param SecretV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretV2Args.__new__(SecretV2Args)

            __props__.__dict__["annotations"] = annotations
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = None if data is None else pulumi.Output.secret(data)
            __props__.__dict__["immutable"] = immutable
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["type"] = type
            __props__.__dict__["resource_version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["data"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretV2, __self__).__init__(
            'rancher2:index/secretV2:SecretV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            immutable: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            resource_version: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretV2':
        """
        Get an existing SecretV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the secret v2 (map)
        :param pulumi.Input[_builtins.str] cluster_id: The cluster id of the secret V2 (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: The data of the secret v2 (map)
        :param pulumi.Input[_builtins.bool] immutable: If set to true, any secret update will remove and recreate the secret. This is a beta field enabled by k8s `ImmutableEphemeralVolumes` feature gate. Default: `false` (bool)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the secret v2 (map)
        :param pulumi.Input[_builtins.str] name: The name of the secret v2 (string)
        :param pulumi.Input[_builtins.str] namespace: The namespaces of the secret v2. Default: `default` (string)
        :param pulumi.Input[_builtins.str] resource_version: (Computed) The k8s resource version (string)
        :param pulumi.Input[_builtins.str] type: The type of the k8s secret, used to facilitate programmatic handling of secret data, [More info](https://github.com/kubernetes/api/blob/release-1.20/core/v1/types.go#L5772) about k8s secret types and expected format.  Default: `Opaque` (string)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretV2State.__new__(_SecretV2State)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["data"] = data
        __props__.__dict__["immutable"] = immutable
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource_version"] = resource_version
        __props__.__dict__["type"] = type
        return SecretV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations for the secret v2 (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster id of the secret V2 (string)
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The data of the secret v2 (map)
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def immutable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, any secret update will remove and recreate the secret. This is a beta field enabled by k8s `ImmutableEphemeralVolumes` feature gate. Default: `false` (bool)
        """
        return pulumi.get(self, "immutable")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels for the secret v2 (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the secret v2 (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespaces of the secret v2. Default: `default` (string)
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The k8s resource version (string)
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the k8s secret, used to facilitate programmatic handling of secret data, [More info](https://github.com/kubernetes/api/blob/release-1.20/core/v1/types.go#L5772) about k8s secret types and expected format.  Default: `Opaque` (string)
        """
        return pulumi.get(self, "type")

