"""
PR Indexer package.

This package contains classes for indexing GitHub pull requests,
separated by responsibility for better maintainability.
"""

from .cli import main
from .github_api_client import GitHubAPIClient
from .indexer import PRIndexer
from .line_mapper import LineMapper
from .pr_index_builder import PRIndexBuilder

__all__ = [
    "GitHubAPIClient",
    "PRIndexBuilder",
    "LineMapper",
    "PRIndexer",
    "main",
]
