import os
from dotenv import load_dotenv
load_dotenv()

hex_color_dict = {
    "red": "FF0000",
    "green": "00FF00",
    "blue": "0000FF",
    "yellow": "FFFF00",
    "purple": "800080",
    "cyan": "00FFFF",
    "magenta": "FF00FF",
    "lime": "00FF00",
    "pink": "FFC0CB",
    "teal": "008080",
    "lavender": "E6E6FA",
    "brown": "A52A2A",
    "beige": "F5F5DC",
    "maroon": "800000",
    "mint": "98FF98",
    "olive": "808000",
    "coral": "FF7F50",
    "navy": "000080",
    "grey": "808080",
    "white": "FFFFFF",
    "black": "000000",
    "orange": "FFA500",
    "indigo": "4B0082",
    "violet": "EE82EE",
    "gold": "FFD700",
    "silver": "C0C0C0",
    "rose": "FF007F",
    "emerald": "50C878",
    "ruby": "E0115F",
    "sapphire": "0F52BA",
    "amber": "FFBF00",
    "crimson": "DC143C",
    "darkgreen": "006400",
    "darkblue": "00008B",
    "darkred": "8B0000",
    "lightgreen": "90EE90",
    "lightblue": "ADD8E6",
    "lightyellow": "FFFFE0",
    "lightpink": "FFB6C1",
    "darkpurple": "800080",
    "lightpurple": "D8BFD8",
    "turquoise": "40E0D0",
    "tan": "D2B48C",
    "lightgrey": "D3D3D3",
    "darkgrey": "A9A9A9",
    "ivory": "FFFFF0",
    "khaki": "F0E68C",
    "lavenderblush": "FFF0F5",
    "lightcoral": "F08080",
    "salmon": "FA8072",
    "darksalmon": "E9967A",
    "lightsalmon": "FFA07A",
    "darkorange": "FF8C00",
    "linen": "FAF0E6",
    "peachpuff": "FFDAB9",
    "seashell": "FFF5EE",
    "snow": "FFFAFA",
    "wheat": "F5DEB3",
    "mistyrose": "FFE4E1",
    "azure": "F0FFFF",
    "aliceblue": "F0F8FF",
    "honeydew": "F0FFF0",
    "mintcream": "F5FFFA"
}


all_forex_pairs = {
'United States/Canada': 'USD/CAD',
'Japan/Euro': 'JPY/EUR',
'Denmark/Canada': 'DKK/CAD',
'Czech Republic/Japan': 'CZK/JPY',
'Euro/China': 'EUR/CNH',
'China/Singapore': 'CNY/SGD',
'Norway/United States': 'NOK/USD',
'Denmark/Mexico': 'DKK/MXN',
'Switzerland/South Africa': 'CHF/ZAR',
'Brazil/Japan': 'BRL/JPY',
'New Zealand/Indonesia': 'NZD/IDR',
'Bermuda/Canada': 'BMD/CAD',
'Silver/Turkey': 'XAG/TRY',
'Australia/South Africa': 'AUD/ZAR',
'Switzerland/Poland': 'CHF/PLN',
'Hong Kong/India': 'HKD/INR',
'Australia/New Zealand': 'AUD/NZD',
'South Africa/United Kingdom': 'ZAR/GBP',
'Malaysia/Australia': 'MYR/AUD',
'India/Taiwan': 'INR/TWD',
'South Korea/Switzerland': 'KRW/CHF',
'New Zealand/Switzerland': 'NZD/CHF',
'Israel/Japan': 'ILS/JPY',
'United States/South Africa': 'USD/ZAR',
'Hungary/Denmark': 'HUF/DKK',
'United States/China': 'USD/CNY',
'British Pound/Canada': 'GBP/CAD',
'Gold/Turkey': 'XAU/TRY',
'Mexican Peso/United States': 'MXN/USD',
'Hong Kong/Thailand': 'HKD/THB',
'Japanese Yen/British Pound': 'JPY/GBP',
'Euro/Singapore': 'EUR/SGD',
'Chilean Peso/British Pound': 'CLP/GBP',
'Colombian Peso/Mexican Peso': 'COP/MXN',
'Colombian Peso/United States': 'COP/USD',
'Brazilian Real/Mexican Peso': 'BRL/MXN',
'New Zealand/Czech Republic': 'NZD/CZK',
'South Korean Won/Australia': 'KRW/AUD',
'New Zealand/Hong Kong': 'NZD/HKD',
'British Pound/Costa Rican Colón': 'GBP/CRC',
'Turkish Lira/United States': 'TRY/USD',
'Silver/Russian Ruble': 'XAG/RUB',
'Silver/Euro': 'XAG/EUR',
'Australian Dollar/Poland': 'AUD/PLN',
'Australian Dollar/China': 'AUD/CNH',
'Euro/Australian Dollar': 'EUR/AUD',
'Japanese Yen/Taiwan': 'JPY/TWD',
'South African Rand/Thailand': 'ZAR/THB',
'New Zealand/Thailand': 'NZD/THB',
'British Pound/Indonesian Rupiah': 'GBP/IDR',
'Australian Dollar/Denmark': 'AUD/DKK',
'Silver/South African Rand': 'XAG/ZAR',
'Silver/Chinese Yuan': 'XAG/CNY',
'Australian Dollar/Hungary': 'AUD/HUF',
'Bulgarian Lev/Chinese Yuan': 'BGN/CNY',
'Singapore Dollar/British Pound': 'SGD/GBP',
'Hong Kong Dollar/Switzerland': 'HKD/CHF',
'Malaysian Ringgit/Singapore Dollar': 'MYR/SGD',
'Silver/United States Dollar': 'XAG/USD',
'United States Dollar/Taiwan Dollar': 'USD/TWD',
'Swedish Krona/Danish Krone': 'SEK/DKK',
'Bermuda/British Pound': 'BMD/GBP',
'British Pound/Euro': 'GBP/EUR',
'Moroccan Dirham/Australian Dollar': 'MAD/AUD',
'Israeli Shekel/Norwegian Krone': 'ILS/NOK',
'British Pound/Singapore Dollar': 'GBP/SGD',
'Singapore Dollar/South African Rand': 'SGD/ZAR',
'Indian Rupee/Singapore Dollar': 'INR/SGD',
'Japanese Yen/Indonesian Rupiah': 'JPY/IDR',
'Japanese Yen/Polish Złoty': 'JPY/PLN',
'British Pound/Danish Krone': 'GBP/DKK',
'Polish Złoty/Hungarian Forint': 'PLN/HUF',
'Turkish Lira/South African Rand': 'TRY/ZAR',
'South African Rand/Egyptian Pound': 'ZAR/EGP',
'Gold/South Korean Won': 'XAU/KRW',
'Egyptian Pound/Japanese Yen': 'EGP/JPY',
'South African Rand/Indian Rupee': 'ZAR/INR',
'Australian Dollar/Indian Rupee': 'AUD/INR',
'Gold/Mexican Peso': 'XAU/MXN',
'Japanese Yen/Canadian Dollar': 'JPY/CAD',
'Gold/British Pound': 'XAU/GBP',
'Danish Krone/Polish Złoty': 'DKK/PLN',
'South African Rand/Singapore Dollar': 'ZAR/SGD',
'Chinese Yuan/Swiss Franc': 'CNY/CHF',
'Chilean Peso/Australian Dollar': 'CLP/AUD',
'Japanese Yen/Indian Rupee': 'JPY/INR',
'Swiss Franc/Hong Kong Dollar': 'CHF/HKD',
'Hong Kong Dollar/Argentine Peso': 'HKD/ARS',
'Swiss Franc/Singapore Dollar': 'CHF/SGD',
'Czech Koruna/United States Dollar': 'CZK/USD',
'Chinese Yuan/South African Rand': 'CNY/ZAR',
'New Zealand/Euro': 'NZD/EUR',
'Australian Dollar/Swedish Krona': 'AUD/SEK',
'Swedish Krona/Polish Złoty': 'SEK/PLN',
'New Zealand/Indian Rupee': 'NZD/INR',
'South African Rand/Swiss Franc': 'ZAR/CHF',
'Indian Rupee/Swedish Krona': 'INR/SEK',
'Polish Złoty/British Pound': 'PLN/GBP',
'Danish Krone/Pakistani Rupee': 'DKK/PKR',
'Swedish Krona/British Pound': 'SEK/GBP',
'Canadian Dollar/Swiss Franc': 'CAD/CHF',
'New Zealand/Polish Złoty': 'NZD/PLN',
'South Korean Won/United States Dollar': 'KRW/USD',
'United States Dollar/Hong Kong Dollar': 'USD/HKD',
'Danish Krone/Thai Baht': 'DKK/THB',
'Gold/Thai Baht': 'XAU/THB',
'Philippine Peso/Danish Krone': 'PHP/DKK',
'Russian Ruble/Swiss Franc': 'RUB/CHF',
'Indian Rupee/Euro': 'INR/EUR',
'Argentine Peso/Euro': 'ARS/EUR',
'Polish Złoty/Czech Koruna': 'PLN/CZK',
'Norwegian Krone/Swedish Krona': 'NOK/SEK',
'Malaysian Ringgit/Swiss Franc': 'MYR/CHF',
'Canadian Dollar/United Arab Emirates Dirham': 'CAD/AED',
'Danish Krone/Swiss Franc': 'DKK/CHF',
'Silver/South Korean Won': 'XAG/KRW',
'Japanese Yen/Thai Baht': 'JPY/THB',
'Silver/Brazilian Real': 'XAG/BRL',
'Swiss Franc/Japanese Yen': 'CHF/JPY',
'Singapore Dollar/Indian Rupee': 'SGD/INR',
'Argentine Peso/Hong Kong Dollar': 'ARS/HKD',
'United States Dollar/Swedish Krona': 'USD/SEK',
'Cayman Islands Dollar/Canadian Dollar': 'KYD/CAD',
'British Pound/New Zealand Dollar': 'GBP/NZD',
'Taiwan Dollar/Danish Krone': 'TWD/DKK',
'Taiwan Dollar/Thai Baht': 'TWD/THB',
'Australian Dollar/Czech Koruna': 'AUD/CZK',
'Swiss Franc/United States Dollar': 'CHF/USD',
'United States Dollar/Danish Krone': 'USD/DKK',
'South African Rand/Philippine Peso': 'ZAR/PHP',
'Euro/Swiss Franc': 'EUR/CHF',
'United States Dollar/Icelandic Króna': 'USD/ISK',
'South African Rand/Botswana Pula': 'ZAR/BWP',
'Australian Dollar/Euro': 'AUD/EUR',
'Japanese Yen/Norwegian Krone': 'JPY/NOK',
'Swiss Franc/Romanian Leu': 'CHF/RON',
'Euro/British Pound': 'EUR/GBP',
'South Korean Won/Singapore Dollar': 'KRW/SGD',
'Peruvian Sol/Canadian Dollar': 'PEN/CAD',
'New Zealand Dollar/Japanese Yen': 'NZD/JPY',
'Malaysian Ringgit/South African Rand': 'MYR/ZAR',
'Swedish Krona/South African Rand': 'SEK/ZAR',
'Cypriot Pound/South African Rand': 'CYP/ZAR',
'Turkish Lira/Japanese Yen': 'TRY/JPY',
'British Pound/Israeli Shekel': 'GBP/ILS',
'South African Rand/New Zealand Dollar': 'ZAR/NZD',
'Turkish Lira/Polish Złoty': 'TRY/PLN',
'South African Rand/United States Dollar': 'ZAR/USD',
'Nigerian Naira/Japanese Yen': 'NGN/JPY',
'Silver/Hong Kong Dollar': 'XAG/HKD',
'Hong Kong Dollar/New Zealand Dollar': 'HKD/NZD',
'Swiss Franc/Swedish Krona': 'CHF/SEK',
'Japanese Yen/Australian Dollar': 'JPY/AUD',
'British Pound/Honduran Lempira': 'GBP/HNL',
'Singapore Dollar/Danish Krone': 'SGD/DKK',
'Malaysian Ringgit/Canadian Dollar': 'MYR/CAD',
'Czech Koruna/Canadian Dollar': 'CZK/CAD',
'Gold/Chinese Yuan': 'XAU/CNY',
'Gold/Canadian Dollar': 'XAU/CAD',
'Australian Dollar/British Pound': 'AUD/GBP',
'Swedish Krona/Swiss Franc': 'SEK/CHF',
'Australian Dollar/Hong Kong Dollar': 'AUD/HKD',
'South Korean Won/British Pound': 'KRW/GBP',
'Taiwan Dollar/Australian Dollar': 'TWD/AUD',
'Taiwan Dollar/Canadian Dollar': 'TWD/CAD',
'Malaysian Ringgit/Indonesian Rupiah': 'MYR/IDR',
'South Korean Won/Hong Kong Dollar': 'KRW/HKD',
'Taiwan Dollar/South African Rand': 'TWD/ZAR',
'New Zealand Dollar/Swedish Krona': 'NZD/SEK',
'Australian Dollar/Moroccan Dirham': 'AUD/MAD',
'New Zealand Dollar/United States Dollar': 'NZD/USD',
'Taiwan Dollar/Swedish Krona': 'TWD/SEK',
'United States Dollar/Indian Rupee': 'USD/INR',
'Norwegian Krone/Danish Krone': 'NOK/DKK',
'Czech Koruna/Mexican Peso': 'CZK/MXN',
'Thai Baht/Indonesian Rupiah': 'THB/IDR',
'United States Dollar/Egyptian Pound': 'USD/EGP',
'Canadian Dollar/Turkish Lira': 'CAD/TRY',
'Indonesian Rupiah/South Korean Won': 'IDR/KRW',
'South African Rand/Swedish Krona': 'ZAR/SEK',
'Israeli Shekel/Swiss Franc': 'ILS/CHF',
'British Pound/Icelandic Króna': 'GBP/ISK',
'Indian Rupee/Thai Baht': 'INR/THB',
'Danish Krone/Czech Koruna': 'DKK/CZK',
'Euro/Mexican Peso': 'EUR/MXN',
'Silver/Swiss Franc': 'XAG/GBP',
'Silver/Australian Dollar': 'XAG/AUD',
'Thai Baht/Taiwan Dollar': 'THB/TWD',
'South Korean Won/Canadian Dollar': 'KRW/CAD',
'New Zealand Dollar/Danish Krone': 'NZD/DKK',
'British Pound/Hungarian Forint': 'GBP/HUF',
'Chinese Yuan/United States Dollar': 'CNH/USD',
'Switzerland/Thailand': 'CHF/THB',
'Australia/South Korea': 'AUD/KRW',
'Czech Republic/Eurozone': 'CZK/EUR',
'Switzerland/Taiwan': 'CHF/TWD',
'Denmark/United Kingdom': 'DKK/GBP',
'Gold/Eurozone': 'XAU/EUR',
'Thai Baht/New Zealand Dollar': 'THB/NZD',
'Japanese Yen/Czech Koruna': 'JPY/CZK',
'Canadian Dollar/Hong Kong Dollar': 'CAD/HKD',
'British Pound/Norwegian Krone': 'GBP/NOK',
'South African Rand/Australian Dollar': 'ZAR/AUD',
'South African Rand/Czech Koruna': 'ZAR/CZK',
'South African Rand/Pakistani Rupee': 'ZAR/PKR',
'British Pound/Czech Koruna': 'GBP/CZK',
'Chinese Yuan/Japanese Yen': 'CNH/JPY',
'United States Dollar/Thai Baht': 'USD/THB',
'Danish Krone/New Zealand Dollar': 'DKK/NZD',
'British Pound/United States Dollar': 'GBP/USD',
'New Taiwan Dollar/Indonesian Rupiah': 'TWD/IDR',
'Singapore Dollar/Mexican Peso': 'SGD/MXN',
'Silver Ounce/Indian Rupee': 'XAG/INR',
'Norwegian Krone/British Pound': 'NOK/GBP',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
'United States Dollar/Australian Dollar': 'USD/AUD',
'Swiss Franc/Hungarian Forint': 'CHF/HUF',
'Bulgarian Lev/Canadian Dollar': 'BGN/CAD',
'Singapore Dollar/Australian Dollar': 'SGD/AUD',
'Euro/Turkish Lira': 'EUR/TRY',
'Canadian Dollar/Norwegian Krone': 'CAD/NOK',
'Canadian Dollar/New Zealand Dollar': 'CAD/NZD',
'South African Rand/Norwegian Krone': 'ZAR/NOK',
'Chilean Peso/Swiss Franc': 'CLP/CHF',
'South Korean Won/Brazilian Real': 'KRW/BRL',
'Thai Baht/South Korean Won': 'THB/KRW',
'Mexican Peso/Australian Dollar': 'MXN/AUD',
'Silver Ounce/Canadian Dollar': 'XAG/CAD',
'British Pound/Chinese Yuan': 'GBP/CNH',
'Norwegian Krone/Indian Rupee': 'NOK/INR',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
'United States Dollar/Australian Dollar': 'USD/AUD',
'Swiss Franc/Hungarian Forint': 'CHF/HUF',
'Bulgarian Lev/Canadian Dollar': 'BGN/CAD',
'Singapore Dollar/Australian Dollar': 'SGD/AUD',
'Euro/Turkish Lira': 'EUR/TRY',
'Canadian Dollar/Norwegian Krone': 'CAD/NOK',
'Canadian Dollar/New Zealand Dollar': 'CAD/NZD',
'South African Rand/Norwegian Krone': 'ZAR/NOK',
'Chilean Peso/Swiss Franc': 'CLP/CHF',
'South Korean Won/Brazilian Real': 'KRW/BRL',
'Thai Baht/South Korean Won': 'THB/KRW',
'Mexican Peso/Australian Dollar': 'MXN/AUD',
'Silver Ounce/Canadian Dollar': 'XAG/CAD',
'British Pound/Chinese Yuan': 'GBP/CNH',
'Norwegian Krone/Indian Rupee': 'NOK/INR',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
    'Indian Rupee/Swiss Franc': 'INR/CHF',
    'Swiss Franc/Australian Dollar': 'CHF/AUD',
    'Danish Krone/Swedish Krona': 'DKK/SEK',
    'United Arab Emirates Dirham/South African Rand': 'AED/ZAR',
    'New Taiwan Dollar/New Zealand Dollar': 'TWD/NZD',
    'Singapore Dollar/Argentine Peso': 'SGD/ARS',
    'Australian Dollar/Swiss Franc': 'AUD/CHF',
    'Swedish Krona/Israeli New Shekel': 'SEK/ILS',
    'Gold (XAU)/Argentine Peso': 'XAU/ARS',
    'Euro/Danish Krone': 'EUR/DKK',
    'Peruvian Sol/British Pound Sterling': 'PEN/GBP',
    'Singapore Dollar/Turkish Lira': 'SGD/TRY',
    'New Taiwan Dollar/Chinese Yuan': 'TWD/CNY',
    'British Pound Sterling/Chilean Peso': 'GBP/CLP',
    'Argentine Peso/Singapore Dollar': 'ARS/SGD',
    'Nigerian Naira/South African Rand': 'NGN/ZAR',
    'Czech Koruna/Swiss Franc': 'CZK/CHF',
    'Euro/Canadian Dollar': 'EUR/CAD',
    'Euro/Polish Złoty': 'EUR/PLN',
    'Nigerian Naira/British Pound Sterling': 'NGN/GBP',
    'Singapore Dollar/Hong Kong Dollar': 'SGD/HKD',
    'Danish Krone/Indian Rupee': 'DKK/INR',
    'Singapore Dollar/Euro': 'SGD/EUR',
    'Canadian Dollar/South Korean Won': 'CAD/KRW',
    'Australian Dollar/United States Dollar': 'AUD/USD',
    'Mexican Peso/Japanese Yen': 'MXN/JPY',
    'Brazilian Real/Swiss Franc': 'BRL/CHF',
    'Danish Krone/Hungarian Forint': 'DKK/HUF',
    'Chinese Yuan/United States Dollar': 'CNY/USD',
    'South African Rand/Euro': 'ZAR/EUR',
    'Euro/Czech Koruna': 'EUR/CZK',
    'Canadian Dollar/Australian Dollar': 'CAD/AUD',
    'Canadian Dollar/Kuwaiti Dinar': 'CAD/KWD',
    'New Zealand Dollar/Mexican Peso': 'NZD/MXN',
    'Nicaraguan Córdoba/British Pound Sterling': 'NIO/GBP',
    'South Korean Won/Swedish Krona': 'KRW/SEK',
    'Danish Krone/Hong Kong Dollar': 'DKK/HKD',
    'Canadian Dollar/New Taiwan Dollar': 'CAD/TWD',
    'Norwegian Krone/Polish Złoty': 'NOK/PLN',
    'New Taiwan Dollar/Swiss Franc': 'TWD/CHF',
    'New Zealand Dollar/British Pound Sterling': 'NZD/GBP',
    'Canadian Dollar/Danish Krone': 'CAD/DKK',
    'Canadian Dollar/Thai Baht': 'CAD/THB',
    'CFP Franc/British Pound Sterling': 'XPF/GBP',
    'Australian Dollar/Singapore Dollar': 'AUD/SGD',
    'Indonesian Rupiah/Indian Rupee': 'IDR/INR',
    'Polish Złoty/Mexican Peso': 'PLN/MXN',
    'British Pound Sterling/Mexican Peso': 'GBP/MXN',
    'Thai Baht/Swiss Franc': 'THB/CHF',
    'Euro/New Taiwan Dollar': 'EUR/TWD',
    'Australian Dollar/Japanese Yen': 'AUD/JPY',
    'Danish Krone/Norwegian Krone': 'DKK/NOK',
    'South African Rand/Hong Kong Dollar': 'ZAR/HKD',
    'British Pound Sterling/Indian Rupee': 'GBP/INR',
    'Egyptian Pound/Euro': 'EGP/EUR',
    'Gold (XAU)/Indian Rupee': 'XAU/INR',
    'New Taiwan Dollar/Hong Kong Dollar': 'TWD/HKD',
    'Argentine Peso/Brazilian Real': 'ARS/BRL',
    'United States Dollar/Singapore Dollar': 'USD/SGD',
    'South Korean Won/Chinese Yuan': 'KRW/CNY',
    'Costa Rican Colón/British Pound Sterling': 'CRC/GBP',
    'Mexican Peso/South African Rand': 'MXN/ZAR',
    'Thai Baht/Hong Kong Dollar': 'THB/HKD',
    'British Pound Sterling/East Caribbean Dollar': 'GBP/XCD',
    'Gold (XAU)/Japanese Yen': 'XAU/JPY',
    'Canadian Dollar/Euro': 'CAD/EUR',
    'Pakistani Rupee/South African Rand': 'PKR/ZAR',
    'Mexican Peso/Polish Złoty': 'MXN/PLN',
    'Australian Dollar/Bulgarian Lev': 'AUD/BGN',
    'Indian Rupee/United States Dollar': 'INR/USD',
    'South African Rand/New Taiwan Dollar': 'ZAR/TWD',
    'New Zealand Dollar/Australian Dollar': 'NZD/AUD',
    'Argentine Peso/Australian Dollar': 'ARS/AUD',
    'Qatari Rial/South African Rand': 'QAR/ZAR',
    'Hungarian Forint/Canadian Dollar': 'HUF/CAD',
    'Mexican Peso/Canadian Dollar': 'MXN/CAD',
    'Swedish Krona/Australian Dollar': 'SEK/AUD',
    'South African Rand/Romanian Leu': 'ZAR/RON',
    'Malaysian Ringgit/Indian Rupee': 'MYR/INR',
    'Honduran Lempira/British Pound Sterling': 'HNL/GBP',
    'Polish Złoty/Japanese Yen': 'PLN/JPY',
    'United States Dollar/Euro': 'USD/EUR',
    'Singapore Dollar/Indonesian Rupiah': 'SGD/IDR',
    'Gold (XAU)/Saudi Riyal': 'XAU/SAR',
    'Israeli New Shekel/Australian Dollar': 'ILS/AUD',
    'Canadian Dollar/British Pound Sterling': 'CAD/GBP',
    'United States Dollar/British Pound Sterling': 'USD/GBP',
    'Thai Baht/Singapore Dollar': 'THB/SGD',
    'Indian Rupee/South Korean Won': 'INR/KRW',
    'Indian Rupee/New Zealand Dollar': 'INR/NZD',
    'Indian Rupee/Australian Dollar': 'INR/AUD',
    'British Pound Sterling/Bermudian Dollar': 'GBP/BMD',
    'Australian Dollar/Philippine Peso': 'AUD/PHP',
    'Hungarian Forint/South African Rand': 'HUF/ZAR',
    'United States Dollar/Philippine Peso': 'USD/PHP',
    'Swedish Krona/Norwegian Krone': 'SEK/NOK',
    'Chinese Yuan/British Pound Sterling': 'CNY/GBP',
    'Canadian Dollar/Hungarian Forint': 'CAD/HUF',
    'Icelandic Króna/Swiss Franc': 'ISK/CHF',
    'Bulgarian Lev/Australian Dollar': 'BGN/AUD',
    'Indian Rupee/Canadian Dollar': 'INR/CAD',
    'Euro/New Zealand Dollar': 'EUR/NZD',
    'Thai Baht/Canadian Dollar': 'THB/CAD',
    'Singapore Dollar/South Korean Won': 'SGD/KRW',
    'Swiss Franc/Euro': 'CHF/EUR',
    'Gold (XAU)/South African Rand': 'XAU/ZAR',
    'Australian Dollar/Chilean Peso': 'AUD/CLP',
    'Swiss Franc/Chilean Peso': 'CHF/CLP',
    'Vietnamese Đồng/Euro': 'VND/EUR',
    'Swiss Franc/Pakistani Rupee': 'CHF/PKR',
    'Swiss Franc/South Korean Won': 'CHF/KRW',
    'Argentine Peso/Japanese Yen': 'ARS/JPY',
    'Sri Lankan Rupee/South African Rand': 'LKR/ZAR',
    'Japanese Yen/South African Rand': 'JPY/ZAR',
    'Thai Baht/South African Rand': 'THB/ZAR',
    'Australian Dollar/Israeli New Shekel': 'AUD/ILS',
    'Swedish Krona/Euro': 'SEK/EUR',
    'South African Rand/Indonesian Rupiah': 'ZAR/IDR',
    'United States Dollar/Swiss Franc': 'USD/CHF',
    'Australian Dollar/Thai Baht': 'AUD/THB',
    'Euro/Argentine Peso': 'EUR/ARS',
    'South African Rand/Argentine Peso': 'ZAR/ARS',
    'Norwegian Krone/Swiss Franc': 'NOK/CHF',
    'New Taiwan Dollar/South Korean Won': 'TWD/KRW',
    'Singapore Dollar/Canadian Dollar': 'SGD/CAD',
    'Canadian Dollar/Singapore Dollar': 'CAD/SGD',
    'British Pound Sterling/Polish Złoty': 'GBP/PLN',
    'Vietnamese Đồng/Canadian Dollar': 'VND/CAD',
    'Canadian Dollar/Mexican Peso': 'CAD/MXN',
    'Polish Złoty/Swedish Krona': 'PLN/SEK',
    'British Pound Sterling/Argentine Peso': 'GBP/ARS',
    'Chinese Yuan/Canadian Dollar': 'CNY/CAD',
    'British Pound Sterling/Australian Dollar': 'GBP/AUD',
    'Thai Baht/Indian Rupee': 'THB/INR',
    'Swiss Franc/British Pound Sterling': 'CHF/GBP',
    'Singapore Dollar/United States Dollar': 'SGD/USD',
    'Japanese Yen/United States Dollar': 'JPY/USD',
    'Peruvian Sol/Argentine Peso': 'PEN/ARS',
    'United States Dollar/Polish Złoty': 'USD/PLN',
    'Australian Dollar/Norwegian Krone': 'AUD/NOK',
    'South African Rand/Nigerian Naira': 'ZAR/NGN',
    'Canadian Dollar/Swedish Krona': 'CAD/SEK',
    'Swiss Franc/Danish Krone': 'CHF/DKK',
    'Polish Złoty/Euro': 'PLN/EUR',
    'Czech Koruna/Swedish Krona': 'CZK/SEK',
    'Canadian Dollar/Polish Złoty': 'CAD/PLN',
    'United States Dollar/Czech Koruna': 'USD/CZK',
    'British Pound Sterling/Guatemalan Quetzal': 'GBP/GTQ',
    'Mexican Peso/Czech Koruna': 'MXN/CZK',
    'Chinese Yuan (Offshore)/Hong Kong Dollar': 'CNH/HKD',
    'Indonesian Rupiah/United States Dollar': 'IDR/USD',
    'United States Dollar/Mexican Peso': 'USD/MXN',
    'Malaysian Ringgit/New Taiwan Dollar': 'MYR/TWD',
    'Hungarian Forint/United States Dollar': 'HUF/USD',
    'Lithuanian Litas/Australian Dollar': 'LTL/AUD',
    'Euro/Indian Rupee': 'EUR/INR',
    'Turkish Lira/Singapore Dollar': 'TRY/SGD',
    'Swedish Krona/Japanese Yen': 'SEK/JPY',
    'Canadian Dollar/Bulgarian Lev': 'CAD/BGN',
    'New Taiwan Dollar/Indian Rupee': 'TWD/INR',
    'Japanese Yen/Argentine Peso': 'JPY/ARS',
    'United States Dollar/New Zealand Dollar': 'USD/NZD',
    'British Pound Sterling/Egyptian Pound': 'GBP/EGP',
    'Swiss Franc/Turkish Lira': 'CHF/TRY',
    'British Pound Sterling/Philippine Peso': 'GBP/PHP',
    'Colombian Peso/Argentine Peso': 'COP/ARS',
    'Hungarian Forint/Swiss Franc': 'HUF/CHF',
    'Hungarian Forint/Japanese Yen': 'HUF/JPY',
    'British Pound Sterling/Nicaraguan Córdoba': 'GBP/NIO',
    'Australian Dollar/New Taiwan Dollar': 'AUD/TWD',
    'Australian Dollar/Canadian Dollar': 'AUD/CAD',
    'Czech Koruna/Polish Złoty': 'CZK/PLN',
    'Mexican Peso/Euro': 'MXN/EUR',
    'Danish Krone/Australian Dollar': 'DKK/AUD',
    'Gold (XAU)/Brazilian Real': 'XAU/BRL',
    'British Pound Sterling/Japanese Yen': 'GBP/JPY',
    'United States Dollar/Japanese Yen': 'USD/JPY',
    'Thai Baht/Australian Dollar': 'THB/AUD',
    'Swiss Franc/Norwegian Krone': 'CHF/NOK',
    'Chinese Yuan/New Zealand Dollar': 'CNY/NZD',
    'Hong Kong Dollar/South Korean Won': 'HKD/KRW',
    'Guatemalan Quetzal/British Pound Sterling': 'GTQ/GBP',
    'New Zealand Dollar/Hungarian Forint': 'NZD/HUF',
    'Hong Kong Dollar/Indonesian Rupiah': 'HKD/IDR',
    'Tanzanian Shilling/South African Rand': 'TZS/ZAR',
    'British Pound Sterling / Turkish Lira': 'GBP/TRY',
    'Swiss Franc / Russian Ruble': 'CHF/RUB',
    'Polish Złoty / Danish Krone': 'PLN/DKK',
    'Australian Dollar / Argentine Peso': 'AUD/ARS',
    'Silver (XAG) / Japanese Yen': 'XAG/JPY',
    'Romanian Leu / Swiss Franc': 'RON/CHF',
    'British Pound Sterling / Hong Kong Dollar': 'GBP/HKD',
    'Mexican Peso / Hong Kong Dollar': 'MXN/HKD',
    'Thai Baht / United States Dollar': 'THB/USD',
    'Japanese Yen / Mexican Peso': 'JPY/MXN',
    'New Taiwan Dollar / United States Dollar': 'TWD/USD',
    'Canadian Dollar / United States Dollar': 'CAD/USD',
    'Danish Krone / Turkish Lira': 'DKK/TRY',
    'Romanian Leu / South African Rand': 'RON/ZAR',
    'British Pound Sterling / Nigerian Naira': 'GBP/NGN',
    'United States Dollar / Indonesian Rupiah': 'USD/IDR',
    'South African Rand / Turkish Lira': 'ZAR/TRY',
    'British Pound Sterling / Swiss Franc': 'GBP/CHF',
    'Turkish Lira / Swiss Franc': 'TRY/CHF',
    'British Pound Sterling / Peruvian Nuevo Sol': 'GBP/PEN',
    'Indonesian Rupiah / New Zealand Dollar': 'IDR/NZD',
    'Danish Krone / Japanese Yen': 'DKK/JPY',
    'Singapore Dollar / Swiss Franc': 'SGD/CHF',
    'Australian Dollar / Indonesian Rupiah': 'AUD/IDR',
    'Swiss Franc / Canadian Dollar': 'CHF/CAD',
    'Hong Kong Dollar / Swedish Krona': 'HKD/SEK',
    'Norwegian Krone / South African Rand': 'NOK/ZAR',
    'Malaysian Ringgit / New Zealand Dollar': 'MYR/NZD',
    'Turkish Lira / Danish Krone': 'TRY/DKK',
    'Indian Rupee / Hong Kong Dollar': 'INR/HKD',
    'Danish Krone / Russian Ruble': 'DKK/RUB',
    'Singapore Dollar / Japanese Yen': 'SGD/JPY',
    'Euro / Japanese Yen': 'EUR/JPY',
    'Norwegian Krone / Israeli New Shekel': 'NOK/ILS',
    'Danish Krone / Singapore Dollar': 'DKK/SGD',
    'Philippine Peso / United States Dollar': 'PHP/USD',
    'Australian Dollar / Mexican Peso': 'AUD/MXN',
    'South African Rand / Danish Krone': 'ZAR/DKK',
    'United States Dollar / Hungarian Forint': 'USD/HUF',
    'Canadian Dollar / Cayman Islands Dollar': 'CAD/KYD',
    'Euro / United States Dollar': 'EUR/USD',
    'Chinese Yuan / Hong Kong Dollar': 'CNY/HKD',
    'South Korean Won / New Zealand Dollar': 'KRW/NZD',
    'Silver (XAG) / Mexican Peso': 'XAG/MXN',
    'Danish Krone / New Taiwan Dollar': 'DKK/TWD',
    'Swedish Krona / United States Dollar': 'SEK/USD',
    'Canadian Dollar / Argentine Peso': 'CAD/ARS',
    'Euro / South African Rand': 'EUR/ZAR',
    'Philippine Peso / Japanese Yen': 'PHP/JPY',
    'Polish Złoty / Norwegian Krone': 'PLN/NOK',
    'New Zealand Dollar / Singapore Dollar': 'NZD/SGD',
    'Euro / Hong Kong Dollar': 'EUR/HKD',
    'Euro / Egyptian Pound': 'EUR/EGP',
    'Japanese Yen / Swedish Krona': 'JPY/SEK',
    'Hong Kong Dollar / Mexican Peso': 'HKD/MXN',
    'Brazilian Real / Australian Dollar': 'BRL/AUD',
    'United States Dollar / Turkish Lira': 'USD/TRY',
    'Indian Rupee / South African Rand': 'INR/ZAR',
    'South Korean Won / Euro': 'KRW/EUR',
    'Canadian Dollar / Russian Ruble': 'CAD/RUB',
    'Hong Kong Dollar / Japanese Yen': 'HKD/JPY',
    'Chinese Yuan / Indian Rupee': 'CNY/INR',
    'Israeli New Shekel / Swedish Krona': 'ILS/SEK',
    'Canadian Dollar / Indian Rupee': 'CAD/INR',
    'Mexican Peso / Danish Krone': 'MXN/DKK',
    'Canadian Dollar / Bermudian Dollar': 'CAD/BMD',
    'New Zealand Dollar / South Korean Won': 'NZD/KRW',
    'New Zealand Dollar / New Taiwan Dollar': 'NZD/TWD',
    'Hungarian Forint / Euro': 'HUF/EUR',
    'South African Rand / Hungarian Forint': 'ZAR/HUF',
    'Polish Złoty / United States Dollar': 'PLN/USD',
    'Danish Krone / Chinese Yuan': 'DKK/CNY',
    'Japanese Yen / Danish Krone': 'JPY/DKK',
    'South African Rand / South Korean Won': 'ZAR/KRW',
    'Egyptian Pound / United States Dollar': 'EGP/USD',
    'Euro / Hungarian Forint': 'EUR/HUF'}



crypto_currency_pairs = {
    'COVAL-USD': 'Circuits of Value to US Dollar',
    'BTT-USD': 'BitTorrent to US Dollar',
    'SEI-USD': 'SatoExchange to US Dollar',
    'CLV-USD': 'Clover Finance to US Dollar',
    'ALCX-USD': 'Alchemix to US Dollar',
    'AUCTION-USD': 'Bounce to US Dollar',
    'TRU-USD': 'TrueFi to US Dollar',
    'EOS-USD': 'EOS to US Dollar',
    'BNT-USD': 'Bancor to US Dollar',
    'SNT-USD': 'Status to US Dollar',
    'DASH-USD': 'Dash to US Dollar',
    'DNT-USD': 'district0x to US Dollar',
    'SPELL-USD': 'Spell to US Dollar',
    'LCX-USD': 'LCX to US Dollar',
    'SWFTC-USD': 'SwftCoin to US Dollar',
    'XRP-AUD': 'XRP to Australian Dollar',
    'INJ-USD': 'Injective Protocol to US Dollar',
    'REQ-USD': 'Request to US Dollar',
    'FIS-USD': 'Stafi to US Dollar',
    'ATOM-USD': 'Cosmos to US Dollar',
    'VET-USD': 'VeChain to US Dollar',
    'FORTH-USD': 'Ampleforth Governance Token to US Dollar',
    'SAND-USD': 'Sandbox to US Dollar',
    'OGN-USD': 'Origin Protocol to US Dollar',
    'JST-USD': 'JUST to US Dollar',
    'IOT-USD': 'IOTA to US Dollar',
    'AVAX-USD': 'Avalanche to US Dollar',
    'SOL-USD': 'Solana to US Dollar',
    'HBAR-USD': 'Hedera Hashgraph to US Dollar',
    'LTC-USD': 'Litecoin to US Dollar',
    'BCH-EUR': 'Bitcoin Cash to Euro',
    'CRO-USD': 'Crypto.com Coin to US Dollar',
    'UST-USD': 'TerraUSD to US Dollar',
    'ZIL-USD': 'Zilliqa to US Dollar',
    'ICX-USD': 'ICON to US Dollar',
    'XVG-USD': 'Verge to US Dollar',
    'BTC-USD': 'Bitcoin to US Dollar',
    'CGLD-USD': 'Celo to US Dollar',
    'TVK-USD': 'Theta Fuel to US Dollar',
    'COMP-USD': 'Compound to US Dollar',
    'LYM-USD': 'Lympo to US Dollar',
    'RAI-USD': 'Rai Reflex Index to US Dollar',
    'STX-USD': 'Stacks to US Dollar',
    'ACH-USD': 'Alchemy Pay to US Dollar',
    'ETH-AUD': 'Ethereum to Australian Dollar',
    'ENJ-USD': 'Enjin Coin to US Dollar',
    'FARM-USD': 'Harvest Finance to US Dollar',
    'IMX-USD': 'Immutable X to US Dollar',
    'MLN-USD': 'Enzyme to US Dollar',
    'BADGER-USD': 'Badger DAO to US Dollar',
    'DOT-USD': 'Polkadot to US Dollar',
    'LTC-EUR': 'Litecoin to Euro',
    'ADA-USD': 'Cardano to US Dollar',
    'XMR-USD': 'Monero to US Dollar',
    'UTK-USD': 'Utrust to US Dollar',
    'NKN-USD': 'NKN to US Dollar',
    'XRP-BTC': 'XRP to Bitcoin',
    'C98-USD': 'Coin98 to US Dollar',
    'NEAR-USD': 'NEAR Protocol to US Dollar',
    'CSM-USD': 'Cryptosol to US Dollar',
    'FTM-USD': 'Fantom to US Dollar',
    'CVX-USD': 'Convex Finance to US Dollar',
    'RLC-USD': 'iExec RLC to US Dollar',
    'SHIB-USD': 'Shiba Inu to US Dollar',
    'NEO-USD': 'NEO to US Dollar',
    '1INCH-USD': '1inch to US Dollar',
    'ARPA-USD': 'ARPA Chain to US Dollar',
    'XLM-USD': 'Stellar Lumens to US Dollar',
    'MKR-USD': 'Maker to US Dollar',
    'GNO-USD': 'Gnosis to US Dollar',
    'IOTX-USD': 'IoTeX to US Dollar',
    'KNC-USD': 'Kyber Network to US Dollar',
    'APE-USD': 'ApeCoin to US Dollar',
    'CTSI-USD': 'Cartesi to US Dollar',
    'ETH-BTC': 'Ethereum to Bitcoin',
    'GLM-USD': 'Golem to US Dollar',
    'LUNA-USD': 'Terra to US Dollar',
    'USDT-USD': 'Tether to US Dollar',
    'LTC-BTC': 'Litecoin to Bitcoin',
    'BOND-USD': 'BarnBridge to US Dollar',
    'RARI-USD': 'Rarible to US Dollar',
    'COTI-USD': 'COTI to US Dollar',
    'GRT-USD': 'The Graph to US Dollar',
    'STORJ-USD': 'Storj to US Dollar',
    'GUSD-USD': 'Gemini Dollar to US Dollar',
    'UNI-USD': 'Uniswap to US Dollar',
    'UMA-USD': 'UMA to US Dollar',
    'OCEAN-USD': 'Ocean Protocol to US Dollar',
    'FIL-USD': 'Filecoin to US Dollar',
    'BTC-GBP': 'Bitcoin to British Pound',
    'USDC-USD': 'USD Coin to US Dollar',
    'API3-USD': 'API3 to US Dollar',
    'QNT-USD': 'Quant to US Dollar',
    'ALGO-USD': 'Algorand to US Dollar',
    'DYDX-USD': 'dYdX to US Dollar',
    'BTC-EUR': 'Bitcoin to Euro',
    'SUSHI-USD': 'SushiSwap to US Dollar',
    'BCH-USD': 'Bitcoin Cash to US Dollar',
    'CRV-USD': 'Curve DAO Token to US Dollar',
    'RUNE-USD': 'THORChain to US Dollar',
    'ZEC-USD': 'Zcash to US Dollar',
    'XRP-USD': 'XRP to US Dollar',
    'PAX-USD': 'Paxos Standard to US Dollar',
    'ZRX-USD': '0x to US Dollar',
    'ETC-USD': 'Ethereum Classic to US Dollar',
    'AMP-USD': 'Amp to US Dollar',
    'SUKU-USD': 'SUKU to US Dollar',
    'MANA-USD': 'Decentraland to US Dollar',
    'BCH-GBP': 'Bitcoin Cash to British Pound',
    'AVT-USD': 'Aventus to US Dollar',
    'QTF-USD': 'Quickswap to US Dollar',
    'ALICE-USD': 'MyNeighborAlice to US Dollar',
    'PERP-USD': 'Perpetual Protocol to US Dollar',
    'ROSE-USD': 'Oasis Network to US Dollar',
    'FET-USD': 'Fetch.ai to US Dollar',
    'TRX-USD': 'TRON to US Dollar',
    'NCT-USD': 'PolySwarm to US Dollar',
    'OXT-USD': 'Orchid to US Dollar',
    'BTRST-USD': 'Bitrue Coin to US Dollar',
    'PNK-USD': 'Kleros to US Dollar',
    'GTC-USD': 'Gitcoin to US Dollar',
    'TRAC-USD': 'OriginTrail to US Dollar',
    'PLA-USD': 'PlayDapp to US Dollar',
    'ZEN-USD': 'Horizen to US Dollar',
    'DSH-USD': 'Dashcoin to US Dollar',
    'AXS-USD': 'Axie Infinity to US Dollar',
    'SRM-USD': 'Serum to US Dollar',
    'RNDR-USD': 'Render Token to US Dollar',
    'XTZ-USD': 'Tezos to US Dollar',
    'SC-USD': 'Siacoin to US Dollar',
    'OMG-USD': 'OMG Network to US Dollar',
    'PAXG-USD': 'Paxos Gold to US Dollar',
    'FX-USD': 'Function X to US Dollar',
    'LRC-USD': 'Loopring to US Dollar',
    'ANKR-USD': 'Ankr to US Dollar',
    'ETH-USD': 'Ethereum to US Dollar',
    'KSM-USD': 'Kusama to US Dollar',
    'TRB-USD': 'Tellor to US Dollar',
    'NANO-USD': 'Nano to US Dollar',
    'CVC-USD': 'Civic to US Dollar',
    'QRDO-USD': 'Qredo to US Dollar',
    'XYO-USD': 'XYO Network to US Dollar',
    'WBTC-USD': 'Wrapped Bitcoin to US Dollar',
    'DOGE-USD': 'Dogecoin to US Dollar',
    'FCL-USD': 'Fractal to US Dollar',
    'GALA-USD': 'Gala to US Dollar',
    'JASMY-USD': 'JasmyCoin to US Dollar',
    'KAVA-USD': 'Kava to US Dollar',
    'TIA-USD': 'Tia Token to US Dollar',
    'BOSON-USD': 'Boson Protocol to US Dollar',
    'ICP-USD': 'Internet Computer to US Dollar',
    'WAVES-USD': 'Waves to US Dollar',
    'LINK-USD': 'Chainlink to US Dollar',
    'BOBA-USD': 'Boba Network to US Dollar',
    'DYDX-EUR': 'dYdX to Euro',
    'QTUM-USD': 'Qtum to US Dollar',
    'YFI-USD': 'yearn.finance to US Dollar',
    'ELA-USD': 'Elastos to US Dollar',
    'CHZ-USD': 'Chiliz to US Dollar',
    'BAND-USD': 'Band Protocol to US Dollar',
    'MASK-USD': 'Mask Network to US Dollar',
    'NEXO-USD': 'Nexo to US Dollar',
    'SEI-EUR': 'SatoExchange to Euro',
    'XRD-USD': 'Radix to US Dollar',
    'KEEP-USD': 'Keep3rV1 to US Dollar',
    'EGLD-USD': 'Elrond to US Dollar',
    'LPT-USD': 'Livepeer to US Dollar',
    'FOX-USD': 'ShapeShift FOX Token to US Dollar',
    'NMR-USD': 'Numeraire to US Dollar',
    'SGB-USD': 'Digital Silver to US Dollar',
    'DUSK-USD': 'Dusk Network to US Dollar',
    'BTC-AUD': 'Bitcoin to Australian Dollar',
    'FLOW-USD': 'Flow to US Dollar',
    'SNX-USD': 'Synthetix to US Dollar',
    'SKL-USD': 'Skale Network to US Dollar',
    'DAI-USD': 'Dai to US Dollar',
    'GHST-USD': 'Aavegotchi to US Dollar',
    'MATIC-USD': 'Polygon to US Dollar',
    'ORN-USD': 'Orion Protocol to US Dollar',
    'GYEN-USD': 'Digital Yen to US Dollar',
    'AAVE-USD': 'Aave to US Dollar',
    'UOS-USD': 'Ultra to US Dollar',
    'TLOS-USD': 'Telos to US Dollar',
    'ASM-USD': 'Assemble Protocol (ASM) to US Dollar',
    'BAL-USD': 'Balancer (BAL) to US Dollar',
    'KRL-USD': 'Kryll (KRL) to US Dollar',
    'BAT-USD': 'Basic Attention Token (BAT) to US Dollar'}


CRYPTO_HOOKS = {
    "1INCH-USD": os.environ.get('1INCH_USD'),
    "AAVE-USD": os.environ.get('AAVE_USD'),
    "ACH-USD": os.environ.get('ACH_USD'),
    "ALGO-USD": os.environ.get('ALGO_USD'),
    "ANKR-USD": os.environ.get('ANKR_USD'),
    "ATOM-USD": os.environ.get('ATOM_USD'),
    "AVA-USD": os.environ.get('AVA_USD'),
    "BAL-USD": os.environ.get('BAL_USD'),
    "BAND-USD": os.environ.get('BAND_USD'),
    "BAT-USD": os.environ.get('BAT_USD'),
    "BCH-USD": os.environ.get('BCH_USD'),
    "BNB-USD": os.environ.get('BNB_USD'),
    "BTC-USD": os.environ.get('BTC_USD'),
    "CELO-USD": os.environ.get('CELO_USD'),
    "CHZ-USD": os.environ.get('CHZ_USD'),
    "CRO-USD": os.environ.get('CRO_USD'),
    "CRV-USD": os.environ.get('CRV_USD'),
    "DAI-USD": os.environ.get('DAI_USD'),
    "DASH-USD": os.environ.get('DASH_USD'),
    "DOGE-USD": os.environ.get('DOGE_USD'),
    "DOT-USD": os.environ.get('DOT_USD'),
    "ENJ-USD": os.environ.get('ENJ_USD'),
    "EOS-USD": os.environ.get('EOS_USD'),
    "ETC-USD": os.environ.get('ETC_USD'),
    "ETH-USD": os.environ.get('ETH_USD'),
    "FIL-USD": os.environ.get('FIL_USD'),
    "FLOW-USD": os.environ.get('FLOW_USD'),
    "GRT-USD": os.environ.get('GRT_USD'),
    "ICP-USD": os.environ.get('ICP_USD'),
    "KNC-USD": os.environ.get('KNC_USD'),
    "LINK-USD": os.environ.get('LINK_USD'),
    "LRC-USD": os.environ.get('LRC_USD'),
    "LTC-USD": os.environ.get('LTC_USD'),
    "MANA-USD": os.environ.get('MANA_USD'),
    "MATIC-USD": os.environ.get('MATIC_USD'),
    "MKR-USD": os.environ.get('MKR_USD'),
    "NANO-USD": os.environ.get('NANO_USD'),
    "OMG-USD": os.environ.get('OMG_USD'),
    "PAX-USD": os.environ.get('PAX_USD'),
    "QTUM-USD": os.environ.get('QTUM_USD'),
    "REN-USD": os.environ.get('REN_USD'),
    "SOL-USD": os.environ.get('SOL_USD'),
    "STMX-USD": os.environ.get('STMX_USD'),
    "STORJ-USD": os.environ.get('STORJ_USD'),
    "SUSHI-USD": os.environ.get('SUSHI_USD'),
    "TRX-USD": os.environ.get('TRX_USD'),
    "UNI-USD": os.environ.get('UNI_USD'),
    "USDC-USD": os.environ.get('USDC_USD'),
    "USDT-USD": os.environ.get('USDT_USD'),
    "VET-USD": os.environ.get('VET_USD'),
    "WAVES-USD": os.environ.get('WAVES_USD'),
    "XLM-USD": os.environ.get('XLM_USD'),
    "XMR-USD": os.environ.get('XMR_USD'),
    "XRP-USD": os.environ.get('XRP_USD'),
    "XTZ-USD": os.environ.get('XTZ_USD'),
    "YFI-USD": os.environ.get('YFI_USD'),
    "ZEC-USD": os.environ.get('ZEC_USD'),
    "ZEN-USD": os.environ.get('ZEN_USD'),
    "ZRX-USD": os.environ.get('ZRX_USD'),
}