from enum import StrEnum

from sereto.exceptions import SeretoValueError


class Environment(StrEnum):
    """Enum representing the environment of a Target."""

    acceptance = "acceptance"
    development = "development"
    production = "production"
    testing = "testing"


class FileFormat(StrEnum):
    """Enum representing the file format."""

    md = "md"
    tex = "tex"


class OutputFormat(StrEnum):
    """Enum representing the output format."""

    table = "table"
    json = "json"


class Risk(StrEnum):
    """Enum representing the risk level of a finding."""

    critical = "critical"
    high = "high"
    medium = "medium"
    low = "low"
    info = "info"
    closed = "closed"

    def to_int(self) -> int:
        """Convert risks to a number.

        Usefull for comparison - e.g. `max(risks, key=lambda r: r.to_int())`
        """
        match self:
            case Risk.closed:
                return 0
            case Risk.info:
                return 1
            case Risk.low:
                return 2
            case Risk.medium:
                return 3
            case Risk.high:
                return 4
            case Risk.critical:
                return 5
            case _:
                raise SeretoValueError("unexpected risk value")
