# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import Any, Dict

from stytch.b2b.models.impersonation import AuthenticateResponse
from stytch.core.api_base import ApiBase
from stytch.core.http.client import AsyncClient, SyncClient


class Impersonation:
    def __init__(
        self, api_base: ApiBase, sync_client: SyncClient, async_client: AsyncClient
    ) -> None:
        self.api_base = api_base
        self.sync_client = sync_client
        self.async_client = async_client

    def authenticate(
        self,
        impersonation_token: str,
    ) -> AuthenticateResponse:
        """Authenticate an impersonation token to impersonate a Member. This endpoint requires an impersonation token that is not expired or previously used.
        A Stytch session will be created for the impersonated member with a 60 minute duration. Impersonated sessions cannot be extended.

        Prior to this step, you can generate an impersonation token by visiting the Stytch Dashboard, viewing a member, and clicking the `Impersonate Member` button.

        Fields:
          - impersonation_token: The Member Impersonation token to authenticate. Expires in 5 minutes by default.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "impersonation_token": impersonation_token,
        }

        url = self.api_base.url_for("/v1/b2b/impersonation/authenticate", data)
        res = self.sync_client.post(url, data, headers)
        return AuthenticateResponse.from_json(res.response.status_code, res.json)

    async def authenticate_async(
        self,
        impersonation_token: str,
    ) -> AuthenticateResponse:
        """Authenticate an impersonation token to impersonate a Member. This endpoint requires an impersonation token that is not expired or previously used.
        A Stytch session will be created for the impersonated member with a 60 minute duration. Impersonated sessions cannot be extended.

        Prior to this step, you can generate an impersonation token by visiting the Stytch Dashboard, viewing a member, and clicking the `Impersonate Member` button.

        Fields:
          - impersonation_token: The Member Impersonation token to authenticate. Expires in 5 minutes by default.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "impersonation_token": impersonation_token,
        }

        url = self.api_base.url_for("/v1/b2b/impersonation/authenticate", data)
        res = await self.async_client.post(url, data, headers)
        return AuthenticateResponse.from_json(res.response.status, res.json)
