# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import Any, Dict, Optional

from stytch.b2b.models.oauth_discovery import AuthenticateResponse
from stytch.core.api_base import ApiBase
from stytch.core.http.client import AsyncClient, SyncClient


class Discovery:
    def __init__(
        self, api_base: ApiBase, sync_client: SyncClient, async_client: AsyncClient
    ) -> None:
        self.api_base = api_base
        self.sync_client = sync_client
        self.async_client = async_client

    def authenticate(
        self,
        discovery_oauth_token: str,
        session_token: Optional[str] = None,
        session_duration_minutes: Optional[int] = None,
        session_jwt: Optional[str] = None,
        session_custom_claims: Optional[Dict[str, Any]] = None,
        pkce_code_verifier: Optional[str] = None,
    ) -> AuthenticateResponse:
        """Authenticates the Discovery OAuth token and exchanges it for an Intermediate
        Session Token. Intermediate Session Tokens can be used for various Discovery login flows and are valid for 10 minutes.

        Fields:
          - discovery_oauth_token: The Discovery OAuth token to authenticate.
          - session_token: (no documentation yet)
          - session_duration_minutes: (no documentation yet)
          - session_jwt: (no documentation yet)
          - session_custom_claims: (no documentation yet)
          - pkce_code_verifier: A base64url encoded one time secret used to validate that the request starts and ends on the same device.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "discovery_oauth_token": discovery_oauth_token,
        }
        if session_token is not None:
            data["session_token"] = session_token
        if session_duration_minutes is not None:
            data["session_duration_minutes"] = session_duration_minutes
        if session_jwt is not None:
            data["session_jwt"] = session_jwt
        if session_custom_claims is not None:
            data["session_custom_claims"] = session_custom_claims
        if pkce_code_verifier is not None:
            data["pkce_code_verifier"] = pkce_code_verifier

        url = self.api_base.url_for("/v1/b2b/oauth/discovery/authenticate", data)
        res = self.sync_client.post(url, data, headers)
        return AuthenticateResponse.from_json(res.response.status_code, res.json)

    async def authenticate_async(
        self,
        discovery_oauth_token: str,
        session_token: Optional[str] = None,
        session_duration_minutes: Optional[int] = None,
        session_jwt: Optional[str] = None,
        session_custom_claims: Optional[Dict[str, Any]] = None,
        pkce_code_verifier: Optional[str] = None,
    ) -> AuthenticateResponse:
        """Authenticates the Discovery OAuth token and exchanges it for an Intermediate
        Session Token. Intermediate Session Tokens can be used for various Discovery login flows and are valid for 10 minutes.

        Fields:
          - discovery_oauth_token: The Discovery OAuth token to authenticate.
          - session_token: (no documentation yet)
          - session_duration_minutes: (no documentation yet)
          - session_jwt: (no documentation yet)
          - session_custom_claims: (no documentation yet)
          - pkce_code_verifier: A base64url encoded one time secret used to validate that the request starts and ends on the same device.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "discovery_oauth_token": discovery_oauth_token,
        }
        if session_token is not None:
            data["session_token"] = session_token
        if session_duration_minutes is not None:
            data["session_duration_minutes"] = session_duration_minutes
        if session_jwt is not None:
            data["session_jwt"] = session_jwt
        if session_custom_claims is not None:
            data["session_custom_claims"] = session_custom_claims
        if pkce_code_verifier is not None:
            data["pkce_code_verifier"] = pkce_code_verifier

        url = self.api_base.url_for("/v1/b2b/oauth/discovery/authenticate", data)
        res = await self.async_client.post(url, data, headers)
        return AuthenticateResponse.from_json(res.response.status, res.json)
