# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import Any, Dict, Optional

from stytch.b2b.models.organizations_members_connected_apps import (
    RevokeRequestOptions,
    RevokeResponse,
)
from stytch.core.api_base import ApiBase
from stytch.core.http.client import AsyncClient, SyncClient


class ConnectedApps:
    def __init__(
        self, api_base: ApiBase, sync_client: SyncClient, async_client: AsyncClient
    ) -> None:
        self.api_base = api_base
        self.sync_client = sync_client
        self.async_client = async_client

    def revoke(
        self,
        organization_id: str,
        member_id: str,
        connected_app_id: str,
        method_options: Optional[RevokeRequestOptions] = None,
    ) -> RevokeResponse:
        """Revoke Connected App revokes a Connected App's access to a Member and revokes all active tokens that have been created
        on the Member's behalf. New tokens cannot be created until the Member completes a new authorization flow with the
        Connected App.

        Fields:
          - organization_id: Globally unique UUID that identifies a specific Organization. The `organization_id` is critical to perform operations on an Organization, so be sure to preserve this value. You may also use the organization_slug or organization_external_id here as a convenience.
          - member_id: Globally unique UUID that identifies a specific Member. The `member_id` is critical to perform operations on a Member, so be sure to preserve this value. You may use an external_id here if one is set for the member.
          - connected_app_id: The ID of the Connected App.
        """  # noqa
        headers: Dict[str, str] = {}
        if method_options is not None:
            headers = method_options.add_headers(headers)
        data: Dict[str, Any] = {
            "organization_id": organization_id,
            "member_id": member_id,
            "connected_app_id": connected_app_id,
        }

        url = self.api_base.url_for(
            "/v1/b2b/organizations/{organization_id}/members/{member_id}/connected_apps/{connected_app_id}/revoke",
            data,
        )
        res = self.sync_client.post(url, data, headers)
        return RevokeResponse.from_json(res.response.status_code, res.json)

    async def revoke_async(
        self,
        organization_id: str,
        member_id: str,
        connected_app_id: str,
        method_options: Optional[RevokeRequestOptions] = None,
    ) -> RevokeResponse:
        """Revoke Connected App revokes a Connected App's access to a Member and revokes all active tokens that have been created
        on the Member's behalf. New tokens cannot be created until the Member completes a new authorization flow with the
        Connected App.

        Fields:
          - organization_id: Globally unique UUID that identifies a specific Organization. The `organization_id` is critical to perform operations on an Organization, so be sure to preserve this value. You may also use the organization_slug or organization_external_id here as a convenience.
          - member_id: Globally unique UUID that identifies a specific Member. The `member_id` is critical to perform operations on a Member, so be sure to preserve this value. You may use an external_id here if one is set for the member.
          - connected_app_id: The ID of the Connected App.
        """  # noqa
        headers: Dict[str, str] = {}
        if method_options is not None:
            headers = method_options.add_headers(headers)
        data: Dict[str, Any] = {
            "organization_id": organization_id,
            "member_id": member_id,
            "connected_app_id": connected_app_id,
        }

        url = self.api_base.url_for(
            "/v1/b2b/organizations/{organization_id}/members/{member_id}/connected_apps/{connected_app_id}/revoke",
            data,
        )
        res = await self.async_client.post(url, data, headers)
        return RevokeResponse.from_json(res.response.status, res.json)
