# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import Any, Dict

from stytch.b2b.api.passwords_discovery_email import Email
from stytch.b2b.models.passwords_discovery import AuthenticateResponse
from stytch.core.api_base import ApiBase
from stytch.core.http.client import AsyncClient, SyncClient


class Discovery:
    def __init__(
        self, api_base: ApiBase, sync_client: SyncClient, async_client: AsyncClient
    ) -> None:
        self.api_base = api_base
        self.sync_client = sync_client
        self.async_client = async_client
        self.email = Email(
            api_base=self.api_base,
            sync_client=self.sync_client,
            async_client=self.async_client,
        )

    def authenticate(
        self,
        email_address: str,
        password: str,
    ) -> AuthenticateResponse:
        """Authenticate an email/password combination in the discovery flow. This authenticate flow is only valid for cross-org passwords use cases, and is not tied to a specific organization.

        If you have breach detection during authentication enabled in your [password strength policy](https://stytch.com/docs/b2b/guides/passwords/strength-policy) and the member's credentials have appeared in the HaveIBeenPwned dataset, this endpoint will return a `member_reset_password` error even if the member enters a correct password. We force a password reset in this case to ensure that the member is the legitimate owner of the email address and not a malicious actor abusing the compromised credentials.

        If successful, this endpoint will create a new intermediate session and return a list of discovered organizations that can be session exchanged into.

        Fields:
          - email_address: The email address of the Member.
          - password: The password to authenticate, reset, or set for the first time. Any UTF8 character is allowed, e.g. spaces, emojis, non-English characters, etc.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "email_address": email_address,
            "password": password,
        }

        url = self.api_base.url_for("/v1/b2b/passwords/discovery/authenticate", data)
        res = self.sync_client.post(url, data, headers)
        return AuthenticateResponse.from_json(res.response.status_code, res.json)

    async def authenticate_async(
        self,
        email_address: str,
        password: str,
    ) -> AuthenticateResponse:
        """Authenticate an email/password combination in the discovery flow. This authenticate flow is only valid for cross-org passwords use cases, and is not tied to a specific organization.

        If you have breach detection during authentication enabled in your [password strength policy](https://stytch.com/docs/b2b/guides/passwords/strength-policy) and the member's credentials have appeared in the HaveIBeenPwned dataset, this endpoint will return a `member_reset_password` error even if the member enters a correct password. We force a password reset in this case to ensure that the member is the legitimate owner of the email address and not a malicious actor abusing the compromised credentials.

        If successful, this endpoint will create a new intermediate session and return a list of discovered organizations that can be session exchanged into.

        Fields:
          - email_address: The email address of the Member.
          - password: The password to authenticate, reset, or set for the first time. Any UTF8 character is allowed, e.g. spaces, emojis, non-English characters, etc.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "email_address": email_address,
            "password": password,
        }

        url = self.api_base.url_for("/v1/b2b/passwords/discovery/authenticate", data)
        res = await self.async_client.post(url, data, headers)
        return AuthenticateResponse.from_json(res.response.status, res.json)
