# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import enum
from typing import Dict, Optional

import pydantic

from stytch.b2b.models.organizations import Member, Organization
from stytch.core.response_base import ResponseBase
from stytch.shared.method_options import Authorization


class InviteRequestLocale(str, enum.Enum):
    EN = "en"
    ES = "es"
    PTBR = "pt-br"
    FR = "fr"


class LoginOrSignupRequestLocale(str, enum.Enum):
    EN = "en"
    ES = "es"
    PTBR = "pt-br"
    FR = "fr"


class InviteRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class InviteResponse(ResponseBase):
    """Response type for `Email.invite`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class LoginOrSignupResponse(ResponseBase):
    """Response type for `Email.login_or_signup`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member_created: A flag indicating `true` if a new Member object was created and `false` if the Member object already existed.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member_created: bool
    member: Member
    organization: Organization
