# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import enum
from typing import Dict, List, Optional

import pydantic

from stytch.b2b.models.organizations import (
    Member,
    MemberConnectedApp,
    OIDCProviderInfo,
    Organization,
    ResultsMetadata,
)
from stytch.core.response_base import ResponseBase
from stytch.shared.method_options import Authorization


class StartEmailUpdateRequestDeliveryMethod(str, enum.Enum):
    EMAIL_MAGIC_LINK = "EMAIL_MAGIC_LINK"
    EMAIL_OTP = "EMAIL_OTP"


class StartEmailUpdateRequestLocale(str, enum.Enum):
    EN = "en"
    ES = "es"
    PTBR = "pt-br"
    FR = "fr"


class CreateRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class DeleteMFAPhoneNumberRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class DeletePasswordRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class DeleteRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class DeleteTOTPRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class GetConnectedAppsRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class ReactivateRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class SearchRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class StartEmailUpdateRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class UnlinkRetiredEmailRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class UpdateRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class CreateResponse(ResponseBase):
    """Response type for `Members.create`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class DeleteMFAPhoneNumberResponse(ResponseBase):
    """Response type for `Members.delete_mfa_phone_number`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class DeletePasswordResponse(ResponseBase):
    """Response type for `Members.delete_password`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class DeleteResponse(ResponseBase):
    """Response type for `Members.delete`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
    """  # noqa

    member_id: str


class DeleteTOTPResponse(ResponseBase):
    """Response type for `Members.delete_totp`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class GetConnectedAppsResponse(ResponseBase):
    """Response type for `Members.get_connected_apps`.
    Fields:
      - connected_apps: An array of Connected Apps with which the Member has successfully completed an authorization flow.
    """  # noqa

    connected_apps: List[MemberConnectedApp]


class GetResponse(ResponseBase):
    """Response type for `Members.dangerously_get`, `Members.get`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class OIDCProvidersResponse(ResponseBase):
    """Response type for `Members.oidc_providers`.
    Fields:
      - registrations: A list of tokens the member is registered with.
    """  # noqa

    registrations: List[OIDCProviderInfo]


class ReactivateResponse(ResponseBase):
    """Response type for `Members.reactivate`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class SearchResponse(ResponseBase):
    """Response type for `Members.search`.
    Fields:
      - members: An array of [Member objects](https://stytch.com/docs/b2b/api/member-object).
      - results_metadata: The search `results_metadata` object contains metadata relevant to your specific query like `total` and `next_cursor`.
      - organizations: A map from `organization_id` to [Organization object](https://stytch.com/docs/b2b/api/organization-object). The map only contains the Organizations that the Members belongs to.
    """  # noqa

    members: List[Member]
    results_metadata: ResultsMetadata
    organizations: Dict[str, Organization]


class StartEmailUpdateResponse(ResponseBase):
    """Response type for `Members.start_email_update`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization


class UnlinkRetiredEmailResponse(ResponseBase):
    """Response type for `Members.unlink_retired_email`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - organization_id: Globally unique UUID that identifies a specific Organization. The `organization_id` is critical to perform operations on an Organization, so be sure to preserve this value.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    organization_id: str
    member: Member
    organization: Organization


class UpdateResponse(ResponseBase):
    """Response type for `Members.update`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member: Member
    organization: Organization
