# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import List, Optional

from stytch.b2b.models.organizations import (
    GithubProviderInfo,
    HubspotProviderInfo,
    SlackProviderInfo,
)
from stytch.core.response_base import ResponseBase


class GithubResponse(ResponseBase):
    """Response type for `OAuthProviders.github`.
    Fields:
      - provider_type: Denotes the OAuth identity provider that the user has authenticated with, e.g. Google, Microsoft, GitHub etc.
      - registrations: A list of tokens the member is registered with.
    """  # noqa

    provider_type: str
    registrations: List[GithubProviderInfo]


class GoogleResponse(ResponseBase):
    """Response type for `OAuthProviders.google`.
    Fields:
      - provider_type: Denotes the OAuth identity provider that the user has authenticated with, e.g. Google, Microsoft, GitHub etc.
      - provider_subject: The unique identifier for the User within a given OAuth provider. Also commonly called the `sub` or "Subject field" in OAuth protocols.
      - id_token: The `id_token` returned by the OAuth provider. ID Tokens are JWTs that contain structured information about a user. The exact content of each ID Token varies from provider to provider. ID Tokens are returned from OAuth providers that conform to the [OpenID Connect](https://openid.net/foundation/) specification, which is based on OAuth.
      - scopes: The OAuth scopes included for a given provider. See each provider's section above to see which scopes are included by default and how to add custom scopes.
      - access_token: The `access_token` that you may use to access the User's data in the provider's API.
      - access_token_expires_in: The number of seconds until the access token expires.
      - refresh_token: The `refresh_token` that you may use to obtain a new `access_token` for the User within the provider's API.
    """  # noqa

    provider_type: str
    provider_subject: str
    id_token: str
    scopes: List[str]
    access_token: Optional[str] = None
    access_token_expires_in: Optional[int] = None
    refresh_token: Optional[str] = None


class HubspotResponse(ResponseBase):
    """Response type for `OAuthProviders.hubspot`.
    Fields:
      - provider_type: Denotes the OAuth identity provider that the user has authenticated with, e.g. Google, Microsoft, GitHub etc.
      - registrations: A list of tokens the member is registered with.
    """  # noqa

    provider_type: str
    registrations: List[HubspotProviderInfo]


class MicrosoftResponse(ResponseBase):
    """Response type for `OAuthProviders.microsoft`.
    Fields:
      - provider_type: Denotes the OAuth identity provider that the user has authenticated with, e.g. Google, Microsoft, GitHub etc.
      - provider_subject: The unique identifier for the User within a given OAuth provider. Also commonly called the `sub` or "Subject field" in OAuth protocols.
      - access_token: The `access_token` that you may use to access the User's data in the provider's API.
      - access_token_expires_in: The number of seconds until the access token expires.
      - id_token: The `id_token` returned by the OAuth provider. ID Tokens are JWTs that contain structured information about a user. The exact content of each ID Token varies from provider to provider. ID Tokens are returned from OAuth providers that conform to the [OpenID Connect](https://openid.net/foundation/) specification, which is based on OAuth.
      - scopes: The OAuth scopes included for a given provider. See each provider's section above to see which scopes are included by default and how to add custom scopes.
      - refresh_token: The `refresh_token` that you may use to obtain a new `access_token` for the User within the provider's API.
    """  # noqa

    provider_type: str
    provider_subject: str
    access_token: str
    access_token_expires_in: int
    id_token: str
    scopes: List[str]
    refresh_token: Optional[str] = None


class SlackResponse(ResponseBase):
    """Response type for `OAuthProviders.slack`.
    Fields:
      - provider_type: Denotes the OAuth identity provider that the user has authenticated with, e.g. Google, Microsoft, GitHub etc.
      - registrations: A list of tokens the member is registered with.
    """  # noqa

    provider_type: str
    registrations: List[SlackProviderInfo]
