# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import enum
from typing import List, Optional

import pydantic

from stytch.b2b.models.mfa import MfaRequired
from stytch.b2b.models.organizations import Member, Organization
from stytch.b2b.models.sessions import MemberSession, PrimaryRequired
from stytch.consumer.models.device_history import DeviceInfo
from stytch.core.response_base import ResponseBase


class AuthenticateRequestLocale(str, enum.Enum):
    EN = "en"
    ES = "es"
    PTBR = "pt-br"
    FR = "fr"


class MigrateRequestHashType(str, enum.Enum):
    BCRYPT = "bcrypt"
    MD_5 = "md_5"
    ARGON_2I = "argon_2i"
    ARGON_2ID = "argon_2id"
    SHA_1 = "sha_1"
    SHA_512 = "sha_512"
    SCRYPT = "scrypt"
    PHPASS = "phpass"
    PBKDF_2 = "pbkdf_2"


class LudsFeedback(pydantic.BaseModel):
    """
    Fields:
      - has_lower_case: For LUDS validation, whether the password contains at least one lowercase letter.
      - has_upper_case: For LUDS validation, whether the password contains at least one uppercase letter.
      - has_digit: For LUDS validation, whether the password contains at least one digit.
      - has_symbol: For LUDS validation, whether the password contains at least one symbol. Any UTF8 character outside of a-z or A-Z may count as a valid symbol.
      - missing_complexity: For LUDS validation, the number of complexity requirements that are missing from the password.
          Check the complexity fields to see which requirements are missing.
      - missing_characters: For LUDS validation, this is the required length of the password that you've set minus the length of the password being checked.
          The user will need to add this many characters to the password to make it valid.
    """  # noqa

    has_lower_case: bool
    has_upper_case: bool
    has_digit: bool
    has_symbol: bool
    missing_complexity: int
    missing_characters: int


class ZxcvbnFeedback(pydantic.BaseModel):
    """
    Fields:
      - warning: For zxcvbn validation, contains an end user consumable warning if the password is valid but not strong enough.
      - suggestions: For zxcvbn validation, contains end user consumable suggestions on how to improve the strength of the password.
    """  # noqa

    warning: str
    suggestions: List[str]


class AuthenticateResponse(ResponseBase):
    """Response type for `Passwords.authenticate`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - organization_id: Globally unique UUID that identifies a specific Organization. The `organization_id` is critical to perform operations on an Organization, so be sure to preserve this value.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - intermediate_session_token: The returned Intermediate Session Token contains a password factor associated with the Member. If this value is non-empty, the member must complete an MFA step to finish logging in to the Organization. The token can be used with the [OTP SMS Authenticate endpoint](https://stytch.com/docs/b2b/api/authenticate-otp-sms), [TOTP Authenticate endpoint](https://stytch.com/docs/b2b/api/authenticate-totp), or [Recovery Codes Recover endpoint](https://stytch.com/docs/b2b/api/recovery-codes-recover) to complete an MFA flow and log in to the Organization. The token has a default expiry of 10 minutes. Password factors are not transferable between Organizations, so the intermediate session token is not valid for use with discovery endpoints.
      - member_authenticated: Indicates whether the Member is fully authenticated. If false, the Member needs to complete an MFA step to log in to the Organization.
      - member_session: The [Session object](https://stytch.com/docs/b2b/api/session-object).
      - mfa_required: Information about the MFA requirements of the Organization and the Member's options for fulfilling MFA.
      - primary_required: Information about the primary authentication requirements of the Organization.
      - member_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `member_device` response field will contain information about the member's device attributes.
    """  # noqa

    member_id: str
    organization_id: str
    member: Member
    session_token: str
    session_jwt: str
    organization: Organization
    intermediate_session_token: str
    member_authenticated: bool
    member_session: Optional[MemberSession] = None
    mfa_required: Optional[MfaRequired] = None
    primary_required: Optional[PrimaryRequired] = None
    member_device: Optional[DeviceInfo] = None


class MigrateResponse(ResponseBase):
    """Response type for `Passwords.migrate`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member_created: A flag indicating `true` if a new Member object was created and `false` if the Member object already existed.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    member_created: bool
    member: Member
    organization: Organization


class StrengthCheckResponse(ResponseBase):
    """Response type for `Passwords.strength_check`.
    Fields:
      - valid_password: Returns `true` if the password passes our password validation. We offer two validation options,
      [zxcvbn](https://stytch.com/docs/guides/passwords/strength-policy) is the default option which offers a high level of sophistication.
      We also offer [LUDS](https://stytch.com/docs/b2b/guides/passwords/strength-policy). If an email address is included in the call we also
      require that the password hasn't been compromised using built-in breach detection powered by [HaveIBeenPwned](https://haveibeenpwned.com/)
      - score: The score of the password determined by [zxcvbn](https://github.com/dropbox/zxcvbn). Values will be between 1 and 4, a 3 or greater is required to pass validation.
      - breached_password: Returns `true` if the password has been breached. Powered by [HaveIBeenPwned](https://haveibeenpwned.com/).
      - strength_policy: The strength policy type enforced, either `zxcvbn` or `luds`.
      - breach_detection_on_create: Will return `true` if breach detection will be evaluated. By default this option is enabled.
      This option can be disabled by contacting [support@stytch.com](mailto:support@stytch.com?subject=Password%20strength%20configuration).
      If this value is false then `breached_password` will always be `false` as well.
      - luds_feedback: Feedback for how to improve the password's strength using [luds](https://stytch.com/docs/guides/passwords/strength-policy).
      - zxcvbn_feedback: Feedback for how to improve the password's strength using [zxcvbn](https://stytch.com/docs/b2b/guides/passwords/strength-policy).
    """  # noqa

    valid_password: bool
    score: int
    breached_password: bool
    strength_policy: str
    breach_detection_on_create: bool
    luds_feedback: Optional[LudsFeedback] = None
    zxcvbn_feedback: Optional[ZxcvbnFeedback] = None
