# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import datetime
from typing import List, Optional

import pydantic


class Address(pydantic.BaseModel):
    formatted: str
    street_address: str
    locality: str
    region: str
    postal_code: str
    country: str
    type: str
    primary: bool


class Email(pydantic.BaseModel):
    value: str
    type: str
    primary: bool


class Entitlement(pydantic.BaseModel):
    value: str
    type: str
    primary: bool


class Group(pydantic.BaseModel):
    value: str
    display: str


class IMs(pydantic.BaseModel):
    value: str
    type: str
    primary: bool


class Manager(pydantic.BaseModel):
    value: str
    ref: str
    display_name: str


class EnterpriseExtension(pydantic.BaseModel):
    employee_number: str
    cost_center: str
    division: str
    department: str
    organization: str
    manager: Optional[Manager] = None


class Name(pydantic.BaseModel):
    formatted: str
    family_name: str
    given_name: str
    middle_name: str
    honorific_prefix: str
    honorific_suffix: str


class PhoneNumber(pydantic.BaseModel):
    value: str
    type: str
    primary: bool


class Photo(pydantic.BaseModel):
    value: str
    type: str
    primary: bool


class Role(pydantic.BaseModel):
    value: str
    type: str
    primary: bool


class SCIMGroup(pydantic.BaseModel):
    """
    Fields:
      - group_id: Stytch-issued, globally unique UUID that identifies a specific SCIM Group. The entity `id` in the SCIM specification is issued by the Service Provider (SP) and returned to the Identity Provider (IdP) to store and use for uniquely identify and updating the Group moving forward.
      - group_name: The displayName of the SCIM group, sent from the Identity Provider (IdP).
      - organization_id: Globally unique UUID that identifies a specific Organization. The organization_id is critical to perform operations on an Organization, so be sure to preserve this value.
      - connection_id: The ID of the SCIM connection.
    """  # noqa

    group_id: str
    group_name: str
    organization_id: str
    connection_id: str


class SCIMGroupImplicitRoleAssignments(pydantic.BaseModel):
    role_id: str
    group_id: str
    group_name: str


class SCIMConnection(pydantic.BaseModel):
    organization_id: str
    connection_id: str
    status: str
    display_name: str
    identity_provider: str
    base_url: str
    bearer_token_last_four: str
    scim_group_implicit_role_assignments: List[SCIMGroupImplicitRoleAssignments]
    next_bearer_token_last_four: str
    bearer_token_expires_at: Optional[datetime.datetime] = None
    next_bearer_token_expires_at: Optional[datetime.datetime] = None


class SCIMConnectionWithNextToken(pydantic.BaseModel):
    organization_id: str
    connection_id: str
    status: str
    display_name: str
    base_url: str
    identity_provider: str
    bearer_token_last_four: str
    next_bearer_token: str
    scim_group_implicit_role_assignments: List[SCIMGroupImplicitRoleAssignments]
    bearer_token_expires_at: Optional[datetime.datetime] = None
    next_bearer_token_expires_at: Optional[datetime.datetime] = None


class SCIMConnectionWithToken(pydantic.BaseModel):
    organization_id: str
    connection_id: str
    status: str
    display_name: str
    identity_provider: str
    base_url: str
    bearer_token: str
    scim_group_implicit_role_assignments: List[SCIMGroupImplicitRoleAssignments]
    bearer_token_expires_at: Optional[datetime.datetime] = None


class X509Certificate(pydantic.BaseModel):
    value: str
    type: str
    primary: bool


class SCIMAttributes(pydantic.BaseModel):
    user_name: str
    id: str
    external_id: str
    active: bool
    groups: List[Group]
    display_name: str
    nick_name: str
    profile_url: str
    user_type: str
    title: str
    preferred_language: str
    locale: str
    timezone: str
    emails: List[Email]
    phone_numbers: List[PhoneNumber]
    addresses: List[Address]
    ims: List[IMs]
    photos: List[Photo]
    entitlements: List[Entitlement]
    roles: List[Role]
    x509certificates: List[X509Certificate]
    name: Optional[Name] = None
    enterprise_extension: Optional[EnterpriseExtension] = None
