# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import enum
from typing import Dict, List, Optional

import pydantic

from stytch.b2b.models.scim import (
    SCIMConnection,
    SCIMConnectionWithNextToken,
    SCIMConnectionWithToken,
    SCIMGroup,
)
from stytch.core.response_base import ResponseBase
from stytch.shared.method_options import Authorization


class CreateRequestIdentityProvider(str, enum.Enum):
    GENERIC = "generic"
    OKTA = "okta"
    MICROSOFTENTRA = "microsoft-entra"
    CYBERARK = "cyberark"
    JUMPCLOUD = "jumpcloud"
    ONELOGIN = "onelogin"
    PINGFEDERATE = "pingfederate"
    RIPPLING = "rippling"


class UpdateRequestIdentityProvider(str, enum.Enum):
    GENERIC = "generic"
    OKTA = "okta"
    MICROSOFTENTRA = "microsoft-entra"
    CYBERARK = "cyberark"
    JUMPCLOUD = "jumpcloud"
    ONELOGIN = "onelogin"
    PINGFEDERATE = "pingfederate"
    RIPPLING = "rippling"


class CreateRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class DeleteRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class GetGroupsRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class GetRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class RotateCancelRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class RotateCompleteRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class RotateStartRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class UpdateRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class CreateResponse(ResponseBase):
    """Response type for `Connection.create`.
    Fields:
      - connection: The `SCIM Connection` object affected by this API call. See the [SCIM Connection Object](https://stytch.com/docs/b2b/api/scim-connection-object) for complete response field details.
    """  # noqa

    connection: Optional[SCIMConnectionWithToken] = None


class DeleteResponse(ResponseBase):
    """Response type for `Connection.delete`.
    Fields:
      - connection_id: The `connection_id` that was deleted as part of the delete request.
    """  # noqa

    connection_id: str


class GetGroupsResponse(ResponseBase):
    """Response type for `Connection.get_groups`.
    Fields:
      - scim_groups: A list of SCIM Connection Groups belonging to the connection.
      - next_cursor: The `next_cursor` string is returned when your search result contains more than one page of results. This value is passed into your next search call in the `cursor` field.
    """  # noqa

    scim_groups: List[SCIMGroup]
    next_cursor: Optional[str] = None


class GetResponse(ResponseBase):
    """Response type for `Connection.get`.
    Fields:
      - connection: A [SCIM Connection](https://stytch.com/docs/b2b/api/scim-connection-object) connection belonging to the organization (currently limited to one).
    """  # noqa

    connection: Optional[SCIMConnection] = None


class RotateCancelResponse(ResponseBase):
    """Response type for `Connection.rotate_cancel`.
    Fields:
      - connection: The `SCIM Connection` object affected by this API call. See the [SCIM Connection Object](https://stytch.com/docs/b2b/api/scim-connection-object) for complete response field details.
    """  # noqa

    connection: Optional[SCIMConnection] = None


class RotateCompleteResponse(ResponseBase):
    """Response type for `Connection.rotate_complete`.
    Fields:
      - connection: The `SCIM Connection` object affected by this API call. See the [SCIM Connection Object](https://stytch.com/docs/b2b/api/scim-connection-object) for complete response field details.
    """  # noqa

    connection: Optional[SCIMConnection] = None


class RotateStartResponse(ResponseBase):
    """Response type for `Connection.rotate_start`.
    Fields:
      - connection: The `SCIM Connection` object affected by this API call. See the [SCIM Connection Object](https://stytch.com/docs/b2b/api/scim-connection-object) for complete response field details.
    """  # noqa

    connection: Optional[SCIMConnectionWithNextToken] = None


class UpdateResponse(ResponseBase):
    """Response type for `Connection.update`.
    Fields:
      - connection: The `SAML Connection` object affected by this API call. See the [SAML Connection Object](https://stytch.com/docs/b2b/api/saml-connection-object) for complete response field details.
    """  # noqa

    connection: Optional[SCIMConnection] = None
